<?php 
get_header();
$args = array(
    'post_type' => 'portfolio',
    'p' => get_the_ID()
);
$portfolio_posts = new WP_Query( $args ); 
while($portfolio_posts->have_posts()) : 
    $portfolio_posts->the_post(); 
    $id = get_the_ID();
    if(get_post_meta($id, $key ='gallery_images', $single = true )) {
        $gallery_images = explode(",",get_post_meta($id, $key ='gallery_images', $single = true )); 
        
        foreach($gallery_images as $key=>$item) {
            if($item == '') {
                unset($gallery_images[$key]);
            }
        } 
        $header_media = "<div class='gallery'>";

        $header_media .= "<div class='gallery-inner'>";
        $j=0;
        foreach($gallery_images as $item) {
            $image_src = wp_get_attachment_image_src($item, "full"); 
            $image_title = get_the_title($item); 
            $header_media .= "<div class='item'>";
            $header_media .= "<a title='".$image_title."'  href='".$image_src[0]."'>";
            $header_media .= "<img alt='".$image_title."'  src='".$image_src[0]."'>";
            $header_media .= "</a>";
            $header_media .= "</div>";
            $j++;
        }
        $header_media .= "</div>";
        $header_media .= "</div>";
      
    }
    elseif(has_post_thumbnail($id)) { 
        $header_media = get_the_post_thumbnail($id, "full");
    }
    elseif(get_post_meta($id, $key ='anps_featured_video', $single = true )) { 
        $header_media = do_shortcode(get_post_meta($id, $key ='anps_featured_video', $single = true ));
    }
    else { 
        $header_media = "";
    }
?>
<section class="container portfolio-single">
    <div class="row">
        <?php if(get_option("portfolio_single", "style-1")=='style-1') : ?>
            <?php
                global $row_inner;
                $row_inner = true;
            ?>
            <div class="col-md-4">
                <?php the_content(); ?>
                <div class="row">
                    <div class="col-md-12 buttons folionav">
                        <?php // previous_post_link( '%link', '<button class="btn btn-lg style-5"><i class="fa fa-angle-left"></i> &nbsp; ' . __('précédent', ANPS_TEMPLATE_LANG)."</button>" ); ?>
                        <?php // next_post_link( '%link', '<button class="btn btn-lg style-5">'.__("suivant", ANPS_TEMPLATE_LANG) . ' &nbsp; <i class="fa fa-angle-right"></i></button>' ); ?>
                                                
                        <?php // previous_post_link( '%link', 'Previous post in category', TRUE, '13' ); ?>
                        <?php // next_post_link( '%link', 'Next post in category', TRUE, '13' ); ?>
                    </div>
                </div>
            </div>
            <div class="col-md-8"><?php echo $header_media; ?></div>
        <?php else : ?>
            <?php
                global $row_inner;
                $row_inner = true;
            ?>
            <?php echo $header_media; ?>
            <?php the_content(); ?>
        <?php endif; ?>
    </div>    
</section>
<?php endwhile; 
wp_reset_postdata();
?>

<?php if( get_option('portfolio_single_footer', '') != "" ): ?>
    <p>&nbsp;</p><p>&nbsp;</p>
<?php endif; ?>

<?php echo do_shortcode(stripslashes(get_option('portfolio_single_footer', ''))); ?>

<?php get_footer(); ?>