<?php

class AnpsText extends WP_Widget {

    public function __construct() {
        parent::__construct(
                'AnpsText', 'AnpsThemes - Text and icon', array('description' => __('Enter text and/or icon to show on page. Can only be used in the Top bar widget areas.', ANPS_TEMPLATE_LANG),)
        );
    }

    function form($instance) {
        $instance = wp_parse_args((array) $instance, array('icon' => '', 'text'=>''));

        $icon = $instance['icon'];
        $text = htmlentities($instance['text']);
        
        $icon_array = array(
            __("Adjust", ANPS_TEMPLATE_LANG)=>"adjust",
            __("Adn", ANPS_TEMPLATE_LANG)=>"adn",
            __("Align center", ANPS_TEMPLATE_LANG)=>"align-center",
            __("Align justify", ANPS_TEMPLATE_LANG)=>"align-justify",
            __("Align left", ANPS_TEMPLATE_LANG)=>"align-left",
            __("Align right", ANPS_TEMPLATE_LANG)=>"align-right",
            __("Ambulance", ANPS_TEMPLATE_LANG)=>"ambulance",
            __("Anchor", ANPS_TEMPLATE_LANG)=>"anchor",
            __("Android", ANPS_TEMPLATE_LANG)=>"android",
            __("Angle double down", ANPS_TEMPLATE_LANG)=>"angle-double-down",
            __("Angle double left", ANPS_TEMPLATE_LANG)=>"angle-double-left",
            __("Angle double right", ANPS_TEMPLATE_LANG)=>"angle-double-right",
            __("Angle double up", ANPS_TEMPLATE_LANG)=>"angle-double-up",
            __("Angle down", ANPS_TEMPLATE_LANG)=>"angle-down",
            __("Angle left", ANPS_TEMPLATE_LANG)=>"angle-left",
            __("Angle right", ANPS_TEMPLATE_LANG)=>"angle-right",
            __("Angle up", ANPS_TEMPLATE_LANG)=>"angle-up",
            __("Apple", ANPS_TEMPLATE_LANG)=>"apple",
            __("Archive", ANPS_TEMPLATE_LANG)=>"archive",
            __("Arrow circle down", ANPS_TEMPLATE_LANG)=>"arrow-circle-down",
            __("Arrow circle left", ANPS_TEMPLATE_LANG)=>"arrow-circle-left",
            __("Arrow circle outlined down", ANPS_TEMPLATE_LANG)=>"arrow-circle-o-down",
            __("Arrow circle outlined left", ANPS_TEMPLATE_LANG)=>"arrow-circle-o-left",
            __("Arrow circle outlined right", ANPS_TEMPLATE_LANG)=>"arrow-circle-o-right",
            __("Arrow circle outlined up", ANPS_TEMPLATE_LANG)=>"arrow-circle-o-up",
            __("Arrow circle right", ANPS_TEMPLATE_LANG)=>"arrow-circle-right",
            __("Arrow circle up", ANPS_TEMPLATE_LANG)=>"arrow-circle-up",
            __("Arrow down", ANPS_TEMPLATE_LANG)=>"arrow-down",
            __("Arrow left", ANPS_TEMPLATE_LANG)=>"arrow-left",
            __("Arrow right", ANPS_TEMPLATE_LANG)=>"arrow-right",
            __("Arrow up", ANPS_TEMPLATE_LANG)=>"arrow-up",
            __("Arrows", ANPS_TEMPLATE_LANG)=>"arrows",
            __("Arrows alt", ANPS_TEMPLATE_LANG)=>"arrows-alt",
            __("Arrows h", ANPS_TEMPLATE_LANG)=>"arrows-h",
            __("Arrows v", ANPS_TEMPLATE_LANG)=>"arrows-v",
            __("Asterisk", ANPS_TEMPLATE_LANG)=>"asterisk",
            __("Backward", ANPS_TEMPLATE_LANG)=>"backward",
            __("Ban", ANPS_TEMPLATE_LANG)=>"ban",
            __("Bar chart outlined", ANPS_TEMPLATE_LANG)=>"bar-chart-o",
            __("Barcode", ANPS_TEMPLATE_LANG)=>"barcode",
            __("Bars", ANPS_TEMPLATE_LANG)=>"bars",
            __("Beer", ANPS_TEMPLATE_LANG)=>"beer",
            __("Bell", ANPS_TEMPLATE_LANG)=>"bell",
            __("Bell outlined", ANPS_TEMPLATE_LANG)=>"bell-o",
            __("Bitbucket", ANPS_TEMPLATE_LANG)=>"bitbucket",
            __("Bitbucket square", ANPS_TEMPLATE_LANG)=>"bitbucket-square",
            __("Bold", ANPS_TEMPLATE_LANG)=>"bold",
            __("Bolt", ANPS_TEMPLATE_LANG)=>"bolt",
            __("Book", ANPS_TEMPLATE_LANG)=>"book",
            __("Bookmark", ANPS_TEMPLATE_LANG)=>"bookmark",
            __("Bookmark outlined", ANPS_TEMPLATE_LANG)=>"bookmark-o",
            __("Briefcase", ANPS_TEMPLATE_LANG)=>"briefcase",
            __("Btc", ANPS_TEMPLATE_LANG)=>"btc",
            __("Bug", ANPS_TEMPLATE_LANG)=>"bug",
            __("Building outlined", ANPS_TEMPLATE_LANG)=>"building-o",
            __("Bullhorn", ANPS_TEMPLATE_LANG)=>"bullhorn",
            __("Bullseye", ANPS_TEMPLATE_LANG)=>"bullseye",
            __("Calendar", ANPS_TEMPLATE_LANG)=>"calendar",
            __("Calendar outlined", ANPS_TEMPLATE_LANG)=>"calendar-o",
            __("Camera", ANPS_TEMPLATE_LANG)=>"camera",
            __("Camera retro", ANPS_TEMPLATE_LANG)=>"camera-retro",
            __("Caret down", ANPS_TEMPLATE_LANG)=>"caret-down",
            __("Caret left", ANPS_TEMPLATE_LANG)=>"caret-left",
            __("Caret right", ANPS_TEMPLATE_LANG)=>"caret-right",
            __("Caret square outlined down", ANPS_TEMPLATE_LANG)=>"caret-square-o-down",
            __("Caret square outlined left", ANPS_TEMPLATE_LANG)=>"caret-square-o-left",
            __("Caret square outlined right", ANPS_TEMPLATE_LANG)=>"caret-square-o-right",
            __("Caret square outlined up", ANPS_TEMPLATE_LANG)=>"caret-square-o-up",
            __("Caret up", ANPS_TEMPLATE_LANG)=>"caret-up",
            __("Certificate", ANPS_TEMPLATE_LANG)=>"certificate",
            __("Chain broken", ANPS_TEMPLATE_LANG)=>"chain-broken",
            __("Check", ANPS_TEMPLATE_LANG)=>"check",
            __("Check circle", ANPS_TEMPLATE_LANG)=>"check-circle",
            __("Check circle outlined", ANPS_TEMPLATE_LANG)=>"check-circle-o",
            __("Check square", ANPS_TEMPLATE_LANG)=>"check-square",
            __("Check square outlined", ANPS_TEMPLATE_LANG)=>"check-square-o",
            __("Chevron circle down", ANPS_TEMPLATE_LANG)=>"chevron-circle-down",
            __("Chevron circle left", ANPS_TEMPLATE_LANG)=>"chevron-circle-left",
            __("Chevron circle right", ANPS_TEMPLATE_LANG)=>"chevron-circle-right",
            __("Chevron circle up", ANPS_TEMPLATE_LANG)=>"chevron-circle-up",
            __("Chevron down", ANPS_TEMPLATE_LANG)=>"chevron-down",
            __("Chevron left", ANPS_TEMPLATE_LANG)=>"chevron-left",
            __("Chevron right", ANPS_TEMPLATE_LANG)=>"chevron-right",
            __("Chevron up", ANPS_TEMPLATE_LANG)=>"chevron-up",
            __("Circle", ANPS_TEMPLATE_LANG)=>"circle",
            __("Circle outlined", ANPS_TEMPLATE_LANG)=>"circle-o",
            __("Clipboard", ANPS_TEMPLATE_LANG)=>"clipboard",
            __("Clock outlined", ANPS_TEMPLATE_LANG)=>"clock-o",
            __("Cloud", ANPS_TEMPLATE_LANG)=>"cloud",
            __("Cloud download", ANPS_TEMPLATE_LANG)=>"cloud-download",
            __("Cloud upload", ANPS_TEMPLATE_LANG)=>"cloud-upload",
            __("Code", ANPS_TEMPLATE_LANG)=>"code",
            __("Code fork", ANPS_TEMPLATE_LANG)=>"code-fork",
            __("Coffee", ANPS_TEMPLATE_LANG)=>"coffee",
            __("Cog", ANPS_TEMPLATE_LANG)=>"cog",
            __("Cogs", ANPS_TEMPLATE_LANG)=>"cogs",
            __("Columns", ANPS_TEMPLATE_LANG)=>"columns",
            __("Comment", ANPS_TEMPLATE_LANG)=>"comment",
            __("Comment outlined", ANPS_TEMPLATE_LANG)=>"comment-o",
            __("Comments", ANPS_TEMPLATE_LANG)=>"comments",
            __("Comments outlined", ANPS_TEMPLATE_LANG)=>"comments-o",
            __("Compass", ANPS_TEMPLATE_LANG)=>"compass",
            __("Compress", ANPS_TEMPLATE_LANG)=>"compress",
            __("Credit card", ANPS_TEMPLATE_LANG)=>"credit-card",
            __("Crop", ANPS_TEMPLATE_LANG)=>"crop",
            __("Crosshairs", ANPS_TEMPLATE_LANG)=>"crosshairs",
            __("Css3", ANPS_TEMPLATE_LANG)=>"css3",
            __("Cutlery", ANPS_TEMPLATE_LANG)=>"cutlery",
            __("Desktop", ANPS_TEMPLATE_LANG)=>"desktop",
            __("Dot circle outlined", ANPS_TEMPLATE_LANG)=>"dot-circle-o",
            __("Download", ANPS_TEMPLATE_LANG)=>"download",
            __("Dribbble", ANPS_TEMPLATE_LANG)=>"dribbble",
            __("Dropbox", ANPS_TEMPLATE_LANG)=>"dropbox",
            __("Eject", ANPS_TEMPLATE_LANG)=>"eject",
            __("Ellipsis h", ANPS_TEMPLATE_LANG)=>"ellipsis-h",
            __("Ellipsis v", ANPS_TEMPLATE_LANG)=>"ellipsis-v",
            __("Envelope", ANPS_TEMPLATE_LANG)=>"envelope",
            __("Envelope outlined", ANPS_TEMPLATE_LANG)=>"envelope-o",
            __("Eraser", ANPS_TEMPLATE_LANG)=>"eraser",
            __("Eur", ANPS_TEMPLATE_LANG)=>"eur",
            __("Exchange", ANPS_TEMPLATE_LANG)=>"exchange",
            __("Exclamation", ANPS_TEMPLATE_LANG)=>"exclamation",
            __("Exclamation circle", ANPS_TEMPLATE_LANG)=>"exclamation-circle",
            __("Exclamation triangle", ANPS_TEMPLATE_LANG)=>"exclamation-triangle",
            __("Expand", ANPS_TEMPLATE_LANG)=>"expand",
            __("External link", ANPS_TEMPLATE_LANG)=>"external-link",
            __("External link square", ANPS_TEMPLATE_LANG)=>"external-link-square",
            __("Eye", ANPS_TEMPLATE_LANG)=>"eye",
            __("Eye slash", ANPS_TEMPLATE_LANG)=>"eye-slash",
            __("Facebook", ANPS_TEMPLATE_LANG)=>"facebook",
            __("Facebook square", ANPS_TEMPLATE_LANG)=>"facebook-square",
            __("Fast backward", ANPS_TEMPLATE_LANG)=>"fast-backward",
            __("Fast forward", ANPS_TEMPLATE_LANG)=>"fast-forward",
            __("Female", ANPS_TEMPLATE_LANG)=>"female",
            __("Fighter jet", ANPS_TEMPLATE_LANG)=>"fighter-jet",
            __("File", ANPS_TEMPLATE_LANG)=>"file",
            __("File outlined", ANPS_TEMPLATE_LANG)=>"file-o",
            __("File text", ANPS_TEMPLATE_LANG)=>"file-text",
            __("File text outlined", ANPS_TEMPLATE_LANG)=>"file-text-o",
            __("Files outlined", ANPS_TEMPLATE_LANG)=>"files-o",
            __("Film", ANPS_TEMPLATE_LANG)=>"film",
            __("Filter", ANPS_TEMPLATE_LANG)=>"filter",
            __("Fire", ANPS_TEMPLATE_LANG)=>"fire",
            __("Fire extinguisher", ANPS_TEMPLATE_LANG)=>"fire-extinguisher",
            __("Flag", ANPS_TEMPLATE_LANG)=>"flag",
            __("Flag checkered", ANPS_TEMPLATE_LANG)=>"flag-checkered",
            __("Flag outlined", ANPS_TEMPLATE_LANG)=>"flag-o",
            __("Flask", ANPS_TEMPLATE_LANG)=>"flask",
            __("Flickr", ANPS_TEMPLATE_LANG)=>"flickr",
            __("Floppy outlined", ANPS_TEMPLATE_LANG)=>"floppy-o",
            __("Folder", ANPS_TEMPLATE_LANG)=>"folder",
            __("Folder outlined", ANPS_TEMPLATE_LANG)=>"folder-o",
            __("Folder open", ANPS_TEMPLATE_LANG)=>"folder-open",
            __("Folder open outlined", ANPS_TEMPLATE_LANG)=>"folder-open-o",
            __("Font", ANPS_TEMPLATE_LANG)=>"font",
            __("Forward", ANPS_TEMPLATE_LANG)=>"forward",
            __("Foursquare", ANPS_TEMPLATE_LANG)=>"foursquare",
            __("Frown outlined", ANPS_TEMPLATE_LANG)=>"frown-o",
            __("Gamepad", ANPS_TEMPLATE_LANG)=>"gamepad",
            __("Gavel", ANPS_TEMPLATE_LANG)=>"gavel",
            __("Gbp", ANPS_TEMPLATE_LANG)=>"gbp",
            __("Gift", ANPS_TEMPLATE_LANG)=>"gift",
            __("Github", ANPS_TEMPLATE_LANG)=>"github",
            __("Github alt", ANPS_TEMPLATE_LANG)=>"github-alt",
            __("Github square", ANPS_TEMPLATE_LANG)=>"github-square",
            __("Gittip", ANPS_TEMPLATE_LANG)=>"gittip",
            __("Glass", ANPS_TEMPLATE_LANG)=>"glass",
            __("Globe", ANPS_TEMPLATE_LANG)=>"globe",
            __("Google plus", ANPS_TEMPLATE_LANG)=>"google-plus",
            __("Google plus square", ANPS_TEMPLATE_LANG)=>"google-plus-square",
            __("H square", ANPS_TEMPLATE_LANG)=>"h-square",
            __("Hand outlined down", ANPS_TEMPLATE_LANG)=>"hand-o-down",
            __("Hand outlined left", ANPS_TEMPLATE_LANG)=>"hand-o-left",
            __("Hand outlined right", ANPS_TEMPLATE_LANG)=>"hand-o-right",
            __("Hand outlined up", ANPS_TEMPLATE_LANG)=>"hand-o-up",
            __("Hdd outlined", ANPS_TEMPLATE_LANG)=>"hdd-o",
            __("Headphones", ANPS_TEMPLATE_LANG)=>"headphones",
            __("Heart", ANPS_TEMPLATE_LANG)=>"heart",
            __("Heart outlined", ANPS_TEMPLATE_LANG)=>"heart-o",
            __("Home", ANPS_TEMPLATE_LANG)=>"home",
            __("Hospital outlined", ANPS_TEMPLATE_LANG)=>"hospital-o",
            __("Html5", ANPS_TEMPLATE_LANG)=>"html5",
            __("Inbox", ANPS_TEMPLATE_LANG)=>"inbox",
            __("Indent", ANPS_TEMPLATE_LANG)=>"indent",
            __("Info", ANPS_TEMPLATE_LANG)=>"info",
            __("Info circle", ANPS_TEMPLATE_LANG)=>"info-circle",
            __("Inr", ANPS_TEMPLATE_LANG)=>"inr",
            __("Instagram", ANPS_TEMPLATE_LANG)=>"instagram",
            __("Italic", ANPS_TEMPLATE_LANG)=>"italic",
            __("Jpy", ANPS_TEMPLATE_LANG)=>"jpy",
            __("Key", ANPS_TEMPLATE_LANG)=>"key",
            __("Keyboard outlined", ANPS_TEMPLATE_LANG)=>"keyboard-o",
            __("Krw", ANPS_TEMPLATE_LANG)=>"krw",
            __("Laptop", ANPS_TEMPLATE_LANG)=>"laptop",
            __("Leaf", ANPS_TEMPLATE_LANG)=>"leaf",
            __("Lemon outlined", ANPS_TEMPLATE_LANG)=>"lemon-o",
            __("Level down", ANPS_TEMPLATE_LANG)=>"level-down",
            __("Level up", ANPS_TEMPLATE_LANG)=>"level-up",
            __("Lightbulb outlined", ANPS_TEMPLATE_LANG)=>"lightbulb-o",
            __("Link", ANPS_TEMPLATE_LANG)=>"link",
            __("Linkedin", ANPS_TEMPLATE_LANG)=>"linkedin",
            __("Linkedin square", ANPS_TEMPLATE_LANG)=>"linkedin-square",
            __("Linux", ANPS_TEMPLATE_LANG)=>"linux",
            __("List", ANPS_TEMPLATE_LANG)=>"list",
            __("List alt", ANPS_TEMPLATE_LANG)=>"list-alt",
            __("List ol", ANPS_TEMPLATE_LANG)=>"list-ol",
            __("List ul", ANPS_TEMPLATE_LANG)=>"list-ul",
            __("Location arrow", ANPS_TEMPLATE_LANG)=>"location-arrow",
            __("Lock", ANPS_TEMPLATE_LANG)=>"lock",
            __("Long arrow down", ANPS_TEMPLATE_LANG)=>"long-arrow-down",
            __("Long arrow left", ANPS_TEMPLATE_LANG)=>"long-arrow-left",
            __("Long arrow right", ANPS_TEMPLATE_LANG)=>"long-arrow-right",
            __("Long arrow up", ANPS_TEMPLATE_LANG)=>"long-arrow-up",
            __("Magic", ANPS_TEMPLATE_LANG)=>"magic",
            __("Magnet", ANPS_TEMPLATE_LANG)=>"magnet",
            __("Mail reply all", ANPS_TEMPLATE_LANG)=>"mail-reply-all",
            __("Male", ANPS_TEMPLATE_LANG)=>"male",
            __("Map marker", ANPS_TEMPLATE_LANG)=>"map-marker",
            __("Maxcdn", ANPS_TEMPLATE_LANG)=>"maxcdn",
            __("Medkit", ANPS_TEMPLATE_LANG)=>"medkit",
            __("Meh outlined", ANPS_TEMPLATE_LANG)=>"meh-o",
            __("Microphone", ANPS_TEMPLATE_LANG)=>"microphone",
            __("Microphone slash", ANPS_TEMPLATE_LANG)=>"microphone-slash",
            __("Minus", ANPS_TEMPLATE_LANG)=>"minus",
            __("Minus circle", ANPS_TEMPLATE_LANG)=>"minus-circle",
            __("Minus square", ANPS_TEMPLATE_LANG)=>"minus-square",
            __("Minus square outlined", ANPS_TEMPLATE_LANG)=>"minus-square-o",
            __("Mobile", ANPS_TEMPLATE_LANG)=>"mobile",
            __("Money", ANPS_TEMPLATE_LANG)=>"money",
            __("Moon outlined", ANPS_TEMPLATE_LANG)=>"moon-o",
            __("Music", ANPS_TEMPLATE_LANG)=>"music",
            __("Outdent", ANPS_TEMPLATE_LANG)=>"outdent",
            __("Pagelines", ANPS_TEMPLATE_LANG)=>"pagelines",
            __("Paperclip", ANPS_TEMPLATE_LANG)=>"paperclip",
            __("Pause", ANPS_TEMPLATE_LANG)=>"pause",
            __("Pencil", ANPS_TEMPLATE_LANG)=>"pencil",
            __("Pencil square", ANPS_TEMPLATE_LANG)=>"pencil-square",
            __("Pencil square outlined", ANPS_TEMPLATE_LANG)=>"pencil-square-o",
            __("Phone", ANPS_TEMPLATE_LANG)=>"phone",
            __("Phone square", ANPS_TEMPLATE_LANG)=>"phone-square",
            __("Picture outlined", ANPS_TEMPLATE_LANG)=>"picture-o",
            __("Pinterest", ANPS_TEMPLATE_LANG)=>"pinterest",
            __("Pinterest square", ANPS_TEMPLATE_LANG)=>"pinterest-square",
            __("Plane", ANPS_TEMPLATE_LANG)=>"plane",
            __("Play", ANPS_TEMPLATE_LANG)=>"play",
            __("Play circle", ANPS_TEMPLATE_LANG)=>"play-circle",
            __("Play circle outlined", ANPS_TEMPLATE_LANG)=>"play-circle-o",
            __("Plus", ANPS_TEMPLATE_LANG)=>"plus",
            __("Plus circle", ANPS_TEMPLATE_LANG)=>"plus-circle",
            __("Plus square", ANPS_TEMPLATE_LANG)=>"plus-square",
            __("Plus square outlined", ANPS_TEMPLATE_LANG)=>"plus-square-o",
            __("Power off", ANPS_TEMPLATE_LANG)=>"power-off",
            __("Print", ANPS_TEMPLATE_LANG)=>"print",
            __("Puzzle piece", ANPS_TEMPLATE_LANG)=>"puzzle-piece",
            __("Qrcode", ANPS_TEMPLATE_LANG)=>"qrcode",
            __("Question", ANPS_TEMPLATE_LANG)=>"question",
            __("Question circle", ANPS_TEMPLATE_LANG)=>"question-circle",
            __("Quote left", ANPS_TEMPLATE_LANG)=>"quote-left",
            __("Quote right", ANPS_TEMPLATE_LANG)=>"quote-right",
            __("Random", ANPS_TEMPLATE_LANG)=>"random",
            __("Refresh", ANPS_TEMPLATE_LANG)=>"refresh",
            __("Renren", ANPS_TEMPLATE_LANG)=>"renren",
            __("Repeat", ANPS_TEMPLATE_LANG)=>"repeat",
            __("Reply", ANPS_TEMPLATE_LANG)=>"reply",
            __("Reply all", ANPS_TEMPLATE_LANG)=>"reply-all",
            __("Retweet", ANPS_TEMPLATE_LANG)=>"retweet",
            __("Road", ANPS_TEMPLATE_LANG)=>"road",
            __("Rocket", ANPS_TEMPLATE_LANG)=>"rocket",
            __("Rss", ANPS_TEMPLATE_LANG)=>"rss",
            __("Rss square", ANPS_TEMPLATE_LANG)=>"rss-square",
            __("Rub", ANPS_TEMPLATE_LANG)=>"rub",
            __("Scissors", ANPS_TEMPLATE_LANG)=>"scissors",
            __("Search", ANPS_TEMPLATE_LANG)=>"search",
            __("Search minus", ANPS_TEMPLATE_LANG)=>"search-minus",
            __("Search plus", ANPS_TEMPLATE_LANG)=>"search-plus",
            __("Share", ANPS_TEMPLATE_LANG)=>"share",
            __("Share square", ANPS_TEMPLATE_LANG)=>"share-square",
            __("Share square outlined", ANPS_TEMPLATE_LANG)=>"share-square-o",
            __("Shield", ANPS_TEMPLATE_LANG)=>"shield",
            __("Shopping cart", ANPS_TEMPLATE_LANG)=>"shopping-cart",
            __("Sign in", ANPS_TEMPLATE_LANG)=>"sign-in",
            __("Sign out", ANPS_TEMPLATE_LANG)=>"sign-out",
            __("Signal", ANPS_TEMPLATE_LANG)=>"signal",
            __("Sitemap", ANPS_TEMPLATE_LANG)=>"sitemap",
            __("Skype", ANPS_TEMPLATE_LANG)=>"skype",
            __("Smile outlined", ANPS_TEMPLATE_LANG)=>"smile-o",
            __("Sort", ANPS_TEMPLATE_LANG)=>"sort",
            __("Sort alpha asc", ANPS_TEMPLATE_LANG)=>"sort-alpha-asc",
            __("Sort alpha desc", ANPS_TEMPLATE_LANG)=>"sort-alpha-desc",
            __("Sort amount asc", ANPS_TEMPLATE_LANG)=>"sort-amount-asc",
            __("Sort amount desc", ANPS_TEMPLATE_LANG)=>"sort-amount-desc",
            __("Sort asc", ANPS_TEMPLATE_LANG)=>"sort-asc",
            __("Sort desc", ANPS_TEMPLATE_LANG)=>"sort-desc",
            __("Sort numeric asc", ANPS_TEMPLATE_LANG)=>"sort-numeric-asc",
            __("Sort numeric desc", ANPS_TEMPLATE_LANG)=>"sort-numeric-desc",
            __("Spinner", ANPS_TEMPLATE_LANG)=>"spinner",
            __("Square", ANPS_TEMPLATE_LANG)=>"square",
            __("Square outlined", ANPS_TEMPLATE_LANG)=>"square-o",
            __("Stack exchange", ANPS_TEMPLATE_LANG)=>"stack-exchange",
            __("Stack overflow", ANPS_TEMPLATE_LANG)=>"stack-overflow",
            __("Star", ANPS_TEMPLATE_LANG)=>"star",
            __("Star half", ANPS_TEMPLATE_LANG)=>"star-half",
            __("Star half outlined", ANPS_TEMPLATE_LANG)=>"star-half-o",
            __("Star outlined", ANPS_TEMPLATE_LANG)=>"star-o",
            __("Step backward", ANPS_TEMPLATE_LANG)=>"step-backward",
            __("Step forward", ANPS_TEMPLATE_LANG)=>"step-forward",
            __("Stethoscope", ANPS_TEMPLATE_LANG)=>"stethoscope",
            __("Stop", ANPS_TEMPLATE_LANG)=>"stop",
            __("Strikethrough", ANPS_TEMPLATE_LANG)=>"strikethrough",
            __("Subscript", ANPS_TEMPLATE_LANG)=>"subscript",
            __("Suitcase", ANPS_TEMPLATE_LANG)=>"suitcase",
            __("Sun outlined", ANPS_TEMPLATE_LANG)=>"sun-o",
            __("Superscript", ANPS_TEMPLATE_LANG)=>"superscript",
            __("Table", ANPS_TEMPLATE_LANG)=>"table",
            __("Tablet", ANPS_TEMPLATE_LANG)=>"tablet",
            __("Tachometer", ANPS_TEMPLATE_LANG)=>"tachometer",
            __("Tag", ANPS_TEMPLATE_LANG)=>"tag",
            __("Tags", ANPS_TEMPLATE_LANG)=>"tags",
            __("Tasks", ANPS_TEMPLATE_LANG)=>"tasks",
            __("Terminal", ANPS_TEMPLATE_LANG)=>"terminal",
            __("Text height", ANPS_TEMPLATE_LANG)=>"text-height",
            __("Text width", ANPS_TEMPLATE_LANG)=>"text-width",
            __("Th", ANPS_TEMPLATE_LANG)=>"th",
            __("Th large", ANPS_TEMPLATE_LANG)=>"th-large",
            __("Th list", ANPS_TEMPLATE_LANG)=>"th-list",
            __("Thumb tack", ANPS_TEMPLATE_LANG)=>"thumb-tack",
            __("Thumbs down", ANPS_TEMPLATE_LANG)=>"thumbs-down",
            __("Thumbs outlined down", ANPS_TEMPLATE_LANG)=>"thumbs-o-down",
            __("Thumbs outlined up", ANPS_TEMPLATE_LANG)=>"thumbs-o-up",
            __("Thumbs up", ANPS_TEMPLATE_LANG)=>"thumbs-up",
            __("Ticket", ANPS_TEMPLATE_LANG)=>"ticket",
            __("Times", ANPS_TEMPLATE_LANG)=>"times",
            __("Times circle", ANPS_TEMPLATE_LANG)=>"times-circle",
            __("Times circle outlined", ANPS_TEMPLATE_LANG)=>"times-circle-o",
            __("Tint", ANPS_TEMPLATE_LANG)=>"tint",
            __("Trash outlined", ANPS_TEMPLATE_LANG)=>"trash-o",
            __("Trello", ANPS_TEMPLATE_LANG)=>"trello",
            __("Trophy", ANPS_TEMPLATE_LANG)=>"trophy",
            __("Truck", ANPS_TEMPLATE_LANG)=>"truck",
            __("Try", ANPS_TEMPLATE_LANG)=>"try",
            __("Tumblr", ANPS_TEMPLATE_LANG)=>"tumblr",
            __("Tumblr square", ANPS_TEMPLATE_LANG)=>"tumblr-square",
            __("Twitter", ANPS_TEMPLATE_LANG)=>"twitter",
            __("Twitter square", ANPS_TEMPLATE_LANG)=>"twitter-square",
            __("Umbrella", ANPS_TEMPLATE_LANG)=>"umbrella",
            __("Underline", ANPS_TEMPLATE_LANG)=>"underline",
            __("Undo", ANPS_TEMPLATE_LANG)=>"undo",
            __("Unlock", ANPS_TEMPLATE_LANG)=>"unlock",
            __("Unlock alt", ANPS_TEMPLATE_LANG)=>"unlock-alt",
            __("Upload", ANPS_TEMPLATE_LANG)=>"upload",
            __("Usd", ANPS_TEMPLATE_LANG)=>"usd",
            __("User", ANPS_TEMPLATE_LANG)=>"user",
            __("User md", ANPS_TEMPLATE_LANG)=>"user-md",
            __("Users", ANPS_TEMPLATE_LANG)=>"users",
            __("Video camera", ANPS_TEMPLATE_LANG)=>"video-camera",
            __("Vimeo square", ANPS_TEMPLATE_LANG)=>"vimeo-square",
            __("Vk", ANPS_TEMPLATE_LANG)=>"vk",
            __("Volume down", ANPS_TEMPLATE_LANG)=>"volume-down",
            __("Volume off", ANPS_TEMPLATE_LANG)=>"volume-off",
            __("Volume up", ANPS_TEMPLATE_LANG)=>"volume-up",
            __("Weibo", ANPS_TEMPLATE_LANG)=>"weibo",
            __("Wheelchair", ANPS_TEMPLATE_LANG)=>"wheelchair",
            __("Windows", ANPS_TEMPLATE_LANG)=>"windows",
            __("Wrench", ANPS_TEMPLATE_LANG)=>"wrench",
            __("Xing", ANPS_TEMPLATE_LANG)=>"xing",
            __("Xing square", ANPS_TEMPLATE_LANG)=>"xing-square",
            __("Youtube", ANPS_TEMPLATE_LANG)=>"youtube",
            __("Youtube play", ANPS_TEMPLATE_LANG)=>"youtube-play",
            __("Youtube square", ANPS_TEMPLATE_LANG)=>"youtube-square"
        );
        ?>
        <p>
            <select id="<?php echo esc_attr($this->get_field_id('icon')); ?>" name="<?php echo esc_attr($this->get_field_name('icon')); ?>">
                <option value="">Select an icon</option>         
                <?php foreach ($icon_array as $value=>$item) : ?>
                    <option <?php if ($item == $icon) {
                        echo 'selected="selected"';
                    } ?> value="<?php echo esc_attr($item); ?>"><?php echo $value; ?></option>
            <?php endforeach; ?>
            </select>
        </p>
        <p>
            <input id="<?php echo esc_attr($this->get_field_id('text')); ?>" name="<?php echo esc_attr($this->get_field_name('text')); ?>" type="text" class="widefat" value="<?php echo esc_attr($text); ?>" />
        </p>
        <?php
    }

    function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['icon'] = $new_instance['icon'];
        $instance['text'] = $new_instance['text'];
        return $instance;
    }

    function widget($args, $instance) {
        extract($args, EXTR_SKIP);
        $icon = $instance['icon'];
        $text = $instance['text'];
        echo $before_widget;
        ?>

        <span class="fa fa-<?php echo esc_attr($icon);?>"></span>
        <?php echo $text; ?>
        <?php
        echo $after_widget;
    }

}

add_action( 'widgets_init', create_function('', 'return register_widget("AnpsText");') );