CREATE DATABASE IF NOT EXISTS atelierywp;
USE atelierywp;
DROP TABLE IF EXISTS ayv__wsd_plugin_alerts;CREATE TABLE `ayv__wsd_plugin_alerts` (
  `alertId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `alertType` tinyint(4) NOT NULL DEFAULT '0',
  `alertSeverity` int(11) NOT NULL DEFAULT '0',
  `alertActionName` varchar(255) NOT NULL,
  `alertTitle` varchar(255) NOT NULL,
  `alertDescription` text NOT NULL,
  `alertSolution` text NOT NULL,
  `alertDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `alertFirstSeen` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`alertId`),
  UNIQUE KEY `alertId_UNIQUE` (`alertId`)
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=utf8;
INSERT INTO ayv__wsd_plugin_alerts VALUES("1","0","3","fix_wp_version_hidden","WordPress version is displayed for all users","<p>Displaying your WordPress version on frontend and in the backend\'s footer to all visitors
                        and users of your website is a security risk because if a hacker knows which version of WordPress a website is running, it can make it easier for him to target a known WordPress security issue.</p>","<p>This plugin can automatically hide your WordPress version from frontend, backend and rss feeds if the option <strong>\"Hide WordPress version for all users but administrators\"</strong> is checked on the plugin\'s settings page.</p>","2016-04-11 10:48:51","2016-04-11 10:31:27");
INSERT INTO ayv__wsd_plugin_alerts VALUES("2","0","3","fix_wp_generators_frontend","WordPress meta tags are displayed on frontend to all users","<p>By default, WordPress creates a few meta tags, among which is the currently installed version, that give a hacker the knowledge about your WordPress installation. At the moment, these meta tags are available for anyone to see, which is a potentially security risk.</p>","<p>This plugin can automatically hide your WordPress\'s default meta tags if the option <strong>\"Remove various meta tags generators from the blog\'s head tag for non-administrators\"</strong> is checked on the plugin\'s settings page.</p>","2016-04-11 10:48:51","2016-04-11 10:31:27");
INSERT INTO ayv__wsd_plugin_alerts VALUES("3","0","0","fix_wp_rsd_frontend","WordPress Really Simple Discovery tag is displayed on frontend to all users","<p>By default, WordPress creates the <strong>rsd meta tag</strong> to allow bloggers to consume services like Flickr using the <a href=\"http://en.wikipedia.org/wiki/XML-RPC\" target=\"_blank\">XML-RPC</a> protocol.
                            If you don\'t use such services it is recommended to hide this meta tag.</p>","<p>This plugin can automatically hide the rsd meta tag if the option <strong>\"Remove Really Simple Discovery meta tags from front-end\"</strong> is checked on the plugin\'s settings page.</p>","2016-04-11 10:48:51","2016-04-11 10:31:27");
INSERT INTO ayv__wsd_plugin_alerts VALUES("4","0","2","fix_wp_wlw_frontend","WordPress Windows Live Writer tag is displayed on frontend for all users","<p>By default, WordPress creates the wlw meta tag to allow bloggers to publish their articles using the <strong>\"Windows Live Writer\"</strong> application.
                        It is recommended to hide this meta tag from all visitors. If the option <strong>\"Remove Windows Live Writer meta tags from front-end\"</strong> is checked on the plugin\'s settings page, this meta tag
                        will still be available for administrator users to use the <strong>\"Windows Live Writer\"</strong> application to publish their blog posts.</p>","<p>This plugin can automatically hide the wlw meta tag if the option <strong>\"Remove Windows Live Writer meta tags from front-end\"\"</strong> is checked on the plugin\'s settings page.</p>","2016-04-11 10:48:51","2016-04-11 10:31:27");
INSERT INTO ayv__wsd_plugin_alerts VALUES("5","0","3","fix_wp_error_reporting","The check for PHP and database error reporting is disabled","<p>By default, WordPress hides database errors, but there are times when a plugin might enable them thus it is very important to have this type of errors turned off
                            so if there is an error during a connection to the database the user will not get access to the error message generated during that request.</p>
                            <p>As regarding the PHP errors, with the <strong>display_error</strong> PHP configuration directive enabled, untrusted sources can see detailed web application environment
                            error messages which include sensitive information that can be used to craft further attacks.</p>
                            <p>Attackers will do anything to collect information in order to design their attack in a more sophisticated way to eventually hack your website or web application, and causing
                            errors to display is a common starting point. Website errors can always occur, but they should be suppressed from being displayed back to the public.</p>
                            <p>Therefore we highly recommend you to have the <strong>\"Disable error reporting (php + db) for all but administrators\"</strong> option checked on the plugin\'s settings page to ensure PHP and
                            database errors will be hidden from all users. For more information, please check the following <a href=\"http://www.acunetix.com/blog/web-security-zone/articles/php-security-directive-your-website-is-showing-php-errors/\" target=\"_blank\">article</a>.</p>","<p>This plugin can do this automatically if the option <strong>\"Disable error reporting (php + db) for all but administrators\"</strong> is checked on the plugin\'s settings page.</p>","2016-04-11 10:48:51","2016-04-11 10:31:27");
INSERT INTO ayv__wsd_plugin_alerts VALUES("6","0","3","fix_wp_core_update_notif","Core update notifications are displayed to all users","<p>These notifications are displayed at the top of the screen by the WordPress platform whenever the website was updated or needs an update.</p>
                    <p>These notifications should only be viewed by the website\'s administrators and not visible to any other users registered with that website.</p>","<p>This plugin can automatically hide these notifications if the option <strong>\"Remove core update notifications from back-end for all but administrators\"</strong> is checked on the plugin\'s settings page.</p>","2016-04-11 10:48:51","2016-04-11 10:31:27");
INSERT INTO ayv__wsd_plugin_alerts VALUES("7","0","2","fix_wp_plugins_update_notif","Plugins update notifications are displayed to all users","<p>These notifications are displayed at the top of the screen by the WordPress platform whenever the blog administrator
                        needs to be informed about an available update for a plugin.</p>
                    <p>These notifications should only be viewed by the website\'s administrators and not visible to any other users registered with that website.</p>","<p>This plugin can automatically hide these notifications if the option <strong>\"Remove plug-ins update notifications from back-end\"</strong> is checked on the plugin\'s settings page.</p>","2016-04-11 10:48:51","2016-04-11 10:31:27");
INSERT INTO ayv__wsd_plugin_alerts VALUES("8","0","0","fix_wp_themes_update_notif","Themes update notifications are displayed to all users.","<p>These notifications are displayed at the top of the screen by the WordPress platform whenever the blog administrator
                        needs to be informed about an available update for a theme.</p>
                    <p>These notifications should only be viewed by the website\'s administrators and not visible to any other users registered with that website.</p>","<p>This plugin can automatically hide these notifications if the option <strong>\"Remove themes update notifications from back-end\"</strong> is checked on the plugin\'s settings page.</p>","2016-04-11 10:48:51","2016-04-11 10:31:27");
INSERT INTO ayv__wsd_plugin_alerts VALUES("9","0","2","fix_wp_login_errors","WordPress login errors are displayed.","<p>Every time a failed login is encountered, the WordPress platform generates an error message that is displayed to the user.
                        This is a potential security risk because it let\'s the user know of his mistake (be it a wrong user name or password) thus making your
                        WordPress website more vulnerable to attacks.</p>
                    <p>We strongly recommend you to hide these login error messages from all users to ensure a better security of your blog.</p>","<p>This plugin can automatically hide these notifications if the option <strong>\"Remove login error notifications from front-end\"</strong> is checked on the plugin\'s settings page.</p>","2016-04-11 10:48:51","2016-04-11 10:31:27");
INSERT INTO ayv__wsd_plugin_alerts VALUES("10","0","2","fix_wp_admin_notices","WordPress admin notifications are displayed to all users.","<p>These notifications are displayed at the top of the screen by the WordPress platform whenever the blog administrator
                       needs to be informed about an event that has occurred inside WordPress, it could be about an available update for the
                       WordPress platform, a plugin or a theme that was updated or needs an update or to be configured, etc.</p>
                    <p>These notifications should only be viewed by the website\'s administrators and not visible to any other users registered with that website.</p>","<p>This plugin can automatically hide these notifications if the option <strong>\"Hide admin notifications for non admins\"</strong> is checked on the plugin\'s settings page.</p>","2016-04-11 10:48:51","2016-04-11 10:31:27");
INSERT INTO ayv__wsd_plugin_alerts VALUES("11","0","2","fix_wp_dir_listing","Directory listing check is disabled. This option should be enabled.","<p>A directory listing provides an attacker with the complete index of all the resources located inside of the directory.
                    The specific risks and consequences vary depending on which files are listed and accessible.
                    Therefore, it is important to protect your directories by having an empty index.php or index.htm file inside them.</p>","<p>This plugin can automatically create an empty <strong>index.php</strong> file in the following directories: wp-content, wp-content/plugins, wp-content/themes and wp-content/uploads if
                    the option <strong>\"Try to create the index.php file in the wp-content, wp-content/plugins, wp-content/themes and wp-content/uploads directories to prevent directory listing\"</strong> is checked on the plugin\'s settings page.</p>","2016-04-11 10:48:51","2016-04-11 10:31:27");
INSERT INTO ayv__wsd_plugin_alerts VALUES("12","0","3","fix_remove_wp_version_links","WordPress version is displayed in links for all users","<p>By default, WordPress will display the current version in links to javascript scripts or stylesheets.
                    Therefore, if anyone has access to this information it might be a security risk because if a hacker knows which version of WordPress a website is running,
                    it can make it easier for him to target a known WordPress security issue.</p>","<p>This plugin can automatically hide the WordPress version from links if the option <strong>\"Remove the version parameter from urls\"</strong> is checked on the plugin\'s settings page.</p>","2016-04-11 10:48:51","2016-04-11 10:31:27");
INSERT INTO ayv__wsd_plugin_alerts VALUES("13","0","2","fix_empty_root_readme_file","Clearing the content of the <strong>\"readme.html\"</strong> file from the <strong>\"root\"</strong> directory is disabled.","<p>A default WordPress installation contains a readme.html file. This file is a simple html file that does not contain executable content that can be exploited by hackers or malicious users.
                        Still, this file can provide hackers the version of your WordPress installation, therefore it is important to either delete this file or make it inaccessible for your visitors.</p>","<p>This plugin can automatically delete its content (assuming the file exists) if the option <strong>\"Empty the content of the readme.html file from the root directory\"</strong> is checked on the plugin\'s settings page.
                    You can also delete this file manually by connecting to your website through an FTP connection.</p>","2016-04-11 10:32:57","2016-04-11 10:31:27");
INSERT INTO ayv__wsd_plugin_alerts VALUES("14","0","0","check_table_prefix","The default WordPress database prefix is not used","<p>The majority of reported WordPress database security attacks were performed by exploiting SQL Injection vulnerabilities.
                        By renaming the WordPress database table prefixes you are securing your WordPress blog and website from zero day SQL injections attacks.</p>
                    <p>Therefore by renaming the WordPress database table prefixes, you are automatically enforcing your WordPress database security against such dangerous attacks because the attacker would not be able to guess the table names.</p>","","2016-04-11 10:48:51","2016-04-11 10:31:27");
INSERT INTO ayv__wsd_plugin_alerts VALUES("15","0","0","check_wp_current_version","You have the latest version of WordPress installed","<p>The latest WordPress version is usually more stable and secure, and is only released to include new features or fix technical and WordPress security bugs;
                            making it an important part of your website administration to keep up to date since some fixes might resolve security issues.<p>
                        <p>Running an older WordPress version could put your blog security at risk, allowing a hacker to exploit known vulnerabilities for your specific version and take full control over your web server.</p>","","2016-04-11 10:48:51","2016-04-11 10:31:27");
INSERT INTO ayv__wsd_plugin_alerts VALUES("16","0","0","check_index_wp_content","The <strong>\"index.php\"</strong> file was found in the <strong>\"/wp-content\"</strong> directory","<p>A directory listing provides an attacker with the complete index of all the resources located inside of the directory. The specific risks and consequences vary depending on which files are listed and accessible.</p>
                    <p>Therefore, it is important to protect your directories by having an empty index.php or index.htm file inside them.</p>","","2016-04-11 10:48:51","2016-04-11 10:31:27");
INSERT INTO ayv__wsd_plugin_alerts VALUES("17","0","0","check_index_wp_plugins","The <strong>\"index.php\"</strong> file was found in the <strong>\"/wp-content/plugins\"</strong> directory","<p>A directory listing provides an attacker with the complete index of all the resources located inside of the directory. The specific risks and consequences vary depending on which files are listed and accessible.</p>
                    <p>Therefore, it is important to protect your directories by having an empty index.php or index.htm file inside them.</p>","","2016-04-11 10:48:51","2016-04-11 10:31:27");
INSERT INTO ayv__wsd_plugin_alerts VALUES("18","0","0","check_index_wp_themes","The <strong>\"index.php\"</strong> file was found in the <strong>\"/wp-content/themes\"</strong> directory","<p>A directory listing provides an attacker with the complete index of all the resources located inside of the directory. The specific risks and consequences vary depending on which files are listed and accessible.</p>
                    <p>Therefore, it is important to protect your directories by having an empty index.php or index.htm file inside them.</p>","","2016-04-11 10:48:51","2016-04-11 10:31:27");
INSERT INTO ayv__wsd_plugin_alerts VALUES("19","0","2","check_index_wp_uploads","The <strong>\"index.php\"</strong> file was not found in the <strong>\"/wp-content/uploads\"</strong> directory","<p>A directory listing provides an attacker with the complete index of all the resources located inside of the directory. The specific risks and consequences vary depending on which files are listed and accessible.</p>
                        <p>Therefore, it is important to protect your directories by having an empty index.php or index.htm file inside them.</p>","<p>This plugin can automatically create an empty <strong>\"index.php\"</strong> file in the following directories: wp-content, wp-content/plugins, wp-content/themes and wp-content/uploads if the
                        option <strong>\"Try to create the index.php file in the wp-content, wp-content/plugins, wp-content/themes and wp-content/uploads directories to prevent directory listing\"</strong> is checked on the plugin\'s settings page.</p>","2016-04-11 10:48:51","2016-04-11 10:31:27");
INSERT INTO ayv__wsd_plugin_alerts VALUES("20","0","2","check_htaccess_wp_admin","The <strong>\".htaccess\"</strong> file was not found in the <strong>\"wp-admin\"</strong> directory","<p>An .htaccess file is a configuration file which provides the ability to specify configuration settings for a specific directory in a website.
                    The .htaccess file can include one or more configuration settings which apply only for the directory in which the .htaccess file has been placed.
                    So while web servers have their own main configuration settings file, the .htaccess file can be used to override their main configuration settings.</p>","<p>Please refer to this <a href=\"http://www.acunetix.com/blog/web-security-zone/articles/what-is-an-htaccess-file/\" target=\"_blank\">article</a> for more information on how to create an .htaccess file.</p>","2016-04-11 10:48:51","2016-04-11 10:31:27");
INSERT INTO ayv__wsd_plugin_alerts VALUES("21","0","0","check_readme_wp_root","The <strong>readme.html</strong> file was not found in the root directory","<p>A default WordPress installation contains a readme.html file.
                        This file is a simple html file that does not contain executable content that can be exploited by hackers or malicious users.
                        Still, this file can provide hackers the version of your WordPress installation, therefore it is important to either delete this file or make it inaccessible for your visitors.</p>","","2016-04-11 10:48:51","2016-04-11 10:31:27");
INSERT INTO ayv__wsd_plugin_alerts VALUES("22","0","0","check_username_admin ","User <strong>\"admin\"</strong> (with administrative rights) was not found","<p>One well known and dangerous WordPress security vulnerability is User Enumeration, in which a
                            malicious user is able to enumerate a valid WordPress user account to launch a brute force attack against it.
                            In order to help deter this type of attack, it is important not to have the default <a href=\"http://www.acunetix.com/blog/web-security-zone/articles/default-wordpress-administrator-account/\" target=\"_blank\">WordPress administrator</a>
                            username enabled on your blog.</p>","","2016-04-11 10:31:27","2016-04-11 10:31:27");
INSERT INTO ayv__wsd_plugin_alerts VALUES("23","0","2","check_wp_admin_install","The <strong>\"install.php\"</strong> file was found in the <strong>\"/wp-admin\"</strong> directory","<p>The install.php file is needed to install WordPress and it is good practice to restrict access to it or delete it afterwards.</p>","<p>Change file permissions 000 <strong>chmod(000)</strong> or delete it from the <strong>/wp-admin</strong> directory</p>","2016-04-11 10:31:27","2016-04-11 10:31:27");
INSERT INTO ayv__wsd_plugin_alerts VALUES("24","0","2","check_wp_admin_upgrade","The <strong>\"upgrade.php\"</strong> file was found in the <strong>\"/wp-admin\"</strong> directory","<p>The upgrade.php file is needed to upgrade WordPress and it is good practice to restrict access to it or delete it afterwards.</p>","<p>Change file permissions 000 <strong>chmod(000)</strong> or delete it from the <strong>/wp-admin</strong> directory</p>","2016-04-11 10:31:27","2016-04-11 10:31:27");
DROP TABLE IF EXISTS ayv__wsd_plugin_live_traffic;CREATE TABLE `ayv__wsd_plugin_live_traffic` (
  `entryId` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `entryTime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `entryIp` text,
  `entryReferrer` text,
  `entryUA` text,
  `entryRequestedUrl` text,
  `entryCountry` varchar(125) NOT NULL,
  `entryCity` varchar(125) NOT NULL,
  `blogId` int(10) NOT NULL DEFAULT '1',
  PRIMARY KEY (`entryId`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
INSERT INTO ayv__wsd_plugin_live_traffic VALUES("1","2016-04-11 10:33:03","85.14.167.34","http://www.atelier-yvanvedel.com/site-wp/wp-admin/plugins.php?activate=true&amp;plugin_status=all&amp;paged=1&amp;s=","Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:45.0) Gecko/20100101 Firefox/45.0","http://www.atelier-yvanvedel.com/site-wp/wp-content/themes/constructo/includes/custom-button-styles.php?ver=3e87fbef0fbe2ef149aa3aafc8c4393f","","","0");
INSERT INTO ayv__wsd_plugin_live_traffic VALUES("2","2016-04-11 10:45:09","85.14.167.34","http://www.atelier-yvanvedel.com/site-wp/wp-admin/admin.php?page=Wordfence","Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:45.0) Gecko/20100101 Firefox/45.0","http://www.atelier-yvanvedel.com/site-wp/?_wfsf=diff&#038;nonce=8e1b56dc47&#038;file=wp-includes%2Fversion.php&#038;cType=core&#038;cKey=&#038;cName=&#038;cVersion=","","","0");
INSERT INTO ayv__wsd_plugin_live_traffic VALUES("3","2016-04-11 10:45:33","85.14.167.34","http://www.atelier-yvanvedel.com/site-wp/wp-admin/admin.php?page=Wordfence","Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:45.0) Gecko/20100101 Firefox/45.0","http://www.atelier-yvanvedel.com/site-wp/?_wfsf=diff&#038;nonce=8e1b56dc47&#038;file=wp-config-sample.php&#038;cType=core&#038;cKey=&#038;cName=&#038;cVersion=","","","0");
INSERT INTO ayv__wsd_plugin_live_traffic VALUES("4","2016-04-11 10:48:07","85.14.167.34","http://www.atelier-yvanvedel.com/site-wp/wp-admin/admin.php?page=WordfenceSecOpt","Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:45.0) Gecko/20100101 Firefox/45.0","http://www.atelier-yvanvedel.com/site-wp/wp-content/themes/constructo/includes/custom-button-styles.php?ver=3e87fbef0fbe2ef149aa3aafc8c4393f","","","0");
DROP TABLE IF EXISTS ayv__wsd_plugin_scan;CREATE TABLE `ayv__wsd_plugin_scan` (
  `entryId` bigint(20) NOT NULL AUTO_INCREMENT,
  `scanId` int(11) NOT NULL,
  `filePath` varchar(1000) NOT NULL,
  `dateModified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `fileNotFound` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`entryId`),
  UNIQUE KEY `entryId_UNIQUE` (`entryId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS ayv__wsd_plugin_scans;CREATE TABLE `ayv__wsd_plugin_scans` (
  `scanId` int(11) NOT NULL AUTO_INCREMENT,
  `scanStartDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `scanEndDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `scanResult` int(11) NOT NULL DEFAULT '0',
  `failReason` varchar(5000) NOT NULL DEFAULT '',
  `scanType` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`scanId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS ayv_commentmeta;CREATE TABLE `ayv_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS ayv_comments;CREATE TABLE `ayv_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS ayv_links;CREATE TABLE `ayv_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS ayv_options;CREATE TABLE `ayv_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) DEFAULT NULL,
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=3127 DEFAULT CHARSET=utf8;
INSERT INTO ayv_options VALUES("1","siteurl","http://www.atelier-yvanvedel.com/site-wp","yes");
INSERT INTO ayv_options VALUES("2","home","http://www.atelier-yvanvedel.com","yes");
INSERT INTO ayv_options VALUES("3","blogname","Atelier Yvan Vedel | Fabricant de cuisines sur mesure","yes");
INSERT INTO ayv_options VALUES("4","blogdescription","Atelier de fabrication de cuisine artisan menuisier Yvan Vedel","yes");
INSERT INTO ayv_options VALUES("5","users_can_register","0","yes");
INSERT INTO ayv_options VALUES("6","admin_email","atelier-yvan.vedel@orange.fr","yes");
INSERT INTO ayv_options VALUES("7","start_of_week","1","yes");
INSERT INTO ayv_options VALUES("8","use_balanceTags","0","yes");
INSERT INTO ayv_options VALUES("9","use_smilies","1","yes");
INSERT INTO ayv_options VALUES("10","require_name_email","1","yes");
INSERT INTO ayv_options VALUES("11","comments_notify","1","yes");
INSERT INTO ayv_options VALUES("12","posts_per_rss","10","yes");
INSERT INTO ayv_options VALUES("13","rss_use_excerpt","1","yes");
INSERT INTO ayv_options VALUES("14","mailserver_url","mail.example.com","yes");
INSERT INTO ayv_options VALUES("15","mailserver_login","login@example.com","yes");
INSERT INTO ayv_options VALUES("16","mailserver_pass","password","yes");
INSERT INTO ayv_options VALUES("17","mailserver_port","110","yes");
INSERT INTO ayv_options VALUES("18","default_category","8","yes");
INSERT INTO ayv_options VALUES("19","default_comment_status","closed","yes");
INSERT INTO ayv_options VALUES("20","default_ping_status","open","yes");
INSERT INTO ayv_options VALUES("21","default_pingback_flag","","yes");
INSERT INTO ayv_options VALUES("22","posts_per_page","10","yes");
INSERT INTO ayv_options VALUES("23","date_format","j F Y","yes");
INSERT INTO ayv_options VALUES("24","time_format","G \\h i \\m\\i\\n","yes");
INSERT INTO ayv_options VALUES("25","links_updated_date_format","j F Y G \\h i \\m\\i\\n","yes");
INSERT INTO ayv_options VALUES("26","comment_moderation","1","yes");
INSERT INTO ayv_options VALUES("27","moderation_notify","1","yes");
INSERT INTO ayv_options VALUES("28","permalink_structure","/%postname%/","yes");
INSERT INTO ayv_options VALUES("30","hack_file","0","yes");
INSERT INTO ayv_options VALUES("31","blog_charset","UTF-8","yes");
INSERT INTO ayv_options VALUES("32","moderation_keys","","no");
INSERT INTO ayv_options VALUES("33","active_plugins","a:12:{i:0;s:30:\"advanced-custom-fields/acf.php\";i:1;s:36:\"contact-form-7/wp-contact-form-7.php\";i:2;s:33:\"duplicate-post/duplicate-post.php\";i:3;s:31:\"easy-swipebox/easy-swipebox.php\";i:4;s:39:\"gallery-slideshow/gallery-slideshow.php\";i:5;s:27:\"js_composer/js_composer.php\";i:6;s:23:\"revslider/revslider.php\";i:7;s:23:\"wordfence/wordfence.php\";i:8;s:24:\"wordpress-seo/wp-seo.php\";i:9;s:48:\"wp-flexible-map-options/flexible-map-options.php\";i:10;s:32:\"wp-flexible-map/flexible-map.php\";i:11;s:26:\"wp-security-scan/index.php\";}","yes");
INSERT INTO ayv_options VALUES("34","category_base","/categories","yes");
INSERT INTO ayv_options VALUES("35","ping_sites","http://rpc.pingomatic.com/","yes");
INSERT INTO ayv_options VALUES("37","comment_max_links","2","yes");
INSERT INTO ayv_options VALUES("38","gmt_offset","1","yes");
INSERT INTO ayv_options VALUES("39","default_email_category","1","yes");
INSERT INTO ayv_options VALUES("40","recently_edited","a:2:{i:0;s:83:\"/home/www/atelier-yvanvedel.com/wp-content/plugins/wp-flexible-map/flexible-map.php\";i:1;s:0:\"\";}","no");
INSERT INTO ayv_options VALUES("41","template","constructo","yes");
INSERT INTO ayv_options VALUES("42","stylesheet","constructo","yes");
INSERT INTO ayv_options VALUES("43","comment_whitelist","1","yes");
INSERT INTO ayv_options VALUES("44","blacklist_keys","","no");
INSERT INTO ayv_options VALUES("45","comment_registration","","yes");
INSERT INTO ayv_options VALUES("46","html_type","text/html","yes");
INSERT INTO ayv_options VALUES("47","use_trackback","0","yes");
INSERT INTO ayv_options VALUES("48","default_role","subscriber","yes");
INSERT INTO ayv_options VALUES("49","db_version","35700","yes");
INSERT INTO ayv_options VALUES("50","uploads_use_yearmonth_folders","1","yes");
INSERT INTO ayv_options VALUES("51","upload_path","","yes");
INSERT INTO ayv_options VALUES("52","blog_public","1","yes");
INSERT INTO ayv_options VALUES("53","default_link_category","0","yes");
INSERT INTO ayv_options VALUES("54","show_on_front","page","yes");
INSERT INTO ayv_options VALUES("55","tag_base","/etiquettes","yes");
INSERT INTO ayv_options VALUES("56","show_avatars","1","yes");
INSERT INTO ayv_options VALUES("57","avatar_rating","G","yes");
INSERT INTO ayv_options VALUES("58","upload_url_path","","yes");
INSERT INTO ayv_options VALUES("59","thumbnail_size_w","150","yes");
INSERT INTO ayv_options VALUES("60","thumbnail_size_h","150","yes");
INSERT INTO ayv_options VALUES("61","thumbnail_crop","1","yes");
INSERT INTO ayv_options VALUES("62","medium_size_w","300","yes");
INSERT INTO ayv_options VALUES("63","medium_size_h","300","yes");
INSERT INTO ayv_options VALUES("64","avatar_default","mystery","yes");
INSERT INTO ayv_options VALUES("65","large_size_w","1024","yes");
INSERT INTO ayv_options VALUES("66","large_size_h","1024","yes");
INSERT INTO ayv_options VALUES("67","image_default_link_type","file","yes");
INSERT INTO ayv_options VALUES("68","image_default_size","","yes");
INSERT INTO ayv_options VALUES("69","image_default_align","","yes");
INSERT INTO ayv_options VALUES("70","close_comments_for_old_posts","","yes");
INSERT INTO ayv_options VALUES("71","close_comments_days_old","14","yes");
INSERT INTO ayv_options VALUES("72","thread_comments","1","yes");
INSERT INTO ayv_options VALUES("73","thread_comments_depth","5","yes");
INSERT INTO ayv_options VALUES("74","page_comments","","yes");
INSERT INTO ayv_options VALUES("75","comments_per_page","50","yes");
INSERT INTO ayv_options VALUES("76","default_comments_page","newest","yes");
INSERT INTO ayv_options VALUES("77","comment_order","asc","yes");
INSERT INTO ayv_options VALUES("78","sticky_posts","a:0:{}","yes");
INSERT INTO ayv_options VALUES("79","widget_categories","a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ayv_options VALUES("80","widget_text","a:5:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:260:\"<div class=\"vc_btn3-container vc_btn3-center\"><a class=\"vc_general vc_btn3 vc_btn3-size-lg vc_btn3-shape-square vc_btn3-style-flat vc_btn3-block vc_btn3-color-danger\" href=\"/nos-realisations\" title=\"Nos ralisations\" target=\"_self\">NOS RALISATIONS</a></div>\";s:6:\"filter\";b:0;}i:3;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:255:\"<img alt=\"Atelier Yvan Vedel\" src=\"/wp-content/uploads/2015/12/logo-atelier-yvan-vedel-blanc-1.png\" height=\"auto\" width=\"200\">
Atelier Yvan VEDEL E.u.r.l.
Conception et cration d\'intrieur
81, impasse du Mas Bruguier
30560 Saint Hilaire de Brethmas\";s:6:\"filter\";b:1;}i:4;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:269:\"<div class=\"dancing-script\">
&nbsp;
Situ dans le Gard, proche d\'Als au pied des Cvennes, l\'Atelier Yvan Vedel accorde la plus grande attention au respect des proportions ainsi qu\' lharmonie des formes et des lignes, et ce depuis deux gnrations.
</div>\";s:6:\"filter\";b:1;}i:5;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"2015  Atelier Yvan Vedel - tous droits rservs - conception : <a href=\"http://www.vertuoz.fr\" title=\"Conception site internet Avignon\" target=\"_blank\">vertuoz</a>\";s:6:\"filter\";b:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ayv_options VALUES("81","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ayv_options VALUES("82","uninstall_plugins","a:1:{s:26:\"wp-security-scan/index.php\";a:2:{i:0;s:9:\"WsdPlugin\";i:1;s:9:\"uninstall\";}}","no");
INSERT INTO ayv_options VALUES("83","timezone_string","","yes");
INSERT INTO ayv_options VALUES("84","page_for_posts","17","yes");
INSERT INTO ayv_options VALUES("85","page_on_front","15","yes");
INSERT INTO ayv_options VALUES("86","default_post_format","0","yes");
INSERT INTO ayv_options VALUES("87","link_manager_enabled","0","yes");
INSERT INTO ayv_options VALUES("88","finished_splitting_shared_terms","1","yes");
INSERT INTO ayv_options VALUES("89","initial_db_version","33056","yes");
INSERT INTO ayv_options VALUES("90","ayv_user_roles","a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:63:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:10:\"copy_posts\";b:1;s:15:\"wpseo_bulk_edit\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"copy_posts\";b:1;s:15:\"wpseo_bulk_edit\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}","yes");
INSERT INTO ayv_options VALUES("91","WPLANG","fr_FR","yes");
INSERT INTO ayv_options VALUES("92","widget_search","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ayv_options VALUES("93","widget_recent-posts","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ayv_options VALUES("94","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ayv_options VALUES("95","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ayv_options VALUES("96","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ayv_options VALUES("97","sidebars_widgets","a:13:{s:19:\"wp_inactive_widgets\";a:1:{i:0;s:19:\"rev-slider-widget-2\";}s:18:\"orphaned_widgets_1\";a:2:{i:0;s:14:\"recent-posts-2\";i:1;s:12:\"categories-2\";}s:18:\"orphaned_widgets_2\";a:1:{i:0;s:10:\"nav_menu-3\";}s:18:\"orphaned_widgets_3\";a:0:{}s:18:\"orphaned_widgets_4\";a:0:{}s:18:\"orphaned_widgets_5\";a:1:{i:0;s:6:\"text-2\";}s:18:\"orphaned_widgets_6\";a:0:{}s:18:\"orphaned_widgets_7\";a:0:{}s:18:\"orphaned_widgets_8\";a:1:{i:0;s:10:\"nav_menu-2\";}s:18:\"orphaned_widgets_9\";a:1:{i:0;s:6:\"text-3\";}s:19:\"orphaned_widgets_10\";a:1:{i:0;s:6:\"text-4\";}s:19:\"orphaned_widgets_11\";a:1:{i:0;s:6:\"text-5\";}s:13:\"array_version\";i:3;}","yes");
INSERT INTO ayv_options VALUES("103","_transient_random_seed","0aa360d083e01bae7b3f4e0616acbcb7","yes");
INSERT INTO ayv_options VALUES("3097","_site_transient_timeout_theme_roots","1460365275","yes");
INSERT INTO ayv_options VALUES("3098","_site_transient_theme_roots","a:4:{s:10:\"constructo\";s:7:\"/themes\";s:13:\"twentyfifteen\";s:7:\"/themes\";s:14:\"twentyfourteen\";s:7:\"/themes\";s:13:\"twentysixteen\";s:7:\"/themes\";}","yes");
INSERT INTO ayv_options VALUES("3046","_transient_timeout_feed_mod_66a70e9599b658d5cc038e8074597e7c","1460167106","no");
INSERT INTO ayv_options VALUES("3047","_transient_feed_mod_66a70e9599b658d5cc038e8074597e7c","1460123906","no");
INSERT INTO ayv_options VALUES("3044","_transient_timeout_feed_66a70e9599b658d5cc038e8074597e7c","1460167106","no");
INSERT INTO ayv_options VALUES("3045","_transient_feed_66a70e9599b658d5cc038e8074597e7c","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"
\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"
	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"http://www.wordpress-fr.net\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"La communaut francophone autour du CMS WordPress et son cosystme\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 11 Feb 2016 11:25:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"fr-FR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"http://wordpress.org/?v=4.3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:45:\"
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"WPFR 2.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/jHn6JESKG5o/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"http://www.wordpress-fr.net/2015/12/21/wpfr-2-0/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 21 Dec 2015 11:00:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:16:\"Association WPFR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7516\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:422:\"Une nouvelle re souvre pour lassociation WordPress Francophone. Un nouveau bureau est en place avec  sa tte : milie Lebrun (trsorire), Benot Catherineau (secrtaire) et moi-mme, Aurlien Denis (prsident). Cette nouvelle aventure sera marque par la &#171;&#160;professionnalisation&#160;&#187; de la communaut  tous les niveaux : refonte du site communautaire, mise  jour du site [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Aurlien Denis\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7431:\"<div class=\"page\" title=\"Page 1\">
<div class=\"section\">
<div class=\"layoutArea\">
<div class=\"column\">
<p>Une nouvelle re souvre pour lassociation WordPress Francophone. Un nouveau bureau est en place avec  sa tte : milie Lebrun (trsorire), Benot Catherineau (secrtaire) et moi-mme, Aurlien Denis (prsident).</p>
<p>Cette nouvelle aventure sera marque par la &laquo;&nbsp;professionnalisation&nbsp;&raquo; de la communaut  tous les niveaux : refonte du site communautaire, mise  jour du site localis de WordPress.org, rflexion sur la cration de certifications et autres formations diplmantes, ouverture de lassociation aux membres&#8230; sont autant de chantiers que nous avons dores et dj lancs en interne.</p>
<p>Nous avons fait le choix dadopter une approche par projets qui devront tre mens de front pour donner un nouveau visage  la communaut francophone dans les 6 prochains mois. La masse de travail est consquente, nous en avons conscience et cest pour cela que toutes les bonnes volonts seront les bienvenues pour nous pauler dans cette mission. Soyez acteur de votre communaut !</p>
<p>Comment agir ? Cette question revient souvent lors des nombreux changes que chacun dentre nous peuvent avoir, aussi bien de manire virtuelle que relle. Il me semble opportun de dcliner les diffrents chantiers afin que chacun puisse se positionner sur lun deux.</p>
<h2>La refonte du site WPFR</h2>
<p>Disons le clairement : les attentes sont fortes, trs fortes ! Contenus dpasss, forum obsolte, absence de services communautaires&#8230; Parmi les changements  venir, nous pouvons retenir :</p>
<ul>
<li>Changement du nom de domaine pour se mettre en conformit avec les rgles tablies par Automattic ;</li>
<li>Changement de serveur pour de meilleures performances ;</li>
<li>Bascule progressive du blog, de la vitrine et du forum vers le site fr.wordpress.org ;</li>
<li>Cration dune nouvelle charte graphique ;</li>
<li>Refonte technique (responsive design, prise en charge des crans HDPI, etc.) ;</li>
<li>Remise  plat fonctionnelle pour rpondre  la ralit des besoins de la communaut ;</li>
<li>Nouvelle stratgie de rfrencement ;</li>
</ul>
<p>Lobjectif majeur de cette nouvelle version est le suivant : faire en sorte que chaque membre de la communaut puisse accder  des services qui le concerne : utilisateurs occasionnels ou passionns, contributeurs actifs ou en qute de contribution, dveloppeurs de thmes ou d&rsquo;extensions WordPress, animateurs dassociations locales&#8230; ce site sera le vtre !</p>
<h2>La mise  jour du site localis fr.wordpress.org</h2>
<p>Il sagit du site officiel sur lequel vous tlchargez larchive WordPress avec ses packs de traduction franaise. Pour les connaisseurs, on parle du site  Rosetta  qui fait rfrence au nom du thme install sur ce dernier.</p>
<p>WPFR a en charge la gestion de ce site et dispose dune certaine latitude dans lactivation de nouvelles fonctionnalits. Vous aurez sans doute remarqu lapparition des rubriques Thmes et Extensions ou encore de contenus rcrits sur les diffrentes pages de prsentation.</p>
<p>Ce travail est en cours de ralisation par lquipe de traducteurs bnvoles que sont Franois-Xavier Bnard, Xavier Borderie et Didier Demory.</p>
</div>
</div>
</div>
</div>
<div class=\"page\" title=\"Page 2\">
<div class=\"section\">
<div class=\"layoutArea\">
<div class=\"column\">
<p>A terme, le blog WPFR rejoindra ce site pour vous tenir inform sur les actualits en lien avec WordPress. De mme, il est envisag de migrer le forum sur cet outil pour se positionner au mme niveau que le site WordPress.org dans sa version anglophone. Il sera donc possible dutiliser votre compte WordPress.org sur les 2 sites. Cest l un chantier immense pour lequel il nous faut prendre des dcisions qui auront un impact fort tant pour lutilisateur que pour les administrateurs.</p>
<h2>La dlivrance de certifications / formations diplmantes</h2>
<p>Un vaste sujet auquel la communaut francophone de WordPress peut rpondre. A linstar de ce que propose dj dautres communauts (SEO Camp) ou des acteurs majeurs du Web (Google, Microsoft, etc.), nous pensons quil nous faut dlivrer des certifications pour les professionnels WordPress.</p>
<p>Le but est l encore de professionnaliser les acteurs du Web en France afin de permettre une identification simple et efficace des entreprises comptentes sur le march par les clients. Cest une demande rcurrente de par le monde  laquelle Automattic ne peut rpondre : le projet WordPress nappartient pas  cette multinationale, elle ne fait que le soutenir et nest donc pas lgitime pour tablir des certifications comme pourrait le faire Google pour ses services.</p>
<p>En outre, comme le savent les formateurs WordPress, les rformes successives sur la formation professionnelle ncessitent quune formation dlivre un diplme. Maxime Bernard-Jacquet est volontaire pour porter les dmarches et des synergies avec <a href=\"http://www.wp-next.fr/\" target=\"_blank\">lassociation WP-Next</a> sont  laborer.</p>
<h2>Louverture des adhsions</h2>
<p>Jusqu aujourdhui lassociation WPFR tait ferme et non ouverte aux adhsions. Certains dentre vous ont rempli un formulaire lors des WordCamps Paris et Lyon cette anne. Rassurez-vous nous les avons bien conservs et vous serez contacts en priorit pour adhrer en ligne ds lors que le nouveau site sera disponible. Si vous ne l&rsquo;avez pas encore fait, contactez-nous via notre formulaire de contact.</p>
<p>Ouvrir une association ncessite de savoir o lon va tous ensemble, de proposer des services&#8230; autant daspects qui restent encore  dfinir prcisment.</p>
<p>Vous laurez compris, les 6 prochains mois seront dcisifs ! Vous avez dsormais la parole dans les commentaires pour nous faire part de vos remarques, vous positionner sur un chantier pour nous aider ou suggrer de nouvelles ides.</p>
<p>Enfin, je terminerai par remercier chaleureusement tous ceux qui ont port l&rsquo;association WPFR durant plus d&rsquo;une dcennie. Ils se reconnatront sans doute : merci !</p>
<p>Amicalement,<br />
Le Prsident.</p>
</div>
</div>
</div>
</div>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=jHn6JESKG5o:rN9c88LUGi4:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=jHn6JESKG5o:rN9c88LUGi4:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=jHn6JESKG5o:rN9c88LUGi4:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=jHn6JESKG5o:rN9c88LUGi4:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=jHn6JESKG5o:rN9c88LUGi4:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=jHn6JESKG5o:rN9c88LUGi4:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/jHn6JESKG5o\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"http://www.wordpress-fr.net/2015/12/21/wpfr-2-0/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"55\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"http://www.wordpress-fr.net/2015/12/21/wpfr-2-0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:45:\"
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"Sortie de WordPress 4.4 Clifford\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/tgW8c7dvWys/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"http://www.wordpress-fr.net/2015/12/09/sortie-de-wordpress-4-4-clifford/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 09 Dec 2015 19:22:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:9:\"WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7508\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:401:\"La version 4.4 de WordPress, baptiseClifford en honneur au trompettiste de jazz Clifford Brown, est disponible en tlchargement ou en mise  jour via votre tableau de bord WordPress. Les nouvelles fonctionnalits de la 4.4 vous donnentun site plus connect et au design adaptatif. Clifford introduit galement un nouveau thme par dfaut :Twenty Sixteen. Prsentation [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Xavier\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6445:\"<p>La version 4.4 de WordPress, baptiseClifford en honneur au trompettiste de jazz Clifford Brown, est disponible en tlchargement ou en mise  jour via votre tableau de bord WordPress.</p>
<p>Les nouvelles fonctionnalits de la 4.4 vous donnentun site plus connect et au design adaptatif. Clifford introduit galement un nouveau thme par dfaut :Twenty Sixteen.</p>
<p><iframe src=\"https://videopress.com/embed/J44FHXvg?hd=0\" width=\"632\" height=\"354.35838150289015\" frameborder=\"0\" allowfullscreen=\"allowfullscreen\"></iframe></p>
<hr />
<h2>Prsentation deTwenty Sixteen</h2>
<p><img class=\"aligncenter size-large wp-image-7512\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/12/ipad-white-desktop-2x-1024x6941-500x339.png\" alt=\"ipad-white-desktop-2x-1024x694\" width=\"500\" height=\"339\" /></p>
<p>Le nouveau thme par dfaut, Twenty Sixteen, est une modernisation dun thme de blog classique.</p>
<p>Twenty Sixteen a t conu pour tre superbe sur tous les appareils. Avec son design en grille fluide, son en-tte flexible et ses jeux de couleurs joyeux, elle mettre en valeur votre contenu.</p>
<hr />
<h2>Images adaptatives</h2>
<p><img class=\"aligncenter size-large wp-image-7511\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/12/responsive-devices-ipad-2x-500x229.png\" alt=\"responsive-devices-ipad-2x\" width=\"500\" height=\"229\" /></p>
<p>WordPress approche dsormais laffichage des images de manires plus intelligente, utilisant  chaque fois la taille dimage la plus pertinente en fonction de lappareil utilis. Vous navez rien a changer  votre thme: a fonctionne, cest tout.</p>
<hr />
<h2>Intgrez votre contenu WordPress</h2>
<div class=\"embed-container\">
<p>https://make.wordpress.org/core/2015/10/28/new-embeds-feature-in-wordpress-4-4/</p>
<p>Vous pouvez dsormais insrer vos articles dans dautres sites, et mme dans dautres sites WordPress. Collez simplement ladresse du contenu dans lditeur, et une prvisualisation saffichera instantanment, avec titre, extrait, et limage de Une si vous avez mise une. Vous y trouverez mme licne de votre site et les liens pour commenter et partager.</p>
</div>
<p>En plus de linsertion de contenu, WordPress 4.4 apporte la reconnaissance de cinq nouveaux fournisseurs oEmbed: Cloudup, RedditComments, ReverbNation, SpeakerDeck et VideoPress.</p>
<hr />
<h2>Sous le capot</h2>
<p><img class=\"aligncenter size-large wp-image-7513\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/12/banner-1544x500-500x162.jpg\" alt=\"banner-1544x500\" width=\"500\" height=\"162\" /></p>
<h3>Infrastructure de lAPI REST</h3>
<p>Linfrastructure de lAPI REST a t intgre au coeur de WordPress, ouvrant ainsi une nouvelle re pour le dveloppement avec le logiciel. LAPI REST a t conue pour offrir aux dveloppeurs une manire central de construire et tendre des API RESTful bases sur le socle WordPress.</p>
<p>Linfrastructure est la premire partie dune mise en place en plusieurs tapes de lAPI REST. Linclusion des points daccs est prvue pour une prochaine version. Pour avoir un aperu des principaux points daccs, et pour obtenir plus dinformation sur la manire dtendre lAPI REST, dcouvrez lextension officielle <a class=\"thickbox\" href=\"http://xavier.borderie.net/blog/wp-admin/plugin-install.php?tab=plugin-information&amp;plugin=rest-api&amp;TB_iframe=1&amp;width=600&amp;height=550\">WordPress REST API</a>.</p>
<h3>Mta des termes</h3>
<p>Les termes disposent dsormais de mtadonnes, tout comme les articles. Lisez la documentation de <a href=\"https://developer.wordpress.org/reference/functions/add_term_meta\"><code>add_term_meta()</code></a>,<a href=\"https://developer.wordpress.org/reference/functions/get_term_meta\"><code>get_term_meta()</code></a> et <a href=\"https://developer.wordpress.org/reference/functions/update_term_meta\"><code>update_term_meta()</code></a>pour plus d&rsquo;information.</p>
<h3>Amlioration des requtes de commentaires</h3>
<p>Les requtes de commentaires disposent dsormais dun gestionnaire de cache pour amliorer les performances. Les nouveaux arguments de <code>WP_Comment_Query</code> simplifient la mise en place de requtes de commentaires robustes.</p>
<div class=\"feature-section under-the-hood three-col\">
<div class=\"col\">
<h3>Objets pour les termes, commentaires et rseaux</h3>
<p>Les nouveaux objets <code>WP_Term</code>, <code>WP_Comment</code>et <code>WP_Network</code> rendent la gestion par le code des termes, commentaires et rseaux plus prvisible et intuitive.</p>
<h2>L&rsquo;quipe</h2>
<p><a class=\"alignleft\" href=\"https://profiles.wordpress.org/wonderboymusic\"><img id=\"grav-ed0f881acb9dc96bee53e4dc61b5558f-0\" class=\"grav-hashed\" src=\"https://www.gravatar.com/avatar/ed0f881acb9dc96bee53e4dc61b5558f?d=mm&amp;s=180&amp;r=G\" alt=\"Scott Taylor\" width=\"80\" height=\"80\" /></a>Cette version a t mene par<a href=\"http://scotty-t.com/\">Scott Taylor</a>, avec l&rsquo;aide de plus de471 contributeurs &#8212; le plus grand nombre jamais vu pour une nouvelle version de WordPress. Parmi eux, on trouve quelques franais : Mathieu Viet, Julio Potier, Nicolas Juen, et tous les traducteurs qui ont donn de leur temps pour s&rsquo;assurer que cette version serait traduite dans les temps. Merci  tous !</p>
</div>
</div>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=tgW8c7dvWys:O5SMFkejhIY:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=tgW8c7dvWys:O5SMFkejhIY:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=tgW8c7dvWys:O5SMFkejhIY:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=tgW8c7dvWys:O5SMFkejhIY:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=tgW8c7dvWys:O5SMFkejhIY:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=tgW8c7dvWys:O5SMFkejhIY:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/tgW8c7dvWys\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"http://www.wordpress-fr.net/2015/12/09/sortie-de-wordpress-4-4-clifford/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"http://www.wordpress-fr.net/2015/12/09/sortie-de-wordpress-4-4-clifford/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:42:\"
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress fait tourner 25% du web\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/WIL51xhSWSw/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"http://www.wordpress-fr.net/2015/11/09/wordpress-fait-tourner-25-du-web/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 Nov 2015 12:15:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7491\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:341:\"Le nombre tant attendu a t atteint ce week-end : selon le site W3Techs, qui prsente de nombreuses statistiques et tudes chiffres sur les technologies du web, WordPress est aujourd&#8217;hui utilis par 25% des sites web &#8212; et pas seulement 1/4 des sites qui ont utilisent un outil de gestion de contenu (CMS), non : [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Xavier\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5162:\"<p>Le nombre tant attendu a t atteint ce week-end : selon le site <a href=\"http://w3techs.com/\">W3Techs</a>, qui prsente de nombreuses statistiques et tudes chiffres sur les technologies du web, <a href=\"http://w3techs.com/technologies/history_overview/content_management/all/y\">WordPress est aujourd&rsquo;hui utilis par 25% des sites web</a> &#8212; et pas seulement 1/4 des sites qui ont utilisent un outil de gestion de contenu (CMS), non : 25% de TOUS les sites actuellement en ligne.</p>
<p><img class=\"aligncenter wp-image-7492 size-full\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/11/wordpress-25pourcent-w3techs-tableau1.png\" alt=\"wordpress-25pourcent-w3techs-tableau1\" width=\"521\" height=\"188\" />Le site indique par ailleurs que WordPress a 58,7% de part de march parmi les sites qui utilisent un CMS, avec l&rsquo;ajout de plus de 1100 sites par jour (dans le top 10 millions des sites).</p>
<p><img class=\"aligncenter wp-image-7493 size-full\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/11/wordpress-25pourcent-w3techs-tableau2.png\" alt=\"wordpress-25pourcent-w3techs-tableau2\" width=\"509\" height=\"146\" /></p>
<p>C&rsquo;est colossal, et c&rsquo;est le rsultat de plusieurs annes d&rsquo;amlioration d&rsquo;un projet qui, <a href=\"http://ma.tt/2015/11/seventy-five-to-go/\">comme le rappelle Matt Mullenweg</a>, a commenc <a href=\"http://zengun.org/weblog/archives/2001/06/post1958/\">en juin 2001</a>sous le nom de <a href=\"http://cafelog.com/\">b2/cafelog</a>, dans la chambre du franais Michel Valdrighi, alors tudiant sur sa Corse natale (voir <a href=\"https://wordpress.tv/2012/02/27/les-origines-de-wordpress-la-naissance-de-b2cafelog/\">sa confrence sur le sujet au WordCamp Paris 2011</a>).</p>
<p><img class=\"aligncenter wp-image-7495 size-full\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/11/wordpress-25pourcent-w3techs-graphique1.png\" alt=\"wordpress-25pourcent-w3techs-graphique1\" width=\"765\" height=\"506\" /></p>
<p>Ce qui a commenc comme un script blog personnel utilis par quelques 3000 personnes au fate de sa popularit, est aujourd&rsquo;hui l&rsquo;outil choisi par la grande majorit des individus et socits quand il s&rsquo;agit de mettre leurs ides et contenus en ligne.</p>
<p><img class=\"aligncenter wp-image-7494 size-full\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/11/wordpress-25pourcent-w3techs-tableau4.png\" alt=\"wordpress-25pourcent-w3techs-tableau4\" width=\"534\" height=\"228\" /></p>
<p>Matt reprend ensuite : &laquo;&nbsp;Il reste une grosse opportunit  saisir avec les 57% de sites qui n&rsquo;utilisent aucun CMS&nbsp;&raquo;, ou en tout cas aucun d&rsquo;identifiable &#8212; qui pourraient tout aussi bien tre des WordPress ou Drupal dont le propritaire a choisi de cacher son outil. &laquo;&nbsp;Je pense que c&rsquo;est l o nous pouvons avoir une norme croissance (et je soutiens galement tous les autres CMS open-source).&nbsp;&raquo;</p>
<p><img class=\"aligncenter size-full wp-image-7496\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/11/wordpress-25pourcent-w3techs-tableau3.png\" alt=\"wordpress-25pourcent-w3techs-tableau3\" width=\"469\" height=\"321\" /></p>
<p> suivre galement, <a href=\"http://trends.builtwith.com/cms/WordPress\">les statistiques proposes par Builtwith</a>.</p>
<p>Ce 25% est un beau nouveau chiffre  ajouter  notre communaut en 2015, avec les 20 ans de PHP&#8230; et les 10 ans de l&rsquo;association WordPress-Francophone (dont vous aurez bientt des nouvelles, promis !).</p>
<p>Merci  toutes la communaut de dveloppeurs, de traducteurs, de crateurs d&rsquo;extensions et de thmes, d&rsquo;accompagnateurs sur les forums, et tant d&rsquo;autres !</p>
<p>Rendez-vous aux prochains vnements WordPress franais afin de fter cela dignement,  commencer par le <a href=\"http://2015.wptech.fr/\">WP Tech</a>  Nantes le 5 dcembre, et le <a href=\"https://paris.wordcamp.org/2016/\">WordCamp Paris</a> les 5 et 6 fvrier 2016, ainsi que tous les autres vnements locaux, petits et grands, organiss par les membres de la grande famille WordPress !</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=WIL51xhSWSw:f1vr0WZxhp4:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=WIL51xhSWSw:f1vr0WZxhp4:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=WIL51xhSWSw:f1vr0WZxhp4:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=WIL51xhSWSw:f1vr0WZxhp4:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=WIL51xhSWSw:f1vr0WZxhp4:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=WIL51xhSWSw:f1vr0WZxhp4:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/WIL51xhSWSw\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"http://www.wordpress-fr.net/2015/11/09/wordpress-fait-tourner-25-du-web/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"http://www.wordpress-fr.net/2015/11/09/wordpress-fait-tourner-25-du-web/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:54:\"
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"LHebdo WordPress n263 du 10e anniversaire\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/ayO_P6QzZyY/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"http://www.wordpress-fr.net/2015/08/28/lhebdo-wordpress-n263-du-10e-anniversaire/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 28 Aug 2015 18:15:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:16:\"Association WPFR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:12:\"anniversaire\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7471\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:348:\"WPFR a 10 ans ! Il tait une fois WordPress Francophone&#8230; Cette histoire a commenc il y a 10 ans par la volont de quelques utilisateurs qui voulaient avoir un espace d&#8217;change en franais pour ne plus se faire rejeter des forums officiels allergiques aux non anglophones. Et un nouveau site wordpress-fr.net tait n ! [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benot\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:12074:\"<h3>WPFR a 10 ans !</h3>
<p>Il tait une fois WordPress Francophone&#8230; <a href=\"http://www.wordpress-fr.net/2005/08/24/le-depart/\">Cette histoire a commenc il y a 10 ans</a> par la volont de quelques utilisateurs qui voulaient avoir un espace d&rsquo;change en franais pour ne plus se faire rejeter des forums officiels allergiques aux non anglophones. <a href=\"http://www.wordpress-fr.net/2005/08/25/wordpress-frnet/\">Et un nouveau site wordpress-fr.net tait n </a>!</p>
<p>10 ans dj de support en franais avec <a href=\"http://www.wordpress-fr.net/support/\">un forum</a> qui est aujourd&rsquo;hui la pierre angulaire de notre communaut. Il reprsente 7 6741 inscrits pour prs de 110 000 discussions ouvertes reprsentant 560 000 messages.</p>
<p>WordPress Francophone et son site portail wordpress-fr.net c&rsquo;est aujourd&rsquo;hui une moyenne de prs de 200 000 visites par mois pour environ 400 000 pages vues mensuelles.</p>
<p>WPFR c&rsquo;est aussi une prsence sur <a href=\"https://twitter.com/wordpress_fr\">Facebook</a>,<a href=\"https://twitter.com/wordpress_fr\"> sur Twitter</a> et sur <a href=\"https://plus.google.com/u/0/b/112387028272126355329/112387028272126355329\">Google+.</a></p>
<p>Comme vous l&rsquo;aurez constat, notre site en gnral et le forum en particulier sont vieillissants&#8230; cela fait des annes qu&rsquo;une refonte est prvue. L&rsquo;volution de notre association en cours nous donne de bons espoirs pour cette fin d&rsquo;anne et le dbut de la suivante. Des annonces officielles vont suivre. Restez connects !</p>
<p>Des projets dans les cartons depuis longtemps devraient pouvoir se concrtiser enfin dans les mois  venir.</p>
<p>Merci  toutes et tous pour votre fidlit, votre soutien, vos encouragements ou mme parfois vos remarques et critiques&#8230; Rien n&rsquo;est vain et WPFR avance, doucement mais surement et cela grce  vous tous, grce  la communaut !</p>
<p><strong>Joyeux anniversaire WPFR</strong> ! 10 ans, c&rsquo;est dj presque l&rsquo;adolescence ! Longue vie !</p>
<hr />
<p>&nbsp;</p>
<p><span style=\"text-decoration: underline;\"><strong>Place  l&rsquo;hebdo WordPress n263 :</strong></span></p>
<h3>La roadmap pour WordPress 4.4</h3>
<p>Le chantier se poursuit, pas de repos. <a href=\"https://make.wordpress.org/core/2015/08/27/taxonomy-roadmap-for-4-4-and-beyond/\">Voici la feuille de route pour 4.4</a>. (en) &#8230; et on vous demande mme votre avis sur <a href=\"https://make.wordpress.org/core/2015/08/19/wordpress-4-4-whats-on-your-wishlist/\">ce que vous voulez voir arriver dans cette future version</a>. (en)</p>
<h3>Le sondage WordPress 2015</h3>
<p>Le sondage annuel de WordPress pour recueillir votre avis sur vos habitudes avec WordPress est disponible. <a href=\"http://wp-survey.polldaddy.com/s/wp-2015\">N&rsquo;hsitez pas  le remplir</a>. (en)</p>
<h3>2016, le prochain thme par dfaut</h3>
<p><a href=\"https://make.wordpress.org/core/2015/08/25/introducing-twenty-sixteen/\">2016 est d&rsquo;ores et dj mis en chantier</a>. (en)</p>
<h3>BuddyPress 2.3.3</h3>
<p>BuddyPress arrive dans sa <a href=\"https://buddypress.org/2015/08/buddypress-2-3-3/\">version 2.3.3</a>. (en)</p>
<h3>Les mots de passe sous WordPress 4.3</h3>
<p>La dernire version en date de WordPress introduit <a href=\"https://make.wordpress.org/core/2015/07/28/passwords-strong-by-default/\">une nouvelle gestion des mots de passe</a> (en).</p>
<h3>Les nouveauts de WordPress 4.3</h3>
<p>Si vous n&rsquo;tes pas encore <a href=\"http://wptavern.com/wordpress-4-3-billie-named-after-jazz-singer-billie-holiday-is-available-for-download\">passs (en) </a> <a href=\"https://poststatus.com/wordpress-4-3-billie-released/\">WordPress 4.3 (en)</a>, <a href=\"http://www.lumieredelune.com/encrelune/nouveautes-wordpress-4-3,2015,08\">voici ce que vous ratez</a> &#8230; quelques <a href=\"http://wptavern.com/text-patterns-and-the-quick-link-toolbar-in-wordpress-4-3\">autres explications</a> (en) ! Mais attention&#8230; <a href=\"http://www.layerswp.com/2015/08/are-you-ready-for-wordpress-4-3/\">soyez srs d&rsquo;tre prts (en) </a>! Certains <a href=\"http://www.lumieredelune.com/encrelune/avertissement-widget-obsolete,2015,08\">Widgets peuvent tre obsoltes</a> notamment.</p>
<h3>La check list essentielle pour la mise en place dun site sous WordPress</h3>
<p><a href=\"http://www.vingthuitzerotrois.fr/wordpress/la-check-list-essentielle-pour-la-mise-en-place-dun-site-sous-wordpress-15947/\">LA checklist pour le moment fatidique (en) </a>o l&rsquo;on doit mettre en place un site sous WordPress. Pour ne rien oublier !</p>
<h3>Le BuddyCamp Brighton de iMath</h3>
<p>Notre iMath national a particip au BuddyCamp de Brighton, <a href=\"http://imathi.eu/2015/08/10/buddycamp-brighton/\">voici son compte rendu</a>.</p>
<h3>Automattic recrute</h3>
<p>Automattic <a href=\"http://ma.tt/2015/08/automattic-is-hiring-2/\">recrute diffrents profils</a>. (en)</p>
<h3>Dsactiver les notifications de YOAST SEO</h3>
<p>Les notifications intempestives de cette extension pour drangent ? <a href=\"http://wpchannel.com/desactiver-notifications-yoast-seo/\">voici la solution</a>.</p>
<h3>Un nouvel vnement ddi  REST API</h3>
<p><a href=\"http://feelingrestful.com/\">A day of Rest est le prochain vnement (en) </a>ddi  cette API de WordPress.</p>
<h3>Inclure l&rsquo;extension REST API dans les thmes du rpertoire officiel ?</h3>
<p>L&rsquo;quipe en charge des thmes du rpertoire officiel ont vot l&rsquo;autorisation d&rsquo;<a href=\"http://wptavern.com/wordpress-theme-review-team-votes-to-allow-themes-to-use-the-rest-api-plugin\">inclure l&rsquo;extension REST API (en)</a> dans les thmes du rpertoire officiel.</p>
<h3>Faciliter les invitations Slack</h3>
<p>Slack est en constante augmentation de popularit. <a href=\"http://wptavern.com/new-wordpress-plugin-automates-slack-team-invitations\">Voici une extension pour simplifier les invitations</a>. (en)</p>
<h3>WordPress, on a un problme !</h3>
<p>Ici ce n&rsquo;est pas Houston, mais quand on a un problme avec WordPress que fait-on ? <a href=\"http://wpformation.com/wordpress-probleme/\">Voici des conseils par WPFormation</a>.</p>
<h3>Les nouveauts de WooCommerce 2.4</h3>
<p><a href=\"http://www.absoluteweb.net/woocommerce-2-4-nouveautes/\">Dcouvrez les nouveauts de WooCommerce 2.4 (en).</a></p>
<h3>Interview de Sara Rosso</h3>
<p>Sara Rosso de chez Automattic <a href=\"http://mymorningroutine.com/sara-rosso/\">est interviewe par mymorningroutine.com</a>. Interview forcment dcale. ?</p>
<h3>Vous n&rsquo;aimez pas les emojis ?</h3>
<p><a href=\"http://www.hongkiat.com/blog/disable-wordpress-emoticons/\">Dsactivez-les !</a> (en)</p>
<h3>Interview de Miriam Schwab de Illuminea.com</h3>
<p>Retour d&rsquo;exprience de <a href=\"http://wptavern.com/wpweekly-episode-205-interview-with-miriam-schwab\">Miriam Schwab</a>. (en)</p>
<h3>WooCommerce : Synchroniser adresses de livraison et de facturation</h3>
<p>Absolute Web explique <a href=\"http://www.absoluteweb.net/woocommerce-synchroniser-pays-livraison-facturation/\">comment synchroniser les adresses de facturation et de livraison </a>dans WooCommerce.</p>
<h3>Comment optimiser WordPress ?</h3>
<p>Korben donne des <a href=\"http://korben.info/comment-optimiser-un-vieux-wordpress-obese.html\">conseils pour allger et optimiser </a>un vieux WordPress obse !</p>
<h3>Quel futur pour WordPress ?</h3>
<p>Quelques hypothses pour <a href=\"http://torquemag.io/where-do-you-see-the-future-of-wordpress/\">l&rsquo;avenir de WordPress</a> (en).</p>
<h3>Ajouter un portfolio</h3>
<p>Comment ajouter un portflolio dans WordPress ? <a href=\"http://www.wpbeginner.com/plugins/how-to-add-a-portfolio-to-your-wordpress-site/\">Suivez le guide</a>. (en)</p>
<h3>Retours d&rsquo;exprience</h3>
<p><a href=\"http://www.wpelevation.com/2015/08/starting-a-wordpress-consulting-business/\">Troy Dean raconte son exprience</a> (en) en tant que consultant WordPress depuis 8 ans. Et Becky Davis nous <a href=\"http://heropress.com/essays/doing-what-i-want/\">raconte son parcours</a>. (en)</p>
<h3>Interview de Nikolay Bachiyski, chez de la scurit de WordPress.org</h3>
<p><a href=\"http://wptavern.com/short-interview-with-nikolay-bachiyski-wordpress-security-czar\">Nikolay est chef de la scurit</a> de WorPress.org (en).</p>
<h3>Comment installer une extension ?</h3>
<p>Il est parfois intressant de revenir aux bases, c&rsquo;est pourquoi cet article devrait intressant les <a href=\"http://yesweblog.fr/wordpress/comment-installer-extension-plugin-wordpress/\">dbutants qui souhaitent installer des extensions</a>.</p>
<h3>Prsentation de Elegant Themes</h3>
<p>WP Marmite nous fait dcouvrir <a href=\"http://wpmarmite.com/elegant-themes/\">Elegant Themes</a>.</p>
<h3>La hirarchie des templates</h3>
<p>La hirarchie des templates est trs importantes dans WordPress. <a href=\"http://wphierarchy.com/\">Voici comment s&rsquo;en imprgner</a>. (en)</p>
<h3>API personnalis pour base de donnes</h3>
<p>Voici le premier numro d&rsquo;<a href=\"https://pippinsplugins.com/custom-database-api-reasons-for-custom-tables-and-an-api/\">un tuto sur la gestion des bases de donnes</a>.</p>
<h3>Un glossaire pour dbutants</h3>
<p>WordPress vous parle en chinois, et ce malgr la langue slectionne avec soin ? Alors <a href=\"http://www.wpexplorer.com/wordpress-glossary-beginners/\">ce guide peut tre pour vous</a> ! (en)</p>
<h3>Un guide pour crer son site e-commerce</h3>
<p>Si vous voulez quelques ides pour crer votre site e-commerce avec WordPress, <a href=\"https://selfstartr.com/wordpress-ecommerce/\">ce guide pourra vous donner des pistes</a>. (en)</p>
<h3>25 raisons de passer  WordPress</h3>
<p>Nelio donne <a href=\"http://neliosoftware.com/25-reasons-to-switch-to-wordpress/\">25 raisons de migrer vers WordPress</a>. (en)</p>
<h3>Au revoir Thmes de France</h3>
<p>Thmes de France, la plateforme de thmes WordPress lances par Alex Bortolotti vient de <a href=\"https://www.themesdefrance.fr/\">fermer dfinitivement ses portes</a>. Alex nous <a href=\"http://alexbortolotti.com/pourquoi-arret-themes-de-france/\">explique les raisons</a>.</p>
<h3>Ajouter un retour en haut</h3>
<p>Thierry propose un bouton pour revenir en <a href=\"https://gist.github.com/thierrypigot/46a1f71af58c2c83a9a7\">haut de page dans Genesis</a>.</p>
<h3>Il tait une fois Automattic&#8230;</h3>
<p>Automattic c&rsquo;est quoi ? <a href=\"http://www.elegantthemes.com/blog/editorial/a-history-of-automattics-acquisitions-from-gravatar-to-woothemes\">voici une partie de la rponse</a>. (en)</p>
<h3>Afficher le profil Facebook dans WordPress</h3>
<p>Si vous souhaitez <a href=\"http://www.hongkiat.com/blog/facebook-author-tag-wordpress/\">afficher le profil Facebook</a> de vos auteurs par exemple, voici comment faire.</p>
<h3>Top 99 des influenceurs WordPress</h3>
<p>Les <a href=\"http://99robots.com/top-99-wordpress-influencers-2015/\">99 personnes</a> qui font WordPress ! (en)</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=ayO_P6QzZyY:xNb17R3nBDQ:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=ayO_P6QzZyY:xNb17R3nBDQ:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=ayO_P6QzZyY:xNb17R3nBDQ:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=ayO_P6QzZyY:xNb17R3nBDQ:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=ayO_P6QzZyY:xNb17R3nBDQ:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=ayO_P6QzZyY:xNb17R3nBDQ:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/ayO_P6QzZyY\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"http://www.wordpress-fr.net/2015/08/28/lhebdo-wordpress-n263-du-10e-anniversaire/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"http://www.wordpress-fr.net/2015/08/28/lhebdo-wordpress-n263-du-10e-anniversaire/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:48:\"
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"Sortie de  WordPress 4.3  Billie \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/KD2NWiu1sHU/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"http://www.wordpress-fr.net/2015/08/19/sortie-de-wordpress-4-3-billie/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 19 Aug 2015 06:35:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:14:\"Dveloppement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:9:\"WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7463\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:391:\"La version 4.3 de WordPress, baptise&#171;&#160;Billie&#160;&#187; en l&#8217;honneur de la chanteuse de jazz Billie Holiday, est disponible en tlchargementou en mise  jour via le tableau de bord de votre WordPress. Les nouvelles fonctionnalits de la version 4.3 simplifient grandement la mise en forme de votre contenu et la personnalisation de votre site. Les menus [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:3:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:45:\"http://s.w.org/images/core/4.3/formatting.mp4\";s:6:\"length\";s:7:\"1574782\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:45:\"http://s.w.org/images/core/4.3/formatting.ogv\";s:6:\"length\";s:7:\"1939540\";s:4:\"type\";s:9:\"video/ogg\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:46:\"http://s.w.org/images/core/4.3/formatting.webm\";s:6:\"length\";s:6:\"686435\";s:4:\"type\";s:10:\"video/webm\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Xavier\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5597:\"<p>La version 4.3 de WordPress, baptise&laquo;&nbsp;Billie&nbsp;&raquo; en l&rsquo;honneur de la chanteuse de jazz <a href=\"https://fr.wikipedia.org/wiki/Billie_Holiday\">Billie Holiday</a>, est disponible en <a href=\"http://fr.wordpress.org/\">tlchargement</a>ou en mise  jour via le tableau de bord de votre WordPress. Les nouvelles fonctionnalits de la version 4.3 simplifient grandement la mise en forme de votre contenu et la personnalisation de votre site.</p>
<p><iframe width=\'555\' height=\'312\' src=\'https://videopress.com/embed/T54Iy7Tw?hd=1\' frameborder=\'0\' allowfullscreen></iframe><script src=\'https://v0.wordpress.com/js/next/videopress-iframe.js?m=1435166243\'></script></p>
<h3>Les menus dans loutil de personnalisation</h3>
<p><img class=\"size-large wp-image-7464 alignnone\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/08/menu-customizer-500x281.png\" alt=\"menu-customizer\" width=\"500\" height=\"281\" /></p>
<p>Crez votre menu, mettez-le  jour et placez-le, le tout en mme temps que vous prvisualisez son apparence dans loutil de personnalisation. Le design pur de loutil de personnalisation offre une interface accessible tant pour les appareils mobiles que pour les utilisateurs en situation de handicap. De version en version, il devient de plus en plus facile de donner  votre lapparence que vous souhaitez.</p>
<h3>Les raccourcis de mise en forme</h3>
<p>Votre flux dcriture va sacclrer grce aux nouveaux raccourcis de WordPress 4.3. Utilisez lastrisque pour crer des listes, et le croisillon pour mettre en place un titre. Votre flux nest plus ralenti par le mouvement de souris; votre texte est plus clair grce aux <code>*</code> et aux <code>#</code>.</p>
<h3>Des icnes pour votre site</h3>
<p><img class=\"size-large wp-image-7465 alignnone\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/08/site-icon-customizer-500x281.png\" alt=\"site-icon-customizer\" width=\"500\" height=\"281\" /></p>
<p>Les icnes du site reprsentent votre site dans les onglets des navigateurs, dans les menus de favoris, et dans la page daccueil des appareils mobiles. Ajoutez votre propre icne de site dans loutil de personnalisation;il restera mme en place quand vous changerez de thme. Faites en sorte que tout votre site soit le reflet de votre marque.</p>
<h3>De meilleurs mots de passe</h3>
<p><img class=\"alignnone size-large wp-image-7466\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/08/better-passwords-500x281.png\" alt=\"better-passwords\" width=\"500\" height=\"281\" /></p>
<p>Amliorez la scurit de votre site grce  la nouvelle gestion des mots de passe de WordPress. Au lieu de recevoir un mot de passe dans votre messagerie, vous recevrez un lien de rinitialisation. Et lorsque vous ajouterez de nouveaux utilisateurs  votre site, ou que vous modifierez le profil dun utilisateur, WordPress gnrera automatiquement un mot de passe scuris.</p>
<h3>D&rsquo;autres amliorations</h3>
<ul>
<li><strong>Une utilisation de ladministration plus agrable </strong>&#8212; Des amliorations  laffichage des listes sur lensemble des pages dadministration rendent WordPress plus accessible et plus facile  utiliser sur nimporte quel appareil.</li>
<li><strong>Les commentaires sont dsactivs sur les pages</strong>&#8212; Toutes les nouvelles pages que vous crerez auront les commentaires dsactivs par dfaut. Cela permet de limiter les conversations  votre blog, l o elle sont censes se drouler.</li>
<li><strong>Une personnalisation rapide de votre site</strong>&#8212; O que vous soyez sur linterface du site, vous pouvez cliquer sur le lien de personnalisation dans la barre doutils pour apporter une modification rapide  votre site.</li>
<li><strong>Feuille de route de la taxinomie</strong>&#8212; Les termes partags par plusieurs taxinomies sont maintenant spars en plusieurs termes distincts.</li>
<li><strong>Hirarchie des fichiers du thme</strong>&#8212; Le fichier <code>singular.php</code> a t ajout en tant qualternative  <code>single.php</code> et <code>page.php</code>.</li>
<li><strong><code>WP_List_Table</code></strong>&#8212; Les tableaux de listes peuvent et doivent dsigner une colonne principale.</li>
</ul>
<p>Cette version a t mene par <a href=\"http://konstantin.obenland.it/\">Konstantin Obenland</a>, avec l&rsquo;aide 246 contributeurs, parmi lesquels on retrouve quelques franais :Clement Biron,Julio Potier,Fabien Quatravaux et Mathieu Viet.</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=KD2NWiu1sHU:oBCnwZX5Yj8:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=KD2NWiu1sHU:oBCnwZX5Yj8:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=KD2NWiu1sHU:oBCnwZX5Yj8:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=KD2NWiu1sHU:oBCnwZX5Yj8:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=KD2NWiu1sHU:oBCnwZX5Yj8:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=KD2NWiu1sHU:oBCnwZX5Yj8:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/KD2NWiu1sHU\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"http://www.wordpress-fr.net/2015/08/19/sortie-de-wordpress-4-3-billie/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"11\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"http://www.wordpress-fr.net/2015/08/19/sortie-de-wordpress-4-3-billie/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:51:\"
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"LHebdo WordPress n262 : Communauts  Retours dexprience  Astuces\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/NRscrl4Ddlw/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"http://www.wordpress-fr.net/2015/07/24/lhebdo-wordpress-n262-communautes-retours-dexperience-astuces/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 24 Jul 2015 17:56:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:7:\"Astuces\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Brves\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:12:\"communauts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7456\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:368:\"WordPress 4.2.3 : mise  jour de scurit Une 3e mise  jour mineure vient corriger une faille de scurit dtecte plus tt. La communaut franaise grandie Jenny Beaumont a fait un rsum de l&#8217;histoire (en) de la communaut franaise de WordPress&#8230; et milie vous dit pourquoi en faire partie. 14e Podcast VFT : l&#8217;animation [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benot\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8365:\"<h3>WordPress 4.2.3 : mise  jour de scurit</h3>
<p>Une <a href=\"http://wptavern.com/wordpress-4-2-3-is-a-critical-security-release-fixes-an-xss-vulnerability\">3e mise  jour mineure </a>vient <a href=\"https://wordpress.org/news/2015/07/wordpress-4-2-3/\">corriger </a>une faille de scurit dtecte plus tt.</p>
<h3>La communaut franaise grandie</h3>
<p>Jenny Beaumont a fait <a href=\"https://poststatus.com/growth-in-the-french-community/\">un rsum de l&rsquo;histoire (en)</a> de la communaut franaise de WordPress&#8230; et <a href=\"http://www.wp-pro.fr/pourquoi-rejoindre-la-communaute-wordpress/\">milie vous dit pourquoi en faire partie</a>.</p>
<h3>14e Podcast VFT : l&rsquo;animation d&rsquo;une communaut locale</h3>
<p>Entours de Valrie et Nicolas, l&rsquo;quipe de VFT <a href=\"http://veryfrenchtrip.com/podcast/podcast-14-animation-locale-wordpress/\">nous donne des pistes pour animer une communaut locale</a>.</p>
<h3>Le WP Tech 2015 a une salle !</h3>
<p>Le lieu du prochain WP Tech <a href=\"http://2015.wptech.fr/lieu/\">est connu</a>, ce sera la facult de Pharmacie en plein centre de Nantes.</p>
<h3>Des retours du WPMX Day, des vrais (cette fois !)</h3>
<p>J&rsquo;avais fait une erreur dans mon dernier hebdo et confondu des liens&#8230; et je n&rsquo;a pas fait la mise  jour&#8230; dont acte !</p>
<ul>
<li><a href=\"http://www.myleneb.fr/wpmx-day-2015-mes-impressions/\">Mylne Boyrie</a></li>
<li><a href=\"http://www.ohmyweb.fr/retour-sur-le-wpmx-day-du-6-juin-2/\">Oh My Web</a></li>
<li><a href=\"http://www.goodness.fr/2015/06/13/referencement-wordpress-wpmx-2015/\">Goodness</a></li>
<li><a href=\"http://www.inpixelitrust.fr/blog/faites-rentrer-votre-elephant-dans-une-smart-bonnes-pratiques-sur-mobiles-ma-conference-au-wpmx-day-2015/\">Stphanie Walter</a></li>
</ul>
<h3>Quelques nouvelles des WordCamps dans le monde</h3>
<p>Les WordCamps franais n&rsquo;tant pas les seuls au monde, <a href=\"https://wordpress.org/news/2015/07/wordcamps-update/\">voici du nouveau sur le reste du Monde</a> ! (en) &#8230; avec un clin dil  Fabrice Ducarme, bien connu de notre communaut&#8230; et le premier <a href=\"http://ma.tt/2015/07/wcus-philadelphia/\">WordCamp US</a> aura lieu  Philadelphie&#8230;</p>
<h3>WordPress 4.3 : revue de travaux</h3>
<ul>
<li><a href=\"http://wptavern.com/wordpress-4-3-adds-new-site-icons-feature-and-a-text-editor-to-press-this\">Favicon et Press This</a> (en)</li>
<li><a href=\"http://wptavern.com/wordpress-4-3-improves-user-search-and-turns-comments-off-on-pages-by-default\">Fermeture de commentaire et recherche amliore</a> (en)</li>
</ul>
<h3>Jetpack 3.6 dbarque</h3>
<p>Cette <a href=\"http://wptavern.com/jetpack-3-6-adds-the-ability-to-manage-your-connections-to-jetpack\">nouvelle version</a> peut dsormais grer vos connexions aux rseaux sociaux. (en)</p>
<h3>Focus sur le rpertoire de thme officiel</h3>
<p>L&rsquo;quipe en charge du rpertoire officiel de thme de WordPress se concentre sur l&rsquo;amlioration du rpertoire officiel de thmes. <a href=\"http://wptavern.com/wordpress-theme-review-team-unanimously-approves-roadmap-to-improve-directory-and-review-process\">Une rorganisation de l&rsquo;quipe est en cours</a>. (en)</p>
<h3>Le fichier htaccess avec WordPress</h3>
<p>MaintPress explique le <a href=\"http://www.maintpress.com/blog/htaccess-wordpress/\">fonctionnement et l&rsquo;optimisation du fichier .htaccess</a> avec WordPress.</p>
<h3>Rappel sur l&rsquo;utilisation d&rsquo;un domaine avec &laquo;&nbsp;wordpress&nbsp;&raquo;</h3>
<p><a href=\"http://chrislema.com/this-is-why-you-dont-put-wordpress-in-a-domain-name/\">Chris Lema rappelle quelques lments</a> concernant lutilisation du terme WordPress&#8230; et un <a href=\"http://thewordpresshelpers.com/wordpress-trademark-lawsuit\">exemple d&rsquo;un cas concret</a> (en).</p>
<h3>Retour sur le WordCamp Europe 2015</h3>
<p><a href=\"http://www.kirstencassidy.com/wordcamp-europe-2015-in-review-day-one/\">Kirsten Cassidy</a> (en)</p>
<h3>Des shortcodes gnrs par ACF</h3>
<p>Si vous avez des shortcodes  grer dans votre site web, ou si vous souhaitez vos y mettre, l&rsquo;<a href=\"http://www.absoluteweb.net/generateur-shortcodes-acf/\">extension ACF pourrait vous faciliter les choses</a>.</p>
<h3>We are WP</h3>
<p><a href=\"http://www.wearewp.pro/\">We are WP</a>, c&rsquo;est la nouvelle agence de conseils et d&rsquo;expertise WordPress cre par Emilie Lebrun et Thierry Pigot, membres minents de la communaut franaise.</p>
<h3>Les parts de march de WordPress dans le monde</h3>
<p>Daniel prsente les parts de march mondiale de WordPress. <a href=\"http://www.seomix.fr/parts-de-marche-wordpress/\">Un article trs intressant et instructif</a>.</p>
<h3>Du nouveau avec REST API</h3>
<p>Une <a href=\"http://wptavern.com/explore-the-wordpress-rest-api-with-the-new-interactive-console-plugin\">console REST API </a>est maintenant disponible. (en)</p>
<h3>WP Rocket, 2 ans aprs</h3>
<p>Voici dj 2 ans que la fuse WP Rocket a dcoll. <a href=\"http://blog.wp-rocket.me/fr/2-ans-bilan-retour-experience/\">A l&rsquo;heure du bilan</a>, autant dire que l&rsquo;optimisme est de rigueur. Une <a href=\"http://wptavern.com/wp-rocket-reports-355k-in-annual-revenue-after-2-years-in-business\">belle aventure de startup  la franaise (en)</a>. (<a href=\"http://blog.wp-rocket.me/2-years-reports-feedbacks/\">English version here</a>)</p>
<h3>Puisqu&rsquo;on vous dit d&rsquo;utiliser un thme enfant !</h3>
<p>On ne le rptera jamais assez&#8230; <a href=\"http://webdesignerhut.com/wordpress-child-themes/\">utilisez un thme enfant</a> ! (en)</p>
<h3>Gestion complte des menus</h3>
<p>Grgoire propose un <a href=\"http://www.gregoirenoyelle.com/gestion-des-menus-depuis-wordpress-3/\">tutoriel pour tout savoir des menus</a> dans WordPress.</p>
<h3>L&rsquo;extension pour les surveiller toutes</h3>
<p>L&rsquo;extension qui surveille les autres pour vous indiquer les failles de scurit existe, il s&rsquo;agit de<a href=\"http://wpformation.com/plugin-failles-securite/\"> Plugin Security Scanner</a>.</p>
<h3>Automattic, Matt Mullenweg et Thesis&#8230; histoire d&rsquo;un conflit</h3>
<p>La <a href=\"https://poststatus.com/thesis-automattic-and-wordpress/\">longue histoire du conflit</a> qui oppose le thme Thesis  Automattic et Matt Mullenweg depuis 2010. (en)</p>
<h3>Comment styliser les formulaires de Gravity Forms</h3>
<p>La Marmite propose dans son menu de <a href=\"http://wpmarmite.com/gravity-forms-css/\">styliser vos formulaires de Gravity Forms</a>.</p>
<h3>Polylang et WooCommerce</h3>
<p>Retour d&rsquo;exprience de l&rsquo;utilisation de <a href=\"http://www.absoluteweb.net/polylang-grosse-deception/\">Polylang avec WooCommerce</a>.</p>
<h3>Mise  jour du livre &laquo;&nbsp;optimiser son rfrencement WordPress&nbsp;&raquo;</h3>
<p>Daniel Roch <a href=\"http://www.wp-referencement.fr/\">indique la mise  jour du livre</a> qu&rsquo;il a crit concernant le rfrencement avec WordPress.</p>
<h3>Chrome 44 et WordPress</h3>
<p>Cette semaine, la <a href=\"http://www.imadarchid.com/un-bug-sur-chrome-44-beta-detruit-wordpress-et-dautres-logiciels/\">mise  jour 44 de Chrome</a> a entrain un <a href=\"https://github.com/IshYoBoy/aaa-ishyoboy-google-chrome-44-ssl-fix\">problme avec WordPress</a>.</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=NRscrl4Ddlw:tH6Ix9sW9-g:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=NRscrl4Ddlw:tH6Ix9sW9-g:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=NRscrl4Ddlw:tH6Ix9sW9-g:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=NRscrl4Ddlw:tH6Ix9sW9-g:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=NRscrl4Ddlw:tH6Ix9sW9-g:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=NRscrl4Ddlw:tH6Ix9sW9-g:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/NRscrl4Ddlw\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"http://www.wordpress-fr.net/2015/07/24/lhebdo-wordpress-n262-communautes-retours-dexperience-astuces/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"6\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"http://www.wordpress-fr.net/2015/07/24/lhebdo-wordpress-n262-communautes-retours-dexperience-astuces/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:66:\"
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"LHebdo WordPress n261 : WordCamp et WPMX Day  e-barcamp  Communauts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/ZSQgxX9WNpE/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"http://www.wordpress-fr.net/2015/06/23/lhebdo-wordpress-n261-wordcamp-et-wpmx-day-e-barcamp-communautes/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 23 Jun 2015 05:26:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:9:{i:0;a:5:{s:4:\"data\";s:16:\"Association WPFR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Brves\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:14:\"Dveloppement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"Evnements\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:10:\"Podcasting\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:7;a:5:{s:4:\"data\";s:12:\"communauts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:8;a:5:{s:4:\"data\";s:8:\"wordcamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7448\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:336:\"WordCamp Lyon 2015 J&#8217;ai eu la chance de participer au 1er WordCamp Lyon. Il s&#8217;est droul le 5 juin dernier sous le soleil du Rhne. Autant le dire tout de suite, c&#8217;tait un grand vnement ! UN belle russite. Bravo aux organisateurs ! Voici quelques liens qui en parlent en des termes au moins aussi [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benot\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6530:\"<h3>WordCamp Lyon 2015</h3>
<p>J&rsquo;ai eu la chance de participer au 1er WordCamp Lyon. Il s&rsquo;est droul le 5 juin dernier sous le soleil du Rhne. Autant le dire tout de suite, c&rsquo;tait un grand vnement ! UN belle russite. Bravo aux organisateurs !</p>
<p>Voici quelques liens qui en parlent en des termes au moins aussi logieux que moi si ce n&rsquo;est plus :</p>
<ul>
<li><a href=\"http://eclozion360.com/wordcamp-lyon-2015/\">Des photos</a></li>
<li><a href=\"http://www.wp-spread.com/comment-travailler-en-equipe-autour-dun-projet-wordpress-wordcamp-lyon-2015/\">Le retour de Maxime BJ</a></li>
<li><a href=\"https://www.flickr.com/search/?text=WPLyon\">D&rsquo;autres photos</a></li>
<li><a href=\"http://wordpress.tv/event/wordcamp-lyon-2015/\">Dj les confrences et ateliers sur WordPress.tv</a></li>
<li><a href=\"http://wpmarmite.com/wordcamp-lyon-2015/\">Une marmite qui dborde de retours</a></li>
<li><a href=\"http://www.jennybeaumont.com/results-2015-wordpress-maintenance-survey/\">Le sondage pre-WordCamp Lyon de Jenny</a></li>
<li><a href=\"https://lyon.wordcamp.org/2015/les-photos/\">Le site officiel dit merci !</a></li>
<li><a href=\"https://twitter.com/search?q=%23wplyon&amp;mode=news&amp;src=tyah\">#wplyon</a></li>
</ul>
<h3>WPMX Day 2015</h3>
<p>Le lendemain du WordCamp Lyon se droulait  quelques centaines de km de Lyon, plus prs de la cte Atlantique, le <a href=\"http://wpmx.org/retour-wpmx-day-2015/\">WPMX Day</a>.</p>
<ul>
<li><a href=\"http://www.lameleeadour.com/wpmx-day-6-juin-2015-a-biarritz-2/\">Un retour de cette journe.</a></li>
</ul>
<h3>Le premier e-barcamp de France</h3>
<p>L&rsquo;quipe de VFT a mis en place fin mai un e-barcamp. L&rsquo;objectif tait d&rsquo;appliquer le mode barcamp  un podcast. <a href=\"http://veryfrenchtrip.com/podcast/podcast-13-e-barcamp-1/\">Le rsultat est en ligne ici</a>. En attendant la prochaine dition, VFT revient bientt pour son traditionnel podcast <a href=\"http://veryfrenchtrip.com/annonce-podcast-14-organiser-des-meetups-wordpress/\">consacr cette fois aux meetups</a>. Restez connects.</p>
<h3>La communaut WPFR sur Slack</h3>
<p>La communaut WordPress Francophone est sur Slack depuis un mois environ et ne cesse de grandir. <a href=\"http://boiteaweb.fr/wordpressfr-on-slack-8588.html\">Si ce n&rsquo;est pas encore faire venez nous rejoindre</a>.</p>
<h3>Des meetups partout&#8230; encore et toujours !</h3>
<p>La communaut est vivante et de plus en plus riche et active. Un nouveau groupe s&rsquo;est <a href=\"http://www.meetup.com/fr/WordPress-Lorraine/\">cr en Lorraine</a>.</p>
<p>Et le prochain et dernier meetup niois avant les vacances, <a href=\"http://www.meetup.com/wordpress-in-nice/events/223309511/?a=ra1_te\">c&rsquo;est le 30 juin</a> !</p>
<h3>Glossaire des traductions franaises</h3>
<p>FX, bien connu des traducteurs en franais, a ralis <a href=\"https://fxbenard.com/glossaire-des-traductions-francaises-de-wordpress/\">un glossaire des traductions en franais</a>. Un &laquo;&nbsp;<em>must have</em>&laquo;&nbsp;.</p>
<h3>La mode est au Wapuu</h3>
<p><a href=\"http://wptavern.com/introducing-the-wp-tavern-wapuu#comment-69209\">WP Tavern a son wapuu</a>&#8230; et maintenant la <a href=\"http://boiteaweb.fr/welcome-to-marcel-le-wapuu-de-la-communaute-francaise-8598.html\">France  le sien aussi</a> ! &#8230; Le<a href=\"http://wapuu.jp/about/\"> Wapuu c&rsquo;est a au fait</a> !</p>
<h3>Un sondage sur WordPress</h3>
<p>Jenny Wong souhaite recueillir vos avis sur WordPress, <a href=\"https://docs.google.com/forms/d/1dkF1nbVCTawp7vq8pZd2SB8FIV2iwny01EtfbadnfoA/viewform?c=0&amp;w=1\">aidez-la (en)</a>.</p>
<h3>Arrter de s&rsquo;arracher les cheveux en cherchant un thme</h3>
<p>Un article qui vous donne<a href=\"http://www.webmarketing-com.com/2015/03/25/36361-comment-arreter-de-sarracher-les-cheveux-en-recherchant-un-theme-wordpress\"> des pistes pour vos recherches de thmes</a> !</p>
<h3>Un guide pour les Custom Page Template</h3>
<p>Apprenez <a href=\"http://www.smashingmagazine.com/2015/06/19/wordpress-custom-page-templates/\"> personnaliser vos pages dans WordPress</a> (en).</p>
<h3>Theme Juice : Une configuration Vagrant pour les dveloppeurs</h3>
<p>Vous tes dveloppeurs et souhaitez une nouvelle plateforme de dveloppement, <a href=\"http://wptavern.com/theme-juice-a-new-vagrant-configuration-for-wordpress-development\">c&rsquo;est ici que a passe</a> (en).</p>
<h3>Pas (que) du WordPress mais du PHP</h3>
<p>PHP et WordPress sont troitement lis, c&rsquo;est pourquoi cet article peut vous intresser : <a href=\"https://kinsta.com/blog/hhvm-vs-php-7/\">HHVM vs PHP7 (en)</a>.</p>
<h3>&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;-</h3>
<h3>Appel  la communaut francophone</h3>
<p>Vous avez dj particip au dveloppement du core de WordPress (vous savez, vous avez eu votre heure de gloire avec votre nom dans les crdits de WordPress ! :p ) ? Signalez-vous ici (ou sur le Slack), un recensement est en cours par Jenny Beaumont <img src=\"http://s.w.org/images/core/emoji/72x72/1f609.png\" alt=\"&#x1f609;\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>
<h3>Association WPFR nouvelle gnration</h3>
<p>J&rsquo;ai oue dire que <span style=\"text-decoration: underline;\"><strong>les nouveaux statuts sont dposs en prfecture</strong></span> et valids ! <em>WPFR next gen, </em>c&rsquo;est parti ! On vous en dit plus trs trs trs trs bientt ! #wpfrstatuts</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=ZSQgxX9WNpE:Tg583M62sFc:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=ZSQgxX9WNpE:Tg583M62sFc:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=ZSQgxX9WNpE:Tg583M62sFc:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=ZSQgxX9WNpE:Tg583M62sFc:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=ZSQgxX9WNpE:Tg583M62sFc:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=ZSQgxX9WNpE:Tg583M62sFc:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/ZSQgxX9WNpE\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:109:\"http://www.wordpress-fr.net/2015/06/23/lhebdo-wordpress-n261-wordcamp-et-wpmx-day-e-barcamp-communautes/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"http://www.wordpress-fr.net/2015/06/23/lhebdo-wordpress-n261-wordcamp-et-wpmx-day-e-barcamp-communautes/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:48:\"
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"LHebdo WordPress n260 : WooThemes  Slack  Insights\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/XyIbHAGFLdw/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"http://www.wordpress-fr.net/2015/06/03/lhebdo-wordpress-n260-woothemes-slack-insights/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 03 Jun 2015 05:27:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:7:\"Astuces\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:10:\"automattic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:9:\"WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7445\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:359:\"Automattic acquiert WooThemes L&#8217;info de cette dernire quinzaine est sans aucun doute le rachat (en) de WooThemes (en) par Automattic (en). Le plus gros marchand de thmes et le crateur du plus clbre outil de e-commerce pour WordPress rejoint donc le giron de l&#8217;outil le plus puissant du web. 12e anniversaire de WordPress Que le [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benot\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3694:\"<h3>Automattic acquiert WooThemes</h3>
<p>L&rsquo;info de cette dernire quinzaine est sans aucun doute le <a href=\"https://poststatus.com/automattic-acquired-woocommerce-woothemes/\">rachat (en) </a>de <a href=\"http://www.woothemes.com/2015/05/woothemes-joins-automattic/\">WooThemes (en) </a>par <a href=\"http://ma.tt/2015/05/woomattic/\">Automattic (en)</a>. Le plus gros marchand de thmes et le crateur du plus clbre outil de e-commerce pour WordPress <a href=\"http://wpchannel.com/woothemes-automattic-acquisition-e-commerce/\">rejoint donc le giron</a> de l&rsquo;outil le plus puissant du web.</p>
<h3>12e anniversaire de WordPress</h3>
<p>Que le temps passe vite ! <a href=\"https://matt.wordpress.com/2015/05/27/wordpress-12th-birthday-cake/\">Dj 12 ans </a>depuis le dbut du projet. (en) !</p>
<h3>WordPress.com lance Insights</h3>
<p>Il s&rsquo;agit d&rsquo;un <a href=\"http://wptavern.com/wordpress-com-launches-insights-better-stats-for-visualizing-publishing-trends\">meilleur outil de statistiques</a> qui apporte un certain nombres de changement  l&rsquo;interface actuelle.</p>
<h3>Une communaut WordPress en franais sur Slack</h3>
<p>Un nouveau groupe a t cr sur la <a href=\"http://www.wp-spread.com/invitez-vous-sur-le-chat-wordpress-francophone-sur-slack/\">plateforme Slack</a>. Rejoignez le groupe ds que vous pouvez !</p>
<h3>Des tutos et ressources pour apprendre</h3>
<p><a href=\"https://matt.wordpress.com/2015/05/27/wordpress-12th-birthday-cake/\">Quelques tutoriels et ressources</a> diverses pour apprendre WordPress</p>
<h3>Renommer automatiquement les fichiers accentus sous WordPress</h3>
<p>Si vous avez des fichiers nomms <a href=\"http://wpchannel.com/renommer-automatiquement-fichiers-accentues-wordpress/\">avec des accents et que vous en avez assez de les renommer sans cesse</a>, cette extension est pour vous.</p>
<h3>La hirarchie des templates</h3>
<p>Avec WordPress il est souvent utile de connaitre<a href=\"http://4design.xyz/wordpress-visualisez-la-hierarchie-des-templates\"> la hirarchie des templates</a> pour travailler dans un thme notamment.</p>
<h3>11 exemples de sites WordPress</h3>
<p><a href=\"http://www.maintpress.com/blog/exemple-site-wordpress-bien-reussi/\">Voici 11 sites WordPress</a> qui semblent intressants selon MaintPress.</p>
<h3>Connecter WordPress  OneNote de Microsoft</h3>
<p>Voici la solution pour connecter <a href=\"http://blogs.office.com/2015/05/22/onenote-welcomes-three-new-partners-cloudhq-equil-and-wordpress/\">un site WordPress avec un compte Microsoft OneNote (en)</a>.</p>
<p><em>NB : A celles et ceux qui vont au WordCamp Lyon, je leur dit : &laquo;&nbsp;A vendredi !&nbsp;&raquo;</em></p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=XyIbHAGFLdw:abkmUGnIo1g:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=XyIbHAGFLdw:abkmUGnIo1g:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=XyIbHAGFLdw:abkmUGnIo1g:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=XyIbHAGFLdw:abkmUGnIo1g:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=XyIbHAGFLdw:abkmUGnIo1g:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=XyIbHAGFLdw:abkmUGnIo1g:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/XyIbHAGFLdw\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"http://www.wordpress-fr.net/2015/06/03/lhebdo-wordpress-n260-woothemes-slack-insights/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"6\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"http://www.wordpress-fr.net/2015/06/03/lhebdo-wordpress-n260-woothemes-slack-insights/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:54:\"
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"LHebdo WordPress n259 : Des vnements WordPress  WordPress 4.3  BuddyPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/LYVelJJ-s4U/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:120:\"http://www.wordpress-fr.net/2015/05/19/lhebdo-wordpress-n259-des-evenements-wordpress-wordpress-4-3-buddypress/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 19 May 2015 05:13:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:7:\"Astuces\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"Dveloppement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:11:\"Evnements\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:10:\"Extensions\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:13:\"WordPress 4.3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7441\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:323:\"Juin dmarre sous le signe de WordPress Le dbut du mois de juin s&#8217;annonce riche en vnements WordPress : 3 juin : WordPress in Alps 5 juin : WordCamp Lyon &#8211;&#62; Il reste des billets, attrapez-les tous ! (Au moment o j&#8217;cris ces lignes, il reste 2 places !!) 6 juin : WPMX Day WordPress [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benot\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4370:\"<h3>Juin dmarre sous le signe de WordPress</h3>
<p>Le dbut du mois de juin s&rsquo;annonce riche en vnements WordPress :</p>
<ul>
<li>3 juin : <a href=\"http://www.wp-spread.com/wordpress-in-alps-le-3-juin-ateliers-decouverte-wordpress/\">WordPress in Alps</a></li>
<li>5 juin : WordCamp Lyon &#8211;&gt; Il reste des billets, <a href=\"https://lyon.wordcamp.org/2015/billetterie/\">attrapez-les tous</a> ! (Au moment o j&rsquo;cris ces lignes, il reste 2 places !!)</li>
<li>6 juin : <a href=\"http://2015.wpmx.org/conferences/\">WPMX Day</a></li>
</ul>
<h3>WordPress 4.3 poursuit son dveloppement</h3>
<p>L&rsquo;<a href=\"https://make.wordpress.org/core/2015/05/11/weekly-core-ui-meetings-for-4-3/\">interface utilisateur poursuit sa mue</a>&#8230; et le <a href=\"https://make.wordpress.org/core/2015/05/12/multisite-office-hours-recap-may-12-2015/\">ct multi-utilisateurs</a> volue encore. (en)</p>
<h3>BuddyPress 2.3.0 beta 2</h3>
<p><a href=\"https://buddypress.org/2015/05/buddypress-2-3-0-beta-2/\">BuddyPress passe en 2e beta (en) </a>pour la version 2.3.0&#8230; et <a href=\"http://wptavern.com/buddypress-2-3-will-introduce-companion-stylesheets-for-wordpress-default-themes\">quelques nouveauts sont attendues</a> (en).</p>
<h3>WordPress c&rsquo;est de la merde !</h3>
<p><a href=\"http://www.seomix.fr/shitty-wordpress/\">Un titre accrocheur pour une argumentation </a>haute en couleur !</p>
<h3>Ajouter un menu de recherche par date ou taxonomie</h3>
<p>Grgoire prsente un tutoriel prcis sur la dmarche  suivre pour <a href=\"http://www.gregoirenoyelle.com/wordpress-ajouter-menus-recherche-date-taxonomie/\">ajouter un menu de recherche par date ou taxonomie</a>.</p>
<h3>Les vidos de LoopConf</h3>
<p>La chaine YouTube de LoopCon o l&rsquo;on peut<a href=\"https://www.youtube.com/channel/UCAwOVsWiMdlz6snWRF2HdSQ\"> retrouver toute leur vido relatives  WordPress</a>. (en)</p>
<h3>Les chiffres de la Rocket en avril</h3>
<p><a href=\"http://blog.wp-rocket.me/inside-wp-rocket-april-2015/\">WP Rocket prsente rgulirement ses statistiques</a>&#8230; voici pour le mois d&rsquo;avril 2015. (en)</p>
<h3>WordPress et Microsoft Azure</h3>
<p>Microsoft Azure et WordPress, a marche ! <a href=\"http://www.script-tutorials.com/scalable-wordpress-on-microsoft-azure/\">La preuve ici.</a> (en)</p>
<h3>Pourquoi paye-t-on pour WordPress 2e partie</h3>
<p><a href=\"http://www.wp-pro.fr/pourquoi-paye-t-on-pour-wordpress-une-solution-gratuite-2eme-partie/\">WP-Pro propose la 2e partie </a>de son analyse sur le fait que l&rsquo;on peut payer &laquo;&nbsp;du WordPress&nbsp;&raquo; alors que l&rsquo;application est gratuite.</p>
<h3>7 extensions de supports clients</h3>
<p>Si vous recherchiez de quoi grer un support client, voici <a href=\"http://www.wpbeginner.com/plugins/6-best-help-desk-customer-support-plugins-for-wordpress/\">7 extensions WordPress qui devrait vous plaire. (en)</a></p>
<h3>Scuriser WordPress</h3>
<p>MaintPress nous donne des pistes sur la faon de <a href=\"http://www.maintpress.com/blog/securiser-wordpress-comment-renforcer-securite-site-wordpress/\">mieux scuriser WordPress</a>.</p>
<h3>L&rsquo;volution de WordPress</h3>
<p>WordPress volue inlassablement depuis 10 ans, <a href=\"http://neliosoftware.com/some-stats-on-the-evolution-of-the-wordpress-codebase/\">petite analyse de cette volution (en)</a>.</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=LYVelJJ-s4U:XQf-hBBVWTY:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=LYVelJJ-s4U:XQf-hBBVWTY:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=LYVelJJ-s4U:XQf-hBBVWTY:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=LYVelJJ-s4U:XQf-hBBVWTY:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=LYVelJJ-s4U:XQf-hBBVWTY:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=LYVelJJ-s4U:XQf-hBBVWTY:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/LYVelJJ-s4U\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:116:\"http://www.wordpress-fr.net/2015/05/19/lhebdo-wordpress-n259-des-evenements-wordpress-wordpress-4-3-buddypress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"http://www.wordpress-fr.net/2015/05/19/lhebdo-wordpress-n259-des-evenements-wordpress-wordpress-4-3-buddypress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:54:\"
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"LHebdo WordPress n258 : WordPress 4.3  WordCamps &amp; Evnements WP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/kwe0XgYW1P0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"http://www.wordpress-fr.net/2015/05/05/lhebdo-wordpress-n258-wordpress-4-3-wordcamps-evenements-wp/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 05 May 2015 05:25:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:7:\"Astuces\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"Dveloppement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:11:\"Evnements\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:10:\"Podcasting\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:8:\"wordcamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7437\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:395:\"WordPress 4.3 est lanc Comme toujours, quelques jours aprs le dploiement d&#8217;une version majeur la suivante est aussitt mise sur les rails. WordPress 4.3 est donc prvue pour le 18 aot prochain et c&#8217;est Konstantin Obenland qui en prend les rnes. (en) Les premires pistes de rflexions sont ouvertes, notamment concernant l&#8217;diteur. (en) WordPress 4.2.1 [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benot\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3621:\"<h3>WordPress 4.3 est lanc</h3>
<p>Comme toujours, quelques jours aprs le dploiement d&rsquo;une version majeur la suivante est aussitt mise sur les rails. WordPress 4.3 est donc <a href=\"http://wp.me/p2AvED-3mD\">prvue pour le 18 aot prochain</a> et c&rsquo;est Konstantin Obenland qui en prend les rnes. (en)</p>
<p>Les premires pistes de rflexions sont ouvertes, <a href=\"https://make.wordpress.org/core/2015/05/01/editor-wish-list-for-4-3/\">notamment concernant l&rsquo;diteur</a>. (en)</p>
<h3>WordPress 4.2.1 : Premire mise  jour mineure</h3>
<p>Une faille de scurit a t dcele rapidement aprs la sortie de WordPress 4.2, <a href=\"http://t.co/O3MDAj635H\">le patch correctif </a>ne s&rsquo;est donc pas fait attendre (en).</p>
<h3>WordCamp Lyon : programme et surprises</h3>
<p>Le WordCamp Lyon avance et se prcise. <a href=\"https://lyon.wordcamp.org/2015/programme/\">Le programme est connu</a> et on sait depuis peu qu&rsquo;un <a href=\"https://lyon.wordcamp.org/2015/nightswapping-vous-offre-2-nuits-a-lyon-pour-le-wordcamp/\">nouveau partenaire propose une surprise</a>.</p>
<h3>WordCamp Europe : les orateurs se dvoilent</h3>
<p>1re surprise de taille, <a href=\"http://europe.wordcamp.org/2015/welcome-the-third-group-of-wceu-speakers/\">Xavier (notre Xavier) fait partie des orateurs </a>du prochains WordCamp Europe.</p>
<h3>WPMX Day</h3>
<p>Rappelons galement que le lendemain du WordCamp Lyon se tiendra le <a href=\"http://2015.wpmx.org/\">WPMX Day</a>, vnement majeur dans le Sud-Ouest de la France.</p>
<h3>Le 11e Podcast de Very French Trip</h3>
<p><a href=\"http://veryfrenchtrip.com/podcast/podcast-12-traduction-wordpress/\">Pour cette 11e dition</a>, la traduction est  l&rsquo;honneur avec des invits de marque que sont Xavier, Didier, Franois-Xavier, Mathieu et Grgoire.</p>
<h3>Les principes de hirarchie dans le design visuel</h3>
<p>Un article qui parle de <a href=\"https://dailypost.wordpress.com/2015/04/29/the-principles-of-design-visual-hierarchy/\">design des sites web</a> racont par un Automatticien. (en)</p>
<h3>WPRocket lue meilleure extension de cache</h3>
<p>WPSiteCare a lu <a href=\"http://www.wpsitecare.com/best-wordpress-plugins/\">WPRocket meilleure extension de cache de tous les temps</a> (en)&#8230; et retrouvez galement le classement des autres meilleures extensions de tous les temps dans ce classement.</p>
<h3>Les vnements WordPress sur une carte</h3>
<p>ManageWP.org a mis en ligne une <a href=\"https://managewp.org/events/\">carte interactive avec les diffrents vnements WordPress </a>de la Plante. (en)</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=kwe0XgYW1P0:5XuUlueSTRA:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=kwe0XgYW1P0:5XuUlueSTRA:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=kwe0XgYW1P0:5XuUlueSTRA:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=kwe0XgYW1P0:5XuUlueSTRA:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=kwe0XgYW1P0:5XuUlueSTRA:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=kwe0XgYW1P0:5XuUlueSTRA:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/kwe0XgYW1P0\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"http://www.wordpress-fr.net/2015/05/05/lhebdo-wordpress-n258-wordpress-4-3-wordcamps-evenements-wp/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"http://www.wordpress-fr.net/2015/05/05/lhebdo-wordpress-n258-wordpress-4-3-wordcamps-evenements-wp/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:2:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";s:4:\"href\";s:48:\"http://feeds.feedburner.com/WordpressFrancophone\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:3:\"hub\";s:4:\"href\";s:32:\"http://pubsubhubbub.appspot.com/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:4:{s:4:\"info\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"uri\";s:20:\"wordpressfrancophone\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:14:\"emailServiceId\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordpressFrancophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:18:\"feedburnerHostname\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://feedburner.google.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"feedFlare\";a:9:{i:0;a:5:{s:4:\"data\";s:24:\"Subscribe with NewsGator\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:112:\"http://www.newsgator.com/ngs/subscriber/subext.aspx?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:42:\"http://www.newsgator.com/images/ngsub1.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:24:\"Subscribe with Bloglines\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:77:\"http://www.bloglines.com/sub/http://feeds.feedburner.com/WordpressFrancophone\";s:3:\"src\";s:48:\"http://www.bloglines.com/images/sub_modern11.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:23:\"Subscribe with Netvibes\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:98:\"http://www.netvibes.com/subscribe.php?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:39:\"//www.netvibes.com/img/add2netvibes.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:21:\"Subscribe with Google\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:93:\"http://fusion.google.com/add?feedurl=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:51:\"http://buttons.googlesyndication.com/fusion/add.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:25:\"Subscribe with Pageflakes\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:101:\"http://www.pageflakes.com/subscribe.aspx?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:87:\"http://www.pageflakes.com/ImageFile.ashx?instanceId=Static_4&fileName=ATP_blu_91x17.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:21:\"Subscribe with Plusmo\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:86:\"http://www.plusmo.com/add?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:43:\"http://plusmo.com/res/graphics/fbplusmo.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:23:\"Subscribe with Live.com\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:81:\"http://www.live.com/?add=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:141:\"http://tkfiles.storage.msn.com/x1piYkpqHC_35nIp1gLE68-wvzLZO8iXl_JMledmJQXP-XTBOLfmQv4zhj4MhcWEJh_GtoBIiAl1Mjh-ndp9k47If7hTaFno0mxW9_i3p_5qQw\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:7;a:5:{s:4:\"data\";s:25:\"Subscribe with Mon Yahoo!\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:99:\"https://add.my.yahoo.com/content?lg=fr&url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:60:\"http://us.i1.yimg.com/us.yimg.com/i/us/my/bn/intatm_fr_1.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:8;a:5:{s:4:\"data\";s:25:\"Subscribe with Excite MIX\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:89:\"http://mix.excite.eu/add?feedurl=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:42:\"http://image.excite.co.uk/mix/addtomix.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:52:\"http://backend.userland.com/creativeCommonsRssModule\";a:1:{s:7:\"license\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"http://creativecommons.org/licenses/by-nc-sa/3.0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:10:{s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:4:\"etag\";s:27:\"ttoxsqES3PNUYpxzINyxjER7faM\";s:13:\"last-modified\";s:29:\"Fri, 08 Apr 2016 13:50:30 GMT\";s:16:\"content-encoding\";s:4:\"gzip\";s:4:\"date\";s:29:\"Fri, 08 Apr 2016 13:58:26 GMT\";s:7:\"expires\";s:29:\"Fri, 08 Apr 2016 13:58:26 GMT\";s:13:\"cache-control\";s:18:\"private, max-age=0\";s:22:\"x-content-type-options\";s:7:\"nosniff\";s:16:\"x-xss-protection\";s:13:\"1; mode=block\";s:6:\"server\";s:3:\"GSE\";}s:5:\"build\";s:14:\"20160408133650\";}","no");
INSERT INTO ayv_options VALUES("100","cron","a:19:{i:1460364567;a:1:{s:26:\"wssPlugin_WpScanCheckState\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:2:\"1m\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}}i:1460367087;a:3:{s:28:\"wps_check_admin_install_file\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}s:28:\"wps_check_admin_upgrade_file\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}s:24:\"wps_cleanup_live_traffic\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1460367180;a:1:{s:21:\"wordfence_hourly_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1460370510;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1460384133;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1460392287;a:1:{s:20:\"wps_check_user_admin\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:2:\"8h\";s:4:\"args\";a:0:{}s:8:\"interval\";i:28800;}}}i:1460403074;a:2:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1460403320;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1460446290;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1460449980;a:1:{s:20:\"wordfence_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1460472194;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1460557331;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1460645442;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1460730720;a:1:{s:18:\"wpseo_onpage_fetch\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1460731720;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1460815678;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1460904864;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1461596400;a:1:{s:31:\"wordfence_email_activity_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}s:7:\"version\";i:2;}","yes");
INSERT INTO ayv_options VALUES("2920","_transient_wpseo_sitemap_cache_portfolio_category_1","<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">
	<url>
		<loc>http://www.atelier-yvanvedel.com/portfolio_category/cuisines-contemporaines/</loc>
		<lastmod>2016-02-26T18:50:14+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.6</priority>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/portfolio_category/cuisines-rustiques-et-provencales/</loc>
		<lastmod>2016-02-26T18:49:25+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.6</priority>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/portfolio_category/foires-et-salons/</loc>
		<lastmod>2016-02-26T18:50:14+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.4</priority>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/portfolio_category/realisations-diverses/</loc>
		<lastmod>2016-02-26T17:53:52+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.2</priority>
	</url>
</urlset>","no");
INSERT INTO ayv_options VALUES("3056","_transient_timeout_plugin_slugs","1460450816","no");
INSERT INTO ayv_options VALUES("3057","_transient_plugin_slugs","a:15:{i:0;s:26:\"wp-security-scan/index.php\";i:1;s:30:\"advanced-custom-fields/acf.php\";i:2;s:19:\"akismet/akismet.php\";i:3;s:36:\"contact-form-7/wp-contact-form-7.php\";i:4;s:33:\"duplicate-post/duplicate-post.php\";i:5;s:31:\"easy-swipebox/easy-swipebox.php\";i:6;s:32:\"wp-flexible-map/flexible-map.php\";i:7;s:48:\"wp-flexible-map-options/flexible-map-options.php\";i:8;s:39:\"gallery-slideshow/gallery-slideshow.php\";i:9;s:9:\"hello.php\";i:10;s:37:\"post-types-order/post-types-order.php\";i:11;s:23:\"revslider/revslider.php\";i:12;s:23:\"wordfence/wordfence.php\";i:13;s:27:\"js_composer/js_composer.php\";i:14;s:24:\"wordpress-seo/wp-seo.php\";}","no");
INSERT INTO ayv_options VALUES("3058","_transient_timeout_dash_bd94b8f41e74bae2f4dc72e9bd8379af","1460167107","no");
INSERT INTO ayv_options VALUES("3059","_transient_dash_bd94b8f41e74bae2f4dc72e9bd8379af","<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'http://feedproxy.google.com/~r/WordpressFrancophone/~3/jHn6JESKG5o/\'>WPFR 2.0</a> <span class=\"rss-date\">21 dcembre 2015</span><div class=\"rssSummary\">Une nouvelle re souvre pour lassociation WordPress Francophone. Un nouveau bureau est en place avec  sa tte : milie Lebrun (trsorire), Benot Catherineau (secrtaire) et moi-mme, Aurlien Denis (prsident). Cette nouvelle aventure sera marque par la professionnalisation de la communaut  tous les niveaux : refonte du site communautaire, mise  jour du site [&hellip;]</div></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'http://feedproxy.google.com/~r/wordpress-fr/RaoY/~3/EC4MwOxgjrw/\'>Franais : Tout ce que vous devez savoir  propos du WordPress Global Translation Day</a></li><li><a class=\'rsswidget\' href=\'http://feedproxy.google.com/~r/wordpress-fr/RaoY/~3/6qnVSENnHEc/\'>L&#039;cho des plugins WordPress : File Manager</a></li><li><a class=\'rsswidget\' href=\'http://feedproxy.google.com/~r/wordpress-fr/RaoY/~3/ILaOPMQdq2U/\'>SEOMix : Apprhender WordPress pour un dveloppeur</a></li></ul></div><div class=\"rss-widget\"><ul><li class=\'dashboard-news-plugin\'><span>Extensions populaires:</span> <a href=\'https://wordpress.org/plugins/google-analytics-dashboard-for-wp/\' class=\'dashboard-news-plugin-link\'>Google Analytics Dashboard for WP</a>&nbsp;<span>(<a href=\'plugin-install.php?tab=plugin-information&amp;plugin=google-analytics-dashboard-for-wp&amp;_wpnonce=1705edd958&amp;TB_iframe=true&amp;width=600&amp;height=800\' class=\'thickbox\' title=\'Google Analytics Dashboard for WP\'>Installer</a>)</span></li></ul></div>","no");
INSERT INTO ayv_options VALUES("1888","_transient_timeout_feed_96281909e104f3c547a3bba0b6d36ad5","1452748388","no");
INSERT INTO ayv_options VALUES("1889","_transient_feed_96281909e104f3c547a3bba0b6d36ad5","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"
\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"
	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"http://www.wordpress-fr.net\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"La communaut francophone autour du CMS WordPress et son cosystme\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 22 Dec 2015 15:02:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"fr-FR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"http://wordpress.org/?v=4.3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:45:\"
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"WPFR 2.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/JhLL9uI42GE/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"http://www.wordpress-fr.net/2015/12/21/wpfr-2-0/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 21 Dec 2015 11:00:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:16:\"Association WPFR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7516\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:422:\"Une nouvelle re souvre pour lassociation WordPress Francophone. Un nouveau bureau est en place avec  sa tte : milie Lebrun (trsorire), Benot Catherineau (secrtaire) et moi-mme, Aurlien Denis (prsident). Cette nouvelle aventure sera marque par la &#171;&#160;professionnalisation&#160;&#187; de la communaut  tous les niveaux : refonte du site communautaire, mise  jour du site [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Aurlien Denis\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7532:\"<div class=\"page\" title=\"Page 1\">
<div class=\"section\">
<div class=\"layoutArea\">
<div class=\"column\">
<p>Une nouvelle re souvre pour lassociation WordPress Francophone. Un nouveau bureau est en place avec  sa tte : milie Lebrun (trsorire), Benot Catherineau (secrtaire) et moi-mme, Aurlien Denis (prsident).</p>
<p>Cette nouvelle aventure sera marque par la &laquo;&nbsp;professionnalisation&nbsp;&raquo; de la communaut  tous les niveaux : refonte du site communautaire, mise  jour du site localis de WordPress.org, rflexion sur la cration de certifications et autres formations diplmantes, ouverture de lassociation aux membres&#8230; sont autant de chantiers que nous avons dores et dj lanc en interne.</p>
<p>Nous avons fait le choix dadopter une approche par projets qui devront tre mens de front pour donner un nouveau visage  la communaut francophone dans les 6 prochains mois. La masse de travail est consquente, nous en avons conscience et cest pour cela que toutes les bonnes volonts seront les bienvenues pour nous pauler dans cette mission. Soyez acteur de votre communaut !</p>
<p>Comment agir ? Cette question revient souvent lors des nombreux changes que chacun dentre nous peuvent avoir, aussi bien de manire virtuelle que relle. Il me semble opportun de dcliner les diffrents chantiers afin que chacun puisse se positionner sur lun deux.</p>
<h2>La refonte du site WPFR</h2>
<p>Disons le clairement : les attentes sont fortes, trs fortes ! Contenus dpasss, forum obsolte, absence de services communautaires&#8230; Parmi les changements  venir, nous pouvons retenir :</p>
<ul>
<li>Changement du nom de domaine pour se mettre en conformit avec les rgles tablies par Automattic ;</li>
<li>Changement de serveur pour de meilleures performances ;</li>
<li>Bascule progressive du blog, de la vitrine et du forum vers le site fr.wordpress.org ;</li>
<li>Cration dune nouvelle charte graphique ;</li>
<li>Refonte technique (responsive design, prise en charge des crans HDPI, etc.) ;</li>
<li>Remise  plat fonctionnelle pour rpondre  la ralit des besoins de la communaut ;</li>
<li>Nouvelle stratgie de rfrencement ;</li>
</ul>
<p>Lobjectif majeur de cette nouvelle version est le suivant : faire en sorte que chaque membre de la communaut puisse accder  des services qui le concerne : utilisateurs occasionnels ou passionns, contributeurs actifs ou en qute de contribution, dveloppeurs de thmes ou d&rsquo;extensions WordPress, animateurs dassociations locales&#8230; ce site sera le vtre !</p>
<h2>La mise  jour du site localis fr.wordpress.org</h2>
<p>Il sagit du site officiel sur lequel vous tlchargez larchive WordPress avec ses packs de traduction franaise. Pour les connaisseurs, on parle du site  Rosetta  qui fait rfrence au nom du thme install sur ce dernier.</p>
<p>WPFR a en charge la gestion de ce site et dispose dune certaine latitude dans lactivation de nouvelles fonctionnalits. Vous aurez sans doute remarqu lapparition des rubriques Thmes et Extensions ou encore de contenus rcrits sur les diffrentes pages de prsentation.</p>
<p>Ce travail est en cours de ralisation par lquipe de traducteurs bnvoles que sont Franois-Xavier Bnard, Xavier Borderie et Didier Demory.</p>
</div>
</div>
</div>
</div>
<div class=\"page\" title=\"Page 2\">
<div class=\"section\">
<div class=\"layoutArea\">
<div class=\"column\">
<p>A terme, le blog WPFR rejoindra ce site pour vous tenir inform sur les actualits en lien avec WordPress. De mme, il est envisag de migrer le forum sur cet outil pour se positionner au mme niveau que le site WordPress.org dans sa version anglophone. Il sera donc possible dutiliser votre compte WordPress.org sur les 2 sites. Cest l un chantier immense pour lequel il nous faut prendre des dcisions qui auront un impact fort tant pour lutilisateur que pour les administrateurs.</p>
<h2>La dlivrance de certifications / formations diplmantes</h2>
<p>Un vaste sujet auquel la communaut francophone de WordPress peut rpondre. A linstar de ce que propose dj dautres communauts (SEO Camp) ou des acteurs majeurs du Web (Google, Microsoft, etc.), nous pensons quil nous faut dlivrer des certifications pour les professionnels WordPress.</p>
<p>Le but est l encore de professionnaliser les acteurs du Web en France afin de permettre une identification simple et efficace des entreprises comptentes sur le march par les clients. Cest une demande rcurrente de par le monde  laquelle Automattic ne peut rpondre : le projet WordPress nappartient pas  cette multinationale, elle ne fait que le soutenir et nest donc pas lgitime pour tablir des certifications comme pourrait le faire Google pour ses services.</p>
<p>En outre, comme le savent les formateurs WordPress, les rformes successives sur la formation professionnelle ncessitent quune formation dlivre un diplme. Maxime Bernard-Jacquet est volontaire pour porter les dmarches et des synergies avec <a href=\"http://www.wp-next.fr/\" target=\"_blank\">lassociation WP-Next</a> sont  laborer.</p>
<h2>Louverture des adhsions</h2>
<p>Jusqu aujourdhui lassociation WPFR tait ferme et non ouverte aux adhsions. Certains dentre vous ont rempli un formulaire lors des WordCamps Paris et Lyon cette anne. Rassurez-vous nous les avons bien conservs et vous serez contacts en priorit pour adhrer en ligne ds lors que le nouveau site sera disponible. Si vous ne l&rsquo;avez pas encore fait, contactez-nous via notre formulaire de contact.</p>
<p>Ouvrir une association ncessite de savoir o lon va tous ensemble, de proposer des services&#8230; autant daspects qui restent encore  dfinir prcisment.</p>
<p>Vous laurez compris, les 6 prochains mois seront dcisifs ! Vous avez dsormais la parole dans les commentaires pour nous faire part de vos remarques, vous positionner sur un chantier pour nous aider ou suggrer de nouvelles ides.</p>
<p>Enfin, je terminerai par remercier chaleureusement tous ceux qui ont port l&rsquo;association WPFR durant plus d&rsquo;une dcennie. Ils se reconnatront sans doute : merci !</p>
<p>Amicalement,<br />
Le Prsident.</p>
</div>
</div>
</div>
</div>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=jHn6JESKG5o:rN9c88LUGi4:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=jHn6JESKG5o:rN9c88LUGi4:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=jHn6JESKG5o:rN9c88LUGi4:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=jHn6JESKG5o:rN9c88LUGi4:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=jHn6JESKG5o:rN9c88LUGi4:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=jHn6JESKG5o:rN9c88LUGi4:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/jHn6JESKG5o\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/JhLL9uI42GE\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"http://www.wordpress-fr.net/2015/12/21/wpfr-2-0/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"48\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:48:\"http://www.wordpress-fr.net/2015/12/21/wpfr-2-0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/jHn6JESKG5o/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:45:\"
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"Sortie de WordPress 4.4 Clifford\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/2K_79TmEaBQ/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"http://www.wordpress-fr.net/2015/12/09/sortie-de-wordpress-4-4-clifford/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 09 Dec 2015 19:22:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:9:\"WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7508\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:401:\"La version 4.4 de WordPress, baptiseClifford en honneur au trompettiste de jazz Clifford Brown, est disponible en tlchargement ou en mise  jour via votre tableau de bord WordPress. Les nouvelles fonctionnalits de la 4.4 vous donnentun site plus connect et au design adaptatif. Clifford introduit galement un nouveau thme par dfaut :Twenty Sixteen. Prsentation [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Xavier\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6547:\"<p>La version 4.4 de WordPress, baptiseClifford en honneur au trompettiste de jazz Clifford Brown, est disponible en tlchargement ou en mise  jour via votre tableau de bord WordPress.</p>
<p>Les nouvelles fonctionnalits de la 4.4 vous donnentun site plus connect et au design adaptatif. Clifford introduit galement un nouveau thme par dfaut :Twenty Sixteen.</p>
<p><iframe src=\"https://videopress.com/embed/J44FHXvg?hd=0\" width=\"632\" height=\"354.35838150289015\" frameborder=\"0\" allowfullscreen=\"allowfullscreen\"></iframe></p>
<hr />
<h2>Prsentation deTwenty Sixteen</h2>
<p><img class=\"aligncenter size-large wp-image-7512\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/12/ipad-white-desktop-2x-1024x6941-500x339.png\" alt=\"ipad-white-desktop-2x-1024x694\" width=\"500\" height=\"339\" /></p>
<p>Le nouveau thme par dfaut, Twenty Sixteen, est une modernisation dun thme de blog classique.</p>
<p>Twenty Sixteen a t conu pour tre superbe sur tous les appareils. Avec son design en grille fluide, son en-tte flexible et ses jeux de couleurs joyeux, elle mettre en valeur votre contenu.</p>
<hr />
<h2>Images adaptatives</h2>
<p><img class=\"aligncenter size-large wp-image-7511\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/12/responsive-devices-ipad-2x-500x229.png\" alt=\"responsive-devices-ipad-2x\" width=\"500\" height=\"229\" /></p>
<p>WordPress approche dsormais laffichage des images de manires plus intelligente, utilisant  chaque fois la taille dimage la plus pertinente en fonction de lappareil utilis. Vous navez rien a changer  votre thme: a fonctionne, cest tout.</p>
<hr />
<h2>Intgrez votre contenu WordPress</h2>
<div class=\"embed-container\">
<p>https://make.wordpress.org/core/2015/10/28/new-embeds-feature-in-wordpress-4-4/</p>
<p>Vous pouvez dsormais insrer vos articles dans dautres sites, et mme dans dautres sites WordPress. Collez simplement ladresse du contenu dans lditeur, et une prvisualisation saffichera instantanment, avec titre, extrait, et limage de Une si vous avez mise une. Vous y trouverez mme licne de votre site et les liens pour commenter et partager.</p>
</div>
<p>En plus de linsertion de contenu, WordPress 4.4 apporte la reconnaissance de cinq nouveaux fournisseurs oEmbed: Cloudup, RedditComments, ReverbNation, SpeakerDeck et VideoPress.</p>
<hr />
<h2>Sous le capot</h2>
<p><img class=\"aligncenter size-large wp-image-7513\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/12/banner-1544x500-500x162.jpg\" alt=\"banner-1544x500\" width=\"500\" height=\"162\" /></p>
<h3>Infrastructure de lAPI REST</h3>
<p>Linfrastructure de lAPI REST a t intgre au coeur de WordPress, ouvrant ainsi une nouvelle re pour le dveloppement avec le logiciel. LAPI REST a t conue pour offrir aux dveloppeurs une manire central de construire et tendre des API RESTful bases sur le socle WordPress.</p>
<p>Linfrastructure est la premire partie dune mise en place en plusieurs tapes de lAPI REST. Linclusion des points daccs est prvue pour une prochaine version. Pour avoir un aperu des principaux points daccs, et pour obtenir plus dinformation sur la manire dtendre lAPI REST, dcouvrez lextension officielle <a class=\"thickbox\" href=\"http://xavier.borderie.net/blog/wp-admin/plugin-install.php?tab=plugin-information&amp;plugin=rest-api&amp;TB_iframe=1&amp;width=600&amp;height=550\">WordPress REST API</a>.</p>
<h3>Mta des termes</h3>
<p>Les termes disposent dsormais de mtadonnes, tout comme les articles. Lisez la documentation de <a href=\"https://developer.wordpress.org/reference/functions/add_term_meta\"><code>add_term_meta()</code></a>,<a href=\"https://developer.wordpress.org/reference/functions/get_term_meta\"><code>get_term_meta()</code></a> et <a href=\"https://developer.wordpress.org/reference/functions/update_term_meta\"><code>update_term_meta()</code></a>pour plus d&rsquo;information.</p>
<h3>Amlioration des requtes de commentaires</h3>
<p>Les requtes de commentaires disposent dsormais dun gestionnaire de cache pour amliorer les performances. Les nouveaux arguments de <code>WP_Comment_Query</code> simplifient la mise en place de requtes de commentaires robustes.</p>
<div class=\"feature-section under-the-hood three-col\">
<div class=\"col\">
<h3>Objets pour les termes, commentaires et rseaux</h3>
<p>Les nouveaux objets <code>WP_Term</code>, <code>WP_Comment</code>et <code>WP_Network</code> rendent la gestion par le code des termes, commentaires et rseaux plus prvisible et intuitive.</p>
<h2>L&rsquo;quipe</h2>
<p><a class=\"alignleft\" href=\"https://profiles.wordpress.org/wonderboymusic\"><img id=\"grav-ed0f881acb9dc96bee53e4dc61b5558f-0\" class=\"grav-hashed\" src=\"https://www.gravatar.com/avatar/ed0f881acb9dc96bee53e4dc61b5558f?d=mm&amp;s=180&amp;r=G\" alt=\"Scott Taylor\" width=\"80\" height=\"80\" /></a>Cette version a t mene par<a href=\"http://scotty-t.com/\">Scott Taylor</a>, avec l&rsquo;aide de plus de471 contributeurs &#8212; le plus grand nombre jamais vu pour une nouvelle version de WordPress. Parmi eux, on trouve quelques franais : Mathieu Viet, Julio Potier, Nicolas Juen, et tous les traducteurs qui ont donn de leur temps pour s&rsquo;assurer que cette version serait traduite dans les temps. Merci  tous !</p>
</div>
</div>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=tgW8c7dvWys:O5SMFkejhIY:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=tgW8c7dvWys:O5SMFkejhIY:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=tgW8c7dvWys:O5SMFkejhIY:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=tgW8c7dvWys:O5SMFkejhIY:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=tgW8c7dvWys:O5SMFkejhIY:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=tgW8c7dvWys:O5SMFkejhIY:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/tgW8c7dvWys\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/2K_79TmEaBQ\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"http://www.wordpress-fr.net/2015/12/09/sortie-de-wordpress-4-4-clifford/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:72:\"http://www.wordpress-fr.net/2015/12/09/sortie-de-wordpress-4-4-clifford/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/tgW8c7dvWys/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:42:\"
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress fait tourner 25% du web\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/XCP7gZ8WS9w/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"http://www.wordpress-fr.net/2015/11/09/wordpress-fait-tourner-25-du-web/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 Nov 2015 12:15:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7491\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:341:\"Le nombre tant attendu a t atteint ce week-end : selon le site W3Techs, qui prsente de nombreuses statistiques et tudes chiffres sur les technologies du web, WordPress est aujourd&#8217;hui utilis par 25% des sites web &#8212; et pas seulement 1/4 des sites qui ont utilisent un outil de gestion de contenu (CMS), non : [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Xavier\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5264:\"<p>Le nombre tant attendu a t atteint ce week-end : selon le site <a href=\"http://w3techs.com/\">W3Techs</a>, qui prsente de nombreuses statistiques et tudes chiffres sur les technologies du web, <a href=\"http://w3techs.com/technologies/history_overview/content_management/all/y\">WordPress est aujourd&rsquo;hui utilis par 25% des sites web</a> &#8212; et pas seulement 1/4 des sites qui ont utilisent un outil de gestion de contenu (CMS), non : 25% de TOUS les sites actuellement en ligne.</p>
<p><img class=\"aligncenter wp-image-7492 size-full\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/11/wordpress-25pourcent-w3techs-tableau1.png\" alt=\"wordpress-25pourcent-w3techs-tableau1\" width=\"521\" height=\"188\" />Le site indique par ailleurs que WordPress a 58,7% de part de march parmi les sites qui utilisent un CMS, avec l&rsquo;ajout de plus de 1100 sites par jour (dans le top 10 millions des sites).</p>
<p><img class=\"aligncenter wp-image-7493 size-full\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/11/wordpress-25pourcent-w3techs-tableau2.png\" alt=\"wordpress-25pourcent-w3techs-tableau2\" width=\"509\" height=\"146\" /></p>
<p>C&rsquo;est colossal, et c&rsquo;est le rsultat de plusieurs annes d&rsquo;amlioration d&rsquo;un projet qui, <a href=\"http://ma.tt/2015/11/seventy-five-to-go/\">comme le rappelle Matt Mullenweg</a>, a commenc <a href=\"http://zengun.org/weblog/archives/2001/06/post1958/\">en juin 2001</a>sous le nom de <a href=\"http://cafelog.com/\">b2/cafelog</a>, dans la chambre du franais Michel Valdrighi, alors tudiant sur sa Corse natale (voir <a href=\"https://wordpress.tv/2012/02/27/les-origines-de-wordpress-la-naissance-de-b2cafelog/\">sa confrence sur le sujet au WordCamp Paris 2011</a>).</p>
<p><img class=\"aligncenter wp-image-7495 size-full\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/11/wordpress-25pourcent-w3techs-graphique1.png\" alt=\"wordpress-25pourcent-w3techs-graphique1\" width=\"765\" height=\"506\" /></p>
<p>Ce qui a commenc comme un script blog personnel utilis par quelques 3000 personnes au fate de sa popularit, est aujourd&rsquo;hui l&rsquo;outil choisi par la grande majorit des individus et socits quand il s&rsquo;agit de mettre leurs ides et contenus en ligne.</p>
<p><img class=\"aligncenter wp-image-7494 size-full\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/11/wordpress-25pourcent-w3techs-tableau4.png\" alt=\"wordpress-25pourcent-w3techs-tableau4\" width=\"534\" height=\"228\" /></p>
<p>Matt reprend ensuite : &laquo;&nbsp;Il reste une grosse opportunit  saisir avec les 57% de sites qui n&rsquo;utilisent aucun CMS&nbsp;&raquo;, ou en tout cas aucun d&rsquo;identifiable &#8212; qui pourraient tout aussi bien tre des WordPress ou Drupal dont le propritaire a choisi de cacher son outil. &laquo;&nbsp;Je pense que c&rsquo;est l o nous pouvons avoir une norme croissance (et je soutiens galement tous les autres CMS open-source).&nbsp;&raquo;</p>
<p><img class=\"aligncenter size-full wp-image-7496\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/11/wordpress-25pourcent-w3techs-tableau3.png\" alt=\"wordpress-25pourcent-w3techs-tableau3\" width=\"469\" height=\"321\" /></p>
<p> suivre galement, <a href=\"http://trends.builtwith.com/cms/WordPress\">les statistiques proposes par Builtwith</a>.</p>
<p>Ce 25% est un beau nouveau chiffre  ajouter  notre communaut en 2015, avec les 20 ans de PHP&#8230; et les 10 ans de l&rsquo;association WordPress-Francophone (dont vous aurez bientt des nouvelles, promis !).</p>
<p>Merci  toutes la communaut de dveloppeurs, de traducteurs, de crateurs d&rsquo;extensions et de thmes, d&rsquo;accompagnateurs sur les forums, et tant d&rsquo;autres !</p>
<p>Rendez-vous aux prochains vnements WordPress franais afin de fter cela dignement,  commencer par le <a href=\"http://2015.wptech.fr/\">WP Tech</a>  Nantes le 5 dcembre, et le <a href=\"https://paris.wordcamp.org/2016/\">WordCamp Paris</a> les 5 et 6 fvrier 2016, ainsi que tous les autres vnements locaux, petits et grands, organiss par les membres de la grande famille WordPress !</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=WIL51xhSWSw:f1vr0WZxhp4:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=WIL51xhSWSw:f1vr0WZxhp4:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=WIL51xhSWSw:f1vr0WZxhp4:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=WIL51xhSWSw:f1vr0WZxhp4:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=WIL51xhSWSw:f1vr0WZxhp4:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=WIL51xhSWSw:f1vr0WZxhp4:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/WIL51xhSWSw\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/XCP7gZ8WS9w\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"http://www.wordpress-fr.net/2015/11/09/wordpress-fait-tourner-25-du-web/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:72:\"http://www.wordpress-fr.net/2015/11/09/wordpress-fait-tourner-25-du-web/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/WIL51xhSWSw/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:54:\"
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"LHebdo WordPress n263 du 10e anniversaire\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/Og4g9561NEU/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"http://www.wordpress-fr.net/2015/08/28/lhebdo-wordpress-n263-du-10e-anniversaire/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 28 Aug 2015 18:15:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:16:\"Association WPFR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:12:\"anniversaire\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7471\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:348:\"WPFR a 10 ans ! Il tait une fois WordPress Francophone&#8230; Cette histoire a commenc il y a 10 ans par la volont de quelques utilisateurs qui voulaient avoir un espace d&#8217;change en franais pour ne plus se faire rejeter des forums officiels allergiques aux non anglophones. Et un nouveau site wordpress-fr.net tait n ! [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benot\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:12176:\"<h3>WPFR a 10 ans !</h3>
<p>Il tait une fois WordPress Francophone&#8230; <a href=\"http://www.wordpress-fr.net/2005/08/24/le-depart/\">Cette histoire a commenc il y a 10 ans</a> par la volont de quelques utilisateurs qui voulaient avoir un espace d&rsquo;change en franais pour ne plus se faire rejeter des forums officiels allergiques aux non anglophones. <a href=\"http://www.wordpress-fr.net/2005/08/25/wordpress-frnet/\">Et un nouveau site wordpress-fr.net tait n </a>!</p>
<p>10 ans dj de support en franais avec <a href=\"http://www.wordpress-fr.net/support/\">un forum</a> qui est aujourd&rsquo;hui la pierre angulaire de notre communaut. Il reprsente 7 6741 inscrits pour prs de 110 000 discussions ouvertes reprsentant 560 000 messages.</p>
<p>WordPress Francophone et son site portail wordpress-fr.net c&rsquo;est aujourd&rsquo;hui une moyenne de prs de 200 000 visites par mois pour environ 400 000 pages vues mensuelles.</p>
<p>WPFR c&rsquo;est aussi une prsence sur <a href=\"https://twitter.com/wordpress_fr\">Facebook</a>,<a href=\"https://twitter.com/wordpress_fr\"> sur Twitter</a> et sur <a href=\"https://plus.google.com/u/0/b/112387028272126355329/112387028272126355329\">Google+.</a></p>
<p>Comme vous l&rsquo;aurez constat, notre site en gnral et le forum en particulier sont vieillissants&#8230; cela fait des annes qu&rsquo;une refonte est prvue. L&rsquo;volution de notre association en cours nous donne de bons espoirs pour cette fin d&rsquo;anne et le dbut de la suivante. Des annonces officielles vont suivre. Restez connects !</p>
<p>Des projets dans les cartons depuis longtemps devraient pouvoir se concrtiser enfin dans les mois  venir.</p>
<p>Merci  toutes et tous pour votre fidlit, votre soutien, vos encouragements ou mme parfois vos remarques et critiques&#8230; Rien n&rsquo;est vain et WPFR avance, doucement mais surement et cela grce  vous tous, grce  la communaut !</p>
<p><strong>Joyeux anniversaire WPFR</strong> ! 10 ans, c&rsquo;est dj presque l&rsquo;adolescence ! Longue vie !</p>
<hr />
<p>&nbsp;</p>
<p><span style=\"text-decoration: underline;\"><strong>Place  l&rsquo;hebdo WordPress n263 :</strong></span></p>
<h3>La roadmap pour WordPress 4.4</h3>
<p>Le chantier se poursuit, pas de repos. <a href=\"https://make.wordpress.org/core/2015/08/27/taxonomy-roadmap-for-4-4-and-beyond/\">Voici la feuille de route pour 4.4</a>. (en) &#8230; et on vous demande mme votre avis sur <a href=\"https://make.wordpress.org/core/2015/08/19/wordpress-4-4-whats-on-your-wishlist/\">ce que vous voulez voir arriver dans cette future version</a>. (en)</p>
<h3>Le sondage WordPress 2015</h3>
<p>Le sondage annuel de WordPress pour recueillir votre avis sur vos habitudes avec WordPress est disponible. <a href=\"http://wp-survey.polldaddy.com/s/wp-2015\">N&rsquo;hsitez pas  le remplir</a>. (en)</p>
<h3>2016, le prochain thme par dfaut</h3>
<p><a href=\"https://make.wordpress.org/core/2015/08/25/introducing-twenty-sixteen/\">2016 est d&rsquo;ores et dj mis en chantier</a>. (en)</p>
<h3>BuddyPress 2.3.3</h3>
<p>BuddyPress arrive dans sa <a href=\"https://buddypress.org/2015/08/buddypress-2-3-3/\">version 2.3.3</a>. (en)</p>
<h3>Les mots de passe sous WordPress 4.3</h3>
<p>La dernire version en date de WordPress introduit <a href=\"https://make.wordpress.org/core/2015/07/28/passwords-strong-by-default/\">une nouvelle gestion des mots de passe</a> (en).</p>
<h3>Les nouveauts de WordPress 4.3</h3>
<p>Si vous n&rsquo;tes pas encore <a href=\"http://wptavern.com/wordpress-4-3-billie-named-after-jazz-singer-billie-holiday-is-available-for-download\">passs (en) </a> <a href=\"https://poststatus.com/wordpress-4-3-billie-released/\">WordPress 4.3 (en)</a>, <a href=\"http://www.lumieredelune.com/encrelune/nouveautes-wordpress-4-3,2015,08\">voici ce que vous ratez</a> &#8230; quelques <a href=\"http://wptavern.com/text-patterns-and-the-quick-link-toolbar-in-wordpress-4-3\">autres explications</a> (en) ! Mais attention&#8230; <a href=\"http://www.layerswp.com/2015/08/are-you-ready-for-wordpress-4-3/\">soyez srs d&rsquo;tre prts (en) </a>! Certains <a href=\"http://www.lumieredelune.com/encrelune/avertissement-widget-obsolete,2015,08\">Widgets peuvent tre obsoltes</a> notamment.</p>
<h3>La check list essentielle pour la mise en place dun site sous WordPress</h3>
<p><a href=\"http://www.vingthuitzerotrois.fr/wordpress/la-check-list-essentielle-pour-la-mise-en-place-dun-site-sous-wordpress-15947/\">LA checklist pour le moment fatidique (en) </a>o l&rsquo;on doit mettre en place un site sous WordPress. Pour ne rien oublier !</p>
<h3>Le BuddyCamp Brighton de iMath</h3>
<p>Notre iMath national a particip au BuddyCamp de Brighton, <a href=\"http://imathi.eu/2015/08/10/buddycamp-brighton/\">voici son compte rendu</a>.</p>
<h3>Automattic recrute</h3>
<p>Automattic <a href=\"http://ma.tt/2015/08/automattic-is-hiring-2/\">recrute diffrents profils</a>. (en)</p>
<h3>Dsactiver les notifications de YOAST SEO</h3>
<p>Les notifications intempestives de cette extension pour drangent ? <a href=\"http://wpchannel.com/desactiver-notifications-yoast-seo/\">voici la solution</a>.</p>
<h3>Un nouvel vnement ddi  REST API</h3>
<p><a href=\"http://feelingrestful.com/\">A day of Rest est le prochain vnement (en) </a>ddi  cette API de WordPress.</p>
<h3>Inclure l&rsquo;extension REST API dans les thmes du rpertoire officiel ?</h3>
<p>L&rsquo;quipe en charge des thmes du rpertoire officiel ont vot l&rsquo;autorisation d&rsquo;<a href=\"http://wptavern.com/wordpress-theme-review-team-votes-to-allow-themes-to-use-the-rest-api-plugin\">inclure l&rsquo;extension REST API (en)</a> dans les thmes du rpertoire officiel.</p>
<h3>Faciliter les invitations Slack</h3>
<p>Slack est en constante augmentation de popularit. <a href=\"http://wptavern.com/new-wordpress-plugin-automates-slack-team-invitations\">Voici une extension pour simplifier les invitations</a>. (en)</p>
<h3>WordPress, on a un problme !</h3>
<p>Ici ce n&rsquo;est pas Houston, mais quand on a un problme avec WordPress que fait-on ? <a href=\"http://wpformation.com/wordpress-probleme/\">Voici des conseils par WPFormation</a>.</p>
<h3>Les nouveauts de WooCommerce 2.4</h3>
<p><a href=\"http://www.absoluteweb.net/woocommerce-2-4-nouveautes/\">Dcouvrez les nouveauts de WooCommerce 2.4 (en).</a></p>
<h3>Interview de Sara Rosso</h3>
<p>Sara Rosso de chez Automattic <a href=\"http://mymorningroutine.com/sara-rosso/\">est interviewe par mymorningroutine.com</a>. Interview forcment dcale. ?</p>
<h3>Vous n&rsquo;aimez pas les emojis ?</h3>
<p><a href=\"http://www.hongkiat.com/blog/disable-wordpress-emoticons/\">Dsactivez-les !</a> (en)</p>
<h3>Interview de Miriam Schwab de Illuminea.com</h3>
<p>Retour d&rsquo;exprience de <a href=\"http://wptavern.com/wpweekly-episode-205-interview-with-miriam-schwab\">Miriam Schwab</a>. (en)</p>
<h3>WooCommerce : Synchroniser adresses de livraison et de facturation</h3>
<p>Absolute Web explique <a href=\"http://www.absoluteweb.net/woocommerce-synchroniser-pays-livraison-facturation/\">comment synchroniser les adresses de facturation et de livraison </a>dans WooCommerce.</p>
<h3>Comment optimiser WordPress ?</h3>
<p>Korben donne des <a href=\"http://korben.info/comment-optimiser-un-vieux-wordpress-obese.html\">conseils pour allger et optimiser </a>un vieux WordPress obse !</p>
<h3>Quel futur pour WordPress ?</h3>
<p>Quelques hypothses pour <a href=\"http://torquemag.io/where-do-you-see-the-future-of-wordpress/\">l&rsquo;avenir de WordPress</a> (en).</p>
<h3>Ajouter un portfolio</h3>
<p>Comment ajouter un portflolio dans WordPress ? <a href=\"http://www.wpbeginner.com/plugins/how-to-add-a-portfolio-to-your-wordpress-site/\">Suivez le guide</a>. (en)</p>
<h3>Retours d&rsquo;exprience</h3>
<p><a href=\"http://www.wpelevation.com/2015/08/starting-a-wordpress-consulting-business/\">Troy Dean raconte son exprience</a> (en) en tant que consultant WordPress depuis 8 ans. Et Becky Davis nous <a href=\"http://heropress.com/essays/doing-what-i-want/\">raconte son parcours</a>. (en)</p>
<h3>Interview de Nikolay Bachiyski, chez de la scurit de WordPress.org</h3>
<p><a href=\"http://wptavern.com/short-interview-with-nikolay-bachiyski-wordpress-security-czar\">Nikolay est chef de la scurit</a> de WorPress.org (en).</p>
<h3>Comment installer une extension ?</h3>
<p>Il est parfois intressant de revenir aux bases, c&rsquo;est pourquoi cet article devrait intressant les <a href=\"http://yesweblog.fr/wordpress/comment-installer-extension-plugin-wordpress/\">dbutants qui souhaitent installer des extensions</a>.</p>
<h3>Prsentation de Elegant Themes</h3>
<p>WP Marmite nous fait dcouvrir <a href=\"http://wpmarmite.com/elegant-themes/\">Elegant Themes</a>.</p>
<h3>La hirarchie des templates</h3>
<p>La hirarchie des templates est trs importantes dans WordPress. <a href=\"http://wphierarchy.com/\">Voici comment s&rsquo;en imprgner</a>. (en)</p>
<h3>API personnalis pour base de donnes</h3>
<p>Voici le premier numro d&rsquo;<a href=\"https://pippinsplugins.com/custom-database-api-reasons-for-custom-tables-and-an-api/\">un tuto sur la gestion des bases de donnes</a>.</p>
<h3>Un glossaire pour dbutants</h3>
<p>WordPress vous parle en chinois, et ce malgr la langue slectionne avec soin ? Alors <a href=\"http://www.wpexplorer.com/wordpress-glossary-beginners/\">ce guide peut tre pour vous</a> ! (en)</p>
<h3>Un guide pour crer son site e-commerce</h3>
<p>Si vous voulez quelques ides pour crer votre site e-commerce avec WordPress, <a href=\"https://selfstartr.com/wordpress-ecommerce/\">ce guide pourra vous donner des pistes</a>. (en)</p>
<h3>25 raisons de passer  WordPress</h3>
<p>Nelio donne <a href=\"http://neliosoftware.com/25-reasons-to-switch-to-wordpress/\">25 raisons de migrer vers WordPress</a>. (en)</p>
<h3>Au revoir Thmes de France</h3>
<p>Thmes de France, la plateforme de thmes WordPress lances par Alex Bortolotti vient de <a href=\"https://www.themesdefrance.fr/\">fermer dfinitivement ses portes</a>. Alex nous <a href=\"http://alexbortolotti.com/pourquoi-arret-themes-de-france/\">explique les raisons</a>.</p>
<h3>Ajouter un retour en haut</h3>
<p>Thierry propose un bouton pour revenir en <a href=\"https://gist.github.com/thierrypigot/46a1f71af58c2c83a9a7\">haut de page dans Genesis</a>.</p>
<h3>Il tait une fois Automattic&#8230;</h3>
<p>Automattic c&rsquo;est quoi ? <a href=\"http://www.elegantthemes.com/blog/editorial/a-history-of-automattics-acquisitions-from-gravatar-to-woothemes\">voici une partie de la rponse</a>. (en)</p>
<h3>Afficher le profil Facebook dans WordPress</h3>
<p>Si vous souhaitez <a href=\"http://www.hongkiat.com/blog/facebook-author-tag-wordpress/\">afficher le profil Facebook</a> de vos auteurs par exemple, voici comment faire.</p>
<h3>Top 99 des influenceurs WordPress</h3>
<p>Les <a href=\"http://99robots.com/top-99-wordpress-influencers-2015/\">99 personnes</a> qui font WordPress ! (en)</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=ayO_P6QzZyY:xNb17R3nBDQ:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=ayO_P6QzZyY:xNb17R3nBDQ:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=ayO_P6QzZyY:xNb17R3nBDQ:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=ayO_P6QzZyY:xNb17R3nBDQ:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=ayO_P6QzZyY:xNb17R3nBDQ:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=ayO_P6QzZyY:xNb17R3nBDQ:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/ayO_P6QzZyY\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/Og4g9561NEU\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"http://www.wordpress-fr.net/2015/08/28/lhebdo-wordpress-n263-du-10e-anniversaire/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:81:\"http://www.wordpress-fr.net/2015/08/28/lhebdo-wordpress-n263-du-10e-anniversaire/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/ayO_P6QzZyY/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:48:\"
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"Sortie de  WordPress 4.3  Billie \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/D2YW8pSwmLs/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"http://www.wordpress-fr.net/2015/08/19/sortie-de-wordpress-4-3-billie/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 19 Aug 2015 06:35:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:14:\"Dveloppement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:9:\"WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7463\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:391:\"La version 4.3 de WordPress, baptise&#171;&#160;Billie&#160;&#187; en l&#8217;honneur de la chanteuse de jazz Billie Holiday, est disponible en tlchargementou en mise  jour via le tableau de bord de votre WordPress. Les nouvelles fonctionnalits de la version 4.3 simplifient grandement la mise en forme de votre contenu et la personnalisation de votre site. Les menus [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:3:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:45:\"http://s.w.org/images/core/4.3/formatting.mp4\";s:6:\"length\";s:7:\"1574782\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:45:\"http://s.w.org/images/core/4.3/formatting.ogv\";s:6:\"length\";s:7:\"1939540\";s:4:\"type\";s:9:\"video/ogg\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:46:\"http://s.w.org/images/core/4.3/formatting.webm\";s:6:\"length\";s:6:\"686435\";s:4:\"type\";s:10:\"video/webm\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Xavier\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5699:\"<p>La version 4.3 de WordPress, baptise&laquo;&nbsp;Billie&nbsp;&raquo; en l&rsquo;honneur de la chanteuse de jazz <a href=\"https://fr.wikipedia.org/wiki/Billie_Holiday\">Billie Holiday</a>, est disponible en <a href=\"http://fr.wordpress.org/\">tlchargement</a>ou en mise  jour via le tableau de bord de votre WordPress. Les nouvelles fonctionnalits de la version 4.3 simplifient grandement la mise en forme de votre contenu et la personnalisation de votre site.</p>
<p><iframe width=\'555\' height=\'312\' src=\'https://videopress.com/embed/T54Iy7Tw?hd=1\' frameborder=\'0\' allowfullscreen></iframe><script src=\'https://v0.wordpress.com/js/next/videopress-iframe.js?m=1435166243\'></script></p>
<h3>Les menus dans loutil de personnalisation</h3>
<p><img class=\"size-large wp-image-7464 alignnone\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/08/menu-customizer-500x281.png\" alt=\"menu-customizer\" width=\"500\" height=\"281\" /></p>
<p>Crez votre menu, mettez-le  jour et placez-le, le tout en mme temps que vous prvisualisez son apparence dans loutil de personnalisation. Le design pur de loutil de personnalisation offre une interface accessible tant pour les appareils mobiles que pour les utilisateurs en situation de handicap. De version en version, il devient de plus en plus facile de donner  votre lapparence que vous souhaitez.</p>
<h3>Les raccourcis de mise en forme</h3>
<p>Votre flux dcriture va sacclrer grce aux nouveaux raccourcis de WordPress 4.3. Utilisez lastrisque pour crer des listes, et le croisillon pour mettre en place un titre. Votre flux nest plus ralenti par le mouvement de souris; votre texte est plus clair grce aux <code>*</code> et aux <code>#</code>.</p>
<h3>Des icnes pour votre site</h3>
<p><img class=\"size-large wp-image-7465 alignnone\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/08/site-icon-customizer-500x281.png\" alt=\"site-icon-customizer\" width=\"500\" height=\"281\" /></p>
<p>Les icnes du site reprsentent votre site dans les onglets des navigateurs, dans les menus de favoris, et dans la page daccueil des appareils mobiles. Ajoutez votre propre icne de site dans loutil de personnalisation;il restera mme en place quand vous changerez de thme. Faites en sorte que tout votre site soit le reflet de votre marque.</p>
<h3>De meilleurs mots de passe</h3>
<p><img class=\"alignnone size-large wp-image-7466\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/08/better-passwords-500x281.png\" alt=\"better-passwords\" width=\"500\" height=\"281\" /></p>
<p>Amliorez la scurit de votre site grce  la nouvelle gestion des mots de passe de WordPress. Au lieu de recevoir un mot de passe dans votre messagerie, vous recevrez un lien de rinitialisation. Et lorsque vous ajouterez de nouveaux utilisateurs  votre site, ou que vous modifierez le profil dun utilisateur, WordPress gnrera automatiquement un mot de passe scuris.</p>
<h3>D&rsquo;autres amliorations</h3>
<ul>
<li><strong>Une utilisation de ladministration plus agrable </strong>&#8212; Des amliorations  laffichage des listes sur lensemble des pages dadministration rendent WordPress plus accessible et plus facile  utiliser sur nimporte quel appareil.</li>
<li><strong>Les commentaires sont dsactivs sur les pages</strong>&#8212; Toutes les nouvelles pages que vous crerez auront les commentaires dsactivs par dfaut. Cela permet de limiter les conversations  votre blog, l o elle sont censes se drouler.</li>
<li><strong>Une personnalisation rapide de votre site</strong>&#8212; O que vous soyez sur linterface du site, vous pouvez cliquer sur le lien de personnalisation dans la barre doutils pour apporter une modification rapide  votre site.</li>
<li><strong>Feuille de route de la taxinomie</strong>&#8212; Les termes partags par plusieurs taxinomies sont maintenant spars en plusieurs termes distincts.</li>
<li><strong>Hirarchie des fichiers du thme</strong>&#8212; Le fichier <code>singular.php</code> a t ajout en tant qualternative  <code>single.php</code> et <code>page.php</code>.</li>
<li><strong><code>WP_List_Table</code></strong>&#8212; Les tableaux de listes peuvent et doivent dsigner une colonne principale.</li>
</ul>
<p>Cette version a t mene par <a href=\"http://konstantin.obenland.it/\">Konstantin Obenland</a>, avec l&rsquo;aide 246 contributeurs, parmi lesquels on retrouve quelques franais :Clement Biron,Julio Potier,Fabien Quatravaux et Mathieu Viet.</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=KD2NWiu1sHU:oBCnwZX5Yj8:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=KD2NWiu1sHU:oBCnwZX5Yj8:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=KD2NWiu1sHU:oBCnwZX5Yj8:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=KD2NWiu1sHU:oBCnwZX5Yj8:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=KD2NWiu1sHU:oBCnwZX5Yj8:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=KD2NWiu1sHU:oBCnwZX5Yj8:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/KD2NWiu1sHU\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/D2YW8pSwmLs\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"http://www.wordpress-fr.net/2015/08/19/sortie-de-wordpress-4-3-billie/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"11\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:70:\"http://www.wordpress-fr.net/2015/08/19/sortie-de-wordpress-4-3-billie/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/KD2NWiu1sHU/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:51:\"
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"LHebdo WordPress n262 : Communauts  Retours dexprience  Astuces\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/0Fxaf6P1QkI/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"http://www.wordpress-fr.net/2015/07/24/lhebdo-wordpress-n262-communautes-retours-dexperience-astuces/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 24 Jul 2015 17:56:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:7:\"Astuces\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Brves\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:12:\"communauts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7456\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:368:\"WordPress 4.2.3 : mise  jour de scurit Une 3e mise  jour mineure vient corriger une faille de scurit dtecte plus tt. La communaut franaise grandie Jenny Beaumont a fait un rsum de l&#8217;histoire (en) de la communaut franaise de WordPress&#8230; et milie vous dit pourquoi en faire partie. 14e Podcast VFT : l&#8217;animation [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benot\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8467:\"<h3>WordPress 4.2.3 : mise  jour de scurit</h3>
<p>Une <a href=\"http://wptavern.com/wordpress-4-2-3-is-a-critical-security-release-fixes-an-xss-vulnerability\">3e mise  jour mineure </a>vient <a href=\"https://wordpress.org/news/2015/07/wordpress-4-2-3/\">corriger </a>une faille de scurit dtecte plus tt.</p>
<h3>La communaut franaise grandie</h3>
<p>Jenny Beaumont a fait <a href=\"https://poststatus.com/growth-in-the-french-community/\">un rsum de l&rsquo;histoire (en)</a> de la communaut franaise de WordPress&#8230; et <a href=\"http://www.wp-pro.fr/pourquoi-rejoindre-la-communaute-wordpress/\">milie vous dit pourquoi en faire partie</a>.</p>
<h3>14e Podcast VFT : l&rsquo;animation d&rsquo;une communaut locale</h3>
<p>Entours de Valrie et Nicolas, l&rsquo;quipe de VFT <a href=\"http://veryfrenchtrip.com/podcast/podcast-14-animation-locale-wordpress/\">nous donne des pistes pour animer une communaut locale</a>.</p>
<h3>Le WP Tech 2015 a une salle !</h3>
<p>Le lieu du prochain WP Tech <a href=\"http://2015.wptech.fr/lieu/\">est connu</a>, ce sera la facult de Pharmacie en plein centre de Nantes.</p>
<h3>Des retours du WPMX Day, des vrais (cette fois !)</h3>
<p>J&rsquo;avais fait une erreur dans mon dernier hebdo et confondu des liens&#8230; et je n&rsquo;a pas fait la mise  jour&#8230; dont acte !</p>
<ul>
<li><a href=\"http://www.myleneb.fr/wpmx-day-2015-mes-impressions/\">Mylne Boyrie</a></li>
<li><a href=\"http://www.ohmyweb.fr/retour-sur-le-wpmx-day-du-6-juin-2/\">Oh My Web</a></li>
<li><a href=\"http://www.goodness.fr/2015/06/13/referencement-wordpress-wpmx-2015/\">Goodness</a></li>
<li><a href=\"http://www.inpixelitrust.fr/blog/faites-rentrer-votre-elephant-dans-une-smart-bonnes-pratiques-sur-mobiles-ma-conference-au-wpmx-day-2015/\">Stphanie Walter</a></li>
</ul>
<h3>Quelques nouvelles des WordCamps dans le monde</h3>
<p>Les WordCamps franais n&rsquo;tant pas les seuls au monde, <a href=\"https://wordpress.org/news/2015/07/wordcamps-update/\">voici du nouveau sur le reste du Monde</a> ! (en) &#8230; avec un clin dil  Fabrice Ducarme, bien connu de notre communaut&#8230; et le premier <a href=\"http://ma.tt/2015/07/wcus-philadelphia/\">WordCamp US</a> aura lieu  Philadelphie&#8230;</p>
<h3>WordPress 4.3 : revue de travaux</h3>
<ul>
<li><a href=\"http://wptavern.com/wordpress-4-3-adds-new-site-icons-feature-and-a-text-editor-to-press-this\">Favicon et Press This</a> (en)</li>
<li><a href=\"http://wptavern.com/wordpress-4-3-improves-user-search-and-turns-comments-off-on-pages-by-default\">Fermeture de commentaire et recherche amliore</a> (en)</li>
</ul>
<h3>Jetpack 3.6 dbarque</h3>
<p>Cette <a href=\"http://wptavern.com/jetpack-3-6-adds-the-ability-to-manage-your-connections-to-jetpack\">nouvelle version</a> peut dsormais grer vos connexions aux rseaux sociaux. (en)</p>
<h3>Focus sur le rpertoire de thme officiel</h3>
<p>L&rsquo;quipe en charge du rpertoire officiel de thme de WordPress se concentre sur l&rsquo;amlioration du rpertoire officiel de thmes. <a href=\"http://wptavern.com/wordpress-theme-review-team-unanimously-approves-roadmap-to-improve-directory-and-review-process\">Une rorganisation de l&rsquo;quipe est en cours</a>. (en)</p>
<h3>Le fichier htaccess avec WordPress</h3>
<p>MaintPress explique le <a href=\"http://www.maintpress.com/blog/htaccess-wordpress/\">fonctionnement et l&rsquo;optimisation du fichier .htaccess</a> avec WordPress.</p>
<h3>Rappel sur l&rsquo;utilisation d&rsquo;un domaine avec &laquo;&nbsp;wordpress&nbsp;&raquo;</h3>
<p><a href=\"http://chrislema.com/this-is-why-you-dont-put-wordpress-in-a-domain-name/\">Chris Lema rappelle quelques lments</a> concernant lutilisation du terme WordPress&#8230; et un <a href=\"http://thewordpresshelpers.com/wordpress-trademark-lawsuit\">exemple d&rsquo;un cas concret</a> (en).</p>
<h3>Retour sur le WordCamp Europe 2015</h3>
<p><a href=\"http://www.kirstencassidy.com/wordcamp-europe-2015-in-review-day-one/\">Kirsten Cassidy</a> (en)</p>
<h3>Des shortcodes gnrs par ACF</h3>
<p>Si vous avez des shortcodes  grer dans votre site web, ou si vous souhaitez vos y mettre, l&rsquo;<a href=\"http://www.absoluteweb.net/generateur-shortcodes-acf/\">extension ACF pourrait vous faciliter les choses</a>.</p>
<h3>We are WP</h3>
<p><a href=\"http://www.wearewp.pro/\">We are WP</a>, c&rsquo;est la nouvelle agence de conseils et d&rsquo;expertise WordPress cre par Emilie Lebrun et Thierry Pigot, membres minents de la communaut franaise.</p>
<h3>Les parts de march de WordPress dans le monde</h3>
<p>Daniel prsente les parts de march mondiale de WordPress. <a href=\"http://www.seomix.fr/parts-de-marche-wordpress/\">Un article trs intressant et instructif</a>.</p>
<h3>Du nouveau avec REST API</h3>
<p>Une <a href=\"http://wptavern.com/explore-the-wordpress-rest-api-with-the-new-interactive-console-plugin\">console REST API </a>est maintenant disponible. (en)</p>
<h3>WP Rocket, 2 ans aprs</h3>
<p>Voici dj 2 ans que la fuse WP Rocket a dcoll. <a href=\"http://blog.wp-rocket.me/fr/2-ans-bilan-retour-experience/\">A l&rsquo;heure du bilan</a>, autant dire que l&rsquo;optimisme est de rigueur. Une <a href=\"http://wptavern.com/wp-rocket-reports-355k-in-annual-revenue-after-2-years-in-business\">belle aventure de startup  la franaise (en)</a>. (<a href=\"http://blog.wp-rocket.me/2-years-reports-feedbacks/\">English version here</a>)</p>
<h3>Puisqu&rsquo;on vous dit d&rsquo;utiliser un thme enfant !</h3>
<p>On ne le rptera jamais assez&#8230; <a href=\"http://webdesignerhut.com/wordpress-child-themes/\">utilisez un thme enfant</a> ! (en)</p>
<h3>Gestion complte des menus</h3>
<p>Grgoire propose un <a href=\"http://www.gregoirenoyelle.com/gestion-des-menus-depuis-wordpress-3/\">tutoriel pour tout savoir des menus</a> dans WordPress.</p>
<h3>L&rsquo;extension pour les surveiller toutes</h3>
<p>L&rsquo;extension qui surveille les autres pour vous indiquer les failles de scurit existe, il s&rsquo;agit de<a href=\"http://wpformation.com/plugin-failles-securite/\"> Plugin Security Scanner</a>.</p>
<h3>Automattic, Matt Mullenweg et Thesis&#8230; histoire d&rsquo;un conflit</h3>
<p>La <a href=\"https://poststatus.com/thesis-automattic-and-wordpress/\">longue histoire du conflit</a> qui oppose le thme Thesis  Automattic et Matt Mullenweg depuis 2010. (en)</p>
<h3>Comment styliser les formulaires de Gravity Forms</h3>
<p>La Marmite propose dans son menu de <a href=\"http://wpmarmite.com/gravity-forms-css/\">styliser vos formulaires de Gravity Forms</a>.</p>
<h3>Polylang et WooCommerce</h3>
<p>Retour d&rsquo;exprience de l&rsquo;utilisation de <a href=\"http://www.absoluteweb.net/polylang-grosse-deception/\">Polylang avec WooCommerce</a>.</p>
<h3>Mise  jour du livre &laquo;&nbsp;optimiser son rfrencement WordPress&nbsp;&raquo;</h3>
<p>Daniel Roch <a href=\"http://www.wp-referencement.fr/\">indique la mise  jour du livre</a> qu&rsquo;il a crit concernant le rfrencement avec WordPress.</p>
<h3>Chrome 44 et WordPress</h3>
<p>Cette semaine, la <a href=\"http://www.imadarchid.com/un-bug-sur-chrome-44-beta-detruit-wordpress-et-dautres-logiciels/\">mise  jour 44 de Chrome</a> a entrain un <a href=\"https://github.com/IshYoBoy/aaa-ishyoboy-google-chrome-44-ssl-fix\">problme avec WordPress</a>.</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=NRscrl4Ddlw:tH6Ix9sW9-g:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=NRscrl4Ddlw:tH6Ix9sW9-g:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=NRscrl4Ddlw:tH6Ix9sW9-g:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=NRscrl4Ddlw:tH6Ix9sW9-g:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=NRscrl4Ddlw:tH6Ix9sW9-g:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=NRscrl4Ddlw:tH6Ix9sW9-g:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/NRscrl4Ddlw\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/0Fxaf6P1QkI\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"http://www.wordpress-fr.net/2015/07/24/lhebdo-wordpress-n262-communautes-retours-dexperience-astuces/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"6\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:101:\"http://www.wordpress-fr.net/2015/07/24/lhebdo-wordpress-n262-communautes-retours-dexperience-astuces/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/NRscrl4Ddlw/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:66:\"
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"LHebdo WordPress n261 : WordCamp et WPMX Day  e-barcamp  Communauts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/QVV623BdIII/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"http://www.wordpress-fr.net/2015/06/23/lhebdo-wordpress-n261-wordcamp-et-wpmx-day-e-barcamp-communautes/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 23 Jun 2015 05:26:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:9:{i:0;a:5:{s:4:\"data\";s:16:\"Association WPFR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Brves\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:14:\"Dveloppement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"Evnements\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:10:\"Podcasting\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:7;a:5:{s:4:\"data\";s:12:\"communauts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:8;a:5:{s:4:\"data\";s:8:\"wordcamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7448\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:336:\"WordCamp Lyon 2015 J&#8217;ai eu la chance de participer au 1er WordCamp Lyon. Il s&#8217;est droul le 5 juin dernier sous le soleil du Rhne. Autant le dire tout de suite, c&#8217;tait un grand vnement ! UN belle russite. Bravo aux organisateurs ! Voici quelques liens qui en parlent en des termes au moins aussi [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benot\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6632:\"<h3>WordCamp Lyon 2015</h3>
<p>J&rsquo;ai eu la chance de participer au 1er WordCamp Lyon. Il s&rsquo;est droul le 5 juin dernier sous le soleil du Rhne. Autant le dire tout de suite, c&rsquo;tait un grand vnement ! UN belle russite. Bravo aux organisateurs !</p>
<p>Voici quelques liens qui en parlent en des termes au moins aussi logieux que moi si ce n&rsquo;est plus :</p>
<ul>
<li><a href=\"http://eclozion360.com/wordcamp-lyon-2015/\">Des photos</a></li>
<li><a href=\"http://www.wp-spread.com/comment-travailler-en-equipe-autour-dun-projet-wordpress-wordcamp-lyon-2015/\">Le retour de Maxime BJ</a></li>
<li><a href=\"https://www.flickr.com/search/?text=WPLyon\">D&rsquo;autres photos</a></li>
<li><a href=\"http://wordpress.tv/event/wordcamp-lyon-2015/\">Dj les confrences et ateliers sur WordPress.tv</a></li>
<li><a href=\"http://wpmarmite.com/wordcamp-lyon-2015/\">Une marmite qui dborde de retours</a></li>
<li><a href=\"http://www.jennybeaumont.com/results-2015-wordpress-maintenance-survey/\">Le sondage pre-WordCamp Lyon de Jenny</a></li>
<li><a href=\"https://lyon.wordcamp.org/2015/les-photos/\">Le site officiel dit merci !</a></li>
<li><a href=\"https://twitter.com/search?q=%23wplyon&amp;mode=news&amp;src=tyah\">#wplyon</a></li>
</ul>
<h3>WPMX Day 2015</h3>
<p>Le lendemain du WordCamp Lyon se droulait  quelques centaines de km de Lyon, plus prs de la cte Atlantique, le <a href=\"http://wpmx.org/retour-wpmx-day-2015/\">WPMX Day</a>.</p>
<ul>
<li><a href=\"http://www.lameleeadour.com/wpmx-day-6-juin-2015-a-biarritz-2/\">Un retour de cette journe.</a></li>
</ul>
<h3>Le premier e-barcamp de France</h3>
<p>L&rsquo;quipe de VFT a mis en place fin mai un e-barcamp. L&rsquo;objectif tait d&rsquo;appliquer le mode barcamp  un podcast. <a href=\"http://veryfrenchtrip.com/podcast/podcast-13-e-barcamp-1/\">Le rsultat est en ligne ici</a>. En attendant la prochaine dition, VFT revient bientt pour son traditionnel podcast <a href=\"http://veryfrenchtrip.com/annonce-podcast-14-organiser-des-meetups-wordpress/\">consacr cette fois aux meetups</a>. Restez connects.</p>
<h3>La communaut WPFR sur Slack</h3>
<p>La communaut WordPress Francophone est sur Slack depuis un mois environ et ne cesse de grandir. <a href=\"http://boiteaweb.fr/wordpressfr-on-slack-8588.html\">Si ce n&rsquo;est pas encore faire venez nous rejoindre</a>.</p>
<h3>Des meetups partout&#8230; encore et toujours !</h3>
<p>La communaut est vivante et de plus en plus riche et active. Un nouveau groupe s&rsquo;est <a href=\"http://www.meetup.com/fr/WordPress-Lorraine/\">cr en Lorraine</a>.</p>
<p>Et le prochain et dernier meetup niois avant les vacances, <a href=\"http://www.meetup.com/wordpress-in-nice/events/223309511/?a=ra1_te\">c&rsquo;est le 30 juin</a> !</p>
<h3>Glossaire des traductions franaises</h3>
<p>FX, bien connu des traducteurs en franais, a ralis <a href=\"https://fxbenard.com/glossaire-des-traductions-francaises-de-wordpress/\">un glossaire des traductions en franais</a>. Un &laquo;&nbsp;<em>must have</em>&laquo;&nbsp;.</p>
<h3>La mode est au Wapuu</h3>
<p><a href=\"http://wptavern.com/introducing-the-wp-tavern-wapuu#comment-69209\">WP Tavern a son wapuu</a>&#8230; et maintenant la <a href=\"http://boiteaweb.fr/welcome-to-marcel-le-wapuu-de-la-communaute-francaise-8598.html\">France  le sien aussi</a> ! &#8230; Le<a href=\"http://wapuu.jp/about/\"> Wapuu c&rsquo;est a au fait</a> !</p>
<h3>Un sondage sur WordPress</h3>
<p>Jenny Wong souhaite recueillir vos avis sur WordPress, <a href=\"https://docs.google.com/forms/d/1dkF1nbVCTawp7vq8pZd2SB8FIV2iwny01EtfbadnfoA/viewform?c=0&amp;w=1\">aidez-la (en)</a>.</p>
<h3>Arrter de s&rsquo;arracher les cheveux en cherchant un thme</h3>
<p>Un article qui vous donne<a href=\"http://www.webmarketing-com.com/2015/03/25/36361-comment-arreter-de-sarracher-les-cheveux-en-recherchant-un-theme-wordpress\"> des pistes pour vos recherches de thmes</a> !</p>
<h3>Un guide pour les Custom Page Template</h3>
<p>Apprenez <a href=\"http://www.smashingmagazine.com/2015/06/19/wordpress-custom-page-templates/\"> personnaliser vos pages dans WordPress</a> (en).</p>
<h3>Theme Juice : Une configuration Vagrant pour les dveloppeurs</h3>
<p>Vous tes dveloppeurs et souhaitez une nouvelle plateforme de dveloppement, <a href=\"http://wptavern.com/theme-juice-a-new-vagrant-configuration-for-wordpress-development\">c&rsquo;est ici que a passe</a> (en).</p>
<h3>Pas (que) du WordPress mais du PHP</h3>
<p>PHP et WordPress sont troitement lis, c&rsquo;est pourquoi cet article peut vous intresser : <a href=\"https://kinsta.com/blog/hhvm-vs-php-7/\">HHVM vs PHP7 (en)</a>.</p>
<h3>&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;-</h3>
<h3>Appel  la communaut francophone</h3>
<p>Vous avez dj particip au dveloppement du core de WordPress (vous savez, vous avez eu votre heure de gloire avec votre nom dans les crdits de WordPress ! :p ) ? Signalez-vous ici (ou sur le Slack), un recensement est en cours par Jenny Beaumont <img src=\"http://s.w.org/images/core/emoji/72x72/1f609.png\" alt=\"&#x1f609;\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>
<h3>Association WPFR nouvelle gnration</h3>
<p>J&rsquo;ai oue dire que <span style=\"text-decoration: underline;\"><strong>les nouveaux statuts sont dposs en prfecture</strong></span> et valids ! <em>WPFR next gen, </em>c&rsquo;est parti ! On vous en dit plus trs trs trs trs bientt ! #wpfrstatuts</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=ZSQgxX9WNpE:Tg583M62sFc:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=ZSQgxX9WNpE:Tg583M62sFc:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=ZSQgxX9WNpE:Tg583M62sFc:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=ZSQgxX9WNpE:Tg583M62sFc:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=ZSQgxX9WNpE:Tg583M62sFc:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=ZSQgxX9WNpE:Tg583M62sFc:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/ZSQgxX9WNpE\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/QVV623BdIII\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:109:\"http://www.wordpress-fr.net/2015/06/23/lhebdo-wordpress-n261-wordcamp-et-wpmx-day-e-barcamp-communautes/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:104:\"http://www.wordpress-fr.net/2015/06/23/lhebdo-wordpress-n261-wordcamp-et-wpmx-day-e-barcamp-communautes/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/ZSQgxX9WNpE/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:48:\"
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"LHebdo WordPress n260 : WooThemes  Slack  Insights\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/siKfBLAVPrQ/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"http://www.wordpress-fr.net/2015/06/03/lhebdo-wordpress-n260-woothemes-slack-insights/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 03 Jun 2015 05:27:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:7:\"Astuces\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:10:\"automattic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:9:\"WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7445\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:359:\"Automattic acquiert WooThemes L&#8217;info de cette dernire quinzaine est sans aucun doute le rachat (en) de WooThemes (en) par Automattic (en). Le plus gros marchand de thmes et le crateur du plus clbre outil de e-commerce pour WordPress rejoint donc le giron de l&#8217;outil le plus puissant du web. 12e anniversaire de WordPress Que le [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benot\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3796:\"<h3>Automattic acquiert WooThemes</h3>
<p>L&rsquo;info de cette dernire quinzaine est sans aucun doute le <a href=\"https://poststatus.com/automattic-acquired-woocommerce-woothemes/\">rachat (en) </a>de <a href=\"http://www.woothemes.com/2015/05/woothemes-joins-automattic/\">WooThemes (en) </a>par <a href=\"http://ma.tt/2015/05/woomattic/\">Automattic (en)</a>. Le plus gros marchand de thmes et le crateur du plus clbre outil de e-commerce pour WordPress <a href=\"http://wpchannel.com/woothemes-automattic-acquisition-e-commerce/\">rejoint donc le giron</a> de l&rsquo;outil le plus puissant du web.</p>
<h3>12e anniversaire de WordPress</h3>
<p>Que le temps passe vite ! <a href=\"https://matt.wordpress.com/2015/05/27/wordpress-12th-birthday-cake/\">Dj 12 ans </a>depuis le dbut du projet. (en) !</p>
<h3>WordPress.com lance Insights</h3>
<p>Il s&rsquo;agit d&rsquo;un <a href=\"http://wptavern.com/wordpress-com-launches-insights-better-stats-for-visualizing-publishing-trends\">meilleur outil de statistiques</a> qui apporte un certain nombres de changement  l&rsquo;interface actuelle.</p>
<h3>Une communaut WordPress en franais sur Slack</h3>
<p>Un nouveau groupe a t cr sur la <a href=\"http://www.wp-spread.com/invitez-vous-sur-le-chat-wordpress-francophone-sur-slack/\">plateforme Slack</a>. Rejoignez le groupe ds que vous pouvez !</p>
<h3>Des tutos et ressources pour apprendre</h3>
<p><a href=\"https://matt.wordpress.com/2015/05/27/wordpress-12th-birthday-cake/\">Quelques tutoriels et ressources</a> diverses pour apprendre WordPress</p>
<h3>Renommer automatiquement les fichiers accentus sous WordPress</h3>
<p>Si vous avez des fichiers nomms <a href=\"http://wpchannel.com/renommer-automatiquement-fichiers-accentues-wordpress/\">avec des accents et que vous en avez assez de les renommer sans cesse</a>, cette extension est pour vous.</p>
<h3>La hirarchie des templates</h3>
<p>Avec WordPress il est souvent utile de connaitre<a href=\"http://4design.xyz/wordpress-visualisez-la-hierarchie-des-templates\"> la hirarchie des templates</a> pour travailler dans un thme notamment.</p>
<h3>11 exemples de sites WordPress</h3>
<p><a href=\"http://www.maintpress.com/blog/exemple-site-wordpress-bien-reussi/\">Voici 11 sites WordPress</a> qui semblent intressants selon MaintPress.</p>
<h3>Connecter WordPress  OneNote de Microsoft</h3>
<p>Voici la solution pour connecter <a href=\"http://blogs.office.com/2015/05/22/onenote-welcomes-three-new-partners-cloudhq-equil-and-wordpress/\">un site WordPress avec un compte Microsoft OneNote (en)</a>.</p>
<p><em>NB : A celles et ceux qui vont au WordCamp Lyon, je leur dit : &laquo;&nbsp;A vendredi !&nbsp;&raquo;</em></p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=XyIbHAGFLdw:abkmUGnIo1g:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=XyIbHAGFLdw:abkmUGnIo1g:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=XyIbHAGFLdw:abkmUGnIo1g:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=XyIbHAGFLdw:abkmUGnIo1g:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=XyIbHAGFLdw:abkmUGnIo1g:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=XyIbHAGFLdw:abkmUGnIo1g:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/XyIbHAGFLdw\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/siKfBLAVPrQ\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"http://www.wordpress-fr.net/2015/06/03/lhebdo-wordpress-n260-woothemes-slack-insights/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"6\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:86:\"http://www.wordpress-fr.net/2015/06/03/lhebdo-wordpress-n260-woothemes-slack-insights/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/XyIbHAGFLdw/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:54:\"
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"LHebdo WordPress n259 : Des vnements WordPress  WordPress 4.3  BuddyPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/O5_p3VM9M2Q/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:120:\"http://www.wordpress-fr.net/2015/05/19/lhebdo-wordpress-n259-des-evenements-wordpress-wordpress-4-3-buddypress/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 19 May 2015 05:13:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:7:\"Astuces\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"Dveloppement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:11:\"Evnements\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:10:\"Extensions\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:13:\"WordPress 4.3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7441\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:323:\"Juin dmarre sous le signe de WordPress Le dbut du mois de juin s&#8217;annonce riche en vnements WordPress : 3 juin : WordPress in Alps 5 juin : WordCamp Lyon &#8211;&#62; Il reste des billets, attrapez-les tous ! (Au moment o j&#8217;cris ces lignes, il reste 2 places !!) 6 juin : WPMX Day WordPress [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benot\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4472:\"<h3>Juin dmarre sous le signe de WordPress</h3>
<p>Le dbut du mois de juin s&rsquo;annonce riche en vnements WordPress :</p>
<ul>
<li>3 juin : <a href=\"http://www.wp-spread.com/wordpress-in-alps-le-3-juin-ateliers-decouverte-wordpress/\">WordPress in Alps</a></li>
<li>5 juin : WordCamp Lyon &#8211;&gt; Il reste des billets, <a href=\"https://lyon.wordcamp.org/2015/billetterie/\">attrapez-les tous</a> ! (Au moment o j&rsquo;cris ces lignes, il reste 2 places !!)</li>
<li>6 juin : <a href=\"http://2015.wpmx.org/conferences/\">WPMX Day</a></li>
</ul>
<h3>WordPress 4.3 poursuit son dveloppement</h3>
<p>L&rsquo;<a href=\"https://make.wordpress.org/core/2015/05/11/weekly-core-ui-meetings-for-4-3/\">interface utilisateur poursuit sa mue</a>&#8230; et le <a href=\"https://make.wordpress.org/core/2015/05/12/multisite-office-hours-recap-may-12-2015/\">ct multi-utilisateurs</a> volue encore. (en)</p>
<h3>BuddyPress 2.3.0 beta 2</h3>
<p><a href=\"https://buddypress.org/2015/05/buddypress-2-3-0-beta-2/\">BuddyPress passe en 2e beta (en) </a>pour la version 2.3.0&#8230; et <a href=\"http://wptavern.com/buddypress-2-3-will-introduce-companion-stylesheets-for-wordpress-default-themes\">quelques nouveauts sont attendues</a> (en).</p>
<h3>WordPress c&rsquo;est de la merde !</h3>
<p><a href=\"http://www.seomix.fr/shitty-wordpress/\">Un titre accrocheur pour une argumentation </a>haute en couleur !</p>
<h3>Ajouter un menu de recherche par date ou taxonomie</h3>
<p>Grgoire prsente un tutoriel prcis sur la dmarche  suivre pour <a href=\"http://www.gregoirenoyelle.com/wordpress-ajouter-menus-recherche-date-taxonomie/\">ajouter un menu de recherche par date ou taxonomie</a>.</p>
<h3>Les vidos de LoopConf</h3>
<p>La chaine YouTube de LoopCon o l&rsquo;on peut<a href=\"https://www.youtube.com/channel/UCAwOVsWiMdlz6snWRF2HdSQ\"> retrouver toute leur vido relatives  WordPress</a>. (en)</p>
<h3>Les chiffres de la Rocket en avril</h3>
<p><a href=\"http://blog.wp-rocket.me/inside-wp-rocket-april-2015/\">WP Rocket prsente rgulirement ses statistiques</a>&#8230; voici pour le mois d&rsquo;avril 2015. (en)</p>
<h3>WordPress et Microsoft Azure</h3>
<p>Microsoft Azure et WordPress, a marche ! <a href=\"http://www.script-tutorials.com/scalable-wordpress-on-microsoft-azure/\">La preuve ici.</a> (en)</p>
<h3>Pourquoi paye-t-on pour WordPress 2e partie</h3>
<p><a href=\"http://www.wp-pro.fr/pourquoi-paye-t-on-pour-wordpress-une-solution-gratuite-2eme-partie/\">WP-Pro propose la 2e partie </a>de son analyse sur le fait que l&rsquo;on peut payer &laquo;&nbsp;du WordPress&nbsp;&raquo; alors que l&rsquo;application est gratuite.</p>
<h3>7 extensions de supports clients</h3>
<p>Si vous recherchiez de quoi grer un support client, voici <a href=\"http://www.wpbeginner.com/plugins/6-best-help-desk-customer-support-plugins-for-wordpress/\">7 extensions WordPress qui devrait vous plaire. (en)</a></p>
<h3>Scuriser WordPress</h3>
<p>MaintPress nous donne des pistes sur la faon de <a href=\"http://www.maintpress.com/blog/securiser-wordpress-comment-renforcer-securite-site-wordpress/\">mieux scuriser WordPress</a>.</p>
<h3>L&rsquo;volution de WordPress</h3>
<p>WordPress volue inlassablement depuis 10 ans, <a href=\"http://neliosoftware.com/some-stats-on-the-evolution-of-the-wordpress-codebase/\">petite analyse de cette volution (en)</a>.</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=LYVelJJ-s4U:XQf-hBBVWTY:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=LYVelJJ-s4U:XQf-hBBVWTY:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=LYVelJJ-s4U:XQf-hBBVWTY:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=LYVelJJ-s4U:XQf-hBBVWTY:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=LYVelJJ-s4U:XQf-hBBVWTY:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=LYVelJJ-s4U:XQf-hBBVWTY:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/LYVelJJ-s4U\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/O5_p3VM9M2Q\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:116:\"http://www.wordpress-fr.net/2015/05/19/lhebdo-wordpress-n259-des-evenements-wordpress-wordpress-4-3-buddypress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:111:\"http://www.wordpress-fr.net/2015/05/19/lhebdo-wordpress-n259-des-evenements-wordpress-wordpress-4-3-buddypress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/LYVelJJ-s4U/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:54:\"
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"LHebdo WordPress n258 : WordPress 4.3  WordCamps &amp; Evnements WP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/FiV0asGKK6M/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"http://www.wordpress-fr.net/2015/05/05/lhebdo-wordpress-n258-wordpress-4-3-wordcamps-evenements-wp/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 05 May 2015 05:25:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:7:\"Astuces\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"Dveloppement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:11:\"Evnements\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:10:\"Podcasting\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:8:\"wordcamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7437\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:395:\"WordPress 4.3 est lanc Comme toujours, quelques jours aprs le dploiement d&#8217;une version majeur la suivante est aussitt mise sur les rails. WordPress 4.3 est donc prvue pour le 18 aot prochain et c&#8217;est Konstantin Obenland qui en prend les rnes. (en) Les premires pistes de rflexions sont ouvertes, notamment concernant l&#8217;diteur. (en) WordPress 4.2.1 [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benot\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3723:\"<h3>WordPress 4.3 est lanc</h3>
<p>Comme toujours, quelques jours aprs le dploiement d&rsquo;une version majeur la suivante est aussitt mise sur les rails. WordPress 4.3 est donc <a href=\"http://wp.me/p2AvED-3mD\">prvue pour le 18 aot prochain</a> et c&rsquo;est Konstantin Obenland qui en prend les rnes. (en)</p>
<p>Les premires pistes de rflexions sont ouvertes, <a href=\"https://make.wordpress.org/core/2015/05/01/editor-wish-list-for-4-3/\">notamment concernant l&rsquo;diteur</a>. (en)</p>
<h3>WordPress 4.2.1 : Premire mise  jour mineure</h3>
<p>Une faille de scurit a t dcele rapidement aprs la sortie de WordPress 4.2, <a href=\"http://t.co/O3MDAj635H\">le patch correctif </a>ne s&rsquo;est donc pas fait attendre (en).</p>
<h3>WordCamp Lyon : programme et surprises</h3>
<p>Le WordCamp Lyon avance et se prcise. <a href=\"https://lyon.wordcamp.org/2015/programme/\">Le programme est connu</a> et on sait depuis peu qu&rsquo;un <a href=\"https://lyon.wordcamp.org/2015/nightswapping-vous-offre-2-nuits-a-lyon-pour-le-wordcamp/\">nouveau partenaire propose une surprise</a>.</p>
<h3>WordCamp Europe : les orateurs se dvoilent</h3>
<p>1re surprise de taille, <a href=\"http://europe.wordcamp.org/2015/welcome-the-third-group-of-wceu-speakers/\">Xavier (notre Xavier) fait partie des orateurs </a>du prochains WordCamp Europe.</p>
<h3>WPMX Day</h3>
<p>Rappelons galement que le lendemain du WordCamp Lyon se tiendra le <a href=\"http://2015.wpmx.org/\">WPMX Day</a>, vnement majeur dans le Sud-Ouest de la France.</p>
<h3>Le 11e Podcast de Very French Trip</h3>
<p><a href=\"http://veryfrenchtrip.com/podcast/podcast-12-traduction-wordpress/\">Pour cette 11e dition</a>, la traduction est  l&rsquo;honneur avec des invits de marque que sont Xavier, Didier, Franois-Xavier, Mathieu et Grgoire.</p>
<h3>Les principes de hirarchie dans le design visuel</h3>
<p>Un article qui parle de <a href=\"https://dailypost.wordpress.com/2015/04/29/the-principles-of-design-visual-hierarchy/\">design des sites web</a> racont par un Automatticien. (en)</p>
<h3>WPRocket lue meilleure extension de cache</h3>
<p>WPSiteCare a lu <a href=\"http://www.wpsitecare.com/best-wordpress-plugins/\">WPRocket meilleure extension de cache de tous les temps</a> (en)&#8230; et retrouvez galement le classement des autres meilleures extensions de tous les temps dans ce classement.</p>
<h3>Les vnements WordPress sur une carte</h3>
<p>ManageWP.org a mis en ligne une <a href=\"https://managewp.org/events/\">carte interactive avec les diffrents vnements WordPress </a>de la Plante. (en)</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=kwe0XgYW1P0:5XuUlueSTRA:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=kwe0XgYW1P0:5XuUlueSTRA:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=kwe0XgYW1P0:5XuUlueSTRA:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=kwe0XgYW1P0:5XuUlueSTRA:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=kwe0XgYW1P0:5XuUlueSTRA:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=kwe0XgYW1P0:5XuUlueSTRA:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/kwe0XgYW1P0\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/FiV0asGKK6M\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"http://www.wordpress-fr.net/2015/05/05/lhebdo-wordpress-n258-wordpress-4-3-wordcamps-evenements-wp/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:99:\"http://www.wordpress-fr.net/2015/05/05/lhebdo-wordpress-n258-wordpress-4-3-wordcamps-evenements-wp/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/kwe0XgYW1P0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:4:{s:4:\"info\";a:2:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"uri\";s:20:\"wordpressfrancophone\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"uri\";s:15:\"feedburner/cjgl\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:14:\"emailServiceId\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordpressFrancophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:18:\"feedburnerHostname\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://feedburner.google.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"feedFlare\";a:18:{i:0;a:5:{s:4:\"data\";s:24:\"Subscribe with NewsGator\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:112:\"http://www.newsgator.com/ngs/subscriber/subext.aspx?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:42:\"http://www.newsgator.com/images/ngsub1.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:24:\"Subscribe with Bloglines\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:77:\"http://www.bloglines.com/sub/http://feeds.feedburner.com/WordpressFrancophone\";s:3:\"src\";s:48:\"http://www.bloglines.com/images/sub_modern11.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:23:\"Subscribe with Netvibes\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:98:\"http://www.netvibes.com/subscribe.php?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:44:\"http://www.netvibes.com/img/add2netvibes.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:21:\"Subscribe with Google\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:93:\"http://fusion.google.com/add?feedurl=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:51:\"http://buttons.googlesyndication.com/fusion/add.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:25:\"Subscribe with Pageflakes\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:101:\"http://www.pageflakes.com/subscribe.aspx?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:87:\"http://www.pageflakes.com/ImageFile.ashx?instanceId=Static_4&fileName=ATP_blu_91x17.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:21:\"Subscribe with Plusmo\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:86:\"http://www.plusmo.com/add?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:43:\"http://plusmo.com/res/graphics/fbplusmo.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:23:\"Subscribe with Live.com\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:81:\"http://www.live.com/?add=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:141:\"http://tkfiles.storage.msn.com/x1piYkpqHC_35nIp1gLE68-wvzLZO8iXl_JMledmJQXP-XTBOLfmQv4zhj4MhcWEJh_GtoBIiAl1Mjh-ndp9k47If7hTaFno0mxW9_i3p_5qQw\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:7;a:5:{s:4:\"data\";s:25:\"Subscribe with Mon Yahoo!\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:99:\"https://add.my.yahoo.com/content?lg=fr&url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:60:\"http://us.i1.yimg.com/us.yimg.com/i/us/my/bn/intatm_fr_1.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:8;a:5:{s:4:\"data\";s:25:\"Subscribe with Excite MIX\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:89:\"http://mix.excite.eu/add?feedurl=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:42:\"http://image.excite.co.uk/mix/addtomix.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:9;a:5:{s:4:\"data\";s:25:\"Subscribe with Mon Yahoo!\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:96:\"https://add.my.yahoo.com/content?lg=fr&url=http%3A%2F%2Ffeeds.feedburner.com%2Ffeedburner%2FcjgL\";s:3:\"src\";s:60:\"http://us.i1.yimg.com/us.yimg.com/i/us/my/bn/intatm_fr_1.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:10;a:5:{s:4:\"data\";s:21:\"Subscribe with Feedly\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:80:\"http://feedly.com/#subscription/feed/http://feeds.feedburner.com/feedburner/cjgL\";s:3:\"src\";s:42:\"http://s3.feedly.com/feedburner/feedly.png\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:11;a:5:{s:4:\"data\";s:24:\"Subscribe with Bloglines\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:72:\"http://www.bloglines.com/sub/http://feeds.feedburner.com/feedburner/cjgL\";s:3:\"src\";s:48:\"http://www.bloglines.com/images/sub_modern11.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:12;a:5:{s:4:\"data\";s:23:\"Subscribe with Netvibes\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:95:\"http://www.netvibes.com/subscribe.php?url=http%3A%2F%2Ffeeds.feedburner.com%2Ffeedburner%2FcjgL\";s:3:\"src\";s:44:\"http://www.netvibes.com/img/add2netvibes.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:13;a:5:{s:4:\"data\";s:25:\"Subscribe with Pageflakes\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:98:\"http://www.pageflakes.com/subscribe.aspx?url=http%3A%2F%2Ffeeds.feedburner.com%2Ffeedburner%2FcjgL\";s:3:\"src\";s:87:\"http://www.pageflakes.com/ImageFile.ashx?instanceId=Static_4&fileName=ATP_blu_91x17.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:14;a:5:{s:4:\"data\";s:34:\"Subscribe with The Free Dictionary\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:103:\"http://www.thefreedictionary.com/_/hp/AddRSS.aspx?http%3A%2F%2Ffeeds.feedburner.com%2Ffeedburner%2FcjgL\";s:3:\"src\";s:48:\"http://img.tfd.com/hp/addToTheFreeDictionary.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:15;a:5:{s:4:\"data\";s:28:\"Subscribe with Bitty Browser\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:115:\"http://www.bitty.com/manual/?contenttype=rssfeed&contentvalue=http%3A%2F%2Ffeeds.feedburner.com%2Ffeedburner%2FcjgL\";s:3:\"src\";s:48:\"http://www.bitty.com/img/bittychicklet_91x17.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:16;a:5:{s:4:\"data\";s:28:\"Subscribe with Podcast Ready\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:107:\"http://www.podcastready.com/oneclick_bookmark.php?url=http%3A%2F%2Ffeeds.feedburner.com%2Ffeedburner%2FcjgL\";s:3:\"src\";s:58:\"http://www.podcastready.com/images/podcastready_button.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:17;a:5:{s:4:\"data\";s:29:\"Subscribe with Daily Rotation\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:97:\"http://www.dailyrotation.com/index.php?feed=http%3A%2F%2Ffeeds.feedburner.com%2Ffeedburner%2FcjgL\";s:3:\"src\";s:40:\"http://www.dailyrotation.com/rss-dr2.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:52:\"http://backend.userland.com/creativeCommonsRssModule\";a:1:{s:7:\"license\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"http://creativecommons.org/licenses/by-nc-sa/3.0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:2:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";s:4:\"href\";s:43:\"http://feeds.feedburner.com/feedburner/cjgL\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:3:\"hub\";s:4:\"href\";s:32:\"http://pubsubhubbub.appspot.com/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:10:{s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:4:\"etag\";s:27:\"Zzh+xmKzhaBIdWsl+8LGjlr0+Fg\";s:13:\"last-modified\";s:29:\"Wed, 13 Jan 2016 16:43:11 GMT\";s:16:\"content-encoding\";s:4:\"gzip\";s:4:\"date\";s:29:\"Wed, 13 Jan 2016 17:13:07 GMT\";s:7:\"expires\";s:29:\"Wed, 13 Jan 2016 17:13:07 GMT\";s:13:\"cache-control\";s:18:\"private, max-age=0\";s:22:\"x-content-type-options\";s:7:\"nosniff\";s:16:\"x-xss-protection\";s:13:\"1; mode=block\";s:6:\"server\";s:3:\"GSE\";}s:5:\"build\";s:14:\"20151224103522\";}","no");
INSERT INTO ayv_options VALUES("130","recently_activated","a:0:{}","yes");
INSERT INTO ayv_options VALUES("134","theme_mods_twentyfifteen","a:2:{s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:2;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1460125583;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:6:{i:0;s:6:\"text-2\";i:1;s:6:\"text-3\";i:2;s:6:\"text-4\";i:3;s:6:\"text-5\";i:4;s:10:\"nav_menu-2\";i:5;s:10:\"nav_menu-3\";}s:9:\"sidebar-1\";a:2:{i:0;s:14:\"recent-posts-2\";i:1;s:12:\"categories-2\";}}}}","yes");
INSERT INTO ayv_options VALUES("135","current_theme","Atelier Yvan Vedel","yes");
INSERT INTO ayv_options VALUES("136","theme_mods_constructo","a:2:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:2;}}","yes");
INSERT INTO ayv_options VALUES("137","theme_switched","","yes");
INSERT INTO ayv_options VALUES("138","anps_google_fonts","a:732:{i:0;a:2:{s:5:\"value\";s:7:\"ABeeZee\";s:4:\"name\";s:7:\"ABeeZee\";}i:1;a:2:{s:5:\"value\";s:4:\"Abel\";s:4:\"name\";s:4:\"Abel\";}i:2;a:2:{s:5:\"value\";s:13:\"Abril+Fatface\";s:4:\"name\";s:13:\"Abril Fatface\";}i:3;a:2:{s:5:\"value\";s:8:\"Aclonica\";s:4:\"name\";s:8:\"Aclonica\";}i:4;a:2:{s:5:\"value\";s:4:\"Acme\";s:4:\"name\";s:4:\"Acme\";}i:5;a:2:{s:5:\"value\";s:5:\"Actor\";s:4:\"name\";s:5:\"Actor\";}i:6;a:2:{s:5:\"value\";s:7:\"Adamina\";s:4:\"name\";s:7:\"Adamina\";}i:7;a:2:{s:5:\"value\";s:10:\"Advent+Pro\";s:4:\"name\";s:10:\"Advent Pro\";}i:8;a:2:{s:5:\"value\";s:15:\"Aguafina+Script\";s:4:\"name\";s:15:\"Aguafina Script\";}i:9;a:2:{s:5:\"value\";s:7:\"Akronim\";s:4:\"name\";s:7:\"Akronim\";}i:10;a:2:{s:5:\"value\";s:6:\"Aladin\";s:4:\"name\";s:6:\"Aladin\";}i:11;a:2:{s:5:\"value\";s:7:\"Aldrich\";s:4:\"name\";s:7:\"Aldrich\";}i:12;a:2:{s:5:\"value\";s:4:\"Alef\";s:4:\"name\";s:4:\"Alef\";}i:13;a:2:{s:5:\"value\";s:8:\"Alegreya\";s:4:\"name\";s:8:\"Alegreya\";}i:14;a:2:{s:5:\"value\";s:11:\"Alegreya+SC\";s:4:\"name\";s:11:\"Alegreya SC\";}i:15;a:2:{s:5:\"value\";s:13:\"Alegreya+Sans\";s:4:\"name\";s:13:\"Alegreya Sans\";}i:16;a:2:{s:5:\"value\";s:16:\"Alegreya+Sans+SC\";s:4:\"name\";s:16:\"Alegreya Sans SC\";}i:17;a:2:{s:5:\"value\";s:10:\"Alex+Brush\";s:4:\"name\";s:10:\"Alex Brush\";}i:18;a:2:{s:5:\"value\";s:13:\"Alfa+Slab+One\";s:4:\"name\";s:13:\"Alfa Slab One\";}i:19;a:2:{s:5:\"value\";s:5:\"Alice\";s:4:\"name\";s:5:\"Alice\";}i:20;a:2:{s:5:\"value\";s:5:\"Alike\";s:4:\"name\";s:5:\"Alike\";}i:21;a:2:{s:5:\"value\";s:13:\"Alike+Angular\";s:4:\"name\";s:13:\"Alike Angular\";}i:22;a:2:{s:5:\"value\";s:5:\"Allan\";s:4:\"name\";s:5:\"Allan\";}i:23;a:2:{s:5:\"value\";s:7:\"Allerta\";s:4:\"name\";s:7:\"Allerta\";}i:24;a:2:{s:5:\"value\";s:15:\"Allerta+Stencil\";s:4:\"name\";s:15:\"Allerta Stencil\";}i:25;a:2:{s:5:\"value\";s:6:\"Allura\";s:4:\"name\";s:6:\"Allura\";}i:26;a:2:{s:5:\"value\";s:8:\"Almendra\";s:4:\"name\";s:8:\"Almendra\";}i:27;a:2:{s:5:\"value\";s:16:\"Almendra+Display\";s:4:\"name\";s:16:\"Almendra Display\";}i:28;a:2:{s:5:\"value\";s:11:\"Almendra+SC\";s:4:\"name\";s:11:\"Almendra SC\";}i:29;a:2:{s:5:\"value\";s:8:\"Amarante\";s:4:\"name\";s:8:\"Amarante\";}i:30;a:2:{s:5:\"value\";s:8:\"Amaranth\";s:4:\"name\";s:8:\"Amaranth\";}i:31;a:2:{s:5:\"value\";s:9:\"Amatic+SC\";s:4:\"name\";s:9:\"Amatic SC\";}i:32;a:2:{s:5:\"value\";s:9:\"Amethysta\";s:4:\"name\";s:9:\"Amethysta\";}i:33;a:2:{s:5:\"value\";s:5:\"Amiri\";s:4:\"name\";s:5:\"Amiri\";}i:34;a:2:{s:5:\"value\";s:5:\"Amita\";s:4:\"name\";s:5:\"Amita\";}i:35;a:2:{s:5:\"value\";s:7:\"Anaheim\";s:4:\"name\";s:7:\"Anaheim\";}i:36;a:2:{s:5:\"value\";s:6:\"Andada\";s:4:\"name\";s:6:\"Andada\";}i:37;a:2:{s:5:\"value\";s:6:\"Andika\";s:4:\"name\";s:6:\"Andika\";}i:38;a:2:{s:5:\"value\";s:6:\"Angkor\";s:4:\"name\";s:6:\"Angkor\";}i:39;a:2:{s:5:\"value\";s:24:\"Annie+Use+Your+Telescope\";s:4:\"name\";s:24:\"Annie Use Your Telescope\";}i:40;a:2:{s:5:\"value\";s:13:\"Anonymous+Pro\";s:4:\"name\";s:13:\"Anonymous Pro\";}i:41;a:2:{s:5:\"value\";s:5:\"Antic\";s:4:\"name\";s:5:\"Antic\";}i:42;a:2:{s:5:\"value\";s:12:\"Antic+Didone\";s:4:\"name\";s:12:\"Antic Didone\";}i:43;a:2:{s:5:\"value\";s:10:\"Antic+Slab\";s:4:\"name\";s:10:\"Antic Slab\";}i:44;a:2:{s:5:\"value\";s:5:\"Anton\";s:4:\"name\";s:5:\"Anton\";}i:45;a:2:{s:5:\"value\";s:6:\"Arapey\";s:4:\"name\";s:6:\"Arapey\";}i:46;a:2:{s:5:\"value\";s:7:\"Arbutus\";s:4:\"name\";s:7:\"Arbutus\";}i:47;a:2:{s:5:\"value\";s:12:\"Arbutus+Slab\";s:4:\"name\";s:12:\"Arbutus Slab\";}i:48;a:2:{s:5:\"value\";s:19:\"Architects+Daughter\";s:4:\"name\";s:19:\"Architects Daughter\";}i:49;a:2:{s:5:\"value\";s:13:\"Archivo+Black\";s:4:\"name\";s:13:\"Archivo Black\";}i:50;a:2:{s:5:\"value\";s:14:\"Archivo+Narrow\";s:4:\"name\";s:14:\"Archivo Narrow\";}i:51;a:2:{s:5:\"value\";s:5:\"Arimo\";s:4:\"name\";s:5:\"Arimo\";}i:52;a:2:{s:5:\"value\";s:8:\"Arizonia\";s:4:\"name\";s:8:\"Arizonia\";}i:53;a:2:{s:5:\"value\";s:6:\"Armata\";s:4:\"name\";s:6:\"Armata\";}i:54;a:2:{s:5:\"value\";s:8:\"Artifika\";s:4:\"name\";s:8:\"Artifika\";}i:55;a:2:{s:5:\"value\";s:4:\"Arvo\";s:4:\"name\";s:4:\"Arvo\";}i:56;a:2:{s:5:\"value\";s:4:\"Arya\";s:4:\"name\";s:4:\"Arya\";}i:57;a:2:{s:5:\"value\";s:4:\"Asap\";s:4:\"name\";s:4:\"Asap\";}i:58;a:2:{s:5:\"value\";s:4:\"Asar\";s:4:\"name\";s:4:\"Asar\";}i:59;a:2:{s:5:\"value\";s:5:\"Asset\";s:4:\"name\";s:5:\"Asset\";}i:60;a:2:{s:5:\"value\";s:7:\"Astloch\";s:4:\"name\";s:7:\"Astloch\";}i:61;a:2:{s:5:\"value\";s:4:\"Asul\";s:4:\"name\";s:4:\"Asul\";}i:62;a:2:{s:5:\"value\";s:10:\"Atomic+Age\";s:4:\"name\";s:10:\"Atomic Age\";}i:63;a:2:{s:5:\"value\";s:6:\"Aubrey\";s:4:\"name\";s:6:\"Aubrey\";}i:64;a:2:{s:5:\"value\";s:9:\"Audiowide\";s:4:\"name\";s:9:\"Audiowide\";}i:65;a:2:{s:5:\"value\";s:10:\"Autour+One\";s:4:\"name\";s:10:\"Autour One\";}i:66;a:2:{s:5:\"value\";s:7:\"Average\";s:4:\"name\";s:7:\"Average\";}i:67;a:2:{s:5:\"value\";s:12:\"Average+Sans\";s:4:\"name\";s:12:\"Average Sans\";}i:68;a:2:{s:5:\"value\";s:19:\"Averia+Gruesa+Libre\";s:4:\"name\";s:19:\"Averia Gruesa Libre\";}i:69;a:2:{s:5:\"value\";s:12:\"Averia+Libre\";s:4:\"name\";s:12:\"Averia Libre\";}i:70;a:2:{s:5:\"value\";s:17:\"Averia+Sans+Libre\";s:4:\"name\";s:17:\"Averia Sans Libre\";}i:71;a:2:{s:5:\"value\";s:18:\"Averia+Serif+Libre\";s:4:\"name\";s:18:\"Averia Serif Libre\";}i:72;a:2:{s:5:\"value\";s:10:\"Bad+Script\";s:4:\"name\";s:10:\"Bad Script\";}i:73;a:2:{s:5:\"value\";s:9:\"Balthazar\";s:4:\"name\";s:9:\"Balthazar\";}i:74;a:2:{s:5:\"value\";s:7:\"Bangers\";s:4:\"name\";s:7:\"Bangers\";}i:75;a:2:{s:5:\"value\";s:5:\"Basic\";s:4:\"name\";s:5:\"Basic\";}i:76;a:2:{s:5:\"value\";s:10:\"Battambang\";s:4:\"name\";s:10:\"Battambang\";}i:77;a:2:{s:5:\"value\";s:7:\"Baumans\";s:4:\"name\";s:7:\"Baumans\";}i:78;a:2:{s:5:\"value\";s:5:\"Bayon\";s:4:\"name\";s:5:\"Bayon\";}i:79;a:2:{s:5:\"value\";s:8:\"Belgrano\";s:4:\"name\";s:8:\"Belgrano\";}i:80;a:2:{s:5:\"value\";s:7:\"Belleza\";s:4:\"name\";s:7:\"Belleza\";}i:81;a:2:{s:5:\"value\";s:9:\"BenchNine\";s:4:\"name\";s:9:\"BenchNine\";}i:82;a:2:{s:5:\"value\";s:7:\"Bentham\";s:4:\"name\";s:7:\"Bentham\";}i:83;a:2:{s:5:\"value\";s:15:\"Berkshire+Swash\";s:4:\"name\";s:15:\"Berkshire Swash\";}i:84;a:2:{s:5:\"value\";s:5:\"Bevan\";s:4:\"name\";s:5:\"Bevan\";}i:85;a:2:{s:5:\"value\";s:13:\"Bigelow+Rules\";s:4:\"name\";s:13:\"Bigelow Rules\";}i:86;a:2:{s:5:\"value\";s:11:\"Bigshot+One\";s:4:\"name\";s:11:\"Bigshot One\";}i:87;a:2:{s:5:\"value\";s:5:\"Bilbo\";s:4:\"name\";s:5:\"Bilbo\";}i:88;a:2:{s:5:\"value\";s:16:\"Bilbo+Swash+Caps\";s:4:\"name\";s:16:\"Bilbo Swash Caps\";}i:89;a:2:{s:5:\"value\";s:7:\"Biryani\";s:4:\"name\";s:7:\"Biryani\";}i:90;a:2:{s:5:\"value\";s:6:\"Bitter\";s:4:\"name\";s:6:\"Bitter\";}i:91;a:2:{s:5:\"value\";s:13:\"Black+Ops+One\";s:4:\"name\";s:13:\"Black Ops One\";}i:92;a:2:{s:5:\"value\";s:5:\"Bokor\";s:4:\"name\";s:5:\"Bokor\";}i:93;a:2:{s:5:\"value\";s:6:\"Bonbon\";s:4:\"name\";s:6:\"Bonbon\";}i:94;a:2:{s:5:\"value\";s:8:\"Boogaloo\";s:4:\"name\";s:8:\"Boogaloo\";}i:95;a:2:{s:5:\"value\";s:10:\"Bowlby+One\";s:4:\"name\";s:10:\"Bowlby One\";}i:96;a:2:{s:5:\"value\";s:13:\"Bowlby+One+SC\";s:4:\"name\";s:13:\"Bowlby One SC\";}i:97;a:2:{s:5:\"value\";s:7:\"Brawler\";s:4:\"name\";s:7:\"Brawler\";}i:98;a:2:{s:5:\"value\";s:10:\"Bree+Serif\";s:4:\"name\";s:10:\"Bree Serif\";}i:99;a:2:{s:5:\"value\";s:14:\"Bubblegum+Sans\";s:4:\"name\";s:14:\"Bubblegum Sans\";}i:100;a:2:{s:5:\"value\";s:11:\"Bubbler+One\";s:4:\"name\";s:11:\"Bubbler One\";}i:101;a:2:{s:5:\"value\";s:4:\"Buda\";s:4:\"name\";s:4:\"Buda\";}i:102;a:2:{s:5:\"value\";s:7:\"Buenard\";s:4:\"name\";s:7:\"Buenard\";}i:103;a:2:{s:5:\"value\";s:10:\"Butcherman\";s:4:\"name\";s:10:\"Butcherman\";}i:104;a:2:{s:5:\"value\";s:14:\"Butterfly+Kids\";s:4:\"name\";s:14:\"Butterfly Kids\";}i:105;a:2:{s:5:\"value\";s:5:\"Cabin\";s:4:\"name\";s:5:\"Cabin\";}i:106;a:2:{s:5:\"value\";s:15:\"Cabin+Condensed\";s:4:\"name\";s:15:\"Cabin Condensed\";}i:107;a:2:{s:5:\"value\";s:12:\"Cabin+Sketch\";s:4:\"name\";s:12:\"Cabin Sketch\";}i:108;a:2:{s:5:\"value\";s:15:\"Caesar+Dressing\";s:4:\"name\";s:15:\"Caesar Dressing\";}i:109;a:2:{s:5:\"value\";s:10:\"Cagliostro\";s:4:\"name\";s:10:\"Cagliostro\";}i:110;a:2:{s:5:\"value\";s:14:\"Calligraffitti\";s:4:\"name\";s:14:\"Calligraffitti\";}i:111;a:2:{s:5:\"value\";s:6:\"Cambay\";s:4:\"name\";s:6:\"Cambay\";}i:112;a:2:{s:5:\"value\";s:5:\"Cambo\";s:4:\"name\";s:5:\"Cambo\";}i:113;a:2:{s:5:\"value\";s:6:\"Candal\";s:4:\"name\";s:6:\"Candal\";}i:114;a:2:{s:5:\"value\";s:9:\"Cantarell\";s:4:\"name\";s:9:\"Cantarell\";}i:115;a:2:{s:5:\"value\";s:11:\"Cantata+One\";s:4:\"name\";s:11:\"Cantata One\";}i:116;a:2:{s:5:\"value\";s:11:\"Cantora+One\";s:4:\"name\";s:11:\"Cantora One\";}i:117;a:2:{s:5:\"value\";s:8:\"Capriola\";s:4:\"name\";s:8:\"Capriola\";}i:118;a:2:{s:5:\"value\";s:5:\"Cardo\";s:4:\"name\";s:5:\"Cardo\";}i:119;a:2:{s:5:\"value\";s:5:\"Carme\";s:4:\"name\";s:5:\"Carme\";}i:120;a:2:{s:5:\"value\";s:14:\"Carrois+Gothic\";s:4:\"name\";s:14:\"Carrois Gothic\";}i:121;a:2:{s:5:\"value\";s:17:\"Carrois+Gothic+SC\";s:4:\"name\";s:17:\"Carrois Gothic SC\";}i:122;a:2:{s:5:\"value\";s:10:\"Carter+One\";s:4:\"name\";s:10:\"Carter One\";}i:123;a:2:{s:5:\"value\";s:9:\"Catamaran\";s:4:\"name\";s:9:\"Catamaran\";}i:124;a:2:{s:5:\"value\";s:6:\"Caudex\";s:4:\"name\";s:6:\"Caudex\";}i:125;a:2:{s:5:\"value\";s:6:\"Caveat\";s:4:\"name\";s:6:\"Caveat\";}i:126;a:2:{s:5:\"value\";s:12:\"Caveat+Brush\";s:4:\"name\";s:12:\"Caveat Brush\";}i:127;a:2:{s:5:\"value\";s:18:\"Cedarville+Cursive\";s:4:\"name\";s:18:\"Cedarville Cursive\";}i:128;a:2:{s:5:\"value\";s:11:\"Ceviche+One\";s:4:\"name\";s:11:\"Ceviche One\";}i:129;a:2:{s:5:\"value\";s:10:\"Changa+One\";s:4:\"name\";s:10:\"Changa One\";}i:130;a:2:{s:5:\"value\";s:6:\"Chango\";s:4:\"name\";s:6:\"Chango\";}i:131;a:2:{s:5:\"value\";s:18:\"Chau+Philomene+One\";s:4:\"name\";s:18:\"Chau Philomene One\";}i:132;a:2:{s:5:\"value\";s:9:\"Chela+One\";s:4:\"name\";s:9:\"Chela One\";}i:133;a:2:{s:5:\"value\";s:14:\"Chelsea+Market\";s:4:\"name\";s:14:\"Chelsea Market\";}i:134;a:2:{s:5:\"value\";s:6:\"Chenla\";s:4:\"name\";s:6:\"Chenla\";}i:135;a:2:{s:5:\"value\";s:17:\"Cherry+Cream+Soda\";s:4:\"name\";s:17:\"Cherry Cream Soda\";}i:136;a:2:{s:5:\"value\";s:12:\"Cherry+Swash\";s:4:\"name\";s:12:\"Cherry Swash\";}i:137;a:2:{s:5:\"value\";s:5:\"Chewy\";s:4:\"name\";s:5:\"Chewy\";}i:138;a:2:{s:5:\"value\";s:6:\"Chicle\";s:4:\"name\";s:6:\"Chicle\";}i:139;a:2:{s:5:\"value\";s:5:\"Chivo\";s:4:\"name\";s:5:\"Chivo\";}i:140;a:2:{s:5:\"value\";s:8:\"Chonburi\";s:4:\"name\";s:8:\"Chonburi\";}i:141;a:2:{s:5:\"value\";s:6:\"Cinzel\";s:4:\"name\";s:6:\"Cinzel\";}i:142;a:2:{s:5:\"value\";s:17:\"Cinzel+Decorative\";s:4:\"name\";s:17:\"Cinzel Decorative\";}i:143;a:2:{s:5:\"value\";s:14:\"Clicker+Script\";s:4:\"name\";s:14:\"Clicker Script\";}i:144;a:2:{s:5:\"value\";s:4:\"Coda\";s:4:\"name\";s:4:\"Coda\";}i:145;a:2:{s:5:\"value\";s:12:\"Coda+Caption\";s:4:\"name\";s:12:\"Coda Caption\";}i:146;a:2:{s:5:\"value\";s:8:\"Codystar\";s:4:\"name\";s:8:\"Codystar\";}i:147;a:2:{s:5:\"value\";s:5:\"Combo\";s:4:\"name\";s:5:\"Combo\";}i:148;a:2:{s:5:\"value\";s:9:\"Comfortaa\";s:4:\"name\";s:9:\"Comfortaa\";}i:149;a:2:{s:5:\"value\";s:11:\"Coming+Soon\";s:4:\"name\";s:11:\"Coming Soon\";}i:150;a:2:{s:5:\"value\";s:11:\"Concert+One\";s:4:\"name\";s:11:\"Concert One\";}i:151;a:2:{s:5:\"value\";s:9:\"Condiment\";s:4:\"name\";s:9:\"Condiment\";}i:152;a:2:{s:5:\"value\";s:7:\"Content\";s:4:\"name\";s:7:\"Content\";}i:153;a:2:{s:5:\"value\";s:12:\"Contrail+One\";s:4:\"name\";s:12:\"Contrail One\";}i:154;a:2:{s:5:\"value\";s:11:\"Convergence\";s:4:\"name\";s:11:\"Convergence\";}i:155;a:2:{s:5:\"value\";s:6:\"Cookie\";s:4:\"name\";s:6:\"Cookie\";}i:156;a:2:{s:5:\"value\";s:5:\"Copse\";s:4:\"name\";s:5:\"Copse\";}i:157;a:2:{s:5:\"value\";s:6:\"Corben\";s:4:\"name\";s:6:\"Corben\";}i:158;a:2:{s:5:\"value\";s:9:\"Courgette\";s:4:\"name\";s:9:\"Courgette\";}i:159;a:2:{s:5:\"value\";s:7:\"Cousine\";s:4:\"name\";s:7:\"Cousine\";}i:160;a:2:{s:5:\"value\";s:8:\"Coustard\";s:4:\"name\";s:8:\"Coustard\";}i:161;a:2:{s:5:\"value\";s:21:\"Covered+By+Your+Grace\";s:4:\"name\";s:21:\"Covered By Your Grace\";}i:162;a:2:{s:5:\"value\";s:12:\"Crafty+Girls\";s:4:\"name\";s:12:\"Crafty Girls\";}i:163;a:2:{s:5:\"value\";s:9:\"Creepster\";s:4:\"name\";s:9:\"Creepster\";}i:164;a:2:{s:5:\"value\";s:11:\"Crete+Round\";s:4:\"name\";s:11:\"Crete Round\";}i:165;a:2:{s:5:\"value\";s:12:\"Crimson+Text\";s:4:\"name\";s:12:\"Crimson Text\";}i:166;a:2:{s:5:\"value\";s:13:\"Croissant+One\";s:4:\"name\";s:13:\"Croissant One\";}i:167;a:2:{s:5:\"value\";s:7:\"Crushed\";s:4:\"name\";s:7:\"Crushed\";}i:168;a:2:{s:5:\"value\";s:6:\"Cuprum\";s:4:\"name\";s:6:\"Cuprum\";}i:169;a:2:{s:5:\"value\";s:6:\"Cutive\";s:4:\"name\";s:6:\"Cutive\";}i:170;a:2:{s:5:\"value\";s:11:\"Cutive+Mono\";s:4:\"name\";s:11:\"Cutive Mono\";}i:171;a:2:{s:5:\"value\";s:6:\"Damion\";s:4:\"name\";s:6:\"Damion\";}i:172;a:2:{s:5:\"value\";s:14:\"Dancing+Script\";s:4:\"name\";s:14:\"Dancing Script\";}i:173;a:2:{s:5:\"value\";s:7:\"Dangrek\";s:4:\"name\";s:7:\"Dangrek\";}i:174;a:2:{s:5:\"value\";s:20:\"Dawning+of+a+New+Day\";s:4:\"name\";s:20:\"Dawning of a New Day\";}i:175;a:2:{s:5:\"value\";s:8:\"Days+One\";s:4:\"name\";s:8:\"Days One\";}i:176;a:2:{s:5:\"value\";s:5:\"Dekko\";s:4:\"name\";s:5:\"Dekko\";}i:177;a:2:{s:5:\"value\";s:6:\"Delius\";s:4:\"name\";s:6:\"Delius\";}i:178;a:2:{s:5:\"value\";s:17:\"Delius+Swash+Caps\";s:4:\"name\";s:17:\"Delius Swash Caps\";}i:179;a:2:{s:5:\"value\";s:14:\"Delius+Unicase\";s:4:\"name\";s:14:\"Delius Unicase\";}i:180;a:2:{s:5:\"value\";s:13:\"Della+Respira\";s:4:\"name\";s:13:\"Della Respira\";}i:181;a:2:{s:5:\"value\";s:8:\"Denk+One\";s:4:\"name\";s:8:\"Denk One\";}i:182;a:2:{s:5:\"value\";s:10:\"Devonshire\";s:4:\"name\";s:10:\"Devonshire\";}i:183;a:2:{s:5:\"value\";s:8:\"Dhurjati\";s:4:\"name\";s:8:\"Dhurjati\";}i:184;a:2:{s:5:\"value\";s:13:\"Didact+Gothic\";s:4:\"name\";s:13:\"Didact Gothic\";}i:185;a:2:{s:5:\"value\";s:9:\"Diplomata\";s:4:\"name\";s:9:\"Diplomata\";}i:186;a:2:{s:5:\"value\";s:12:\"Diplomata+SC\";s:4:\"name\";s:12:\"Diplomata SC\";}i:187;a:2:{s:5:\"value\";s:6:\"Domine\";s:4:\"name\";s:6:\"Domine\";}i:188;a:2:{s:5:\"value\";s:11:\"Donegal+One\";s:4:\"name\";s:11:\"Donegal One\";}i:189;a:2:{s:5:\"value\";s:10:\"Doppio+One\";s:4:\"name\";s:10:\"Doppio One\";}i:190;a:2:{s:5:\"value\";s:5:\"Dorsa\";s:4:\"name\";s:5:\"Dorsa\";}i:191;a:2:{s:5:\"value\";s:5:\"Dosis\";s:4:\"name\";s:5:\"Dosis\";}i:192;a:2:{s:5:\"value\";s:11:\"Dr+Sugiyama\";s:4:\"name\";s:11:\"Dr Sugiyama\";}i:193;a:2:{s:5:\"value\";s:10:\"Droid+Sans\";s:4:\"name\";s:10:\"Droid Sans\";}i:194;a:2:{s:5:\"value\";s:15:\"Droid+Sans+Mono\";s:4:\"name\";s:15:\"Droid Sans Mono\";}i:195;a:2:{s:5:\"value\";s:11:\"Droid+Serif\";s:4:\"name\";s:11:\"Droid Serif\";}i:196;a:2:{s:5:\"value\";s:9:\"Duru+Sans\";s:4:\"name\";s:9:\"Duru Sans\";}i:197;a:2:{s:5:\"value\";s:9:\"Dynalight\";s:4:\"name\";s:9:\"Dynalight\";}i:198;a:2:{s:5:\"value\";s:11:\"EB+Garamond\";s:4:\"name\";s:11:\"EB Garamond\";}i:199;a:2:{s:5:\"value\";s:10:\"Eagle+Lake\";s:4:\"name\";s:10:\"Eagle Lake\";}i:200;a:2:{s:5:\"value\";s:5:\"Eater\";s:4:\"name\";s:5:\"Eater\";}i:201;a:2:{s:5:\"value\";s:9:\"Economica\";s:4:\"name\";s:9:\"Economica\";}i:202;a:2:{s:5:\"value\";s:5:\"Eczar\";s:4:\"name\";s:5:\"Eczar\";}i:203;a:2:{s:5:\"value\";s:8:\"Ek+Mukta\";s:4:\"name\";s:8:\"Ek Mukta\";}i:204;a:2:{s:5:\"value\";s:11:\"Electrolize\";s:4:\"name\";s:11:\"Electrolize\";}i:205;a:2:{s:5:\"value\";s:5:\"Elsie\";s:4:\"name\";s:5:\"Elsie\";}i:206;a:2:{s:5:\"value\";s:16:\"Elsie+Swash+Caps\";s:4:\"name\";s:16:\"Elsie Swash Caps\";}i:207;a:2:{s:5:\"value\";s:11:\"Emblema+One\";s:4:\"name\";s:11:\"Emblema One\";}i:208;a:2:{s:5:\"value\";s:12:\"Emilys+Candy\";s:4:\"name\";s:12:\"Emilys Candy\";}i:209;a:2:{s:5:\"value\";s:10:\"Engagement\";s:4:\"name\";s:10:\"Engagement\";}i:210;a:2:{s:5:\"value\";s:9:\"Englebert\";s:4:\"name\";s:9:\"Englebert\";}i:211;a:2:{s:5:\"value\";s:9:\"Enriqueta\";s:4:\"name\";s:9:\"Enriqueta\";}i:212;a:2:{s:5:\"value\";s:9:\"Erica+One\";s:4:\"name\";s:9:\"Erica One\";}i:213;a:2:{s:5:\"value\";s:7:\"Esteban\";s:4:\"name\";s:7:\"Esteban\";}i:214;a:2:{s:5:\"value\";s:15:\"Euphoria+Script\";s:4:\"name\";s:15:\"Euphoria Script\";}i:215;a:2:{s:5:\"value\";s:5:\"Ewert\";s:4:\"name\";s:5:\"Ewert\";}i:216;a:2:{s:5:\"value\";s:3:\"Exo\";s:4:\"name\";s:3:\"Exo\";}i:217;a:2:{s:5:\"value\";s:5:\"Exo+2\";s:4:\"name\";s:5:\"Exo 2\";}i:218;a:2:{s:5:\"value\";s:13:\"Expletus+Sans\";s:4:\"name\";s:13:\"Expletus Sans\";}i:219;a:2:{s:5:\"value\";s:12:\"Fanwood+Text\";s:4:\"name\";s:12:\"Fanwood Text\";}i:220;a:2:{s:5:\"value\";s:9:\"Fascinate\";s:4:\"name\";s:9:\"Fascinate\";}i:221;a:2:{s:5:\"value\";s:16:\"Fascinate+Inline\";s:4:\"name\";s:16:\"Fascinate Inline\";}i:222;a:2:{s:5:\"value\";s:10:\"Faster+One\";s:4:\"name\";s:10:\"Faster One\";}i:223;a:2:{s:5:\"value\";s:8:\"Fasthand\";s:4:\"name\";s:8:\"Fasthand\";}i:224;a:2:{s:5:\"value\";s:9:\"Fauna+One\";s:4:\"name\";s:9:\"Fauna One\";}i:225;a:2:{s:5:\"value\";s:8:\"Federant\";s:4:\"name\";s:8:\"Federant\";}i:226;a:2:{s:5:\"value\";s:6:\"Federo\";s:4:\"name\";s:6:\"Federo\";}i:227;a:2:{s:5:\"value\";s:6:\"Felipa\";s:4:\"name\";s:6:\"Felipa\";}i:228;a:2:{s:5:\"value\";s:5:\"Fenix\";s:4:\"name\";s:5:\"Fenix\";}i:229;a:2:{s:5:\"value\";s:12:\"Finger+Paint\";s:4:\"name\";s:12:\"Finger Paint\";}i:230;a:2:{s:5:\"value\";s:9:\"Fira+Mono\";s:4:\"name\";s:9:\"Fira Mono\";}i:231;a:2:{s:5:\"value\";s:9:\"Fira+Sans\";s:4:\"name\";s:9:\"Fira Sans\";}i:232;a:2:{s:5:\"value\";s:10:\"Fjalla+One\";s:4:\"name\";s:10:\"Fjalla One\";}i:233;a:2:{s:5:\"value\";s:9:\"Fjord+One\";s:4:\"name\";s:9:\"Fjord One\";}i:234;a:2:{s:5:\"value\";s:8:\"Flamenco\";s:4:\"name\";s:8:\"Flamenco\";}i:235;a:2:{s:5:\"value\";s:7:\"Flavors\";s:4:\"name\";s:7:\"Flavors\";}i:236;a:2:{s:5:\"value\";s:10:\"Fondamento\";s:4:\"name\";s:10:\"Fondamento\";}i:237;a:2:{s:5:\"value\";s:16:\"Fontdiner+Swanky\";s:4:\"name\";s:16:\"Fontdiner Swanky\";}i:238;a:2:{s:5:\"value\";s:5:\"Forum\";s:4:\"name\";s:5:\"Forum\";}i:239;a:2:{s:5:\"value\";s:12:\"Francois+One\";s:4:\"name\";s:12:\"Francois One\";}i:240;a:2:{s:5:\"value\";s:12:\"Freckle+Face\";s:4:\"name\";s:12:\"Freckle Face\";}i:241;a:2:{s:5:\"value\";s:20:\"Fredericka+the+Great\";s:4:\"name\";s:20:\"Fredericka the Great\";}i:242;a:2:{s:5:\"value\";s:11:\"Fredoka+One\";s:4:\"name\";s:11:\"Fredoka One\";}i:243;a:2:{s:5:\"value\";s:8:\"Freehand\";s:4:\"name\";s:8:\"Freehand\";}i:244;a:2:{s:5:\"value\";s:6:\"Fresca\";s:4:\"name\";s:6:\"Fresca\";}i:245;a:2:{s:5:\"value\";s:7:\"Frijole\";s:4:\"name\";s:7:\"Frijole\";}i:246;a:2:{s:5:\"value\";s:7:\"Fruktur\";s:4:\"name\";s:7:\"Fruktur\";}i:247;a:2:{s:5:\"value\";s:9:\"Fugaz+One\";s:4:\"name\";s:9:\"Fugaz One\";}i:248;a:2:{s:5:\"value\";s:9:\"GFS+Didot\";s:4:\"name\";s:9:\"GFS Didot\";}i:249;a:2:{s:5:\"value\";s:15:\"GFS+Neohellenic\";s:4:\"name\";s:15:\"GFS Neohellenic\";}i:250;a:2:{s:5:\"value\";s:8:\"Gabriela\";s:4:\"name\";s:8:\"Gabriela\";}i:251;a:2:{s:5:\"value\";s:6:\"Gafata\";s:4:\"name\";s:6:\"Gafata\";}i:252;a:2:{s:5:\"value\";s:8:\"Galdeano\";s:4:\"name\";s:8:\"Galdeano\";}i:253;a:2:{s:5:\"value\";s:7:\"Galindo\";s:4:\"name\";s:7:\"Galindo\";}i:254;a:2:{s:5:\"value\";s:13:\"Gentium+Basic\";s:4:\"name\";s:13:\"Gentium Basic\";}i:255;a:2:{s:5:\"value\";s:18:\"Gentium+Book+Basic\";s:4:\"name\";s:18:\"Gentium Book Basic\";}i:256;a:2:{s:5:\"value\";s:3:\"Geo\";s:4:\"name\";s:3:\"Geo\";}i:257;a:2:{s:5:\"value\";s:7:\"Geostar\";s:4:\"name\";s:7:\"Geostar\";}i:258;a:2:{s:5:\"value\";s:12:\"Geostar+Fill\";s:4:\"name\";s:12:\"Geostar Fill\";}i:259;a:2:{s:5:\"value\";s:12:\"Germania+One\";s:4:\"name\";s:12:\"Germania One\";}i:260;a:2:{s:5:\"value\";s:6:\"Gidugu\";s:4:\"name\";s:6:\"Gidugu\";}i:261;a:2:{s:5:\"value\";s:13:\"Gilda+Display\";s:4:\"name\";s:13:\"Gilda Display\";}i:262;a:2:{s:5:\"value\";s:14:\"Give+You+Glory\";s:4:\"name\";s:14:\"Give You Glory\";}i:263;a:2:{s:5:\"value\";s:13:\"Glass+Antiqua\";s:4:\"name\";s:13:\"Glass Antiqua\";}i:264;a:2:{s:5:\"value\";s:6:\"Glegoo\";s:4:\"name\";s:6:\"Glegoo\";}i:265;a:2:{s:5:\"value\";s:17:\"Gloria+Hallelujah\";s:4:\"name\";s:17:\"Gloria Hallelujah\";}i:266;a:2:{s:5:\"value\";s:10:\"Goblin+One\";s:4:\"name\";s:10:\"Goblin One\";}i:267;a:2:{s:5:\"value\";s:10:\"Gochi+Hand\";s:4:\"name\";s:10:\"Gochi Hand\";}i:268;a:2:{s:5:\"value\";s:8:\"Gorditas\";s:4:\"name\";s:8:\"Gorditas\";}i:269;a:2:{s:5:\"value\";s:21:\"Goudy+Bookletter+1911\";s:4:\"name\";s:21:\"Goudy Bookletter 1911\";}i:270;a:2:{s:5:\"value\";s:8:\"Graduate\";s:4:\"name\";s:8:\"Graduate\";}i:271;a:2:{s:5:\"value\";s:11:\"Grand+Hotel\";s:4:\"name\";s:11:\"Grand Hotel\";}i:272;a:2:{s:5:\"value\";s:12:\"Gravitas+One\";s:4:\"name\";s:12:\"Gravitas One\";}i:273;a:2:{s:5:\"value\";s:11:\"Great+Vibes\";s:4:\"name\";s:11:\"Great Vibes\";}i:274;a:2:{s:5:\"value\";s:6:\"Griffy\";s:4:\"name\";s:6:\"Griffy\";}i:275;a:2:{s:5:\"value\";s:6:\"Gruppo\";s:4:\"name\";s:6:\"Gruppo\";}i:276;a:2:{s:5:\"value\";s:5:\"Gudea\";s:4:\"name\";s:5:\"Gudea\";}i:277;a:2:{s:5:\"value\";s:8:\"Gurajada\";s:4:\"name\";s:8:\"Gurajada\";}i:278;a:2:{s:5:\"value\";s:6:\"Habibi\";s:4:\"name\";s:6:\"Habibi\";}i:279;a:2:{s:5:\"value\";s:6:\"Halant\";s:4:\"name\";s:6:\"Halant\";}i:280;a:2:{s:5:\"value\";s:15:\"Hammersmith+One\";s:4:\"name\";s:15:\"Hammersmith One\";}i:281;a:2:{s:5:\"value\";s:7:\"Hanalei\";s:4:\"name\";s:7:\"Hanalei\";}i:282;a:2:{s:5:\"value\";s:12:\"Hanalei+Fill\";s:4:\"name\";s:12:\"Hanalei Fill\";}i:283;a:2:{s:5:\"value\";s:7:\"Handlee\";s:4:\"name\";s:7:\"Handlee\";}i:284;a:2:{s:5:\"value\";s:7:\"Hanuman\";s:4:\"name\";s:7:\"Hanuman\";}i:285;a:2:{s:5:\"value\";s:12:\"Happy+Monkey\";s:4:\"name\";s:12:\"Happy Monkey\";}i:286;a:2:{s:5:\"value\";s:12:\"Headland+One\";s:4:\"name\";s:12:\"Headland One\";}i:287;a:2:{s:5:\"value\";s:11:\"Henny+Penny\";s:4:\"name\";s:11:\"Henny Penny\";}i:288;a:2:{s:5:\"value\";s:20:\"Herr+Von+Muellerhoff\";s:4:\"name\";s:20:\"Herr Von Muellerhoff\";}i:289;a:2:{s:5:\"value\";s:4:\"Hind\";s:4:\"name\";s:4:\"Hind\";}i:290;a:2:{s:5:\"value\";s:13:\"Hind+Siliguri\";s:4:\"name\";s:13:\"Hind Siliguri\";}i:291;a:2:{s:5:\"value\";s:13:\"Hind+Vadodara\";s:4:\"name\";s:13:\"Hind Vadodara\";}i:292;a:2:{s:5:\"value\";s:15:\"Holtwood+One+SC\";s:4:\"name\";s:15:\"Holtwood One SC\";}i:293;a:2:{s:5:\"value\";s:14:\"Homemade+Apple\";s:4:\"name\";s:14:\"Homemade Apple\";}i:294;a:2:{s:5:\"value\";s:8:\"Homenaje\";s:4:\"name\";s:8:\"Homenaje\";}i:295;a:2:{s:5:\"value\";s:15:\"IM+Fell+DW+Pica\";s:4:\"name\";s:15:\"IM Fell DW Pica\";}i:296;a:2:{s:5:\"value\";s:18:\"IM+Fell+DW+Pica+SC\";s:4:\"name\";s:18:\"IM Fell DW Pica SC\";}i:297;a:2:{s:5:\"value\";s:19:\"IM+Fell+Double+Pica\";s:4:\"name\";s:19:\"IM Fell Double Pica\";}i:298;a:2:{s:5:\"value\";s:22:\"IM+Fell+Double+Pica+SC\";s:4:\"name\";s:22:\"IM Fell Double Pica SC\";}i:299;a:2:{s:5:\"value\";s:15:\"IM+Fell+English\";s:4:\"name\";s:15:\"IM Fell English\";}i:300;a:2:{s:5:\"value\";s:18:\"IM+Fell+English+SC\";s:4:\"name\";s:18:\"IM Fell English SC\";}i:301;a:2:{s:5:\"value\";s:20:\"IM+Fell+French+Canon\";s:4:\"name\";s:20:\"IM Fell French Canon\";}i:302;a:2:{s:5:\"value\";s:23:\"IM+Fell+French+Canon+SC\";s:4:\"name\";s:23:\"IM Fell French Canon SC\";}i:303;a:2:{s:5:\"value\";s:20:\"IM+Fell+Great+Primer\";s:4:\"name\";s:20:\"IM Fell Great Primer\";}i:304;a:2:{s:5:\"value\";s:23:\"IM+Fell+Great+Primer+SC\";s:4:\"name\";s:23:\"IM Fell Great Primer SC\";}i:305;a:2:{s:5:\"value\";s:7:\"Iceberg\";s:4:\"name\";s:7:\"Iceberg\";}i:306;a:2:{s:5:\"value\";s:7:\"Iceland\";s:4:\"name\";s:7:\"Iceland\";}i:307;a:2:{s:5:\"value\";s:7:\"Imprima\";s:4:\"name\";s:7:\"Imprima\";}i:308;a:2:{s:5:\"value\";s:11:\"Inconsolata\";s:4:\"name\";s:11:\"Inconsolata\";}i:309;a:2:{s:5:\"value\";s:5:\"Inder\";s:4:\"name\";s:5:\"Inder\";}i:310;a:2:{s:5:\"value\";s:12:\"Indie+Flower\";s:4:\"name\";s:12:\"Indie Flower\";}i:311;a:2:{s:5:\"value\";s:5:\"Inika\";s:4:\"name\";s:5:\"Inika\";}i:312;a:2:{s:5:\"value\";s:14:\"Inknut+Antiqua\";s:4:\"name\";s:14:\"Inknut Antiqua\";}i:313;a:2:{s:5:\"value\";s:12:\"Irish+Grover\";s:4:\"name\";s:12:\"Irish Grover\";}i:314;a:2:{s:5:\"value\";s:9:\"Istok+Web\";s:4:\"name\";s:9:\"Istok Web\";}i:315;a:2:{s:5:\"value\";s:8:\"Italiana\";s:4:\"name\";s:8:\"Italiana\";}i:316;a:2:{s:5:\"value\";s:9:\"Italianno\";s:4:\"name\";s:9:\"Italianno\";}i:317;a:2:{s:5:\"value\";s:4:\"Itim\";s:4:\"name\";s:4:\"Itim\";}i:318;a:2:{s:5:\"value\";s:16:\"Jacques+Francois\";s:4:\"name\";s:16:\"Jacques Francois\";}i:319;a:2:{s:5:\"value\";s:23:\"Jacques+Francois+Shadow\";s:4:\"name\";s:23:\"Jacques Francois Shadow\";}i:320;a:2:{s:5:\"value\";s:5:\"Jaldi\";s:4:\"name\";s:5:\"Jaldi\";}i:321;a:2:{s:5:\"value\";s:14:\"Jim+Nightshade\";s:4:\"name\";s:14:\"Jim Nightshade\";}i:322;a:2:{s:5:\"value\";s:10:\"Jockey+One\";s:4:\"name\";s:10:\"Jockey One\";}i:323;a:2:{s:5:\"value\";s:12:\"Jolly+Lodger\";s:4:\"name\";s:12:\"Jolly Lodger\";}i:324;a:2:{s:5:\"value\";s:12:\"Josefin+Sans\";s:4:\"name\";s:12:\"Josefin Sans\";}i:325;a:2:{s:5:\"value\";s:12:\"Josefin+Slab\";s:4:\"name\";s:12:\"Josefin Slab\";}i:326;a:2:{s:5:\"value\";s:8:\"Joti+One\";s:4:\"name\";s:8:\"Joti One\";}i:327;a:2:{s:5:\"value\";s:6:\"Judson\";s:4:\"name\";s:6:\"Judson\";}i:328;a:2:{s:5:\"value\";s:5:\"Julee\";s:4:\"name\";s:5:\"Julee\";}i:329;a:2:{s:5:\"value\";s:15:\"Julius+Sans+One\";s:4:\"name\";s:15:\"Julius Sans One\";}i:330;a:2:{s:5:\"value\";s:5:\"Junge\";s:4:\"name\";s:5:\"Junge\";}i:331;a:2:{s:5:\"value\";s:4:\"Jura\";s:4:\"name\";s:4:\"Jura\";}i:332;a:2:{s:5:\"value\";s:17:\"Just+Another+Hand\";s:4:\"name\";s:17:\"Just Another Hand\";}i:333;a:2:{s:5:\"value\";s:23:\"Just+Me+Again+Down+Here\";s:4:\"name\";s:23:\"Just Me Again Down Here\";}i:334;a:2:{s:5:\"value\";s:5:\"Kadwa\";s:4:\"name\";s:5:\"Kadwa\";}i:335;a:2:{s:5:\"value\";s:5:\"Kalam\";s:4:\"name\";s:5:\"Kalam\";}i:336;a:2:{s:5:\"value\";s:7:\"Kameron\";s:4:\"name\";s:7:\"Kameron\";}i:337;a:2:{s:5:\"value\";s:9:\"Kantumruy\";s:4:\"name\";s:9:\"Kantumruy\";}i:338;a:2:{s:5:\"value\";s:5:\"Karla\";s:4:\"name\";s:5:\"Karla\";}i:339;a:2:{s:5:\"value\";s:5:\"Karma\";s:4:\"name\";s:5:\"Karma\";}i:340;a:2:{s:5:\"value\";s:14:\"Kaushan+Script\";s:4:\"name\";s:14:\"Kaushan Script\";}i:341;a:2:{s:5:\"value\";s:6:\"Kavoon\";s:4:\"name\";s:6:\"Kavoon\";}i:342;a:2:{s:5:\"value\";s:10:\"Kdam+Thmor\";s:4:\"name\";s:10:\"Kdam Thmor\";}i:343;a:2:{s:5:\"value\";s:10:\"Keania+One\";s:4:\"name\";s:10:\"Keania One\";}i:344;a:2:{s:5:\"value\";s:10:\"Kelly+Slab\";s:4:\"name\";s:10:\"Kelly Slab\";}i:345;a:2:{s:5:\"value\";s:5:\"Kenia\";s:4:\"name\";s:5:\"Kenia\";}i:346;a:2:{s:5:\"value\";s:5:\"Khand\";s:4:\"name\";s:5:\"Khand\";}i:347;a:2:{s:5:\"value\";s:5:\"Khmer\";s:4:\"name\";s:5:\"Khmer\";}i:348;a:2:{s:5:\"value\";s:5:\"Khula\";s:4:\"name\";s:5:\"Khula\";}i:349;a:2:{s:5:\"value\";s:8:\"Kite+One\";s:4:\"name\";s:8:\"Kite One\";}i:350;a:2:{s:5:\"value\";s:7:\"Knewave\";s:4:\"name\";s:7:\"Knewave\";}i:351;a:2:{s:5:\"value\";s:9:\"Kotta+One\";s:4:\"name\";s:9:\"Kotta One\";}i:352;a:2:{s:5:\"value\";s:6:\"Koulen\";s:4:\"name\";s:6:\"Koulen\";}i:353;a:2:{s:5:\"value\";s:6:\"Kranky\";s:4:\"name\";s:6:\"Kranky\";}i:354;a:2:{s:5:\"value\";s:5:\"Kreon\";s:4:\"name\";s:5:\"Kreon\";}i:355;a:2:{s:5:\"value\";s:6:\"Kristi\";s:4:\"name\";s:6:\"Kristi\";}i:356;a:2:{s:5:\"value\";s:9:\"Krona+One\";s:4:\"name\";s:9:\"Krona One\";}i:357;a:2:{s:5:\"value\";s:6:\"Kurale\";s:4:\"name\";s:6:\"Kurale\";}i:358;a:2:{s:5:\"value\";s:15:\"La+Belle+Aurore\";s:4:\"name\";s:15:\"La Belle Aurore\";}i:359;a:2:{s:5:\"value\";s:5:\"Laila\";s:4:\"name\";s:5:\"Laila\";}i:360;a:2:{s:5:\"value\";s:11:\"Lakki+Reddy\";s:4:\"name\";s:11:\"Lakki Reddy\";}i:361;a:2:{s:5:\"value\";s:8:\"Lancelot\";s:4:\"name\";s:8:\"Lancelot\";}i:362;a:2:{s:5:\"value\";s:6:\"Lateef\";s:4:\"name\";s:6:\"Lateef\";}i:363;a:2:{s:5:\"value\";s:4:\"Lato\";s:4:\"name\";s:4:\"Lato\";}i:364;a:2:{s:5:\"value\";s:13:\"League+Script\";s:4:\"name\";s:13:\"League Script\";}i:365;a:2:{s:5:\"value\";s:12:\"Leckerli+One\";s:4:\"name\";s:12:\"Leckerli One\";}i:366;a:2:{s:5:\"value\";s:6:\"Ledger\";s:4:\"name\";s:6:\"Ledger\";}i:367;a:2:{s:5:\"value\";s:6:\"Lekton\";s:4:\"name\";s:6:\"Lekton\";}i:368;a:2:{s:5:\"value\";s:5:\"Lemon\";s:4:\"name\";s:5:\"Lemon\";}i:369;a:2:{s:5:\"value\";s:17:\"Libre+Baskerville\";s:4:\"name\";s:17:\"Libre Baskerville\";}i:370;a:2:{s:5:\"value\";s:11:\"Life+Savers\";s:4:\"name\";s:11:\"Life Savers\";}i:371;a:2:{s:5:\"value\";s:10:\"Lilita+One\";s:4:\"name\";s:10:\"Lilita One\";}i:372;a:2:{s:5:\"value\";s:15:\"Lily+Script+One\";s:4:\"name\";s:15:\"Lily Script One\";}i:373;a:2:{s:5:\"value\";s:9:\"Limelight\";s:4:\"name\";s:9:\"Limelight\";}i:374;a:2:{s:5:\"value\";s:11:\"Linden+Hill\";s:4:\"name\";s:11:\"Linden Hill\";}i:375;a:2:{s:5:\"value\";s:7:\"Lobster\";s:4:\"name\";s:7:\"Lobster\";}i:376;a:2:{s:5:\"value\";s:11:\"Lobster+Two\";s:4:\"name\";s:11:\"Lobster Two\";}i:377;a:2:{s:5:\"value\";s:16:\"Londrina+Outline\";s:4:\"name\";s:16:\"Londrina Outline\";}i:378;a:2:{s:5:\"value\";s:15:\"Londrina+Shadow\";s:4:\"name\";s:15:\"Londrina Shadow\";}i:379;a:2:{s:5:\"value\";s:15:\"Londrina+Sketch\";s:4:\"name\";s:15:\"Londrina Sketch\";}i:380;a:2:{s:5:\"value\";s:14:\"Londrina+Solid\";s:4:\"name\";s:14:\"Londrina Solid\";}i:381;a:2:{s:5:\"value\";s:4:\"Lora\";s:4:\"name\";s:4:\"Lora\";}i:382;a:2:{s:5:\"value\";s:21:\"Love+Ya+Like+A+Sister\";s:4:\"name\";s:21:\"Love Ya Like A Sister\";}i:383;a:2:{s:5:\"value\";s:17:\"Loved+by+the+King\";s:4:\"name\";s:17:\"Loved by the King\";}i:384;a:2:{s:5:\"value\";s:14:\"Lovers+Quarrel\";s:4:\"name\";s:14:\"Lovers Quarrel\";}i:385;a:2:{s:5:\"value\";s:12:\"Luckiest+Guy\";s:4:\"name\";s:12:\"Luckiest Guy\";}i:386;a:2:{s:5:\"value\";s:8:\"Lusitana\";s:4:\"name\";s:8:\"Lusitana\";}i:387;a:2:{s:5:\"value\";s:7:\"Lustria\";s:4:\"name\";s:7:\"Lustria\";}i:388;a:2:{s:5:\"value\";s:7:\"Macondo\";s:4:\"name\";s:7:\"Macondo\";}i:389;a:2:{s:5:\"value\";s:18:\"Macondo+Swash+Caps\";s:4:\"name\";s:18:\"Macondo Swash Caps\";}i:390;a:2:{s:5:\"value\";s:5:\"Magra\";s:4:\"name\";s:5:\"Magra\";}i:391;a:2:{s:5:\"value\";s:13:\"Maiden+Orange\";s:4:\"name\";s:13:\"Maiden Orange\";}i:392;a:2:{s:5:\"value\";s:4:\"Mako\";s:4:\"name\";s:4:\"Mako\";}i:393;a:2:{s:5:\"value\";s:8:\"Mallanna\";s:4:\"name\";s:8:\"Mallanna\";}i:394;a:2:{s:5:\"value\";s:7:\"Mandali\";s:4:\"name\";s:7:\"Mandali\";}i:395;a:2:{s:5:\"value\";s:9:\"Marcellus\";s:4:\"name\";s:9:\"Marcellus\";}i:396;a:2:{s:5:\"value\";s:12:\"Marcellus+SC\";s:4:\"name\";s:12:\"Marcellus SC\";}i:397;a:2:{s:5:\"value\";s:12:\"Marck+Script\";s:4:\"name\";s:12:\"Marck Script\";}i:398;a:2:{s:5:\"value\";s:9:\"Margarine\";s:4:\"name\";s:9:\"Margarine\";}i:399;a:2:{s:5:\"value\";s:9:\"Marko+One\";s:4:\"name\";s:9:\"Marko One\";}i:400;a:2:{s:5:\"value\";s:8:\"Marmelad\";s:4:\"name\";s:8:\"Marmelad\";}i:401;a:2:{s:5:\"value\";s:6:\"Martel\";s:4:\"name\";s:6:\"Martel\";}i:402;a:2:{s:5:\"value\";s:11:\"Martel+Sans\";s:4:\"name\";s:11:\"Martel Sans\";}i:403;a:2:{s:5:\"value\";s:6:\"Marvel\";s:4:\"name\";s:6:\"Marvel\";}i:404;a:2:{s:5:\"value\";s:4:\"Mate\";s:4:\"name\";s:4:\"Mate\";}i:405;a:2:{s:5:\"value\";s:7:\"Mate+SC\";s:4:\"name\";s:7:\"Mate SC\";}i:406;a:2:{s:5:\"value\";s:9:\"Maven+Pro\";s:4:\"name\";s:9:\"Maven Pro\";}i:407;a:2:{s:5:\"value\";s:7:\"McLaren\";s:4:\"name\";s:7:\"McLaren\";}i:408;a:2:{s:5:\"value\";s:6:\"Meddon\";s:4:\"name\";s:6:\"Meddon\";}i:409;a:2:{s:5:\"value\";s:13:\"MedievalSharp\";s:4:\"name\";s:13:\"MedievalSharp\";}i:410;a:2:{s:5:\"value\";s:10:\"Medula+One\";s:4:\"name\";s:10:\"Medula One\";}i:411;a:2:{s:5:\"value\";s:6:\"Megrim\";s:4:\"name\";s:6:\"Megrim\";}i:412;a:2:{s:5:\"value\";s:11:\"Meie+Script\";s:4:\"name\";s:11:\"Meie Script\";}i:413;a:2:{s:5:\"value\";s:8:\"Merienda\";s:4:\"name\";s:8:\"Merienda\";}i:414;a:2:{s:5:\"value\";s:12:\"Merienda+One\";s:4:\"name\";s:12:\"Merienda One\";}i:415;a:2:{s:5:\"value\";s:12:\"Merriweather\";s:4:\"name\";s:12:\"Merriweather\";}i:416;a:2:{s:5:\"value\";s:17:\"Merriweather+Sans\";s:4:\"name\";s:17:\"Merriweather Sans\";}i:417;a:2:{s:5:\"value\";s:5:\"Metal\";s:4:\"name\";s:5:\"Metal\";}i:418;a:2:{s:5:\"value\";s:11:\"Metal+Mania\";s:4:\"name\";s:11:\"Metal Mania\";}i:419;a:2:{s:5:\"value\";s:12:\"Metamorphous\";s:4:\"name\";s:12:\"Metamorphous\";}i:420;a:2:{s:5:\"value\";s:11:\"Metrophobic\";s:4:\"name\";s:11:\"Metrophobic\";}i:421;a:2:{s:5:\"value\";s:8:\"Michroma\";s:4:\"name\";s:8:\"Michroma\";}i:422;a:2:{s:5:\"value\";s:7:\"Milonga\";s:4:\"name\";s:7:\"Milonga\";}i:423;a:2:{s:5:\"value\";s:9:\"Miltonian\";s:4:\"name\";s:9:\"Miltonian\";}i:424;a:2:{s:5:\"value\";s:16:\"Miltonian+Tattoo\";s:4:\"name\";s:16:\"Miltonian Tattoo\";}i:425;a:2:{s:5:\"value\";s:7:\"Miniver\";s:4:\"name\";s:7:\"Miniver\";}i:426;a:2:{s:5:\"value\";s:14:\"Miss+Fajardose\";s:4:\"name\";s:14:\"Miss Fajardose\";}i:427;a:2:{s:5:\"value\";s:5:\"Modak\";s:4:\"name\";s:5:\"Modak\";}i:428;a:2:{s:5:\"value\";s:14:\"Modern+Antiqua\";s:4:\"name\";s:14:\"Modern Antiqua\";}i:429;a:2:{s:5:\"value\";s:7:\"Molengo\";s:4:\"name\";s:7:\"Molengo\";}i:430;a:2:{s:5:\"value\";s:5:\"Molle\";s:4:\"name\";s:5:\"Molle\";}i:431;a:2:{s:5:\"value\";s:5:\"Monda\";s:4:\"name\";s:5:\"Monda\";}i:432;a:2:{s:5:\"value\";s:8:\"Monofett\";s:4:\"name\";s:8:\"Monofett\";}i:433;a:2:{s:5:\"value\";s:7:\"Monoton\";s:4:\"name\";s:7:\"Monoton\";}i:434;a:2:{s:5:\"value\";s:20:\"Monsieur+La+Doulaise\";s:4:\"name\";s:20:\"Monsieur La Doulaise\";}i:435;a:2:{s:5:\"value\";s:7:\"Montaga\";s:4:\"name\";s:7:\"Montaga\";}i:436;a:2:{s:5:\"value\";s:6:\"Montez\";s:4:\"name\";s:6:\"Montez\";}i:437;a:2:{s:5:\"value\";s:10:\"Montserrat\";s:4:\"name\";s:10:\"Montserrat\";}i:438;a:2:{s:5:\"value\";s:21:\"Montserrat+Alternates\";s:4:\"name\";s:21:\"Montserrat Alternates\";}i:439;a:2:{s:5:\"value\";s:20:\"Montserrat+Subrayada\";s:4:\"name\";s:20:\"Montserrat Subrayada\";}i:440;a:2:{s:5:\"value\";s:4:\"Moul\";s:4:\"name\";s:4:\"Moul\";}i:441;a:2:{s:5:\"value\";s:8:\"Moulpali\";s:4:\"name\";s:8:\"Moulpali\";}i:442;a:2:{s:5:\"value\";s:22:\"Mountains+of+Christmas\";s:4:\"name\";s:22:\"Mountains of Christmas\";}i:443;a:2:{s:5:\"value\";s:13:\"Mouse+Memoirs\";s:4:\"name\";s:13:\"Mouse Memoirs\";}i:444;a:2:{s:5:\"value\";s:10:\"Mr+Bedfort\";s:4:\"name\";s:10:\"Mr Bedfort\";}i:445;a:2:{s:5:\"value\";s:8:\"Mr+Dafoe\";s:4:\"name\";s:8:\"Mr Dafoe\";}i:446;a:2:{s:5:\"value\";s:14:\"Mr+De+Haviland\";s:4:\"name\";s:14:\"Mr De Haviland\";}i:447;a:2:{s:5:\"value\";s:19:\"Mrs+Saint+Delafield\";s:4:\"name\";s:19:\"Mrs Saint Delafield\";}i:448;a:2:{s:5:\"value\";s:13:\"Mrs+Sheppards\";s:4:\"name\";s:13:\"Mrs Sheppards\";}i:449;a:2:{s:5:\"value\";s:4:\"Muli\";s:4:\"name\";s:4:\"Muli\";}i:450;a:2:{s:5:\"value\";s:13:\"Mystery+Quest\";s:4:\"name\";s:13:\"Mystery Quest\";}i:451;a:2:{s:5:\"value\";s:3:\"NTR\";s:4:\"name\";s:3:\"NTR\";}i:452;a:2:{s:5:\"value\";s:6:\"Neucha\";s:4:\"name\";s:6:\"Neucha\";}i:453;a:2:{s:5:\"value\";s:6:\"Neuton\";s:4:\"name\";s:6:\"Neuton\";}i:454;a:2:{s:5:\"value\";s:10:\"New+Rocker\";s:4:\"name\";s:10:\"New Rocker\";}i:455;a:2:{s:5:\"value\";s:10:\"News+Cycle\";s:4:\"name\";s:10:\"News Cycle\";}i:456;a:2:{s:5:\"value\";s:7:\"Niconne\";s:4:\"name\";s:7:\"Niconne\";}i:457;a:2:{s:5:\"value\";s:9:\"Nixie+One\";s:4:\"name\";s:9:\"Nixie One\";}i:458;a:2:{s:5:\"value\";s:6:\"Nobile\";s:4:\"name\";s:6:\"Nobile\";}i:459;a:2:{s:5:\"value\";s:6:\"Nokora\";s:4:\"name\";s:6:\"Nokora\";}i:460;a:2:{s:5:\"value\";s:7:\"Norican\";s:4:\"name\";s:7:\"Norican\";}i:461;a:2:{s:5:\"value\";s:7:\"Nosifer\";s:4:\"name\";s:7:\"Nosifer\";}i:462;a:2:{s:5:\"value\";s:20:\"Nothing+You+Could+Do\";s:4:\"name\";s:20:\"Nothing You Could Do\";}i:463;a:2:{s:5:\"value\";s:12:\"Noticia+Text\";s:4:\"name\";s:12:\"Noticia Text\";}i:464;a:2:{s:5:\"value\";s:9:\"Noto+Sans\";s:4:\"name\";s:9:\"Noto Sans\";}i:465;a:2:{s:5:\"value\";s:10:\"Noto+Serif\";s:4:\"name\";s:10:\"Noto Serif\";}i:466;a:2:{s:5:\"value\";s:8:\"Nova+Cut\";s:4:\"name\";s:8:\"Nova Cut\";}i:467;a:2:{s:5:\"value\";s:9:\"Nova+Flat\";s:4:\"name\";s:9:\"Nova Flat\";}i:468;a:2:{s:5:\"value\";s:9:\"Nova+Mono\";s:4:\"name\";s:9:\"Nova Mono\";}i:469;a:2:{s:5:\"value\";s:9:\"Nova+Oval\";s:4:\"name\";s:9:\"Nova Oval\";}i:470;a:2:{s:5:\"value\";s:10:\"Nova+Round\";s:4:\"name\";s:10:\"Nova Round\";}i:471;a:2:{s:5:\"value\";s:11:\"Nova+Script\";s:4:\"name\";s:11:\"Nova Script\";}i:472;a:2:{s:5:\"value\";s:9:\"Nova+Slim\";s:4:\"name\";s:9:\"Nova Slim\";}i:473;a:2:{s:5:\"value\";s:11:\"Nova+Square\";s:4:\"name\";s:11:\"Nova Square\";}i:474;a:2:{s:5:\"value\";s:6:\"Numans\";s:4:\"name\";s:6:\"Numans\";}i:475;a:2:{s:5:\"value\";s:6:\"Nunito\";s:4:\"name\";s:6:\"Nunito\";}i:476;a:2:{s:5:\"value\";s:14:\"Odor+Mean+Chey\";s:4:\"name\";s:14:\"Odor Mean Chey\";}i:477;a:2:{s:5:\"value\";s:7:\"Offside\";s:4:\"name\";s:7:\"Offside\";}i:478;a:2:{s:5:\"value\";s:15:\"Old+Standard+TT\";s:4:\"name\";s:15:\"Old Standard TT\";}i:479;a:2:{s:5:\"value\";s:9:\"Oldenburg\";s:4:\"name\";s:9:\"Oldenburg\";}i:480;a:2:{s:5:\"value\";s:11:\"Oleo+Script\";s:4:\"name\";s:11:\"Oleo Script\";}i:481;a:2:{s:5:\"value\";s:22:\"Oleo+Script+Swash+Caps\";s:4:\"name\";s:22:\"Oleo Script Swash Caps\";}i:482;a:2:{s:5:\"value\";s:9:\"Open+Sans\";s:4:\"name\";s:9:\"Open Sans\";}i:483;a:2:{s:5:\"value\";s:19:\"Open+Sans+Condensed\";s:4:\"name\";s:19:\"Open Sans Condensed\";}i:484;a:2:{s:5:\"value\";s:11:\"Oranienbaum\";s:4:\"name\";s:11:\"Oranienbaum\";}i:485;a:2:{s:5:\"value\";s:8:\"Orbitron\";s:4:\"name\";s:8:\"Orbitron\";}i:486;a:2:{s:5:\"value\";s:7:\"Oregano\";s:4:\"name\";s:7:\"Oregano\";}i:487;a:2:{s:5:\"value\";s:7:\"Orienta\";s:4:\"name\";s:7:\"Orienta\";}i:488;a:2:{s:5:\"value\";s:15:\"Original+Surfer\";s:4:\"name\";s:15:\"Original Surfer\";}i:489;a:2:{s:5:\"value\";s:6:\"Oswald\";s:4:\"name\";s:6:\"Oswald\";}i:490;a:2:{s:5:\"value\";s:16:\"Over+the+Rainbow\";s:4:\"name\";s:16:\"Over the Rainbow\";}i:491;a:2:{s:5:\"value\";s:8:\"Overlock\";s:4:\"name\";s:8:\"Overlock\";}i:492;a:2:{s:5:\"value\";s:11:\"Overlock+SC\";s:4:\"name\";s:11:\"Overlock SC\";}i:493;a:2:{s:5:\"value\";s:3:\"Ovo\";s:4:\"name\";s:3:\"Ovo\";}i:494;a:2:{s:5:\"value\";s:6:\"Oxygen\";s:4:\"name\";s:6:\"Oxygen\";}i:495;a:2:{s:5:\"value\";s:11:\"Oxygen+Mono\";s:4:\"name\";s:11:\"Oxygen Mono\";}i:496;a:2:{s:5:\"value\";s:7:\"PT+Mono\";s:4:\"name\";s:7:\"PT Mono\";}i:497;a:2:{s:5:\"value\";s:7:\"PT+Sans\";s:4:\"name\";s:7:\"PT Sans\";}i:498;a:2:{s:5:\"value\";s:15:\"PT+Sans+Caption\";s:4:\"name\";s:15:\"PT Sans Caption\";}i:499;a:2:{s:5:\"value\";s:14:\"PT+Sans+Narrow\";s:4:\"name\";s:14:\"PT Sans Narrow\";}i:500;a:2:{s:5:\"value\";s:8:\"PT+Serif\";s:4:\"name\";s:8:\"PT Serif\";}i:501;a:2:{s:5:\"value\";s:16:\"PT+Serif+Caption\";s:4:\"name\";s:16:\"PT Serif Caption\";}i:502;a:2:{s:5:\"value\";s:8:\"Pacifico\";s:4:\"name\";s:8:\"Pacifico\";}i:503;a:2:{s:5:\"value\";s:9:\"Palanquin\";s:4:\"name\";s:9:\"Palanquin\";}i:504;a:2:{s:5:\"value\";s:14:\"Palanquin+Dark\";s:4:\"name\";s:14:\"Palanquin Dark\";}i:505;a:2:{s:5:\"value\";s:7:\"Paprika\";s:4:\"name\";s:7:\"Paprika\";}i:506;a:2:{s:5:\"value\";s:10:\"Parisienne\";s:4:\"name\";s:10:\"Parisienne\";}i:507;a:2:{s:5:\"value\";s:11:\"Passero+One\";s:4:\"name\";s:11:\"Passero One\";}i:508;a:2:{s:5:\"value\";s:11:\"Passion+One\";s:4:\"name\";s:11:\"Passion One\";}i:509;a:2:{s:5:\"value\";s:18:\"Pathway+Gothic+One\";s:4:\"name\";s:18:\"Pathway Gothic One\";}i:510;a:2:{s:5:\"value\";s:12:\"Patrick+Hand\";s:4:\"name\";s:12:\"Patrick Hand\";}i:511;a:2:{s:5:\"value\";s:15:\"Patrick+Hand+SC\";s:4:\"name\";s:15:\"Patrick Hand SC\";}i:512;a:2:{s:5:\"value\";s:9:\"Patua+One\";s:4:\"name\";s:9:\"Patua One\";}i:513;a:2:{s:5:\"value\";s:11:\"Paytone+One\";s:4:\"name\";s:11:\"Paytone One\";}i:514;a:2:{s:5:\"value\";s:7:\"Peddana\";s:4:\"name\";s:7:\"Peddana\";}i:515;a:2:{s:5:\"value\";s:7:\"Peralta\";s:4:\"name\";s:7:\"Peralta\";}i:516;a:2:{s:5:\"value\";s:16:\"Permanent+Marker\";s:4:\"name\";s:16:\"Permanent Marker\";}i:517;a:2:{s:5:\"value\";s:19:\"Petit+Formal+Script\";s:4:\"name\";s:19:\"Petit Formal Script\";}i:518;a:2:{s:5:\"value\";s:7:\"Petrona\";s:4:\"name\";s:7:\"Petrona\";}i:519;a:2:{s:5:\"value\";s:11:\"Philosopher\";s:4:\"name\";s:11:\"Philosopher\";}i:520;a:2:{s:5:\"value\";s:6:\"Piedra\";s:4:\"name\";s:6:\"Piedra\";}i:521;a:2:{s:5:\"value\";s:13:\"Pinyon+Script\";s:4:\"name\";s:13:\"Pinyon Script\";}i:522;a:2:{s:5:\"value\";s:10:\"Pirata+One\";s:4:\"name\";s:10:\"Pirata One\";}i:523;a:2:{s:5:\"value\";s:7:\"Plaster\";s:4:\"name\";s:7:\"Plaster\";}i:524;a:2:{s:5:\"value\";s:4:\"Play\";s:4:\"name\";s:4:\"Play\";}i:525;a:2:{s:5:\"value\";s:8:\"Playball\";s:4:\"name\";s:8:\"Playball\";}i:526;a:2:{s:5:\"value\";s:16:\"Playfair+Display\";s:4:\"name\";s:16:\"Playfair Display\";}i:527;a:2:{s:5:\"value\";s:19:\"Playfair+Display+SC\";s:4:\"name\";s:19:\"Playfair Display SC\";}i:528;a:2:{s:5:\"value\";s:7:\"Podkova\";s:4:\"name\";s:7:\"Podkova\";}i:529;a:2:{s:5:\"value\";s:10:\"Poiret+One\";s:4:\"name\";s:10:\"Poiret One\";}i:530;a:2:{s:5:\"value\";s:10:\"Poller+One\";s:4:\"name\";s:10:\"Poller One\";}i:531;a:2:{s:5:\"value\";s:4:\"Poly\";s:4:\"name\";s:4:\"Poly\";}i:532;a:2:{s:5:\"value\";s:8:\"Pompiere\";s:4:\"name\";s:8:\"Pompiere\";}i:533;a:2:{s:5:\"value\";s:12:\"Pontano+Sans\";s:4:\"name\";s:12:\"Pontano Sans\";}i:534;a:2:{s:5:\"value\";s:7:\"Poppins\";s:4:\"name\";s:7:\"Poppins\";}i:535;a:2:{s:5:\"value\";s:16:\"Port+Lligat+Sans\";s:4:\"name\";s:16:\"Port Lligat Sans\";}i:536;a:2:{s:5:\"value\";s:16:\"Port+Lligat+Slab\";s:4:\"name\";s:16:\"Port Lligat Slab\";}i:537;a:2:{s:5:\"value\";s:14:\"Pragati+Narrow\";s:4:\"name\";s:14:\"Pragati Narrow\";}i:538;a:2:{s:5:\"value\";s:5:\"Prata\";s:4:\"name\";s:5:\"Prata\";}i:539;a:2:{s:5:\"value\";s:11:\"Preahvihear\";s:4:\"name\";s:11:\"Preahvihear\";}i:540;a:2:{s:5:\"value\";s:14:\"Press+Start+2P\";s:4:\"name\";s:14:\"Press Start 2P\";}i:541;a:2:{s:5:\"value\";s:14:\"Princess+Sofia\";s:4:\"name\";s:14:\"Princess Sofia\";}i:542;a:2:{s:5:\"value\";s:8:\"Prociono\";s:4:\"name\";s:8:\"Prociono\";}i:543;a:2:{s:5:\"value\";s:10:\"Prosto+One\";s:4:\"name\";s:10:\"Prosto One\";}i:544;a:2:{s:5:\"value\";s:7:\"Puritan\";s:4:\"name\";s:7:\"Puritan\";}i:545;a:2:{s:5:\"value\";s:12:\"Purple+Purse\";s:4:\"name\";s:12:\"Purple Purse\";}i:546;a:2:{s:5:\"value\";s:6:\"Quando\";s:4:\"name\";s:6:\"Quando\";}i:547;a:2:{s:5:\"value\";s:8:\"Quantico\";s:4:\"name\";s:8:\"Quantico\";}i:548;a:2:{s:5:\"value\";s:12:\"Quattrocento\";s:4:\"name\";s:12:\"Quattrocento\";}i:549;a:2:{s:5:\"value\";s:17:\"Quattrocento+Sans\";s:4:\"name\";s:17:\"Quattrocento Sans\";}i:550;a:2:{s:5:\"value\";s:9:\"Questrial\";s:4:\"name\";s:9:\"Questrial\";}i:551;a:2:{s:5:\"value\";s:9:\"Quicksand\";s:4:\"name\";s:9:\"Quicksand\";}i:552;a:2:{s:5:\"value\";s:14:\"Quintessential\";s:4:\"name\";s:14:\"Quintessential\";}i:553;a:2:{s:5:\"value\";s:7:\"Qwigley\";s:4:\"name\";s:7:\"Qwigley\";}i:554;a:2:{s:5:\"value\";s:15:\"Racing+Sans+One\";s:4:\"name\";s:15:\"Racing Sans One\";}i:555;a:2:{s:5:\"value\";s:6:\"Radley\";s:4:\"name\";s:6:\"Radley\";}i:556;a:2:{s:5:\"value\";s:8:\"Rajdhani\";s:4:\"name\";s:8:\"Rajdhani\";}i:557;a:2:{s:5:\"value\";s:7:\"Raleway\";s:4:\"name\";s:7:\"Raleway\";}i:558;a:2:{s:5:\"value\";s:12:\"Raleway+Dots\";s:4:\"name\";s:12:\"Raleway Dots\";}i:559;a:2:{s:5:\"value\";s:10:\"Ramabhadra\";s:4:\"name\";s:10:\"Ramabhadra\";}i:560;a:2:{s:5:\"value\";s:8:\"Ramaraja\";s:4:\"name\";s:8:\"Ramaraja\";}i:561;a:2:{s:5:\"value\";s:6:\"Rambla\";s:4:\"name\";s:6:\"Rambla\";}i:562;a:2:{s:5:\"value\";s:12:\"Rammetto+One\";s:4:\"name\";s:12:\"Rammetto One\";}i:563;a:2:{s:5:\"value\";s:8:\"Ranchers\";s:4:\"name\";s:8:\"Ranchers\";}i:564;a:2:{s:5:\"value\";s:6:\"Rancho\";s:4:\"name\";s:6:\"Rancho\";}i:565;a:2:{s:5:\"value\";s:5:\"Ranga\";s:4:\"name\";s:5:\"Ranga\";}i:566;a:2:{s:5:\"value\";s:9:\"Rationale\";s:4:\"name\";s:9:\"Rationale\";}i:567;a:2:{s:5:\"value\";s:12:\"Ravi+Prakash\";s:4:\"name\";s:12:\"Ravi Prakash\";}i:568;a:2:{s:5:\"value\";s:9:\"Redressed\";s:4:\"name\";s:9:\"Redressed\";}i:569;a:2:{s:5:\"value\";s:13:\"Reenie+Beanie\";s:4:\"name\";s:13:\"Reenie Beanie\";}i:570;a:2:{s:5:\"value\";s:7:\"Revalia\";s:4:\"name\";s:7:\"Revalia\";}i:571;a:2:{s:5:\"value\";s:13:\"Rhodium+Libre\";s:4:\"name\";s:13:\"Rhodium Libre\";}i:572;a:2:{s:5:\"value\";s:6:\"Ribeye\";s:4:\"name\";s:6:\"Ribeye\";}i:573;a:2:{s:5:\"value\";s:13:\"Ribeye+Marrow\";s:4:\"name\";s:13:\"Ribeye Marrow\";}i:574;a:2:{s:5:\"value\";s:9:\"Righteous\";s:4:\"name\";s:9:\"Righteous\";}i:575;a:2:{s:5:\"value\";s:6:\"Risque\";s:4:\"name\";s:6:\"Risque\";}i:576;a:2:{s:5:\"value\";s:6:\"Roboto\";s:4:\"name\";s:6:\"Roboto\";}i:577;a:2:{s:5:\"value\";s:16:\"Roboto+Condensed\";s:4:\"name\";s:16:\"Roboto Condensed\";}i:578;a:2:{s:5:\"value\";s:11:\"Roboto+Mono\";s:4:\"name\";s:11:\"Roboto Mono\";}i:579;a:2:{s:5:\"value\";s:11:\"Roboto+Slab\";s:4:\"name\";s:11:\"Roboto Slab\";}i:580;a:2:{s:5:\"value\";s:9:\"Rochester\";s:4:\"name\";s:9:\"Rochester\";}i:581;a:2:{s:5:\"value\";s:9:\"Rock+Salt\";s:4:\"name\";s:9:\"Rock Salt\";}i:582;a:2:{s:5:\"value\";s:7:\"Rokkitt\";s:4:\"name\";s:7:\"Rokkitt\";}i:583;a:2:{s:5:\"value\";s:9:\"Romanesco\";s:4:\"name\";s:9:\"Romanesco\";}i:584;a:2:{s:5:\"value\";s:9:\"Ropa+Sans\";s:4:\"name\";s:9:\"Ropa Sans\";}i:585;a:2:{s:5:\"value\";s:7:\"Rosario\";s:4:\"name\";s:7:\"Rosario\";}i:586;a:2:{s:5:\"value\";s:8:\"Rosarivo\";s:4:\"name\";s:8:\"Rosarivo\";}i:587;a:2:{s:5:\"value\";s:12:\"Rouge+Script\";s:4:\"name\";s:12:\"Rouge Script\";}i:588;a:2:{s:5:\"value\";s:9:\"Rozha+One\";s:4:\"name\";s:9:\"Rozha One\";}i:589;a:2:{s:5:\"value\";s:5:\"Rubik\";s:4:\"name\";s:5:\"Rubik\";}i:590;a:2:{s:5:\"value\";s:14:\"Rubik+Mono+One\";s:4:\"name\";s:14:\"Rubik Mono One\";}i:591;a:2:{s:5:\"value\";s:9:\"Rubik+One\";s:4:\"name\";s:9:\"Rubik One\";}i:592;a:2:{s:5:\"value\";s:4:\"Ruda\";s:4:\"name\";s:4:\"Ruda\";}i:593;a:2:{s:5:\"value\";s:6:\"Rufina\";s:4:\"name\";s:6:\"Rufina\";}i:594;a:2:{s:5:\"value\";s:11:\"Ruge+Boogie\";s:4:\"name\";s:11:\"Ruge Boogie\";}i:595;a:2:{s:5:\"value\";s:6:\"Ruluko\";s:4:\"name\";s:6:\"Ruluko\";}i:596;a:2:{s:5:\"value\";s:10:\"Rum+Raisin\";s:4:\"name\";s:10:\"Rum Raisin\";}i:597;a:2:{s:5:\"value\";s:14:\"Ruslan+Display\";s:4:\"name\";s:14:\"Ruslan Display\";}i:598;a:2:{s:5:\"value\";s:9:\"Russo+One\";s:4:\"name\";s:9:\"Russo One\";}i:599;a:2:{s:5:\"value\";s:6:\"Ruthie\";s:4:\"name\";s:6:\"Ruthie\";}i:600;a:2:{s:5:\"value\";s:3:\"Rye\";s:4:\"name\";s:3:\"Rye\";}i:601;a:2:{s:5:\"value\";s:10:\"Sacramento\";s:4:\"name\";s:10:\"Sacramento\";}i:602;a:2:{s:5:\"value\";s:7:\"Sahitya\";s:4:\"name\";s:7:\"Sahitya\";}i:603;a:2:{s:5:\"value\";s:4:\"Sail\";s:4:\"name\";s:4:\"Sail\";}i:604;a:2:{s:5:\"value\";s:5:\"Salsa\";s:4:\"name\";s:5:\"Salsa\";}i:605;a:2:{s:5:\"value\";s:7:\"Sanchez\";s:4:\"name\";s:7:\"Sanchez\";}i:606;a:2:{s:5:\"value\";s:8:\"Sancreek\";s:4:\"name\";s:8:\"Sancreek\";}i:607;a:2:{s:5:\"value\";s:11:\"Sansita+One\";s:4:\"name\";s:11:\"Sansita One\";}i:608;a:2:{s:5:\"value\";s:6:\"Sarala\";s:4:\"name\";s:6:\"Sarala\";}i:609;a:2:{s:5:\"value\";s:6:\"Sarina\";s:4:\"name\";s:6:\"Sarina\";}i:610;a:2:{s:5:\"value\";s:8:\"Sarpanch\";s:4:\"name\";s:8:\"Sarpanch\";}i:611;a:2:{s:5:\"value\";s:7:\"Satisfy\";s:4:\"name\";s:7:\"Satisfy\";}i:612;a:2:{s:5:\"value\";s:5:\"Scada\";s:4:\"name\";s:5:\"Scada\";}i:613;a:2:{s:5:\"value\";s:12:\"Scheherazade\";s:4:\"name\";s:12:\"Scheherazade\";}i:614;a:2:{s:5:\"value\";s:10:\"Schoolbell\";s:4:\"name\";s:10:\"Schoolbell\";}i:615;a:2:{s:5:\"value\";s:14:\"Seaweed+Script\";s:4:\"name\";s:14:\"Seaweed Script\";}i:616;a:2:{s:5:\"value\";s:9:\"Sevillana\";s:4:\"name\";s:9:\"Sevillana\";}i:617;a:2:{s:5:\"value\";s:11:\"Seymour+One\";s:4:\"name\";s:11:\"Seymour One\";}i:618;a:2:{s:5:\"value\";s:18:\"Shadows+Into+Light\";s:4:\"name\";s:18:\"Shadows Into Light\";}i:619;a:2:{s:5:\"value\";s:22:\"Shadows+Into+Light+Two\";s:4:\"name\";s:22:\"Shadows Into Light Two\";}i:620;a:2:{s:5:\"value\";s:6:\"Shanti\";s:4:\"name\";s:6:\"Shanti\";}i:621;a:2:{s:5:\"value\";s:5:\"Share\";s:4:\"name\";s:5:\"Share\";}i:622;a:2:{s:5:\"value\";s:10:\"Share+Tech\";s:4:\"name\";s:10:\"Share Tech\";}i:623;a:2:{s:5:\"value\";s:15:\"Share+Tech+Mono\";s:4:\"name\";s:15:\"Share Tech Mono\";}i:624;a:2:{s:5:\"value\";s:9:\"Shojumaru\";s:4:\"name\";s:9:\"Shojumaru\";}i:625;a:2:{s:5:\"value\";s:11:\"Short+Stack\";s:4:\"name\";s:11:\"Short Stack\";}i:626;a:2:{s:5:\"value\";s:8:\"Siemreap\";s:4:\"name\";s:8:\"Siemreap\";}i:627;a:2:{s:5:\"value\";s:10:\"Sigmar+One\";s:4:\"name\";s:10:\"Sigmar One\";}i:628;a:2:{s:5:\"value\";s:7:\"Signika\";s:4:\"name\";s:7:\"Signika\";}i:629;a:2:{s:5:\"value\";s:16:\"Signika+Negative\";s:4:\"name\";s:16:\"Signika Negative\";}i:630;a:2:{s:5:\"value\";s:9:\"Simonetta\";s:4:\"name\";s:9:\"Simonetta\";}i:631;a:2:{s:5:\"value\";s:7:\"Sintony\";s:4:\"name\";s:7:\"Sintony\";}i:632;a:2:{s:5:\"value\";s:13:\"Sirin+Stencil\";s:4:\"name\";s:13:\"Sirin Stencil\";}i:633;a:2:{s:5:\"value\";s:8:\"Six+Caps\";s:4:\"name\";s:8:\"Six Caps\";}i:634;a:2:{s:5:\"value\";s:7:\"Skranji\";s:4:\"name\";s:7:\"Skranji\";}i:635;a:2:{s:5:\"value\";s:10:\"Slabo+13px\";s:4:\"name\";s:10:\"Slabo 13px\";}i:636;a:2:{s:5:\"value\";s:10:\"Slabo+27px\";s:4:\"name\";s:10:\"Slabo 27px\";}i:637;a:2:{s:5:\"value\";s:7:\"Slackey\";s:4:\"name\";s:7:\"Slackey\";}i:638;a:2:{s:5:\"value\";s:6:\"Smokum\";s:4:\"name\";s:6:\"Smokum\";}i:639;a:2:{s:5:\"value\";s:6:\"Smythe\";s:4:\"name\";s:6:\"Smythe\";}i:640;a:2:{s:5:\"value\";s:7:\"Sniglet\";s:4:\"name\";s:7:\"Sniglet\";}i:641;a:2:{s:5:\"value\";s:7:\"Snippet\";s:4:\"name\";s:7:\"Snippet\";}i:642;a:2:{s:5:\"value\";s:13:\"Snowburst+One\";s:4:\"name\";s:13:\"Snowburst One\";}i:643;a:2:{s:5:\"value\";s:10:\"Sofadi+One\";s:4:\"name\";s:10:\"Sofadi One\";}i:644;a:2:{s:5:\"value\";s:5:\"Sofia\";s:4:\"name\";s:5:\"Sofia\";}i:645;a:2:{s:5:\"value\";s:10:\"Sonsie+One\";s:4:\"name\";s:10:\"Sonsie One\";}i:646;a:2:{s:5:\"value\";s:16:\"Sorts+Mill+Goudy\";s:4:\"name\";s:16:\"Sorts Mill Goudy\";}i:647;a:2:{s:5:\"value\";s:15:\"Source+Code+Pro\";s:4:\"name\";s:15:\"Source Code Pro\";}i:648;a:2:{s:5:\"value\";s:15:\"Source+Sans+Pro\";s:4:\"name\";s:15:\"Source Sans Pro\";}i:649;a:2:{s:5:\"value\";s:16:\"Source+Serif+Pro\";s:4:\"name\";s:16:\"Source Serif Pro\";}i:650;a:2:{s:5:\"value\";s:13:\"Special+Elite\";s:4:\"name\";s:13:\"Special Elite\";}i:651;a:2:{s:5:\"value\";s:10:\"Spicy+Rice\";s:4:\"name\";s:10:\"Spicy Rice\";}i:652;a:2:{s:5:\"value\";s:9:\"Spinnaker\";s:4:\"name\";s:9:\"Spinnaker\";}i:653;a:2:{s:5:\"value\";s:6:\"Spirax\";s:4:\"name\";s:6:\"Spirax\";}i:654;a:2:{s:5:\"value\";s:10:\"Squada+One\";s:4:\"name\";s:10:\"Squada One\";}i:655;a:2:{s:5:\"value\";s:20:\"Sree+Krushnadevaraya\";s:4:\"name\";s:20:\"Sree Krushnadevaraya\";}i:656;a:2:{s:5:\"value\";s:9:\"Stalemate\";s:4:\"name\";s:9:\"Stalemate\";}i:657;a:2:{s:5:\"value\";s:13:\"Stalinist+One\";s:4:\"name\";s:13:\"Stalinist One\";}i:658;a:2:{s:5:\"value\";s:15:\"Stardos+Stencil\";s:4:\"name\";s:15:\"Stardos Stencil\";}i:659;a:2:{s:5:\"value\";s:21:\"Stint+Ultra+Condensed\";s:4:\"name\";s:21:\"Stint Ultra Condensed\";}i:660;a:2:{s:5:\"value\";s:20:\"Stint+Ultra+Expanded\";s:4:\"name\";s:20:\"Stint Ultra Expanded\";}i:661;a:2:{s:5:\"value\";s:5:\"Stoke\";s:4:\"name\";s:5:\"Stoke\";}i:662;a:2:{s:5:\"value\";s:6:\"Strait\";s:4:\"name\";s:6:\"Strait\";}i:663;a:2:{s:5:\"value\";s:19:\"Sue+Ellen+Francisco\";s:4:\"name\";s:19:\"Sue Ellen Francisco\";}i:664;a:2:{s:5:\"value\";s:6:\"Sumana\";s:4:\"name\";s:6:\"Sumana\";}i:665;a:2:{s:5:\"value\";s:9:\"Sunshiney\";s:4:\"name\";s:9:\"Sunshiney\";}i:666;a:2:{s:5:\"value\";s:16:\"Supermercado+One\";s:4:\"name\";s:16:\"Supermercado One\";}i:667;a:2:{s:5:\"value\";s:4:\"Sura\";s:4:\"name\";s:4:\"Sura\";}i:668;a:2:{s:5:\"value\";s:7:\"Suranna\";s:4:\"name\";s:7:\"Suranna\";}i:669;a:2:{s:5:\"value\";s:9:\"Suravaram\";s:4:\"name\";s:9:\"Suravaram\";}i:670;a:2:{s:5:\"value\";s:11:\"Suwannaphum\";s:4:\"name\";s:11:\"Suwannaphum\";}i:671;a:2:{s:5:\"value\";s:18:\"Swanky+and+Moo+Moo\";s:4:\"name\";s:18:\"Swanky and Moo Moo\";}i:672;a:2:{s:5:\"value\";s:9:\"Syncopate\";s:4:\"name\";s:9:\"Syncopate\";}i:673;a:2:{s:5:\"value\";s:9:\"Tangerine\";s:4:\"name\";s:9:\"Tangerine\";}i:674;a:2:{s:5:\"value\";s:6:\"Taprom\";s:4:\"name\";s:6:\"Taprom\";}i:675;a:2:{s:5:\"value\";s:5:\"Tauri\";s:4:\"name\";s:5:\"Tauri\";}i:676;a:2:{s:5:\"value\";s:4:\"Teko\";s:4:\"name\";s:4:\"Teko\";}i:677;a:2:{s:5:\"value\";s:5:\"Telex\";s:4:\"name\";s:5:\"Telex\";}i:678;a:2:{s:5:\"value\";s:18:\"Tenali+Ramakrishna\";s:4:\"name\";s:18:\"Tenali Ramakrishna\";}i:679;a:2:{s:5:\"value\";s:10:\"Tenor+Sans\";s:4:\"name\";s:10:\"Tenor Sans\";}i:680;a:2:{s:5:\"value\";s:11:\"Text+Me+One\";s:4:\"name\";s:11:\"Text Me One\";}i:681;a:2:{s:5:\"value\";s:18:\"The+Girl+Next+Door\";s:4:\"name\";s:18:\"The Girl Next Door\";}i:682;a:2:{s:5:\"value\";s:6:\"Tienne\";s:4:\"name\";s:6:\"Tienne\";}i:683;a:2:{s:5:\"value\";s:7:\"Tillana\";s:4:\"name\";s:7:\"Tillana\";}i:684;a:2:{s:5:\"value\";s:7:\"Timmana\";s:4:\"name\";s:7:\"Timmana\";}i:685;a:2:{s:5:\"value\";s:5:\"Tinos\";s:4:\"name\";s:5:\"Tinos\";}i:686;a:2:{s:5:\"value\";s:9:\"Titan+One\";s:4:\"name\";s:9:\"Titan One\";}i:687;a:2:{s:5:\"value\";s:13:\"Titillium+Web\";s:4:\"name\";s:13:\"Titillium Web\";}i:688;a:2:{s:5:\"value\";s:11:\"Trade+Winds\";s:4:\"name\";s:11:\"Trade Winds\";}i:689;a:2:{s:5:\"value\";s:7:\"Trocchi\";s:4:\"name\";s:7:\"Trocchi\";}i:690;a:2:{s:5:\"value\";s:7:\"Trochut\";s:4:\"name\";s:7:\"Trochut\";}i:691;a:2:{s:5:\"value\";s:7:\"Trykker\";s:4:\"name\";s:7:\"Trykker\";}i:692;a:2:{s:5:\"value\";s:10:\"Tulpen+One\";s:4:\"name\";s:10:\"Tulpen One\";}i:693;a:2:{s:5:\"value\";s:6:\"Ubuntu\";s:4:\"name\";s:6:\"Ubuntu\";}i:694;a:2:{s:5:\"value\";s:16:\"Ubuntu+Condensed\";s:4:\"name\";s:16:\"Ubuntu Condensed\";}i:695;a:2:{s:5:\"value\";s:11:\"Ubuntu+Mono\";s:4:\"name\";s:11:\"Ubuntu Mono\";}i:696;a:2:{s:5:\"value\";s:5:\"Ultra\";s:4:\"name\";s:5:\"Ultra\";}i:697;a:2:{s:5:\"value\";s:14:\"Uncial+Antiqua\";s:4:\"name\";s:14:\"Uncial Antiqua\";}i:698;a:2:{s:5:\"value\";s:8:\"Underdog\";s:4:\"name\";s:8:\"Underdog\";}i:699;a:2:{s:5:\"value\";s:9:\"Unica+One\";s:4:\"name\";s:9:\"Unica One\";}i:700;a:2:{s:5:\"value\";s:14:\"UnifrakturCook\";s:4:\"name\";s:14:\"UnifrakturCook\";}i:701;a:2:{s:5:\"value\";s:18:\"UnifrakturMaguntia\";s:4:\"name\";s:18:\"UnifrakturMaguntia\";}i:702;a:2:{s:5:\"value\";s:7:\"Unkempt\";s:4:\"name\";s:7:\"Unkempt\";}i:703;a:2:{s:5:\"value\";s:6:\"Unlock\";s:4:\"name\";s:6:\"Unlock\";}i:704;a:2:{s:5:\"value\";s:4:\"Unna\";s:4:\"name\";s:4:\"Unna\";}i:705;a:2:{s:5:\"value\";s:5:\"VT323\";s:4:\"name\";s:5:\"VT323\";}i:706;a:2:{s:5:\"value\";s:11:\"Vampiro+One\";s:4:\"name\";s:11:\"Vampiro One\";}i:707;a:2:{s:5:\"value\";s:6:\"Varela\";s:4:\"name\";s:6:\"Varela\";}i:708;a:2:{s:5:\"value\";s:12:\"Varela+Round\";s:4:\"name\";s:12:\"Varela Round\";}i:709;a:2:{s:5:\"value\";s:11:\"Vast+Shadow\";s:4:\"name\";s:11:\"Vast Shadow\";}i:710;a:2:{s:5:\"value\";s:12:\"Vesper+Libre\";s:4:\"name\";s:12:\"Vesper Libre\";}i:711;a:2:{s:5:\"value\";s:5:\"Vibur\";s:4:\"name\";s:5:\"Vibur\";}i:712;a:2:{s:5:\"value\";s:8:\"Vidaloka\";s:4:\"name\";s:8:\"Vidaloka\";}i:713;a:2:{s:5:\"value\";s:4:\"Viga\";s:4:\"name\";s:4:\"Viga\";}i:714;a:2:{s:5:\"value\";s:5:\"Voces\";s:4:\"name\";s:5:\"Voces\";}i:715;a:2:{s:5:\"value\";s:7:\"Volkhov\";s:4:\"name\";s:7:\"Volkhov\";}i:716;a:2:{s:5:\"value\";s:8:\"Vollkorn\";s:4:\"name\";s:8:\"Vollkorn\";}i:717;a:2:{s:5:\"value\";s:8:\"Voltaire\";s:4:\"name\";s:8:\"Voltaire\";}i:718;a:2:{s:5:\"value\";s:23:\"Waiting+for+the+Sunrise\";s:4:\"name\";s:23:\"Waiting for the Sunrise\";}i:719;a:2:{s:5:\"value\";s:8:\"Wallpoet\";s:4:\"name\";s:8:\"Wallpoet\";}i:720;a:2:{s:5:\"value\";s:15:\"Walter+Turncoat\";s:4:\"name\";s:15:\"Walter Turncoat\";}i:721;a:2:{s:5:\"value\";s:6:\"Warnes\";s:4:\"name\";s:6:\"Warnes\";}i:722;a:2:{s:5:\"value\";s:9:\"Wellfleet\";s:4:\"name\";s:9:\"Wellfleet\";}i:723;a:2:{s:5:\"value\";s:9:\"Wendy+One\";s:4:\"name\";s:9:\"Wendy One\";}i:724;a:2:{s:5:\"value\";s:8:\"Wire+One\";s:4:\"name\";s:8:\"Wire One\";}i:725;a:2:{s:5:\"value\";s:9:\"Work+Sans\";s:4:\"name\";s:9:\"Work Sans\";}i:726;a:2:{s:5:\"value\";s:17:\"Yanone+Kaffeesatz\";s:4:\"name\";s:17:\"Yanone Kaffeesatz\";}i:727;a:2:{s:5:\"value\";s:11:\"Yantramanav\";s:4:\"name\";s:11:\"Yantramanav\";}i:728;a:2:{s:5:\"value\";s:10:\"Yellowtail\";s:4:\"name\";s:10:\"Yellowtail\";}i:729;a:2:{s:5:\"value\";s:10:\"Yeseva+One\";s:4:\"name\";s:10:\"Yeseva One\";}i:730;a:2:{s:5:\"value\";s:10:\"Yesteryear\";s:4:\"name\";s:10:\"Yesteryear\";}i:731;a:2:{s:5:\"value\";s:6:\"Zeyada\";s:4:\"name\";s:6:\"Zeyada\";}}","yes");
INSERT INTO ayv_options VALUES("139","font_type_1","Montserrat","yes");
INSERT INTO ayv_options VALUES("140","font_type_2","PT+Sans","yes");
INSERT INTO ayv_options VALUES("141","anps_custom_fonts","a:1:{i:0;a:2:{s:5:\"value\";s:9:\"titillium\";s:4:\"name\";s:9:\"titillium\";}}","yes");
INSERT INTO ayv_options VALUES("142","fonts_intalled","1","yes");
INSERT INTO ayv_options VALUES("145","widget_anpsdownload","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ayv_options VALUES("146","widget_anpsimages","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ayv_options VALUES("147","widget_anpsrecentprojects","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ayv_options VALUES("148","widget_anpssocial","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ayv_options VALUES("149","widget_anpstext","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ayv_options VALUES("150","widget_calendar","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ayv_options VALUES("151","widget_nav_menu","a:4:{i:1;a:0:{}i:2;a:1:{s:8:\"nav_menu\";i:2;}i:3;a:1:{s:8:\"nav_menu\";i:7;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ayv_options VALUES("152","widget_tag_cloud","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ayv_options VALUES("153","widget_pages","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ayv_options VALUES("236","wpcf7","a:1:{s:7:\"version\";s:5:\"4.4.1\";}","yes");
INSERT INTO ayv_options VALUES("184","ftp_credentials","a:3:{s:8:\"hostname\";s:20:\"178.33.229.143:13131\";s:8:\"username\";s:8:\"ftpVedel\";s:15:\"connection_type\";s:3:\"ftp\";}","yes");
INSERT INTO ayv_options VALUES("237","nav_menu_options","a:2:{i:0;b:0;s:8:\"auto_add\";a:1:{i:0;i:7;}}","yes");
INSERT INTO ayv_options VALUES("238","anps_acc_info","a:4:{s:7:\"pattern\";s:1:\"0\";s:14:\"custom_pattern\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:14:\"footer_columns\";s:1:\"1\";}","yes");
INSERT INTO ayv_options VALUES("239","anps_page_setup","a:22:{s:11:\"coming_soon\";s:1:\"0\";s:10:\"error_page\";s:2:\"59\";s:16:\"portfolio_single\";s:7:\"style-1\";s:23:\"portfolio_single_footer\";s:0:\"\";s:14:\"anps_menu_type\";s:1:\"2\";s:21:\"anps_front_text_color\";s:0:\"\";s:27:\"anps_front_text_hover_color\";s:0:\"\";s:19:\"anps_front_bg_color\";s:0:\"\";s:23:\"anps_front_topbar_color\";s:0:\"\";s:29:\"anps_front_topbar_hover_color\";s:0:\"\";s:15:\"anps_front_logo\";s:0:\"\";s:16:\"anps_full_screen\";s:0:\"\";s:13:\"topmenu_style\";s:1:\"3\";s:10:\"menu_style\";s:1:\"1\";s:11:\"sticky_menu\";s:2:\"on\";s:21:\"logo_transition_style\";s:1:\"1\";s:11:\"search_icon\";s:2:\"on\";s:18:\"search_icon_mobile\";s:2:\"on\";s:9:\"prefooter\";s:2:\"on\";s:15:\"prefooter_style\";s:1:\"6\";s:12:\"footer_style\";s:1:\"2\";s:16:\"copyright_footer\";s:1:\"1\";}","yes");
INSERT INTO ayv_options VALUES("240","coming_soon","0","yes");
INSERT INTO ayv_options VALUES("241","topmenu_style","3","yes");
INSERT INTO ayv_options VALUES("242","portfolio_single","style-1","yes");
INSERT INTO ayv_options VALUES("243","anps_menu_type","2","yes");
INSERT INTO ayv_options VALUES("244","anps_front_text_color","","yes");
INSERT INTO ayv_options VALUES("245","anps_front_text_hover_color","","yes");
INSERT INTO ayv_options VALUES("246","anps_front_bg_color","","yes");
INSERT INTO ayv_options VALUES("247","anps_full_screen","","yes");
INSERT INTO ayv_options VALUES("248","menu_style","1","yes");
INSERT INTO ayv_options VALUES("249","sticky_menu","on","yes");
INSERT INTO ayv_options VALUES("250","logo_transition_style","1","yes");
INSERT INTO ayv_options VALUES("251","menu_center","","yes");
INSERT INTO ayv_options VALUES("252","search_icon","on","yes");
INSERT INTO ayv_options VALUES("253","search_icon_mobile","on","yes");
INSERT INTO ayv_options VALUES("254","portfolio_single_footer","","yes");
INSERT INTO ayv_options VALUES("255","footer_style","2","yes");
INSERT INTO ayv_options VALUES("256","prefooter_style","6","yes");
INSERT INTO ayv_options VALUES("257","prefooter","on","yes");
INSERT INTO ayv_options VALUES("258","footer_disable","","yes");
INSERT INTO ayv_options VALUES("259","copyright_footer","1","yes");
INSERT INTO ayv_options VALUES("260","anps_front_topbar_color","","yes");
INSERT INTO ayv_options VALUES("261","anps_front_topbar_hover_color","","yes");
INSERT INTO ayv_options VALUES("262","side_submenu_background_color","","yes");
INSERT INTO ayv_options VALUES("263","side_submenu_text_color","","yes");
INSERT INTO ayv_options VALUES("264","side_submenu_text_hover_color","","yes");
INSERT INTO ayv_options VALUES("265","anps_front_logo","","yes");
INSERT INTO ayv_options VALUES("266","anps_media_info","a:7:{s:10:\"heading_bg\";s:0:\"\";s:17:\"search_heading_bg\";s:0:\"\";s:4:\"logo\";s:89:\"http://www.atelier-yvanvedel.com/wp-content/uploads/2015/12/logo-atelier-yvan-vedel-1.png\";s:10:\"logo-width\";s:3:\"253\";s:11:\"logo-height\";s:2:\"55\";s:11:\"sticky_logo\";s:89:\"http://www.atelier-yvanvedel.com/wp-content/uploads/2015/12/logo-atelier-yvan-vedel-1.png\";s:7:\"favicon\";s:0:\"\";}","yes");
INSERT INTO ayv_options VALUES("267","auto_adjust_logo","","yes");
INSERT INTO ayv_options VALUES("270","vc_version","4.8.0.1","yes");
INSERT INTO ayv_options VALUES("3061","_site_transient_timeout_available_translations","1460134728","yes");
INSERT INTO ayv_options VALUES("3062","_site_transient_available_translations","a:78:{s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-07 13:09:53\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"???????\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"????????\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-12 10:15:45\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"??????? ????????\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4.2/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"????????\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-07 20:53:51\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Az?rbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-11 22:42:10\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"????? ?????????\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4.2/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-08 08:50:29\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"?????????\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:22:\"???????????\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-08 13:17:04\";s:12:\"english_name\";s:7:\"Bengali\";s:11:\"native_name\";s:15:\"?????\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:23:\"????? ??.\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-04 09:40:25\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-03-24 08:27:23\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Catal\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-16 15:34:57\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-11 18:32:36\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:12:\"?etina?\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokra?ovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-01-26 16:01:40\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-08 22:48:20\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Forts&#230;t\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-08 14:19:21\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Fortfahren\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-29 10:47:54\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Fortfahren\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-26 16:11:56\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/4.4.2/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Fortfahren\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-04-07 16:18:59\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"????????\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"????????\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-07 04:39:48\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-06 23:10:59\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-15 11:52:35\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-08 13:34:17\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-01-14 21:14:29\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-01-25 13:07:29\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Da?rigi\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-07 17:35:10\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Espaol de Mxico\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/es_MX.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-13 12:28:49\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Espaol\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/es_ES.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"es\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-09 18:08:52\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Espaol de Guatemala\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/es_GT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-01-13 06:14:13\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Espaol de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/es_VE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:6:\"4.3-RC\";s:7:\"updated\";s:19:\"2015-08-04 06:10:33\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Espaol de Colombia\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.3-RC/es_CO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-23 00:46:01\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Espaol de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/es_AR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-01-24 15:17:36\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Espaol de Per\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/es_PE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-03-02 20:27:44\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Espaol de Chile\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/es_CL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-18 06:44:22\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jtka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-03-03 10:31:09\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-01-31 19:24:20\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"?????\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"?????\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-23 06:49:15\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-08 13:47:35\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Franais de Belgique\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-03-08 17:19:17\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Franais\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-09 02:16:19\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Franais du Canada\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.3.3\";s:7:\"updated\";s:19:\"2015-09-24 15:25:30\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.3.3/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-01-13 16:48:03\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"????? ??\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4.2/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"?????\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-03-16 18:59:27\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"????????\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"??????\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-03-31 09:54:46\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"??????\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"????\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-03-04 08:39:26\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-03 14:37:42\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Tovbb\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-04 07:13:54\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"???????\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"??????????\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-21 16:17:50\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-08 00:20:24\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"slenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"fram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-04-05 08:30:38\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-25 13:08:14\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"???\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"???\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-09 08:53:31\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"???????\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"??????????\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-24 00:12:01\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"???\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"??\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-08 20:07:24\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvi? kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"T?sti\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-01-28 05:41:39\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.1.10\";s:7:\"updated\";s:19:\"2015-03-26 15:57:42\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"?????\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.1.10/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"??????????????????\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-07 10:01:09\";s:12:\"english_name\";s:19:\"Norwegian (Bokml)\";s:11:\"native_name\";s:13:\"Norsk bokml\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-01-20 13:35:50\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/4.4.2/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-23 18:59:13\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-14 12:19:44\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-08 16:21:37\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4.2/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-03-24 15:31:29\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.1.10\";s:7:\"updated\";s:19:\"2015-03-29 22:19:48\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"????\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1.10/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"????\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-03-03 17:32:29\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Portugus do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-04-07 13:40:53\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Portugus\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-03-31 14:58:13\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Romn?\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continu?\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-03-21 18:23:26\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"???????\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"??????????\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-26 11:29:13\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Sloven?ina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokra?ova?\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-11-26 00:00:18\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Sloven?ina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Nadaljujte\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-23 10:30:30\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-09 09:09:51\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"?????? ?????\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"???????\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-08 23:28:56\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortstt\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-08 03:22:55\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"???\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"?????\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-11-27 15:51:36\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-17 23:12:27\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Trke\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:6:\"4.1.10\";s:7:\"updated\";s:19:\"2015-03-26 16:45:38\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:9:\"Uy?urq?\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.1.10/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"?????????????\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-01-03 22:04:41\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"??????????\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"??????????\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-09 01:01:25\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Ti?ng Vi?t\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Ti?p t?c\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-11 18:51:41\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"????\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"??\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-12 22:55:08\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"????\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"??\";}}}","yes");
INSERT INTO ayv_options VALUES("275","font_type_navigation","Montserrat","yes");
INSERT INTO ayv_options VALUES("276","body_font_size","14","yes");
INSERT INTO ayv_options VALUES("277","menu_font_size","14","yes");
INSERT INTO ayv_options VALUES("278","h1_font_size","31","yes");
INSERT INTO ayv_options VALUES("279","h2_font_size","24","yes");
INSERT INTO ayv_options VALUES("280","h3_font_size","21","yes");
INSERT INTO ayv_options VALUES("281","h4_font_size","18","yes");
INSERT INTO ayv_options VALUES("282","h5_font_size","16","yes");
INSERT INTO ayv_options VALUES("283","page_heading_h1_font_size","24","yes");
INSERT INTO ayv_options VALUES("284","blog_heading_h1_font_size","28","yes");
INSERT INTO ayv_options VALUES("285","text_color","#727272","yes");
INSERT INTO ayv_options VALUES("286","primary_color","#292929","yes");
INSERT INTO ayv_options VALUES("287","hovers_color","#d54900","yes");
INSERT INTO ayv_options VALUES("288","menu_text_color","#000","yes");
INSERT INTO ayv_options VALUES("289","headings_color","#000000","yes");
INSERT INTO ayv_options VALUES("290","top_bar_color","#c1c1c1","yes");
INSERT INTO ayv_options VALUES("291","top_bar_bg_color","#f9f9f9","yes");
INSERT INTO ayv_options VALUES("292","footer_bg_color","#313131","yes");
INSERT INTO ayv_options VALUES("293","copyright_footer_bg_color","#2c2c2c","yes");
INSERT INTO ayv_options VALUES("294","footer_text_color","#d9d9d9","yes");
INSERT INTO ayv_options VALUES("295","nav_background_color","#fff","yes");
INSERT INTO ayv_options VALUES("296","submenu_background_color","#fff","yes");
INSERT INTO ayv_options VALUES("297","submenu_text_color","#000","yes");
INSERT INTO ayv_options VALUES("298","default_button_bg","#292929","yes");
INSERT INTO ayv_options VALUES("299","default_button_color","#fff","yes");
INSERT INTO ayv_options VALUES("300","default_button_hover_bg","#d54900","yes");
INSERT INTO ayv_options VALUES("301","default_button_hover_color","#fff","yes");
INSERT INTO ayv_options VALUES("302","style_1_button_bg","#292929","yes");
INSERT INTO ayv_options VALUES("303","style_1_button_color","#fff","yes");
INSERT INTO ayv_options VALUES("304","style_1_button_hover_bg","#d54900","yes");
INSERT INTO ayv_options VALUES("305","style_1_button_hover_color","#fff","yes");
INSERT INTO ayv_options VALUES("306","style_2_button_bg","#292929","yes");
INSERT INTO ayv_options VALUES("307","style_2_button_color","#fff","yes");
INSERT INTO ayv_options VALUES("308","style_2_button_hover_bg","#d54900","yes");
INSERT INTO ayv_options VALUES("309","style_2_button_hover_color","#fff","yes");
INSERT INTO ayv_options VALUES("310","style_3_button_color","#000","yes");
INSERT INTO ayv_options VALUES("311","style_3_button_hover_bg","#fafafa","yes");
INSERT INTO ayv_options VALUES("312","style_3_button_hover_color","#000","yes");
INSERT INTO ayv_options VALUES("313","style_3_button_border_color","#000","yes");
INSERT INTO ayv_options VALUES("314","style_4_button_color","#000","yes");
INSERT INTO ayv_options VALUES("315","style_4_button_hover_color","#d54900","yes");
INSERT INTO ayv_options VALUES("316","style_slider_button_bg","#292929","yes");
INSERT INTO ayv_options VALUES("317","style_slider_button_color","#fff","yes");
INSERT INTO ayv_options VALUES("318","style_slider_button_hover_bg","#d54900","yes");
INSERT INTO ayv_options VALUES("319","style_slider_button_hover_color","#fff","yes");
INSERT INTO ayv_options VALUES("320","style_style_5_button_bg","#c3c3c3","yes");
INSERT INTO ayv_options VALUES("321","style_style_5_button_color","#fff","yes");
INSERT INTO ayv_options VALUES("322","style_style_5_button_hover_bg","#737373","yes");
INSERT INTO ayv_options VALUES("323","style_style_5_button_hover_color","#fff","yes");
INSERT INTO ayv_options VALUES("324","font_source_1","Google fonts","yes");
INSERT INTO ayv_options VALUES("325","font_source_2","Google fonts","yes");
INSERT INTO ayv_options VALUES("326","font_source_navigation","Google fonts","yes");
INSERT INTO ayv_options VALUES("329","widget_rev-slider-widget","a:3:{i:1;a:0:{}i:2;a:2:{s:10:\"rev_slider\";s:1:\"2\";s:16:\"rev_slider_pages\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ayv_options VALUES("1037","category_children","a:0:{}","yes");
INSERT INTO ayv_options VALUES("3052","_transient_timeout_feed_b9388c83948825c1edaef0d856b7b109","1460167107","no");
INSERT INTO ayv_options VALUES("3053","_transient_feed_b9388c83948825c1edaef0d856b7b109","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"
\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:117:\"
	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordPress Plugins  View: Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://wordpress.org/plugins/browse/popular/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordPress Plugins  View: Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 08 Apr 2016 13:58:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"http://bbpress.org/?v=1.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:30:{i:0;a:6:{s:4:\"data\";s:30:\"
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Hello Dolly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/hello-dolly/#post-5790\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 May 2008 22:11:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"5790@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"This is not just a plugin, it symbolizes the hope and enthusiasm of an entire generation summed up in two words sung most famously by Louis Armstrong.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:30:\"
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Google XML Sitemaps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/google-sitemap-generator/#post-132\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:31:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"132@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"This plugin will generate a special XML sitemap which will help search engines to better index your blog.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Arne Brachhold\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:30:\"
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Regenerate Thumbnails\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/plugins/regenerate-thumbnails/#post-6743\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 23 Aug 2008 14:38:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"6743@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"Allows you to regenerate your thumbnails after changing the thumbnail sizes.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Alex Mills (Viper007Bond)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:30:\"
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"All in One SEO Pack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/all-in-one-seo-pack/#post-753\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Mar 2007 20:08:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"753@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"The most downloaded plugin for WordPress (almost 30 million downloads). Use All in One SEO Pack to automatically optimize your site for Search Engines\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"uberdose\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:30:\"
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Contact Form 7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/contact-form-7/#post-2141\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Aug 2007 12:45:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2141@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Just another contact form plugin. Simple but flexible.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:30:\"
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"TinyMCE Advanced\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://wordpress.org/plugins/tinymce-advanced/#post-2082\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Jun 2007 15:00:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2082@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Enables the advanced features of TinyMCE, the WordPress WYSIWYG editor.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Andrew Ozz\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:30:\"
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"WooCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/woocommerce/#post-29860\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Sep 2011 08:13:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"29860@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WooCommerce is a powerful, extendable eCommerce plugin that helps you sell anything. Beautifully.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"WooThemes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:30:\"
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"WP-PageNavi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wp-pagenavi/#post-363\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 23:17:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"363@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"Adds a more advanced paging navigation interface.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Lester Chan\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:30:\"
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"W3 Total Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/w3-total-cache/#post-12073\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2009 18:46:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"12073@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:132:\"Easy Web Performance Optimization (WPO) using caching: browser, page, object, database, minify and content delivery network support.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Frederick Townes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:30:\"
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"NextGEN Gallery\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/nextgen-gallery/#post-1169\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Apr 2007 20:08:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"1169@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"The most popular WordPress gallery plugin and one of the most popular plugins of all time with over 14 million downloads.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Alex Rabe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:30:\"
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Advanced Custom Fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/advanced-custom-fields/#post-25254\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Mar 2011 04:07:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"25254@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"Customise WordPress with powerful, professional and intuitive fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"elliotcondon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:30:\"
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Akismet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wordpress.org/plugins/akismet/#post-15\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:11:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"15@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"Akismet checks your comments against the Akismet Web service to see if they look like spam or not.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:30:\"
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Google Analytics by Yoast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/plugins/google-analytics-for-wordpress/#post-2316\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Sep 2007 12:15:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2316@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:124:\"Track your WordPress site easily with the latest tracking codes and lots added data for search result pages and error pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:30:\"
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Yoast SEO\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://wordpress.org/plugins/wordpress-seo/#post-8321\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Jan 2009 20:34:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"8321@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"Improve your WordPress SEO: Write better content and have a fully optimized WordPress site using Yoast SEO plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:30:\"
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Really Simple CAPTCHA\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/plugins/really-simple-captcha/#post-9542\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 Mar 2009 02:17:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"9542@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"Really Simple CAPTCHA is a CAPTCHA module intended to be called from other plugins. It is originally created for my Contact Form 7 plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:30:\"
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Duplicate Post\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/duplicate-post/#post-2646\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Dec 2007 17:40:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2646@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Clone posts and pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Lopo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:30:\"
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WordPress Importer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wordpress-importer/#post-18101\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 May 2010 17:42:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"18101@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"Import posts, pages, comments, custom fields, categories, tags and more from a WordPress export file.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brian Colinger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:30:\"
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Wordfence Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wordfence/#post-29832\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 04 Sep 2011 03:13:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"29832@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"The Wordfence WordPress security plugin provides free enterprise-class WordPress security, protecting your website from hacks and malware.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Wordfence\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:30:\"
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WP Super Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/wp-super-cache/#post-2572\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Nov 2007 11:40:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2572@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"A very fast caching engine for WordPress that produces static html files.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Donncha O Caoimh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:30:\"
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Jetpack by WordPress.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://wordpress.org/plugins/jetpack/#post-23862\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Jan 2011 02:21:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"23862@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"Increase your traffic, view your stats, speed up your site, and protect yourself from hackers with Jetpack.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Tim Moore\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:30:\"
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Page Builder by SiteOrigin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/siteorigin-panels/#post-51888\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 11 Apr 2013 10:36:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"51888@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"Build responsive page layouts using the widgets you know and love using this simple drag and drop page builder.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Greg Priday\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:30:\"
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Disable Comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wordpress.org/plugins/disable-comments/#post-26907\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 May 2011 04:42:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"26907@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:134:\"Allows administrators to globally disable comments on their site. Comments can be disabled according to post type. Multisite friendly.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Samir Shah\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:30:\"
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WP Multibyte Patch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wp-multibyte-patch/#post-28395\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 14 Jul 2011 12:22:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"28395@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Multibyte functionality enhancement for the WordPress Japanese package.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"plugin-master\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:30:\"
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Black Studio TinyMCE Widget\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/plugins/black-studio-tinymce-widget/#post-31973\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Nov 2011 15:06:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"31973@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"The visual editor widget for Wordpress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Marco Chiesi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:30:\"
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Google Analytics Dashboard for WP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://wordpress.org/plugins/google-analytics-dashboard-for-wp/#post-50539\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 10 Mar 2013 17:07:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"50539@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:127:\"Displays Google Analytics reports in your WordPress Dashboard. Inserts the latest Google Analytics tracking code in your pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Alin Marcu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:30:\"
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"iThemes Security (formerly Better WP Security)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/better-wp-security/#post-21738\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 22 Oct 2010 22:06:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"21738@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"Protect your WordPress site by hiding vital areas of your site, protecting access to important files, preventing brute-force login attempts, detecting\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"iThemes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:30:\"
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"Clef Two-Factor Authentication\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wordpress.org/plugins/wpclef/#post-47509\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 27 Dec 2012 01:25:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"47509@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"Modern two-factor that people love to use: strong authentication without passwords or tokens; single sign on/off; magical user experience.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Dave Ross\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:30:\"
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"UpdraftPlus Backup and Restoration\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/updraftplus/#post-38058\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 21 May 2012 15:14:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"38058@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:148:\"Backup and restoration made easy. Complete backups; manual or scheduled (backup to S3, Dropbox, Google Drive, Rackspace, FTP, SFTP, email + others).\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"David Anderson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:30:\"
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Duplicator\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/duplicator/#post-26607\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 May 2011 12:15:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"26607@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"Duplicate, clone, backup, move and transfer an entire site from one location to another.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Cory Lamle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:30:\"
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Meta Slider\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/ml-slider/#post-49521\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 14 Feb 2013 16:56:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"49521@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:145:\"Easy to use WordPress slider plugin. Create SEO optimised responsive slideshows with Nivo Slider, Flex Slider, Coin Slider and Responsive Slides.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Matcha Labs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:46:\"https://wordpress.org/plugins/rss/view/popular\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Fri, 08 Apr 2016 13:58:27 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:13:\"last-modified\";s:29:\"Thu, 29 May 2008 22:11:34 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 250\";}s:5:\"build\";s:14:\"20160408133650\";}","no");
INSERT INTO ayv_options VALUES("3054","_transient_timeout_feed_mod_b9388c83948825c1edaef0d856b7b109","1460167107","no");
INSERT INTO ayv_options VALUES("3055","_transient_feed_mod_b9388c83948825c1edaef0d856b7b109","1460123907","no");
INSERT INTO ayv_options VALUES("458","wpgmza_xml_location","{uploads_dir}/wp-google-maps/","yes");
INSERT INTO ayv_options VALUES("459","wpgmza_xml_url","{uploads_url}/wp-google-maps/","yes");
INSERT INTO ayv_options VALUES("460","wpgmza_db_version","6.3.02","yes");
INSERT INTO ayv_options VALUES("461","wpgmaps_current_version","6.3.02","yes");
INSERT INTO ayv_options VALUES("462","WPGMZA_OTHER_SETTINGS","a:6:{s:26:\"wpgmza_settings_map_scroll\";s:3:\"yes\";s:34:\"wpgmza_settings_map_open_marker_by\";s:1:\"1\";s:18:\"wpgmza_api_version\";s:4:\"3.15\";s:17:\"wpgmza_custom_css\";s:0:\"\";s:28:\"wpgmza_settings_access_level\";s:14:\"manage_options\";s:27:\"wpgmza_settings_marker_pull\";s:1:\"0\";}","yes");
INSERT INTO ayv_options VALUES("463","WPGMZA_FIRST_TIME","6.3.02","yes");
INSERT INTO ayv_options VALUES("464","wpgmza_stats","a:4:{s:15:\"list_maps_basic\";a:3:{s:5:\"views\";i:12;s:13:\"last_accessed\";s:19:\"2015-11-06 10:57:50\";s:14:\"first_accessed\";s:19:\"2015-11-06 10:33:20\";}s:9:\"dashboard\";a:3:{s:5:\"views\";i:19;s:13:\"last_accessed\";s:19:\"2015-11-06 10:57:53\";s:14:\"first_accessed\";s:19:\"2015-11-06 10:33:24\";}s:13:\"support_basic\";a:3:{s:5:\"views\";i:1;s:13:\"last_accessed\";s:19:\"2015-11-06 10:43:17\";s:14:\"first_accessed\";s:19:\"2015-11-06 10:43:17\";}s:14:\"settings_basic\";a:3:{s:5:\"views\";i:2;s:13:\"last_accessed\";s:19:\"2015-11-06 10:44:51\";s:14:\"first_accessed\";s:19:\"2015-11-06 10:44:23\";}}","yes");
INSERT INTO ayv_options VALUES("465","WPGMZA_SETTINGS","a:10:{s:24:\"map_default_starting_lat\";s:18:\"44.007285673311145\";s:24:\"map_default_starting_lng\";s:17:\"4.310471562499947\";s:18:\"map_default_height\";s:3:\"400\";s:17:\"map_default_width\";s:3:\"100\";s:16:\"map_default_zoom\";i:8;s:20:\"map_default_max_zoom\";i:1;s:16:\"map_default_type\";i:1;s:21:\"map_default_alignment\";i:1;s:22:\"map_default_width_type\";s:2:\"\\%\";s:23:\"map_default_height_type\";s:2:\"px\";}","yes");
INSERT INTO ayv_options VALUES("483","flexible-map-options-status","active","yes");
INSERT INTO ayv_options VALUES("484","flexible-map-options","a:25:{s:5:\"width\";s:4:\"100%\";s:6:\"height\";s:3:\"400\";s:4:\"zoom\";s:4:\"auto\";s:7:\"maptype\";s:7:\"roadmap\";s:11:\"hidemaptype\";s:4:\"true\";s:11:\"hidepanning\";s:4:\"true\";s:11:\"hidezooming\";s:5:\"false\";s:14:\"hidestreetview\";s:4:\"true\";s:9:\"zoomstyle\";s:7:\"default\";s:9:\"hidescale\";s:4:\"true\";s:11:\"scrollwheel\";s:5:\"false\";s:9:\"draggable\";s:4:\"true\";s:12:\"dblclickzoom\";s:4:\"true\";s:10:\"directions\";s:5:\"false\";s:12:\"dirdraggable\";s:5:\"false\";s:12:\"dirnomarkers\";s:5:\"false\";s:12:\"dirshowsteps\";s:4:\"true\";s:14:\"dirshowssearch\";s:4:\"true\";s:6:\"region\";s:0:\"\";s:6:\"locale\";s:0:\"\";s:4:\"icon\";s:0:\"\";s:14:\"showdirections\";s:4:\"true\";s:14:\"directionsfrom\";s:0:\"\";s:8:\"showinfo\";s:4:\"true\";s:9:\"targetfix\";s:4:\"true\";}","yes");
INSERT INTO ayv_options VALUES("2929","_transient_timeout_flxmap_8b176ee3c65270889eda770445eb0ced","1457564698","no");
INSERT INTO ayv_options VALUES("2930","_transient_flxmap_8b176ee3c65270889eda770445eb0ced","address: 81, impasse du Mas Bruguier 30560 Saint Hilaire de Brethmas; error retrieving address: OVER_QUERY_LIMIT","no");
INSERT INTO ayv_options VALUES("509","portfolio_category_children","a:0:{}","yes");
INSERT INTO ayv_options VALUES("591","duplicate_post_copyexcerpt","1","yes");
INSERT INTO ayv_options VALUES("592","duplicate_post_copyattachments","","yes");
INSERT INTO ayv_options VALUES("593","duplicate_post_copychildren","","yes");
INSERT INTO ayv_options VALUES("594","duplicate_post_copystatus","1","yes");
INSERT INTO ayv_options VALUES("595","duplicate_post_taxonomies_blacklist","","yes");
INSERT INTO ayv_options VALUES("596","duplicate_post_show_row","1","yes");
INSERT INTO ayv_options VALUES("597","duplicate_post_show_adminbar","1","yes");
INSERT INTO ayv_options VALUES("598","duplicate_post_show_submitbox","1","yes");
INSERT INTO ayv_options VALUES("599","duplicate_post_version","2.6","yes");
INSERT INTO ayv_options VALUES("600","duplicate_post_copydate","","yes");
INSERT INTO ayv_options VALUES("601","duplicate_post_blacklist","","yes");
INSERT INTO ayv_options VALUES("602","duplicate_post_title_prefix","","yes");
INSERT INTO ayv_options VALUES("603","duplicate_post_title_suffix","","yes");
INSERT INTO ayv_options VALUES("604","duplicate_post_roles","a:2:{i:0;s:13:\"administrator\";i:1;s:6:\"editor\";}","yes");
INSERT INTO ayv_options VALUES("613","acf_version","4.4.6","yes");
INSERT INTO ayv_options VALUES("3065","theme_mods_twentysixteen","a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:2;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1460125093;s:4:\"data\";a:10:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:2:{i:0;s:14:\"recent-posts-2\";i:1;s:12:\"categories-2\";}s:9:\"sidebar-2\";a:1:{i:0;s:10:\"nav_menu-3\";}s:9:\"sidebar-3\";a:0:{}s:18:\"orphaned_widgets_1\";a:1:{i:0;s:6:\"text-2\";}s:18:\"orphaned_widgets_2\";a:0:{}s:18:\"orphaned_widgets_3\";a:1:{i:0;s:10:\"nav_menu-2\";}s:18:\"orphaned_widgets_4\";a:1:{i:0;s:6:\"text-3\";}s:18:\"orphaned_widgets_5\";a:1:{i:0;s:6:\"text-4\";}s:18:\"orphaned_widgets_6\";a:1:{i:0;s:6:\"text-5\";}}}}","yes");
INSERT INTO ayv_options VALUES("3111","wordfence_version","6.0.25","yes");
INSERT INTO ayv_options VALUES("2940","_transient_timeout_wpseo_sitemap_cache_post_1","1457107869","no");
INSERT INTO ayv_options VALUES("2941","_transient_wpseo_sitemap_cache_post_1","<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:image=\"http://www.google.com/schemas/sitemap-image/1.1\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">
	<url>
		<loc>http://www.atelier-yvanvedel.com/actualites/</loc>
		<changefreq>daily</changefreq>
		<priority>1</priority>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/11-eme-salon-de-lhabitat-dales-2015/</loc>
		<lastmod>2015-12-29T19:33:15+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.6</priority>
		<image:image>
			<image:loc>http://www.atelier-yvanvedel.com/wp-content/uploads/2015/12/11eme-salon-habitat.jpg</image:loc>
			<image:caption><![CDATA[11 me Salon de L]]></image:caption>
		</image:image>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/47e-foire-annuelle-dales/</loc>
		<lastmod>2015-12-29T19:31:13+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.6</priority>
		<image:image>
			<image:loc>http://www.atelier-yvanvedel.com/wp-content/uploads/2015/12/Alespo1.png</image:loc>
			<image:caption><![CDATA[47e foire annuelle dAls]]></image:caption>
		</image:image>
	</url>
</urlset>","no");
INSERT INTO ayv_options VALUES("3081","_transient_timeout_yoast_i18n_wordpress-seo_fr_FR","1460212324","no");
INSERT INTO ayv_options VALUES("3082","_transient_yoast_i18n_wordpress-seo_fr_FR","O:8:\"stdClass\":12:{s:2:\"id\";s:1:\"4\";s:4:\"name\";s:15:\"French (France)\";s:4:\"slug\";s:7:\"default\";s:10:\"project_id\";s:1:\"1\";s:6:\"locale\";s:2:\"fr\";s:13:\"current_count\";s:3:\"839\";s:18:\"untranslated_count\";i:0;s:13:\"waiting_count\";i:0;s:11:\"fuzzy_count\";i:0;s:18:\"percent_translated\";i:100;s:9:\"wp_locale\";s:5:\"fr_FR\";s:13:\"last_modified\";s:19:\"2016-03-02 09:39:27\";}","no");
INSERT INTO ayv_options VALUES("1017","cpto_options","a:5:{s:23:\"show_reorder_interfaces\";a:5:{s:4:\"post\";s:4:\"show\";s:10:\"attachment\";s:4:\"show\";s:12:\"vc_grid_item\";s:4:\"show\";s:4:\"team\";s:4:\"show\";s:9:\"portfolio\";s:4:\"show\";}s:8:\"autosort\";s:0:\"\";s:9:\"adminsort\";i:1;s:10:\"capability\";s:4:\"read\";s:21:\"navigation_sort_apply\";i:1;}","yes");
INSERT INTO ayv_options VALUES("1018","CPT_configured","TRUE","yes");
INSERT INTO ayv_options VALUES("2529","_site_transient_timeout_browser_2fd2384a111894d575192d5c4cf5a8cd","1455723149","yes");
INSERT INTO ayv_options VALUES("2530","_site_transient_browser_2fd2384a111894d575192d5c4cf5a8cd","a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"43.0\";s:10:\"update_url\";s:23:\"http://www.firefox.com/\";s:7:\"img_src\";s:50:\"http://s.wordpress.org/images/browsers/firefox.png\";s:11:\"img_src_ssl\";s:49:\"https://wordpress.org/images/browsers/firefox.png\";s:15:\"current_version\";s:2:\"16\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO ayv_options VALUES("1890","_transient_timeout_feed_mod_96281909e104f3c547a3bba0b6d36ad5","1452748388","no");
INSERT INTO ayv_options VALUES("1891","_transient_feed_mod_96281909e104f3c547a3bba0b6d36ad5","1452705188","no");
INSERT INTO ayv_options VALUES("1093","sm_status","O:28:\"GoogleSitemapGeneratorStatus\":4:{s:39:\"\0GoogleSitemapGeneratorStatus\0startTime\";d:1450966501.228898;s:37:\"\0GoogleSitemapGeneratorStatus\0endTime\";d:1450966501.483094;s:41:\"\0GoogleSitemapGeneratorStatus\0pingResults\";a:2:{s:6:\"google\";a:5:{s:9:\"startTime\";d:1450966501.2301061;s:7:\"endTime\";d:1450966501.2582581;s:7:\"success\";b:1;s:3:\"url\";s:107:\"http://www.google.com/webmasters/sitemaps/ping?sitemap=http%3A%2F%2Fwww.atelier-yvanvedel.com%2Fsitemap.xml\";s:4:\"name\";s:6:\"Google\";}s:4:\"bing\";a:5:{s:9:\"startTime\";d:1450966501.258914;s:7:\"endTime\";d:1450966501.4796219;s:7:\"success\";b:1;s:3:\"url\";s:100:\"http://www.bing.com/webmaster/ping.aspx?siteMap=http%3A%2F%2Fwww.atelier-yvanvedel.com%2Fsitemap.xml\";s:4:\"name\";s:4:\"Bing\";}}s:38:\"\0GoogleSitemapGeneratorStatus\0autoSave\";b:1;}","no");
INSERT INTO ayv_options VALUES("3115","wps_live_traffic_entries","4","yes");
INSERT INTO ayv_options VALUES("3077","_site_transient_update_themes","O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1460364392;s:7:\"checked\";a:4:{s:10:\"constructo\";s:3:\"1.0\";s:13:\"twentyfifteen\";s:3:\"1.4\";s:14:\"twentyfourteen\";s:3:\"1.6\";s:13:\"twentysixteen\";s:3:\"1.1\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}}","yes");
INSERT INTO ayv_options VALUES("3112","wordfenceActivated","1","yes");
INSERT INTO ayv_options VALUES("3113","wf_plugin_act_error","","yes");
INSERT INTO ayv_options VALUES("1758","auto_core_update_notified","a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:28:\"atelier-yvan.vedel@orange.fr\";s:7:\"version\";s:5:\"4.4.2\";s:9:\"timestamp\";i:1454438798;}","yes");
INSERT INTO ayv_options VALUES("3125","_site_transient_update_plugins","O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1460364405;s:7:\"checked\";a:15:{s:26:\"wp-security-scan/index.php\";s:5:\"4.0.5\";s:30:\"advanced-custom-fields/acf.php\";s:5:\"4.4.6\";s:19:\"akismet/akismet.php\";s:6:\"3.1.10\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:5:\"4.4.1\";s:33:\"duplicate-post/duplicate-post.php\";s:3:\"2.6\";s:31:\"easy-swipebox/easy-swipebox.php\";s:5:\"1.1.0\";s:32:\"wp-flexible-map/flexible-map.php\";s:6:\"1.10.1\";s:48:\"wp-flexible-map-options/flexible-map-options.php\";s:5:\"1.0.3\";s:39:\"gallery-slideshow/gallery-slideshow.php\";s:5:\"1.3.1\";s:9:\"hello.php\";s:3:\"1.6\";s:37:\"post-types-order/post-types-order.php\";s:5:\"1.8.6\";s:23:\"revslider/revslider.php\";s:5:\"2.3.3\";s:23:\"wordfence/wordfence.php\";s:6:\"6.0.25\";s:27:\"js_composer/js_composer.php\";s:7:\"4.8.0.1\";s:24:\"wordpress-seo/wp-seo.php\";s:5:\"3.1.2\";}s:8:\"response\";a:1:{s:27:\"js_composer/js_composer.php\";O:8:\"stdClass\":5:{s:4:\"slug\";s:11:\"js_composer\";s:11:\"new_version\";s:6:\"4.11.1\";s:3:\"url\";s:0:\"\";s:7:\"package\";s:0:\"\";s:4:\"name\";s:24:\"WPBakery Visual Composer\";}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:13:{s:26:\"wp-security-scan/index.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"2821\";s:4:\"slug\";s:16:\"wp-security-scan\";s:6:\"plugin\";s:26:\"wp-security-scan/index.php\";s:11:\"new_version\";s:5:\"4.0.5\";s:3:\"url\";s:47:\"https://wordpress.org/plugins/wp-security-scan/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/wp-security-scan.zip\";}s:30:\"advanced-custom-fields/acf.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"21367\";s:4:\"slug\";s:22:\"advanced-custom-fields\";s:6:\"plugin\";s:30:\"advanced-custom-fields/acf.php\";s:11:\"new_version\";s:5:\"4.4.6\";s:3:\"url\";s:53:\"https://wordpress.org/plugins/advanced-custom-fields/\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/plugin/advanced-custom-fields.4.4.6.zip\";}s:19:\"akismet/akismet.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:2:\"15\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:6:\"3.1.10\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:57:\"https://downloads.wordpress.org/plugin/akismet.3.1.10.zip\";}s:36:\"contact-form-7/wp-contact-form-7.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:3:\"790\";s:4:\"slug\";s:14:\"contact-form-7\";s:6:\"plugin\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"new_version\";s:5:\"4.4.1\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.4.1.zip\";}s:33:\"duplicate-post/duplicate-post.php\";O:8:\"stdClass\":7:{s:2:\"id\";s:4:\"1295\";s:4:\"slug\";s:14:\"duplicate-post\";s:6:\"plugin\";s:33:\"duplicate-post/duplicate-post.php\";s:11:\"new_version\";s:3:\"2.6\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/duplicate-post/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/duplicate-post.2.6.zip\";s:14:\"upgrade_notice\";s:90:\"PHP 5.4 (Strict Standards) compatible + Fixed possible XSS and SQL injections + other bugs\";}s:31:\"easy-swipebox/easy-swipebox.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"56925\";s:4:\"slug\";s:13:\"easy-swipebox\";s:6:\"plugin\";s:31:\"easy-swipebox/easy-swipebox.php\";s:11:\"new_version\";s:5:\"1.1.0\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/easy-swipebox/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/easy-swipebox.1.1.0.zip\";}s:32:\"wp-flexible-map/flexible-map.php\";O:8:\"stdClass\":7:{s:2:\"id\";s:5:\"28316\";s:4:\"slug\";s:15:\"wp-flexible-map\";s:6:\"plugin\";s:32:\"wp-flexible-map/flexible-map.php\";s:11:\"new_version\";s:6:\"1.10.1\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/wp-flexible-map/\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/plugin/wp-flexible-map.1.10.1.zip\";s:14:\"upgrade_notice\";s:131:\"fix NextGEN Gallery breaking localisation of maps; bump version of Google Maps API to 3.22; update translations de_DE, nb_NO, nl_NL\";}s:48:\"wp-flexible-map-options/flexible-map-options.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"46689\";s:4:\"slug\";s:23:\"wp-flexible-map-options\";s:6:\"plugin\";s:48:\"wp-flexible-map-options/flexible-map-options.php\";s:11:\"new_version\";s:5:\"1.0.3\";s:3:\"url\";s:54:\"https://wordpress.org/plugins/wp-flexible-map-options/\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/plugin/wp-flexible-map-options.1.0.3.zip\";}s:39:\"gallery-slideshow/gallery-slideshow.php\";O:8:\"stdClass\":7:{s:2:\"id\";s:5:\"44499\";s:4:\"slug\";s:17:\"gallery-slideshow\";s:6:\"plugin\";s:39:\"gallery-slideshow/gallery-slideshow.php\";s:11:\"new_version\";s:5:\"1.3.1\";s:3:\"url\";s:48:\"https://wordpress.org/plugins/gallery-slideshow/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/gallery-slideshow.1.3.1.zip\";s:14:\"upgrade_notice\";s:56:\"Fixed header bug from version 1.3 uploaded to WordPress.\";}s:9:\"hello.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"3564\";s:4:\"slug\";s:11:\"hello-dolly\";s:6:\"plugin\";s:9:\"hello.php\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/hello-dolly/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/hello-dolly.1.6.zip\";}s:37:\"post-types-order/post-types-order.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"17292\";s:4:\"slug\";s:16:\"post-types-order\";s:6:\"plugin\";s:37:\"post-types-order/post-types-order.php\";s:11:\"new_version\";s:5:\"1.8.6\";s:3:\"url\";s:47:\"https://wordpress.org/plugins/post-types-order/\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/plugin/post-types-order.1.8.6.zip\";}s:23:\"wordfence/wordfence.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"25305\";s:4:\"slug\";s:9:\"wordfence\";s:6:\"plugin\";s:23:\"wordfence/wordfence.php\";s:11:\"new_version\";s:6:\"6.0.25\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/wordfence/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/wordfence.6.0.25.zip\";}s:24:\"wordpress-seo/wp-seo.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"5899\";s:4:\"slug\";s:13:\"wordpress-seo\";s:6:\"plugin\";s:24:\"wordpress-seo/wp-seo.php\";s:11:\"new_version\";s:5:\"3.1.2\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/wordpress-seo/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.3.1.2.zip\";}}}","yes");
INSERT INTO ayv_options VALUES("1115","wpseo_dismiss_recalculate","1","yes");
INSERT INTO ayv_options VALUES("1087","sm_options","a:51:{s:18:\"sm_b_prio_provider\";s:41:\"GoogleSitemapGeneratorPrioByCountProvider\";s:9:\"sm_b_ping\";b:1;s:10:\"sm_b_stats\";b:0;s:12:\"sm_b_pingmsn\";b:1;s:12:\"sm_b_autozip\";b:1;s:11:\"sm_b_memory\";s:0:\"\";s:9:\"sm_b_time\";i:-1;s:18:\"sm_b_style_default\";b:1;s:10:\"sm_b_style\";s:0:\"\";s:12:\"sm_b_baseurl\";s:0:\"\";s:11:\"sm_b_robots\";b:1;s:9:\"sm_b_html\";b:1;s:12:\"sm_b_exclude\";a:0:{}s:17:\"sm_b_exclude_cats\";a:0:{}s:10:\"sm_in_home\";b:1;s:11:\"sm_in_posts\";b:1;s:15:\"sm_in_posts_sub\";b:0;s:11:\"sm_in_pages\";b:1;s:10:\"sm_in_cats\";b:0;s:10:\"sm_in_arch\";b:0;s:10:\"sm_in_auth\";b:0;s:10:\"sm_in_tags\";b:0;s:9:\"sm_in_tax\";a:0:{}s:17:\"sm_in_customtypes\";a:0:{}s:13:\"sm_in_lastmod\";b:1;s:10:\"sm_cf_home\";s:5:\"daily\";s:11:\"sm_cf_posts\";s:7:\"monthly\";s:11:\"sm_cf_pages\";s:6:\"weekly\";s:10:\"sm_cf_cats\";s:6:\"weekly\";s:10:\"sm_cf_auth\";s:6:\"weekly\";s:15:\"sm_cf_arch_curr\";s:5:\"daily\";s:14:\"sm_cf_arch_old\";s:6:\"yearly\";s:10:\"sm_cf_tags\";s:6:\"weekly\";s:10:\"sm_pr_home\";d:1;s:11:\"sm_pr_posts\";d:0.59999999999999998;s:15:\"sm_pr_posts_min\";d:0.20000000000000001;s:11:\"sm_pr_pages\";d:0.59999999999999998;s:10:\"sm_pr_cats\";d:0.29999999999999999;s:10:\"sm_pr_arch\";d:0.29999999999999999;s:10:\"sm_pr_auth\";d:0.29999999999999999;s:10:\"sm_pr_tags\";d:0.29999999999999999;s:12:\"sm_i_donated\";b:0;s:17:\"sm_i_hide_donated\";b:0;s:17:\"sm_i_install_date\";i:1450962800;s:14:\"sm_i_hide_note\";b:0;s:15:\"sm_i_hide_works\";b:0;s:16:\"sm_i_hide_donors\";b:0;s:9:\"sm_i_hash\";s:20:\"3c1567bc113b22e563ff\";s:13:\"sm_i_lastping\";i:1450966501;s:16:\"sm_i_supportfeed\";b:1;s:22:\"sm_i_supportfeed_cache\";i:1450966501;}","yes");
INSERT INTO ayv_options VALUES("1088","_transient_timeout_feed_08a9370cca8e4bda25c11f8557e93830","1451567600","no");
INSERT INTO ayv_options VALUES("1089","_transient_feed_08a9370cca8e4bda25c11f8557e93830","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"
\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:23:\"
	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"Google Sitemap Generator Support Topics\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"Google Sitemap Generator Support Topics\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"http://www.arnebrachhold.de/projects/wordpress-plugins/google-xml-sitemaps-generator/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"Wed, 02 Jul 2014 7:54:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:3:{i:0;a:6:{s:4:\"data\";s:19:\"
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:4:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"Common error messages in Google Webmaster Tools\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"http://www.arnebrachhold.de/redir/sitemap-feed-gwterrs/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"C2VZYxeTESzcCF2IhS13\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 28 Apr 2014 00:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:19:\"
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:4:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"How to move your sitemap to the root of your domain\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"http://www.arnebrachhold.de/redir/sitemap-feed-movesm/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"C2VZYxeTESzcCF2IhS12\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 27 Apr 2014 00:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:19:\"
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:4:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"Introducing a new format for your sitemap\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"http://www.arnebrachhold.de/redir/sitemap-feed-newformat/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"C2VZYxeTESzcCF2IhS1l\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 26 Apr 2014 00:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:11:{s:4:\"date\";s:29:\"Thu, 24 Dec 2015 13:13:20 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=utf-8\";s:10:\"connection\";s:5:\"close\";s:10:\"set-cookie\";s:133:\"__cfduid=dd25264ad2f16bf3490a32d20cc76d1fe1450962800; expires=Fri, 23-Dec-16 13:13:20 GMT; path=/; domain=.arnebrachhold.de; HttpOnly\";s:13:\"cache-control\";s:21:\"public, max-age=86400\";s:13:\"last-modified\";s:29:\"Wed, 02 Jul 2014 19:54:35 GMT\";s:4:\"etag\";s:32:\"d1272b2e516d060d6085f9129217af7c\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:16:\"content-encoding\";s:4:\"gzip\";s:6:\"server\";s:16:\"cloudflare-nginx\";s:6:\"cf-ray\";s:20:\"259c901f70541503-CDG\";}s:5:\"build\";s:14:\"20151224103522\";}","no");
INSERT INTO ayv_options VALUES("1090","_transient_timeout_feed_mod_08a9370cca8e4bda25c11f8557e93830","1451567600","no");
INSERT INTO ayv_options VALUES("1091","_transient_feed_mod_08a9370cca8e4bda25c11f8557e93830","1450962800","no");
INSERT INTO ayv_options VALUES("1097","wpseo","a:21:{s:14:\"blocking_files\";a:0:{}s:26:\"ignore_blog_public_warning\";b:0;s:31:\"ignore_meta_description_warning\";b:0;s:20:\"ignore_page_comments\";b:0;s:16:\"ignore_permalink\";b:0;s:15:\"ms_defaults_set\";b:0;s:23:\"theme_description_found\";s:0:\"\";s:21:\"theme_has_description\";b:0;s:7:\"version\";s:5:\"3.1.2\";s:11:\"alexaverify\";s:0:\"\";s:12:\"company_logo\";s:0:\"\";s:12:\"company_name\";s:0:\"\";s:17:\"company_or_person\";s:0:\"\";s:20:\"disableadvanced_meta\";b:1;s:19:\"onpage_indexability\";b:1;s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:12:\"website_name\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";}","yes");
INSERT INTO ayv_options VALUES("1098","wpseo_permalinks","a:13:{s:15:\"cleanpermalinks\";b:0;s:24:\"cleanpermalink-extravars\";s:0:\"\";s:29:\"cleanpermalink-googlecampaign\";b:0;s:31:\"cleanpermalink-googlesitesearch\";b:0;s:15:\"cleanreplytocom\";b:0;s:10:\"cleanslugs\";b:1;s:14:\"hide-feedlinks\";b:0;s:12:\"hide-rsdlink\";b:0;s:14:\"hide-shortlink\";b:0;s:16:\"hide-wlwmanifest\";b:0;s:18:\"redirectattachment\";b:0;s:17:\"stripcategorybase\";b:0;s:13:\"trailingslash\";b:0;}","yes");
INSERT INTO ayv_options VALUES("1099","wpseo_titles","a:81:{s:10:\"title_test\";i:0;s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:5:\"noodp\";b:0;s:6:\"noydir\";b:0;s:15:\"usemetakeywords\";b:0;s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, Auteur  %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:65:\"Vous avez cherch %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:44:\"La page est introuvable %%sep%% %%sitename%%\";s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:18:\"metakey-home-wpseo\";s:0:\"\";s:20:\"metakey-author-wpseo\";s:0:\"\";s:22:\"noindex-subpages-wpseo\";b:0;s:20:\"noindex-author-wpseo\";b:0;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"metakey-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:13:\"showdate-post\";b:0;s:16:\"hideeditbox-post\";b:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"metakey-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:13:\"showdate-page\";b:0;s:16:\"hideeditbox-page\";b:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"metakey-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:19:\"showdate-attachment\";b:0;s:22:\"hideeditbox-attachment\";b:0;s:10:\"title-team\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-team\";s:0:\"\";s:12:\"metakey-team\";s:0:\"\";s:12:\"noindex-team\";b:0;s:13:\"showdate-team\";b:0;s:16:\"hideeditbox-team\";b:0;s:15:\"title-portfolio\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:18:\"metadesc-portfolio\";s:0:\"\";s:17:\"metakey-portfolio\";s:0:\"\";s:17:\"noindex-portfolio\";b:0;s:18:\"showdate-portfolio\";b:0;s:21:\"hideeditbox-portfolio\";b:0;s:18:\"title-tax-category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:20:\"metakey-tax-category\";s:0:\"\";s:24:\"hideeditbox-tax-category\";b:0;s:20:\"noindex-tax-category\";b:0;s:18:\"title-tax-post_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:20:\"metakey-tax-post_tag\";s:0:\"\";s:24:\"hideeditbox-tax-post_tag\";b:0;s:20:\"noindex-tax-post_tag\";b:0;s:21:\"title-tax-post_format\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:23:\"metakey-tax-post_format\";s:0:\"\";s:27:\"hideeditbox-tax-post_format\";b:0;s:23:\"noindex-tax-post_format\";b:1;s:19:\"title-tax-team_tags\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:22:\"metadesc-tax-team_tags\";s:0:\"\";s:21:\"metakey-tax-team_tags\";s:0:\"\";s:25:\"hideeditbox-tax-team_tags\";b:0;s:21:\"noindex-tax-team_tags\";b:0;s:23:\"title-tax-team_category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-tax-team_category\";s:0:\"\";s:25:\"metakey-tax-team_category\";s:0:\"\";s:29:\"hideeditbox-tax-team_category\";b:0;s:25:\"noindex-tax-team_category\";b:0;s:28:\"title-tax-portfolio_category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:31:\"metadesc-tax-portfolio_category\";s:0:\"\";s:30:\"metakey-tax-portfolio_category\";s:0:\"\";s:34:\"hideeditbox-tax-portfolio_category\";b:0;s:30:\"noindex-tax-portfolio_category\";b:0;}","yes");
INSERT INTO ayv_options VALUES("1100","wpseo_social","a:21:{s:9:\"fb_admins\";a:0:{}s:12:\"fbconnectkey\";s:32:\"605b8ae4c9e911d2004349771bb00621\";s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:9:\"opengraph\";b:1;s:10:\"googleplus\";b:0;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:14:\"plus-publisher\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:7:\"summary\";s:11:\"youtube_url\";s:0:\"\";s:15:\"google_plus_url\";s:0:\"\";s:10:\"fbadminapp\";s:0:\"\";}","yes");
INSERT INTO ayv_options VALUES("1101","wpseo_rss","a:2:{s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:64:\"Cet article %%POSTLINK%% est apparu en premier sur %%BLOGLINK%%.\";}","yes");
INSERT INTO ayv_options VALUES("1102","wpseo_internallinks","a:15:{s:20:\"breadcrumbs-404crumb\";s:28:\"Erreur 404: Page introuvable\";s:23:\"breadcrumbs-blog-remove\";b:0;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:13:\"Archives pour\";s:18:\"breadcrumbs-enable\";b:0;s:16:\"breadcrumbs-home\";s:7:\"Accueil\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:18:\"Vous avez cherch\";s:15:\"breadcrumbs-sep\";s:7:\"&raquo;\";s:23:\"post_types-post-maintax\";i:0;s:23:\"post_types-team-maintax\";i:0;s:28:\"post_types-portfolio-maintax\";i:0;s:27:\"taxonomy-team_tags-ptparent\";i:0;s:31:\"taxonomy-team_category-ptparent\";i:0;s:36:\"taxonomy-portfolio_category-ptparent\";i:0;}","yes");
INSERT INTO ayv_options VALUES("1103","wpseo_xml","a:21:{s:22:\"disable_author_sitemap\";b:1;s:22:\"disable_author_noposts\";b:1;s:16:\"enablexmlsitemap\";b:1;s:16:\"entries-per-page\";i:1000;s:14:\"excluded-posts\";s:0:\"\";s:38:\"user_role-administrator-not_in_sitemap\";b:0;s:31:\"user_role-editor-not_in_sitemap\";b:0;s:31:\"user_role-author-not_in_sitemap\";b:0;s:36:\"user_role-contributor-not_in_sitemap\";b:0;s:35:\"user_role-subscriber-not_in_sitemap\";b:0;s:30:\"post_types-post-not_in_sitemap\";b:0;s:30:\"post_types-page-not_in_sitemap\";b:0;s:36:\"post_types-attachment-not_in_sitemap\";b:1;s:34:\"taxonomies-category-not_in_sitemap\";b:0;s:34:\"taxonomies-post_tag-not_in_sitemap\";b:0;s:37:\"taxonomies-post_format-not_in_sitemap\";b:0;s:30:\"post_types-team-not_in_sitemap\";b:0;s:35:\"post_types-portfolio-not_in_sitemap\";b:0;s:35:\"taxonomies-team_tags-not_in_sitemap\";b:0;s:39:\"taxonomies-team_category-not_in_sitemap\";b:0;s:44:\"taxonomies-portfolio_category-not_in_sitemap\";b:0;}","yes");
INSERT INTO ayv_options VALUES("2106","_site_transient_timeout_browser_6d44eab61dcf5b1f0e6fa8f6595ee1bc","1454139212","yes");
INSERT INTO ayv_options VALUES("2107","_site_transient_browser_6d44eab61dcf5b1f0e6fa8f6595ee1bc","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:17:\"Internet Explorer\";s:7:\"version\";s:2:\"11\";s:10:\"update_url\";s:51:\"http://www.microsoft.com/windows/internet-explorer/\";s:7:\"img_src\";s:45:\"http://s.wordpress.org/images/browsers/ie.png\";s:11:\"img_src_ssl\";s:44:\"https://wordpress.org/images/browsers/ie.png\";s:15:\"current_version\";s:1:\"9\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO ayv_options VALUES("2919","_transient_timeout_wpseo_sitemap_cache_portfolio_category_1","1457002955","no");
INSERT INTO ayv_options VALUES("2510","_site_transient_timeout_wordpress_credits_fr_FR","1455169997","yes");
INSERT INTO ayv_options VALUES("3020","_transient_timeout_wpseo_sitemap_cache_page_1","1457491032","no");
INSERT INTO ayv_options VALUES("3021","_transient_wpseo_sitemap_cache_page_1","<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:image=\"http://www.google.com/schemas/sitemap-image/1.1\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">
	<url>
		<loc>http://www.atelier-yvanvedel.com/qui-sommes-nous/</loc>
		<lastmod>2015-12-31T16:26:10+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.8</priority>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/</loc>
		<lastmod>2015-12-29T19:49:33+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>1</priority>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/actualites/</loc>
		<lastmod>2015-11-06T15:20:45+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.8</priority>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/erreur-404/</loc>
		<lastmod>2015-11-03T10:04:08+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.8</priority>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/contact/</loc>
		<lastmod>2015-12-31T16:36:58+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.8</priority>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/nos-realisations/</loc>
		<lastmod>2015-12-22T15:51:06+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.8</priority>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/nos-realisations/cuisines-contemporaines/</loc>
		<lastmod>2015-12-29T19:56:33+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.6</priority>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/nos-realisations/cuisines-rustiques-et-provencales/</loc>
		<lastmod>2015-12-31T15:45:35+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.6</priority>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/nos-realisations/foires-et-salons/</loc>
		<lastmod>2015-12-24T08:16:03+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.6</priority>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/nos-realisations/realisations-diverses/</loc>
		<lastmod>2016-01-03T16:39:14+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.6</priority>
	</url>
</urlset>","no");
INSERT INTO ayv_options VALUES("1139","wpseo_onpage","a:2:{s:6:\"status\";i:0;s:10:\"last_fetch\";i:1460252367;}","yes");
INSERT INTO ayv_options VALUES("1331","site_icon","0","yes");
INSERT INTO ayv_options VALUES("1332","medium_large_size_w","768","yes");
INSERT INTO ayv_options VALUES("1333","medium_large_size_h","0","yes");
INSERT INTO ayv_options VALUES("1334","db_upgraded","","yes");
INSERT INTO ayv_options VALUES("3079","rewrite_rules","a:139:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:49:\"categories/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:44:\"categories/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:37:\"categories/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:19:\"categories/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:51:\"etiquettes/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:46:\"etiquettes/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"etiquettes/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:21:\"etiquettes/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:40:\"vc_grid_item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"vc_grid_item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"vc_grid_item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"vc_grid_item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"vc_grid_item/([^/]+)/embed/?$\";s:45:\"index.php?vc_grid_item=$matches[1]&embed=true\";s:33:\"vc_grid_item/([^/]+)/trackback/?$\";s:39:\"index.php?vc_grid_item=$matches[1]&tb=1\";s:41:\"vc_grid_item/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&paged=$matches[2]\";s:48:\"vc_grid_item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&cpage=$matches[2]\";s:37:\"vc_grid_item/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?vc_grid_item=$matches[1]&page=$matches[2]\";s:29:\"vc_grid_item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"vc_grid_item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"vc_grid_item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"vc_grid_item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"team/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"team/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"team/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"team/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"team/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"team/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:21:\"team/([^/]+)/embed/?$\";s:37:\"index.php?team=$matches[1]&embed=true\";s:25:\"team/([^/]+)/trackback/?$\";s:31:\"index.php?team=$matches[1]&tb=1\";s:33:\"team/([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?team=$matches[1]&paged=$matches[2]\";s:40:\"team/([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?team=$matches[1]&cpage=$matches[2]\";s:29:\"team/([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?team=$matches[1]&page=$matches[2]\";s:21:\"team/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:31:\"team/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:51:\"team/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"team/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"team/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:27:\"team/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:50:\"team_tags/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?team_tags=$matches[1]&feed=$matches[2]\";s:45:\"team_tags/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?team_tags=$matches[1]&feed=$matches[2]\";s:38:\"team_tags/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?team_tags=$matches[1]&paged=$matches[2]\";s:20:\"team_tags/([^/]+)/?$\";s:31:\"index.php?team_tags=$matches[1]\";s:54:\"team_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?team_category=$matches[1]&feed=$matches[2]\";s:49:\"team_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?team_category=$matches[1]&feed=$matches[2]\";s:42:\"team_category/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?team_category=$matches[1]&paged=$matches[2]\";s:24:\"team_category/([^/]+)/?$\";s:35:\"index.php?team_category=$matches[1]\";s:37:\"portfolio/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"portfolio/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"portfolio/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"portfolio/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"portfolio/([^/]+)/embed/?$\";s:35:\"index.php?id=$matches[1]&embed=true\";s:30:\"portfolio/([^/]+)/trackback/?$\";s:29:\"index.php?id=$matches[1]&tb=1\";s:38:\"portfolio/([^/]+)/page/?([0-9]{1,})/?$\";s:42:\"index.php?id=$matches[1]&paged=$matches[2]\";s:45:\"portfolio/([^/]+)/comment-page-([0-9]{1,})/?$\";s:42:\"index.php?id=$matches[1]&cpage=$matches[2]\";s:34:\"portfolio/([^/]+)(?:/([0-9]+))?/?$\";s:41:\"index.php?id=$matches[1]&page=$matches[2]\";s:26:\"portfolio/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"portfolio/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"portfolio/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"portfolio/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"portfolio_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:54:\"portfolio_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:47:\"portfolio_category/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?portfolio_category=$matches[1]&paged=$matches[2]\";s:29:\"portfolio_category/([^/]+)/?$\";s:40:\"index.php?portfolio_category=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=15&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}","yes");
INSERT INTO ayv_options VALUES("3095","_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a","1460374243","yes");
INSERT INTO ayv_options VALUES("3096","_site_transient_poptags_40cd750bba9870f18aada2478b24840a","a:100:{s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";s:4:\"5800\";}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"Post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";s:4:\"3598\";}s:6:\"plugin\";a:3:{s:4:\"name\";s:6:\"plugin\";s:4:\"slug\";s:6:\"plugin\";s:5:\"count\";s:4:\"3560\";}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";s:4:\"3071\";}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";s:4:\"2756\";}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";s:4:\"2287\";}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";s:4:\"2191\";}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";s:4:\"2062\";}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";s:4:\"2009\";}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";s:4:\"1981\";}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";s:4:\"1967\";}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";s:4:\"1922\";}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";s:4:\"1843\";}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"Facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";s:4:\"1654\";}s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";s:4:\"1572\";}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";s:4:\"1549\";}s:9:\"wordpress\";a:3:{s:4:\"name\";s:9:\"wordpress\";s:4:\"slug\";s:9:\"wordpress\";s:5:\"count\";s:4:\"1523\";}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";s:4:\"1351\";}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";s:4:\"1292\";}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";s:4:\"1276\";}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";s:4:\"1194\";}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";s:4:\"1091\";}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";s:4:\"1056\";}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";s:4:\"1002\";}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";s:3:\"965\";}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";s:3:\"949\";}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";s:3:\"909\";}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";s:3:\"901\";}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"AJAX\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";s:3:\"900\";}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";s:3:\"887\";}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";s:3:\"882\";}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";s:3:\"828\";}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";s:3:\"806\";}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";s:3:\"786\";}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";s:3:\"758\";}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";s:3:\"753\";}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";s:3:\"748\";}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";s:3:\"741\";}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";s:3:\"741\";}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";s:3:\"740\";}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"Share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";s:3:\"733\";}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";s:3:\"731\";}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";s:3:\"693\";}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";s:3:\"686\";}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";s:3:\"678\";}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";s:3:\"675\";}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"CSS\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";s:3:\"670\";}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";s:3:\"666\";}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";s:3:\"649\";}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";s:3:\"640\";}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";s:3:\"638\";}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";s:3:\"632\";}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";s:3:\"610\";}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";s:3:\"602\";}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";s:3:\"594\";}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";s:3:\"589\";}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";s:3:\"588\";}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";s:3:\"585\";}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";s:3:\"585\";}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";s:3:\"574\";}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";s:3:\"566\";}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";s:3:\"558\";}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";s:3:\"553\";}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";s:3:\"544\";}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";s:3:\"540\";}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";s:3:\"528\";}s:4:\"list\";a:3:{s:4:\"name\";s:4:\"list\";s:4:\"slug\";s:4:\"list\";s:5:\"count\";s:3:\"524\";}s:7:\"picture\";a:3:{s:4:\"name\";s:7:\"picture\";s:4:\"slug\";s:7:\"picture\";s:5:\"count\";s:3:\"513\";}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";s:3:\"510\";}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";s:3:\"509\";}s:6:\"simple\";a:3:{s:4:\"name\";s:6:\"simple\";s:4:\"slug\";s:6:\"simple\";s:5:\"count\";s:3:\"496\";}s:9:\"multisite\";a:3:{s:4:\"name\";s:9:\"multisite\";s:4:\"slug\";s:9:\"multisite\";s:5:\"count\";s:3:\"496\";}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";s:3:\"494\";}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";s:3:\"486\";}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";s:3:\"469\";}s:8:\"pictures\";a:3:{s:4:\"name\";s:8:\"pictures\";s:4:\"slug\";s:8:\"pictures\";s:5:\"count\";s:3:\"457\";}s:4:\"shop\";a:3:{s:4:\"name\";s:4:\"shop\";s:4:\"slug\";s:4:\"shop\";s:5:\"count\";s:3:\"453\";}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";s:3:\"439\";}s:3:\"url\";a:3:{s:4:\"name\";s:3:\"url\";s:4:\"slug\";s:3:\"url\";s:5:\"count\";s:3:\"439\";}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";s:3:\"437\";}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";s:3:\"437\";}s:4:\"html\";a:3:{s:4:\"name\";s:4:\"html\";s:4:\"slug\";s:4:\"html\";s:5:\"count\";s:3:\"436\";}s:5:\"flash\";a:3:{s:4:\"name\";s:5:\"flash\";s:4:\"slug\";s:5:\"flash\";s:5:\"count\";s:3:\"423\";}s:4:\"meta\";a:3:{s:4:\"name\";s:4:\"meta\";s:4:\"slug\";s:4:\"meta\";s:5:\"count\";s:3:\"418\";}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";s:3:\"415\";}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";s:3:\"414\";}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";s:3:\"410\";}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";s:3:\"407\";}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"News\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";s:3:\"405\";}s:3:\"tag\";a:3:{s:4:\"name\";s:3:\"tag\";s:4:\"slug\";s:3:\"tag\";s:5:\"count\";s:3:\"405\";}s:11:\"advertising\";a:3:{s:4:\"name\";s:11:\"advertising\";s:4:\"slug\";s:11:\"advertising\";s:5:\"count\";s:3:\"399\";}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";s:3:\"396\";}s:9:\"thumbnail\";a:3:{s:4:\"name\";s:9:\"thumbnail\";s:4:\"slug\";s:9:\"thumbnail\";s:5:\"count\";s:3:\"392\";}s:7:\"sharing\";a:3:{s:4:\"name\";s:7:\"sharing\";s:4:\"slug\";s:7:\"sharing\";s:5:\"count\";s:3:\"388\";}s:6:\"upload\";a:3:{s:4:\"name\";s:6:\"upload\";s:4:\"slug\";s:6:\"upload\";s:5:\"count\";s:3:\"388\";}s:6:\"paypal\";a:3:{s:4:\"name\";s:6:\"paypal\";s:4:\"slug\";s:6:\"paypal\";s:5:\"count\";s:3:\"388\";}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";s:3:\"388\";}s:4:\"text\";a:3:{s:4:\"name\";s:4:\"text\";s:4:\"slug\";s:4:\"text\";s:5:\"count\";s:3:\"388\";}s:4:\"code\";a:3:{s:4:\"name\";s:4:\"code\";s:4:\"slug\";s:4:\"code\";s:5:\"count\";s:3:\"386\";}s:8:\"lightbox\";a:3:{s:4:\"name\";s:8:\"lightbox\";s:4:\"slug\";s:8:\"lightbox\";s:5:\"count\";s:3:\"384\";}}","yes");
INSERT INTO ayv_options VALUES("1340","can_compress_scripts","0","yes");
INSERT INTO ayv_options VALUES("3107","wps_plugin_wp_scan","a:5:{s:10:\"SCAN_STATE\";i:3;s:13:\"SCAN_PROGRESS\";i:0;s:11:\"SCAN_RESULT\";i:2;s:9:\"SCAN_TYPE\";i:0;s:7:\"SCAN_ID\";i:0;}","yes");
INSERT INTO ayv_options VALUES("3106","wps_plugin_settings","a:13:{s:17:\"fix_hideWpVersion\";a:3:{s:4:\"name\";s:17:\"fix_hideWpVersion\";s:5:\"value\";i:0;s:4:\"desc\";s:55:\"Hide WordPress version for all users but administrators\";}s:34:\"fix_removeWpMetaGeneratorsFrontend\";a:3:{s:4:\"name\";s:34:\"fix_removeWpMetaGeneratorsFrontend\";s:5:\"value\";i:0;s:4:\"desc\";s:83:\"Remove various meta tags generators from the blog\'s head tag for non-administrators\";}s:31:\"fix_removeReallySimpleDiscovery\";a:3:{s:4:\"name\";s:31:\"fix_removeReallySimpleDiscovery\";s:5:\"value\";i:0;s:4:\"desc\";s:55:\"Remove Really Simple Discovery meta tags from front-end\";}s:27:\"fix_removeWindowsLiveWriter\";a:3:{s:4:\"name\";s:27:\"fix_removeWindowsLiveWriter\";s:5:\"value\";i:0;s:4:\"desc\";s:51:\"Remove Windows Live Writer meta tags from front-end\";}s:25:\"fix_disableErrorReporting\";a:3:{s:4:\"name\";s:25:\"fix_disableErrorReporting\";s:5:\"value\";i:0;s:4:\"desc\";s:61:\"Disable error reporting (php + db) for all but administrators\";}s:32:\"fix_removeCoreUpdateNotification\";a:3:{s:4:\"name\";s:32:\"fix_removeCoreUpdateNotification\";s:5:\"value\";i:0;s:4:\"desc\";s:73:\"Remove core update notifications from back-end for all but administrators\";}s:35:\"fix_removePluginUpdateNotifications\";a:3:{s:4:\"name\";s:35:\"fix_removePluginUpdateNotifications\";s:5:\"value\";i:0;s:4:\"desc\";s:50:\"Remove plug-ins update notifications from back-end\";}s:34:\"fix_removeThemeUpdateNotifications\";a:3:{s:4:\"name\";s:34:\"fix_removeThemeUpdateNotifications\";s:5:\"value\";i:0;s:4:\"desc\";s:48:\"Remove themes update notifications from back-end\";}s:41:\"fix_removeLoginErrorNotificationsFrontEnd\";a:3:{s:4:\"name\";s:41:\"fix_removeLoginErrorNotificationsFrontEnd\";s:5:\"value\";i:0;s:4:\"desc\";s:47:\"Remove login error notifications from front-end\";}s:26:\"fix_hideAdminNotifications\";a:3:{s:4:\"name\";s:26:\"fix_hideAdminNotifications\";s:5:\"value\";i:0;s:4:\"desc\";s:39:\"Hide admin notifications for non admins\";}s:27:\"fix_preventDirectoryListing\";a:3:{s:4:\"name\";s:27:\"fix_preventDirectoryListing\";s:5:\"value\";i:0;s:4:\"desc\";s:153:\"Try to create the index.php file in the wp-content, wp-content/plugins, wp-content/themes and wp-content/uploads directories to prevent directory listing\";}s:28:\"fix_removeWpVersionFromLinks\";a:3:{s:4:\"name\";s:28:\"fix_removeWpVersionFromLinks\";s:5:\"value\";i:0;s:4:\"desc\";s:38:\"Remove the version parameter from urls\";}s:27:\"fix_emptyReadmeFileFromRoot\";a:3:{s:4:\"name\";s:27:\"fix_emptyReadmeFileFromRoot\";s:5:\"value\";i:0;s:4:\"desc\";s:65:\"Empty the content of the readme.html file from the root directory\";}}","yes");
INSERT INTO ayv_options VALUES("2511","_site_transient_wordpress_credits_fr_FR","a:2:{s:6:\"groups\";a:8:{s:15:\"project-leaders\";a:4:{s:4:\"name\";s:15:\"Project Leaders\";s:4:\"type\";s:6:\"titles\";s:7:\"shuffle\";b:1;s:4:\"data\";a:6:{s:4:\"matt\";a:4:{i:0;s:14:\"Matt Mullenweg\";i:1;s:32:\"767fc9c115a1b989744c755db47feb60\";i:2;s:4:\"matt\";i:3;s:23:\"Cofounder, Project Lead\";}s:5:\"nacin\";a:4:{i:0;s:12:\"Andrew Nacin\";i:1;s:32:\"01cfe9feaafb068590891bbd1f6a7f5a\";i:2;s:5:\"nacin\";i:3;s:14:\"Lead Developer\";}s:11:\"markjaquith\";a:4:{i:0;s:12:\"Mark Jaquith\";i:1;s:32:\"097a87a525e317519b5ee124820012fb\";i:2;s:11:\"markjaquith\";i:3;s:14:\"Lead Developer\";}s:6:\"azaozz\";a:4:{i:0;s:10:\"Andrew Ozz\";i:1;s:32:\"4e84843ebff0918d72ade21c6ee7b1e4\";i:2;s:6:\"azaozz\";i:3;s:14:\"Lead Developer\";}s:5:\"helen\";a:4:{i:0;s:16:\"Helen Hou-Sand\";i:1;s:32:\"6506162ada6b700b151ad8a187f65842\";i:2;s:5:\"helen\";i:3;s:14:\"Lead Developer\";}s:4:\"dd32\";a:4:{i:0;s:10:\"Dion Hulse\";i:1;s:32:\"4af2825655b46fb1206b08d9041d8e3e\";i:2;s:4:\"dd32\";i:3;s:14:\"Lead Developer\";}}}s:15:\"core-developers\";a:4:{s:4:\"name\";s:23:\"Contributing Developers\";s:4:\"type\";s:6:\"titles\";s:7:\"shuffle\";b:0;s:4:\"data\";a:9:{s:14:\"wonderboymusic\";a:4:{i:0;s:12:\"Scott Taylor\";i:1;s:32:\"112ca15732a80bb928c52caec9d2c8dd\";i:2;s:14:\"wonderboymusic\";i:3;s:12:\"Release Lead\";}s:7:\"ocean90\";a:4:{i:0;s:17:\"Dominik Schilling\";i:1;s:32:\"3e8e161d97d793bd8fc2dcd62583bb76\";i:2;s:7:\"ocean90\";i:3;s:14:\"Core Developer\";}s:14:\"SergeyBiryukov\";a:4:{i:0;s:15:\"Sergey Biryukov\";i:1;s:32:\"750b7b0fcd855389264c2b1294d61bd6\";i:2;s:14:\"SergeyBiryukov\";i:3;s:14:\"Core Developer\";}s:12:\"boonebgorges\";a:4:{i:0;s:15:\"Boone B. Gorges\";i:1;s:32:\"9cf7c4541a582729a5fc7ae484786c0c\";i:2;s:12:\"boonebgorges\";i:3;s:14:\"Core Developer\";}s:5:\"pento\";a:4:{i:0;s:15:\"Gary Pendergast\";i:1;s:32:\"1ad9e5c98d81c6815a65dab5b6e1f669\";i:2;s:5:\"pento\";i:3;s:14:\"Core Developer\";}s:11:\"johnbillion\";a:4:{i:0;s:15:\"John Blackbourn\";i:1;s:32:\"0000ba6dd1b089e1746abbfe6281ee3b\";i:2;s:11:\"johnbillion\";i:3;s:14:\"Core Developer\";}s:12:\"DrewAPicture\";a:4:{i:0;s:11:\"Drew Jaynes\";i:1;s:32:\"95c934fa2c3362794bf62ff8c59ada08\";i:2;s:12:\"DrewAPicture\";i:3;s:14:\"Core Developer\";}s:10:\"jeremyfelt\";a:4:{i:0;s:11:\"Jeremy Felt\";i:1;s:32:\"d1759b1c669981b7c52ec9a97d19e6bd\";i:2;s:10:\"jeremyfelt\";i:3;s:14:\"Core Developer\";}s:6:\"jorbin\";a:4:{i:0;s:12:\"Aaron Jorbin\";i:1;s:32:\"b3e2b94eb305bf95a1bee11bc7705fb7\";i:2;s:6:\"jorbin\";i:3;s:14:\"Core Developer\";}}}s:23:\"contributing-developers\";a:4:{s:4:\"name\";b:0;s:4:\"type\";s:6:\"titles\";s:7:\"shuffle\";b:1;s:4:\"data\";a:6:{s:8:\"obenland\";a:4:{i:0;s:19:\"Konstantin Obenland\";i:1;s:32:\"2370ea5912750f4cb0f3c51ae1cbca55\";i:2;s:8:\"obenland\";i:3;s:0:\"\";}s:7:\"iseulde\";a:4:{i:0;s:22:\"Ella Iseulde Van Dorpe\";i:1;s:32:\"a6120816539629cbe193dbd9fde02f79\";i:2;s:7:\"iseulde\";i:3;s:0:\"\";}s:11:\"westonruter\";a:4:{i:0;s:12:\"Weston Ruter\";i:1;s:32:\"22ed378fbf1d918ef43a45b2a1f34634\";i:2;s:11:\"westonruter\";i:3;s:0:\"\";}s:7:\"afercia\";a:4:{i:0;s:13:\"Andrea Fercia\";i:1;s:32:\"074af62ea5ff218b6a6eeab89104f616\";i:2;s:7:\"afercia\";i:3;s:0:\"\";}s:6:\"rmccue\";a:4:{i:0;s:10:\"Ryan McCue\";i:1;s:32:\"08818120f223035a0857c2a0ec417f93\";i:2;s:6:\"rmccue\";i:3;s:0:\"\";}s:10:\"karmatosed\";a:4:{i:0;s:13:\"Tammie Lister\";i:1;s:32:\"ca7d4273a689cdbf524d8332771bb1ca\";i:2;s:10:\"karmatosed\";i:3;s:0:\"\";}}}s:16:\"recent-rockstars\";a:4:{s:4:\"name\";b:0;s:4:\"type\";s:6:\"titles\";s:7:\"shuffle\";b:1;s:4:\"data\";a:13:{s:9:\"chriscct7\";a:4:{i:0;s:15:\"Chris Christoff\";i:1;s:32:\"d0931e57862048dabb0bea3a71ce6229\";i:2;s:9:\"chriscct7\";i:3;s:0:\"\";}s:10:\"swissspidy\";a:4:{i:0;s:15:\"Pascal Birchler\";i:1;s:32:\"609d6ee54dc13a51270cb99769535b82\";i:2;s:10:\"swissspidy\";i:3;s:0:\"\";}s:15:\"danielbachhuber\";a:4:{i:0;s:16:\"Daniel Bachhuber\";i:1;s:32:\"a304ad0084a78fe52f6b93e00871754e\";i:2;s:15:\"danielbachhuber\";i:3;s:0:\"\";}s:11:\"rachelbaker\";a:4:{i:0;s:12:\"Rachel Baker\";i:1;s:32:\"634b37a53babc18a5bda19722d5b41a3\";i:2;s:11:\"rachelbaker\";i:3;s:0:\"\";}s:8:\"joehoyle\";a:4:{i:0;s:9:\"Joe Hoyle\";i:1;s:32:\"0ceb885cc3d306af93c9764b2936d618\";i:2;s:8:\"joehoyle\";i:3;s:0:\"\";}s:5:\"ramiy\";a:4:{i:0;s:14:\"Rami Yushuvaev\";i:1;s:32:\"ce2a269e424156d79cb0c4e1d4d82db1\";i:2;s:5:\"ramiy\";i:3;s:0:\"\";}s:12:\"mikeschroder\";a:4:{i:0;s:13:\"Mike Schroder\";i:1;s:32:\"76424a001dc6b3ebb4faca0c567800c4\";i:2;s:12:\"mikeschroder\";i:3;s:0:\"\";}s:5:\"tevko\";a:4:{i:0;s:8:\"Tim Evko\";i:1;s:32:\"3223dfa38896f09bad075c1515d4f3aa\";i:2;s:5:\"tevko\";i:3;s:0:\"\";}s:14:\"jaspermdegroot\";a:4:{i:0;s:15:\"Jasper de Groot\";i:1;s:32:\"e8170d7574cd649bce2639e24737de88\";i:2;s:14:\"jaspermdegroot\";i:3;s:0:\"\";}s:9:\"joemcgill\";a:4:{i:0;s:10:\"Joe McGill\";i:1;s:32:\"7cef1c9108207ec24db7a40f142db676\";i:2;s:9:\"joemcgill\";i:3;s:0:\"\";}s:5:\"wilto\";a:4:{i:0;s:11:\"Mat Marquis\";i:1;s:32:\"2d087e6ab3f067d53c6cbc2e9b722a62\";i:2;s:5:\"wilto\";i:3;s:0:\"\";}s:10:\"iamtakashi\";a:4:{i:0;s:12:\"Takashi Irie\";i:1;s:32:\"56bae6e12bf9305a0852753e0f557489\";i:2;s:10:\"iamtakashi\";i:3;s:0:\"\";}s:13:\"peterwilsoncc\";a:4:{i:0;s:12:\"Peter Wilson\";i:1;s:32:\"1dd9fded718f9b344d48f37f9bfcb159\";i:2;s:13:\"peterwilsoncc\";i:3;s:0:\"\";}}}s:5:\"props\";a:4:{s:4:\"name\";s:33:\"Core Contributors to WordPress %s\";s:12:\"placeholders\";a:1:{i:0;s:3:\"4.4\";}s:4:\"type\";s:4:\"list\";s:4:\"data\";a:458:{s:7:\"mercime\";s:8:\"@mercime\";s:10:\"a5hleyrich\";s:10:\"A5hleyRich\";s:13:\"aaroncampbell\";s:17:\"Aaron D. Campbell\";s:11:\"aaronrutley\";s:12:\"Aaron Rutley\";s:7:\"kawauso\";s:21:\"Adam Harley (Kawauso)\";s:11:\"adamholisky\";s:11:\"adamholisky\";s:15:\"adamsilverstein\";s:16:\"Adam Silverstein\";s:5:\"aduth\";s:5:\"aduth\";s:12:\"mrahmadawais\";s:11:\"Ahmad Awais\";s:12:\"akibjorklund\";s:13:\"Aki Bjorklund\";s:9:\"albertoct\";s:9:\"AlbertoCT\";s:7:\"gounder\";s:17:\"Alexander Gounder\";s:5:\"akirk\";s:9:\"Alex Kirk\";s:12:\"viper007bond\";s:25:\"Alex Mills (Viper007Bond)\";s:10:\"tellyworth\";s:11:\"Alex Shiels\";s:11:\"alireza1375\";s:11:\"alireza1375\";s:9:\"shedonist\";s:12:\"Amanda Giles\";s:12:\"amereservant\";s:12:\"amereservant\";s:8:\"sabreuse\";s:22:\"Amy Hendrix (sabreuse)\";s:8:\"norcross\";s:15:\"Andrew Norcross\";s:7:\"afragen\";s:11:\"Andy Fragen\";s:8:\"amandato\";s:14:\"Angelo Mandato\";s:18:\"ankitgadertcampcom\";s:10:\"Ankit Gade\";s:13:\"ankit-k-gupta\";s:13:\"Ankit K Gupta\";s:5:\"antpb\";s:16:\"Anthony Burchell\";s:9:\"apkoponen\";s:10:\"ap.koponen\";s:11:\"apokalyptik\";s:11:\"apokalyptik\";s:7:\"athsear\";s:12:\"Athsear\'J.S.\";s:10:\"atomicjack\";s:10:\"atomicjack\";s:12:\"austinginder\";s:13:\"Austin Ginder\";s:8:\"filosofo\";s:13:\"Austin Matzko\";s:11:\"barryceelen\";s:12:\"Barry Ceelen\";s:10:\"barrykooij\";s:11:\"Barry Kooij\";s:7:\"bcworkz\";s:7:\"bcworkz\";s:7:\"bdn3504\";s:7:\"BdN3504\";s:7:\"pixolin\";s:16:\"Bego Mario Garde\";s:12:\"benjaminpick\";s:13:\"Benjamin Pick\";s:7:\"benjmay\";s:7:\"Ben May\";s:12:\"berengerzyla\";s:12:\"berengerzyla\";s:5:\"neoxx\";s:14:\"Bernhard Riedl\";s:9:\"bigdawggi\";s:9:\"bigdawggi\";s:10:\"bilalcoder\";s:10:\"bilalcoder\";s:12:\"binarykitten\";s:12:\"BinaryKitten\";s:7:\"birgire\";s:27:\"Birgir Erlendsson (birgire)\";s:13:\"bjornjohansen\";s:19:\"Bj&#248;rn Johansen\";s:11:\"bobbingwide\";s:11:\"bobbingwide\";s:7:\"gitlost\";s:6:\"bonger\";s:9:\"bradparbs\";s:9:\"bradparbs\";s:5:\"bradt\";s:14:\"Brad Touesnard\";s:12:\"bradyvercher\";s:13:\"Brady Vercher\";s:7:\"kraftbj\";s:13:\"Brandon Kraft\";s:9:\"bravokeyl\";s:9:\"bravokeyl\";s:7:\"brentvr\";s:7:\"brentvr\";s:8:\"brettz95\";s:8:\"brettz95\";s:7:\"mckilem\";s:9:\"Bruno Kos\";s:12:\"crazycoolcam\";s:3:\"Cam\";s:8:\"camikaos\";s:9:\"Cami Kaos\";s:13:\"carolinegeven\";s:13:\"carolinegeven\";s:12:\"misterbisson\";s:12:\"Casey Bisson\";s:6:\"ch1902\";s:6:\"ch1902\";s:5:\"nhuja\";s:9:\"Chandra M\";s:12:\"chandrapatel\";s:13:\"Chandra Patel\";s:12:\"chasewiseman\";s:13:\"Chase Wiseman\";s:9:\"chiara_09\";s:14:\"Chiara Dossena\";s:11:\"chipbennett\";s:12:\"Chip Bennett\";s:12:\"chiragswadia\";s:13:\"Chirag Swadia\";s:11:\"chriscoyier\";s:11:\"chriscoyier\";s:8:\"chrisdc1\";s:8:\"Chrisdc1\";s:13:\"chrismkindred\";s:13:\"Chris Kindred\";s:8:\"cklosows\";s:15:\"Chris Klosowski\";s:10:\"lovememore\";s:14:\"christianoliff\";s:6:\"cfinke\";s:17:\"Christopher Finke\";s:13:\"christophherr\";s:14:\"Christoph Herr\";s:24:\"chrisvendiadvertisingcom\";s:6:\"cjhaas\";s:9:\"codeelite\";s:9:\"codeelite\";s:10:\"coenjacobs\";s:11:\"Coen Jacobs\";s:7:\"compute\";s:7:\"Compute\";s:12:\"couturefreak\";s:13:\"Courtney Ivey\";s:13:\"craig-ralston\";s:13:\"Craig Ralston\";s:8:\"cgrymala\";s:15:\"Curtiss Grymala\";s:4:\"cdog\";s:16:\"C?t?lin Dogaru\";s:11:\"extendwings\";s:32:\"Daisuke Takahashi (Extend Wings)\";s:7:\"dboulet\";s:10:\"Dan Boulet\";s:5:\"mte90\";s:21:\"Daniele Scasciafratte\";s:10:\"redsweater\";s:27:\"Daniel Jalkut (Red Sweater)\";s:15:\"daniel-koskinen\";s:15:\"Daniel Koskinen\";s:12:\"daniellandau\";s:12:\"daniellandau\";s:7:\"dmenard\";s:18:\"Daniel M&#233;nard\";s:12:\"daniloercoli\";s:12:\"daniloercoli\";s:11:\"dannydehaan\";s:13:\"Danny de Haan\";s:10:\"dvankooten\";s:16:\"Danny van Kooten\";s:6:\"nerrad\";s:22:\"Darren Ethier (nerrad)\";s:4:\"dllh\";s:26:\"Daryl L. L. Houston (dllh)\";s:10:\"dattaparad\";s:11:\"Datta Parad\";s:7:\"dmchale\";s:11:\"Dave McHale\";s:13:\"davidakennedy\";s:16:\"David A. Kennedy\";s:13:\"davidanderson\";s:14:\"David Anderson\";s:10:\"davidbinda\";s:13:\"David Binovec\";s:3:\"dlh\";s:13:\"David Herrera\";s:8:\"dshanske\";s:13:\"David Shanske\";s:6:\"debaat\";s:6:\"DeBAAT\";s:17:\"denis-de-bernardy\";s:17:\"Denis de Bernardy\";s:7:\"realloc\";s:15:\"Dennis Ploetner\";s:12:\"valendesigns\";s:12:\"Derek Herman\";s:13:\"downstairsdev\";s:11:\"Devin Price\";s:5:\"dezzy\";s:5:\"Dezzy\";s:21:\"dipalidhole27gmailcom\";s:12:\"Dipali Dhole\";s:14:\"dipeshkakadiya\";s:15:\"dipesh.kakadiya\";s:4:\"dbru\";s:16:\"Dominik Bruderer\";s:5:\"dossy\";s:14:\"Dossy Shiobara\";s:11:\"drebbitsweb\";s:9:\"Dreb Bits\";s:12:\"dustinbolton\";s:12:\"dustinbolton\";s:6:\"kucrut\";s:11:\"Dzikri Aziz\";s:9:\"edirect24\";s:9:\"edirect24\";s:10:\"oso96_2000\";s:15:\"Eduardo Reveles\";s:13:\"eduardozulian\";s:14:\"Eduardo Zulian\";s:4:\"cais\";s:14:\"Edward Caissie\";s:5:\"egill\";s:19:\"Egill R. Erlendsson\";s:6:\"egower\";s:6:\"egower\";s:8:\"iehsanir\";s:6:\"Ehsaan\";s:5:\"ehtis\";s:5:\"ehtis\";s:12:\"ellieroepken\";s:14:\"Ellie Strejlau\";s:14:\"elliott-stocks\";s:14:\"Elliott Stocks\";s:11:\"elusiveunit\";s:11:\"elusiveunit\";s:9:\"enshrined\";s:9:\"enshrined\";s:9:\"ericlewis\";s:17:\"Eric Andrew Lewis\";s:8:\"ebinnion\";s:12:\"Eric Binnion\";s:9:\"ericdaams\";s:10:\"Eric Daams\";s:9:\"ericjuden\";s:9:\"ericjuden\";s:8:\"ericmann\";s:9:\"Eric Mann\";s:9:\"eherman24\";s:11:\"Evan Herman\";s:6:\"f4rkie\";s:6:\"F4rkie\";s:8:\"flixos90\";s:11:\"Felix Arntz\";s:6:\"fsylum\";s:14:\"Firdaus Zahari\";s:10:\"firebird75\";s:10:\"firebird75\";s:6:\"fonglh\";s:6:\"fonglh\";s:9:\"francoisb\";s:9:\"francoisb\";s:8:\"fjarrett\";s:15:\"Frankie Jarrett\";s:11:\"frank-klein\";s:11:\"Frank Klein\";s:8:\"frozzare\";s:14:\"Fredrik Forsmo\";s:6:\"gaelan\";s:12:\"Gaelan Lloyd\";s:9:\"gagan0123\";s:16:\"Gagan Deep Singh\";s:7:\"garyc40\";s:8:\"Gary Cao\";s:5:\"garyj\";s:10:\"Gary Jones\";s:5:\"garza\";s:5:\"garza\";s:7:\"grvrulz\";s:13:\"Gaurav Pareek\";s:11:\"gautamgupta\";s:12:\"Gautam Gupta\";s:5:\"gblsm\";s:5:\"gblsm\";s:9:\"geminorum\";s:9:\"geminorum\";s:5:\"kloon\";s:17:\"Gerhard Potgieter\";s:9:\"gezamiklo\";s:10:\"geza.miklo\";s:8:\"gizburdt\";s:13:\"Gijs Jorissen\";s:7:\"garusky\";s:15:\"Giuseppe Mamone\";s:8:\"jubstuff\";s:22:\"Giustino Borzacchiello\";s:7:\"gnaka08\";s:7:\"gnaka08\";s:8:\"gradyetc\";s:8:\"gradyetc\";s:6:\"tivnet\";s:27:\"Gregory Karpinsky (@tivnet)\";s:11:\"gregrickaby\";s:12:\"Greg Rickaby\";s:7:\"bordoni\";s:15:\"Gustavo Bordoni\";s:6:\"webord\";s:15:\"Gustavo Bordoni\";s:10:\"gwinhlopez\";s:11:\"gwinh.lopez\";s:5:\"hakre\";s:5:\"hakre\";s:7:\"hauvong\";s:7:\"hauvong\";s:4:\"hnle\";s:7:\"Hinaloe\";s:9:\"hrishiv90\";s:20:\"Hrishikesh Vaipurkar\";s:11:\"hlashbrooke\";s:15:\"Hugh Lashbrooke\";s:9:\"hugobaeta\";s:10:\"Hugo Baeta\";s:12:\"polevaultweb\";s:12:\"Iain Poulson\";s:7:\"iandunn\";s:8:\"Ian Dunn\";s:11:\"iandstewart\";s:11:\"Ian Stewart\";s:6:\"icetee\";s:6:\"icetee\";s:7:\"igmoweb\";s:19:\"Ignacio Cruz Moreno\";s:10:\"headonfire\";s:13:\"Ihor Vorotnov\";s:5:\"imath\";s:5:\"imath\";s:8:\"ippetkov\";s:8:\"ippetkov\";s:14:\"ivankristianto\";s:15:\"Ivan Kristianto\";s:8:\"jdgrimes\";s:11:\"J.D. Grimes\";s:5:\"jadpm\";s:5:\"jadpm\";s:11:\"jakubtyrcha\";s:12:\"jakub.tyrcha\";s:7:\"macmanx\";s:10:\"James Huff\";s:11:\"janhenckens\";s:12:\"Jan Henckens\";s:4:\"japh\";s:4:\"Japh\";s:6:\"jazbek\";s:6:\"jazbek\";s:9:\"jcroucher\";s:9:\"jcroucher\";s:11:\"jfarthing84\";s:13:\"Jeff Farthing\";s:10:\"jeffmatson\";s:10:\"JeffMatson\";s:9:\"cheffheid\";s:14:\"Jeffrey de Wit\";s:15:\"jeffpyebrookcom\";s:17:\"Jeffrey Schutzman\";s:11:\"jeffstieler\";s:12:\"Jeff Stieler\";s:8:\"jeichorn\";s:8:\"jeichorn\";s:6:\"jmdodd\";s:16:\"Jennifer M. Dodd\";s:4:\"jpry\";s:10:\"Jeremy Pry\";s:8:\"slimndap\";s:13:\"Jeroen Schmit\";s:5:\"jesin\";s:7:\"Jesin A\";s:7:\"engelen\";s:18:\"Jesper van Engelen\";s:6:\"jim912\";s:6:\"jim912\";s:6:\"jliman\";s:6:\"jliman\";s:7:\"jmayhak\";s:7:\"jmayhak\";s:7:\"jnylen0\";s:7:\"jnylen0\";s:5:\"jobst\";s:18:\"Jobst Schmalenbach\";s:9:\"joedolson\";s:10:\"Joe Dolson\";s:8:\"joehills\";s:8:\"joehills\";s:15:\"johnjamesjacoby\";s:17:\"John James Jacoby\";s:10:\"johnpbloch\";s:13:\"John P. Bloch\";s:8:\"mindctrl\";s:11:\"John Parris\";s:13:\"jonathanbardo\";s:14:\"Jonathan Bardo\";s:7:\"desrosj\";s:19:\"Jonathan Desrosiers\";s:5:\"duck_\";s:8:\"Jon Cave\";s:11:\"joostdevalk\";s:13:\"Joost de Valk\";s:4:\"koke\";s:12:\"Jorge Bernal\";s:8:\"betzster\";s:9:\"Josh Betz\";s:7:\"jjeaton\";s:10:\"Josh Eaton\";s:7:\"shelob9\";s:12:\"Josh Pollock\";s:3:\"jpr\";s:3:\"jpr\";s:3:\"jrf\";s:3:\"jrf\";s:6:\"juhise\";s:11:\"Juhi Saxena\";s:8:\"juliobox\";s:12:\"Julio Potier\";s:8:\"justdaiv\";s:8:\"justdaiv\";s:13:\"justinsainton\";s:14:\"Justin Sainton\";s:7:\"jshreve\";s:13:\"Justin Shreve\";s:11:\"jtsternberg\";s:16:\"Justin Sternberg\";s:10:\"greenshady\";s:14:\"Justin Tadlock\";s:10:\"kadamwhite\";s:12:\"K.Adam White\";s:7:\"trepmal\";s:16:\"Kailey (trepmal)\";s:12:\"kalenjohnson\";s:12:\"KalenJohnson\";s:8:\"karinedo\";s:8:\"karinedo\";s:13:\"karpstrucking\";s:13:\"karpstrucking\";s:6:\"ryelle\";s:10:\"Kelly Dwan\";s:14:\"kevinatelement\";s:14:\"kevinatelement\";s:6:\"kevinb\";s:13:\"Kevin Behrens\";s:14:\"kevinlangleyjr\";s:13:\"Kevin Langley\";s:7:\"kitchin\";s:7:\"kitchin\";s:7:\"ixkaito\";s:4:\"Kite\";s:9:\"kovshenin\";s:20:\"Konstantin Kovshenin\";s:8:\"krissiev\";s:8:\"KrissieV\";s:6:\"drozdz\";s:22:\"Krzysiek Dr&#243;?d?\";s:9:\"kurtpayne\";s:10:\"Kurt Payne\";s:7:\"laceous\";s:7:\"laceous\";s:12:\"lancewillett\";s:13:\"Lance Willett\";s:9:\"offereins\";s:17:\"Laurens Offereins\";s:8:\"lcherpit\";s:8:\"lcherpit\";s:9:\"ldinclaux\";s:9:\"ldinclaux\";s:6:\"leemon\";s:6:\"leemon\";s:11:\"leewillis77\";s:10:\"Lee Willis\";s:9:\"lessbloat\";s:9:\"lessbloat\";s:11:\"linuxologos\";s:11:\"linuxologos\";s:8:\"spmlucas\";s:13:\"Lucas Karpiuk\";s:8:\"lucatume\";s:8:\"lucatume\";s:10:\"luciole135\";s:10:\"luciole135\";s:7:\"lucymtc\";s:10:\"Lucy Tomas\";s:10:\"lukecarbis\";s:11:\"Luke Carbis\";s:16:\"madalinungureanu\";s:17:\"madalin.ungureanu\";s:6:\"mako09\";s:4:\"Mako\";s:9:\"manolis09\";s:9:\"manolis09\";s:6:\"iworks\";s:15:\"Marcin Pietrzak\";s:5:\"tyxla\";s:14:\"Marin Atanasov\";s:9:\"nofearinc\";s:12:\"Mario Peshev\";s:7:\"clorith\";s:16:\"Marius (Clorith)\";s:12:\"markoheijnen\";s:13:\"Marko Heijnen\";s:7:\"mechter\";s:6:\"Markus\";s:9:\"matheusfd\";s:15:\"Matheus Martins\";s:11:\"mattbagwell\";s:12:\"Matt Bagwell\";s:9:\"mgibbs189\";s:10:\"Matt Gibbs\";s:7:\"mboynes\";s:14:\"Matthew Boynes\";s:12:\"wp-architect\";s:11:\"Matthew Ell\";s:7:\"mattheu\";s:20:\"Matthew Haines-Young\";s:5:\"sivel\";s:10:\"Matt Martz\";s:7:\"veraxus\";s:14:\"Matt van Andel\";s:9:\"mazurstas\";s:9:\"mazurstas\";s:8:\"mbrandys\";s:8:\"mbrandys\";s:8:\"mdmcginn\";s:8:\"mdmcginn\";s:13:\"mehulkaklotar\";s:14:\"Mehul Kaklotar\";s:6:\"meitar\";s:6:\"Meitar\";s:9:\"melchoyce\";s:10:\"Mel Choyce\";s:7:\"meloniq\";s:7:\"meloniq\";s:10:\"micahmills\";s:10:\"micahmills\";s:9:\"micahwave\";s:9:\"micahwave\";s:8:\"mdawaffe\";s:24:\"Michael Adams (mdawaffe)\";s:15:\"michael-arestad\";s:15:\"Michael Arestad\";s:5:\"cainm\";s:12:\"Michael Cain\";s:10:\"michielhab\";s:16:\"Michiel Habraken\";s:8:\"mcguive7\";s:10:\"Mickey Kay\";s:4:\"mdgl\";s:16:\"Mike Glendinning\";s:12:\"mikehansenme\";s:11:\"Mike Hansen\";s:10:\"mikejolley\";s:11:\"Mike Jolley\";s:9:\"thaicloud\";s:11:\"Mike Jordan\";s:12:\"mikeschinkel\";s:13:\"Mike Schinkel\";s:7:\"dimadin\";s:12:\"Milan Dini?\";s:10:\"mismith227\";s:10:\"mismith227\";s:13:\"misterunknown\";s:13:\"misterunknown\";s:15:\"mitchoyoshitaka\";s:35:\"mitcho (Michael Yoshitaka Erlewine)\";s:6:\"monika\";s:6:\"Monika\";s:11:\"morganestes\";s:11:\"morganestes\";s:5:\"mor10\";s:22:\"Morten Rand-Hendriksen\";s:6:\"mt8biz\";s:22:\"moto hachi ( mt8.biz )\";s:6:\"mrmist\";s:6:\"mrmist\";s:10:\"usermrpapa\";s:7:\"Mr Papa\";s:7:\"mulvane\";s:7:\"mulvane\";s:8:\"neoscrib\";s:8:\"neoscrib\";s:11:\"next-season\";s:11:\"NExT-Season\";s:12:\"niallkennedy\";s:13:\"Niall Kennedy\";s:11:\"nicholas_io\";s:11:\"nicholas_io\";s:9:\"nickciske\";s:10:\"Nick Ciske\";s:10:\"nickduncan\";s:10:\"NickDuncan\";s:16:\"celloexpressions\";s:11:\"Nick Halsey\";s:4:\"rahe\";s:12:\"Nicolas Juen\";s:5:\"nikeo\";s:5:\"nikeo\";s:10:\"nikschavan\";s:13:\"Nikhil Chavan\";s:8:\"niklasbr\";s:6:\"Niklas\";s:10:\"nikolovtmw\";s:14:\"Nikola Nikolov\";s:10:\"nbachiyski\";s:17:\"Nikolay Bachiyski\";s:8:\"rabmalin\";s:15:\"Nilambar Sharma\";s:11:\"originalexe\";s:11:\"OriginalEXE\";s:16:\"pareshradadiya-1\";s:15:\"Paresh Radadiya\";s:10:\"obrienlabs\";s:11:\"Pat O\'Brien\";s:7:\"pbearne\";s:11:\"Paul Bearne\";s:13:\"pauldewouters\";s:15:\"Paul de Wouters\";s:9:\"figureone\";s:9:\"Paul Ryan\";s:9:\"paulwilde\";s:10:\"Paul Wilde\";s:9:\"pavelevap\";s:9:\"pavelevap\";s:10:\"sirbrillig\";s:12:\"Payton Swick\";s:5:\"walbo\";s:32:\"Petter Walb&#248; Johnsg&#229;rd\";s:5:\"petya\";s:15:\"Petya Raykovska\";s:9:\"pfefferle\";s:9:\"pfefferle\";s:17:\"philiparthurmoore\";s:19:\"Philip Arthur Moore\";s:11:\"philiplakin\";s:11:\"PhilipLakin\";s:6:\"corphi\";s:14:\"Philipp Cordes\";s:8:\"delawski\";s:14:\"Piotr Delawski\";s:7:\"psoluch\";s:12:\"Piotr Soluch\";s:7:\"mordauk\";s:17:\"Pippin Williamson\";s:13:\"prasad-nevase\";s:13:\"Prasad Nevase\";s:11:\"nprasath002\";s:17:\"Prasath Nadarajah\";s:13:\"pratikchaskar\";s:6:\"Pratik\";s:9:\"rajnikmit\";s:9:\"rajnikmit\";s:6:\"racase\";s:29:\"Rakesh Lawaju (Racase Lawaju)\";s:5:\"ramay\";s:5:\"ramay\";s:10:\"raulillana\";s:11:\"Raul Illana\";s:7:\"renoirb\";s:7:\"renoirb\";s:14:\"rhubbardreverb\";s:14:\"rhubbardreverb\";s:9:\"rhyswynne\";s:10:\"Rhys Wynne\";s:12:\"rianrietveld\";s:13:\"Rian Rietveld\";s:11:\"iamfriendly\";s:12:\"Richard Tape\";s:11:\"miqrogroove\";s:13:\"Robert Chapin\";s:13:\"rodrigosprimo\";s:13:\"Rodrigo Primo\";s:8:\"rogerhub\";s:10:\"Roger Chen\";s:13:\"rommelxcastro\";s:13:\"Rommel Castro\";s:7:\"ronalfy\";s:14:\"Ronald Huereca\";s:8:\"wpmuguru\";s:11:\"Ron Rennick\";s:10:\"kingkool68\";s:16:\"Russell Heimlich\";s:8:\"ruudjoyo\";s:9:\"Ruud Laan\";s:12:\"ryankienstra\";s:13:\"Ryan Kienstra\";s:6:\"markel\";s:11:\"Ryan Markel\";s:7:\"welcher\";s:12:\"Ryan Welcher\";s:3:\"zeo\";s:15:\"Safirul Alredha\";s:7:\"salcode\";s:14:\"Sal Ferrarello\";s:14:\"salvoaranzulla\";s:14:\"salvoaranzulla\";s:6:\"sam2kb\";s:6:\"sam2kb\";s:10:\"sammybeats\";s:10:\"Sam Brodie\";s:12:\"solarissmoke\";s:10:\"Samir Shah\";s:12:\"samuelsidler\";s:13:\"Samuel Sidler\";s:6:\"otto42\";s:18:\"Samuel Wood (Otto)\";s:12:\"sanketparmar\";s:13:\"Sanket Parmar\";s:7:\"rosso99\";s:10:\"Sara Rosso\";s:12:\"sarciszewski\";s:12:\"sarciszewski\";s:20:\"scottbrownconsulting\";s:20:\"scottbrownconsulting\";s:6:\"sgrant\";s:11:\"Scott Grant\";s:11:\"sc0ttkclark\";s:20:\"Scott Kingsley Clark\";s:11:\"coffee2code\";s:12:\"Scott Reilly\";s:8:\"greglone\";s:12:\"ScreenfeedFr\";s:6:\"scribu\";s:6:\"scribu\";s:10:\"sdavis2702\";s:10:\"sdavis2702\";s:10:\"seanchayes\";s:10:\"Sean Hayes\";s:15:\"sebastianpisula\";s:16:\"Sebastian Pisula\";s:11:\"serpent7776\";s:11:\"serpent7776\";s:9:\"several27\";s:9:\"several27\";s:13:\"shimakyohsuke\";s:13:\"shimakyohsuke\";s:9:\"shinichin\";s:18:\"Shinichi Nishikawa\";s:7:\"side777\";s:7:\"side777\";s:5:\"pross\";s:13:\"Simon Prosser\";s:13:\"simonwheatley\";s:14:\"Simon Wheatley\";s:7:\"siobhan\";s:7:\"Siobhan\";s:8:\"sirzooro\";s:8:\"sirzooro\";s:5:\"sjmur\";s:5:\"sjmur\";s:9:\"smerriman\";s:9:\"smerriman\";s:12:\"spacedmonkey\";s:12:\"Spacedmonkey\";s:9:\"sboisvert\";s:22:\"St&#233;phane Boisvert\";s:7:\"khromov\";s:17:\"Stanislav Khromov\";s:8:\"metodiew\";s:15:\"Stanko Metodiev\";s:7:\"stebbiv\";s:7:\"stebbiv\";s:7:\"miglosh\";s:16:\"Stefan Froehlich\";s:9:\"sillybean\";s:15:\"Stephanie Leary\";s:6:\"netweb\";s:13:\"Stephen Edgar\";s:13:\"stephenharris\";s:14:\"Stephen Harris\";s:13:\"stevegrunwell\";s:14:\"Steve Grunwell\";s:10:\"stevehenty\";s:10:\"stevehenty\";s:12:\"stevehoneynz\";s:12:\"SteveHoneyNZ\";s:11:\"stevenkword\";s:11:\"Steven Word\";s:12:\"charlestonsw\";s:18:\"Store Locator Plus\";s:5:\"sudar\";s:11:\"Sudar Muthu\";s:15:\"brainstormforce\";s:5:\"Sujay\";s:5:\"5um17\";s:11:\"Sumit Singh\";s:10:\"summerblue\";s:10:\"summerblue\";s:12:\"sunnyratilal\";s:13:\"Sunny Ratilal\";s:8:\"miyauchi\";s:17:\"Takayuki Miyauchi\";s:8:\"tanner-m\";s:14:\"Tanner Moushey\";s:6:\"tbcorr\";s:6:\"tbcorr\";s:6:\"tychay\";s:10:\"Terry Chay\";s:12:\"tharsheblows\";s:12:\"tharsheblows\";s:8:\"themiked\";s:8:\"theMikeD\";s:8:\"kraftner\";s:20:\"Thomas Kr&#228;ftner\";s:8:\"thomaswm\";s:8:\"thomaswm\";s:8:\"tfrommen\";s:16:\"Thorsten Frommen\";s:4:\"tott\";s:12:\"Thorsten Ott\";s:9:\"tigertech\";s:9:\"tigertech\";s:10:\"tillkruess\";s:15:\"Till Kr&#252;ss\";s:8:\"tmatsuur\";s:8:\"tmatsuur\";s:8:\"tmeister\";s:8:\"tmeister\";s:8:\"tobiasbg\";s:8:\"TobiasBg\";s:11:\"tomharrigan\";s:11:\"TomHarrigan\";s:11:\"tommarshall\";s:11:\"tommarshall\";s:9:\"tomsommer\";s:9:\"tomsommer\";s:7:\"willmot\";s:11:\"Tom Willmot\";s:8:\"skithund\";s:17:\"Toni Viemer&#246;\";s:9:\"toro_unit\";s:25:\"Toro_Unit (Hiroshi Urabe)\";s:8:\"liljimmi\";s:14:\"Tracy Levesque\";s:6:\"rilwis\";s:18:\"Tran Ngoc Tuan Anh\";s:7:\"wpsmith\";s:12:\"Travis Smith\";s:10:\"trenzterra\";s:10:\"trenzterra\";s:5:\"tryon\";s:15:\"Tryon Eggleston\";s:7:\"tszming\";s:7:\"tszming\";s:9:\"junsuijin\";s:2:\"ty\";s:7:\"tywayne\";s:10:\"Ty Carlson\";s:9:\"chacha102\";s:12:\"Tyler Carter\";s:14:\"grapplerulrich\";s:6:\"Ulrich\";s:8:\"sorich87\";s:13:\"Ulrich Sossou\";s:11:\"umeshsingla\";s:11:\"Umesh Kumar\";s:11:\"umeshnevase\";s:12:\"Umesh Nevase\";s:12:\"utkarshpatel\";s:7:\"Utkarsh\";s:8:\"vilkatis\";s:8:\"vilkatis\";s:14:\"voldemortensen\";s:14:\"voldemortensen\";s:14:\"walterbarcelos\";s:14:\"walterbarcelos\";s:11:\"walterebert\";s:12:\"Walter Ebert\";s:8:\"webaware\";s:8:\"webaware\";s:14:\"webdevmattcrom\";s:14:\"webdevmattcrom\";s:13:\"wen-solutions\";s:13:\"WEN Solutions\";s:9:\"wenthemes\";s:10:\"WEN Themes\";s:8:\"wmertens\";s:8:\"wmertens\";s:14:\"wojtekszkutnik\";s:15:\"Wojtek Szkutnik\";s:8:\"wpdev101\";s:8:\"wpdev101\";s:6:\"theode\";s:21:\"WP Plugin Dev dot com\";s:9:\"alphawolf\";s:6:\"wpseek\";s:8:\"wturrell\";s:8:\"wturrell\";s:10:\"yamchhetri\";s:11:\"Yam Chhetri\";s:5:\"yoavf\";s:10:\"Yoav Farhi\";s:8:\"oxymoron\";s:10:\"Zach Wills\";s:10:\"zrothauser\";s:14:\"Zack Rothauser\";s:8:\"tollmanz\";s:12:\"Zack Tollman\";s:9:\"_smartik_\";s:9:\"_smartik_\";}}s:10:\"validators\";a:4:{s:4:\"name\";s:11:\"Translators\";s:4:\"type\";s:7:\"compact\";s:7:\"shuffle\";b:1;s:4:\"data\";a:5:{s:13:\"momo360modena\";a:3:{i:0;s:13:\"Amaury Balmer\";i:1;s:32:\"bd9516b368db97643f1cff5bf4c82123\";i:2;s:13:\"momo360modena\";}s:10:\"ben-kenobi\";a:3:{i:0;s:23:\"Beno&#238;t Catherineau\";i:1;s:32:\"7bb495a607f1f7e4a231404a42b81936\";i:2;s:10:\"ben-kenobi\";}s:7:\"wolforg\";a:3:{i:0;s:14:\"Didier Wolforg\";i:1;s:32:\"1ffc54a1bdddde2a5731099ae085c780\";i:2;s:7:\"wolforg\";}s:8:\"fxbenard\";a:3:{i:0;s:8:\"fxbenard\";i:1;s:32:\"aa4e3c2ebaa52da10d9e669341c574af\";i:2;s:8:\"fxbenard\";}s:4:\"xibe\";a:3:{i:0;s:15:\"Xavier Borderie\";i:1;s:32:\"c16970a350d2de8ced3017a5a8514969\";i:2;s:4:\"xibe\";}}}s:11:\"translators\";a:3:{s:4:\"name\";b:0;s:4:\"type\";s:4:\"list\";s:4:\"data\";a:12:{s:6:\"chouby\";s:6:\"Chouby\";s:8:\"crash_47\";s:8:\"crash_47\";s:5:\"danbp\";s:5:\"danbp\";s:7:\"dchassi\";s:7:\"dchassi\";s:6:\"dregad\";s:6:\"dregad\";s:4:\"fge0\";s:14:\"Franck Gervais\";s:6:\"kaibot\";s:6:\"Kaibot\";s:10:\"katiabovez\";s:10:\"katiabovez\";s:11:\"mialevesque\";s:12:\"Mia Levesque\";s:6:\"p0ouet\";s:6:\"p0ouet\";s:7:\"remyj38\";s:7:\"remyj38\";s:7:\"syhlver\";s:7:\"Syhlver\";}}s:9:\"libraries\";a:3:{s:4:\"name\";s:18:\"External Libraries\";s:4:\"type\";s:9:\"libraries\";s:4:\"data\";a:29:{i:0;a:2:{i:0;s:11:\"Backbone.js\";i:1;s:22:\"http://backbonejs.org/\";}i:1;a:2:{i:0;s:10:\"Class POP3\";i:1;s:24:\"http://squirrelmail.org/\";}i:2;a:2:{i:0;s:16:\"Color Animations\";i:1;s:32:\"http://plugins.jquery.com/color/\";}i:3;a:2:{i:0;s:15:\"Horde Text Diff\";i:1;s:22:\"http://pear.horde.org/\";}i:4;a:2:{i:0;s:11:\"hoverIntent\";i:1;s:45:\"http://plugins.jquery.com/project/hoverIntent\";}i:5;a:2:{i:0;s:13:\"imgAreaSelect\";i:1;s:42:\"http://odyniec.net/projects/imgareaselect/\";}i:6;a:2:{i:0;s:4:\"Iris\";i:1;s:34:\"https://github.com/Automattic/Iris\";}i:7;a:2:{i:0;s:6:\"jQuery\";i:1;s:18:\"http://jquery.com/\";}i:8;a:2:{i:0;s:9:\"jQuery UI\";i:1;s:20:\"http://jqueryui.com/\";}i:9;a:2:{i:0;s:14:\"jQuery Hotkeys\";i:1;s:41:\"https://github.com/tzuryby/jquery.hotkeys\";}i:10;a:2:{i:0;s:22:\"jQuery serializeObject\";i:1;s:49:\"http://benalman.com/projects/jquery-misc-plugins/\";}i:11;a:2:{i:0;s:12:\"jQuery.query\";i:1;s:39:\"http://plugins.jquery.com/query-object/\";}i:12;a:2:{i:0;s:14:\"jQuery.suggest\";i:1;s:41:\"http://plugins.jquery.com/project/suggest\";}i:13;a:2:{i:0;s:21:\"jQuery UI Touch Punch\";i:1;s:27:\"http://touchpunch.furf.com/\";}i:14;a:2:{i:0;s:5:\"json2\";i:1;s:43:\"https://github.com/douglascrockford/JSON-js\";}i:15;a:2:{i:0;s:7:\"Masonry\";i:1;s:28:\"http://masonry.desandro.com/\";}i:16;a:2:{i:0;s:15:\"MediaElement.js\";i:1;s:26:\"http://mediaelementjs.com/\";}i:17;a:2:{i:0;s:6:\"PclZip\";i:1;s:33:\"http://www.phpconcept.net/pclzip/\";}i:18;a:2:{i:0;s:6:\"PemFTP\";i:1;s:50:\"http://www.phpclasses.org/browse/package/1743.html\";}i:19;a:2:{i:0;s:6:\"phpass\";i:1;s:31:\"http://www.openwall.com/phpass/\";}i:20;a:2:{i:0;s:9:\"PHPMailer\";i:1;s:55:\"http://code.google.com/a/apache-extras.org/p/phpmailer/\";}i:21;a:2:{i:0;s:8:\"Plupload\";i:1;s:24:\"http://www.plupload.com/\";}i:22;a:2:{i:0;s:9:\"SimplePie\";i:1;s:21:\"http://simplepie.org/\";}i:23;a:2:{i:0;s:27:\"The Incutio XML-RPC Library\";i:1;s:34:\"http://scripts.incutio.com/xmlrpc/\";}i:24;a:2:{i:0;s:8:\"Thickbox\";i:1;s:32:\"http://codylindley.com/thickbox/\";}i:25;a:2:{i:0;s:7:\"TinyMCE\";i:1;s:23:\"http://www.tinymce.com/\";}i:26;a:2:{i:0;s:7:\"Twemoji\";i:1;s:34:\"https://github.com/twitter/twemoji\";}i:27;a:2:{i:0;s:13:\"Underscore.js\";i:1;s:24:\"http://underscorejs.org/\";}i:28;a:2:{i:0;s:6:\"zxcvbn\";i:1;s:33:\"https://github.com/dropbox/zxcvbn\";}}}}s:4:\"data\";a:2:{s:8:\"profiles\";s:33:\"https://profiles.wordpress.org/%s\";s:7:\"version\";s:3:\"4.4\";}}","yes");
INSERT INTO ayv_options VALUES("3011","_transient_timeout_wpseo_sitemap_cache_1_1","1457447966","no");
INSERT INTO ayv_options VALUES("3012","_transient_wpseo_sitemap_cache_1_1","<sitemapindex xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">
<sitemap>
<loc>http://www.atelier-yvanvedel.com/post-sitemap.xml</loc>
<lastmod>2015-12-29T19:33:15+00:00</lastmod>
</sitemap>
<sitemap>
<loc>http://www.atelier-yvanvedel.com/page-sitemap.xml</loc>
<lastmod>2016-01-03T16:39:14+00:00</lastmod>
</sitemap>
<sitemap>
<loc>http://www.atelier-yvanvedel.com/portfolio-sitemap.xml</loc>
<lastmod>2016-02-26T18:50:14+00:00</lastmod>
</sitemap>
<sitemap>
<loc>http://www.atelier-yvanvedel.com/category-sitemap.xml</loc>
<lastmod>2015-12-29T19:33:15+00:00</lastmod>
</sitemap>
<sitemap>
<loc>http://www.atelier-yvanvedel.com/portfolio_category-sitemap.xml</loc>
<lastmod>2016-02-26T18:50:14+00:00</lastmod>
</sitemap>
</sitemapindex>","no");
INSERT INTO ayv_options VALUES("3048","_transient_timeout_feed_925a96b1918580ab3893979ca7a4a994","1460167106","no");
INSERT INTO ayv_options VALUES("3049","_transient_feed_925a96b1918580ab3893979ca7a4a994","a:4:{s:5:\"child\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:3:\"RDF\";a:1:{i:0;a:6:{s:4:\"data\";s:281:\"
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:24:\"http://purl.org/rss/1.0/\";a:2:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:91:\"
    \";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:5:\"about\";s:35:\"http://www.wordpress-fr.net/planet/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:24:\"http://purl.org/rss/1.0/\";a:4:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"WordPress Francophone : Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/planet/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"items\";a:1:{i:0;a:6:{s:4:\"data\";s:18:\"
        \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:3:\"Seq\";a:1:{i:0;a:6:{s:4:\"data\";s:749:\"
                    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:2:\"li\";a:20:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:8:\"resource\";s:111:\"https://fr.wordpress.org/2016/04/08/tout-ce-que-vous-devez-savoir-a-propos-du-wordpress-global-translation-day/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:8:\"resource\";s:56:\"http://www.echodesplugins.li-an.fr/plugins/file-manager/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:8:\"resource\";s:55:\"http://www.seomix.fr/apprehender-wordpress-developpeur/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:8:\"resource\";s:60:\"https://wpchannel.com/supprimer-balises-opengraph-yoast-seo/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:8:\"resource\";s:50:\"http://www.echodesplugins.li-an.fr/plugins/flatty/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:8:\"resource\";s:80:\"https://www.gregoirenoyelle.com/wordpress-gestion-optimisee-organisation-medias/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:8:\"resource\";s:88:\"https://wpchannel.com/wp-admin-ui-personnaliser-optimiser-back-office-wordpress-clients/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:7;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:8:\"resource\";s:56:\"http://www.echodesplugins.li-an.fr/plugins/front-end-pm/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:8;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:8:\"resource\";s:37:\"http://wpmarmite.com/pat-episode-022/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:9;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:8:\"resource\";s:57:\"https://wpchannel.com/obtenir-role-utilisateur-wordpress/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:10;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:8:\"resource\";s:47:\"http://www.echodesplugins.li-an.fr/plugins/amp/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:11;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:8:\"resource\";s:49:\"http://wpformation.com/seo-multilingue-wordpress/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:12;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:8:\"resource\";s:52:\"http://wpmarmite.com/gestion-utilisateurs-wordpress/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:13;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:8:\"resource\";s:69:\"http://www.seomix.fr/creer-un-site-wordpress-les-cles-de-la-reussite/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:14;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:8:\"resource\";s:37:\"http://wpmarmite.com/boutons-partage/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:15;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:8:\"resource\";s:65:\"http://www.echodesplugins.li-an.fr/plugins/feature-a-page-widget/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:16;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:8:\"resource\";s:37:\"http://wpformation.com/amp-wordpress/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:17;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:8:\"resource\";s:67:\"https://wpchannel.com/26-photos-libres-droits-promouvoir-wordpress/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:18;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:8:\"resource\";s:59:\"http://www.wp-spread.com/compte-rendu-de-wpia-6-a-grenoble/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:19;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:8:\"resource\";s:57:\"http://www.echodesplugins.li-an.fr/plugins/asgaros-forum/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:4:{s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"rights\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"date\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2016-04-08T15:51:00+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:22:\"http://webns.net/mvcb/\";a:1:{s:14:\"generatorAgent\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:8:\"resource\";s:28:\"http://moonmoon.inertie.org/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:2:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rdf+xml\";s:4:\"href\";s:45:\"http://feeds.feedburner.com/wordpress-fr/RaoY\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:3:\"hub\";s:4:\"href\";s:32:\"http://pubsubhubbub.appspot.com/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:4:\"info\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"uri\";s:17:\"wordpress-fr/raoy\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:20:{i:0;a:6:{s:4:\"data\";s:59:\"
    \";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:5:\"about\";s:111:\"https://fr.wordpress.org/2016/04/08/tout-ce-que-vous-devez-savoir-a-propos-du-wordpress-global-translation-day/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:24:\"http://purl.org/rss/1.0/\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"Franais : Tout ce que vous devez savoir  propos du WordPress Global Translation Day\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"http://feedproxy.google.com/~r/wordpress-fr/RaoY/~3/EC4MwOxgjrw/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5580:\"<div>
<p>Le WordPress Global Translation Day est une journ&eacute;e consacr&eacute;e &agrave; la traduction de WordPress afin de le proposer &agrave; plus de personnes dans le monde entier.<br>
24 heures de sessions vid&eacute;os de formation en direct sur l&rsquo;internationalisation (i18n) et la localisation (L10n) de WordPress.<br><img class=\"aligncenter size-full wp-image-330\" src=\"https://fr.wordpress.org/files/2016/04/GTD_FR_02_mini.png\" alt=\"GTD_FR_02_mini\" width=\"717\" height=\"427\" srcset=\"https://fr.wordpress.org/files/2016/04/GTD_FR_02_mini.png 717w, https://fr.wordpress.org/files/2016/04/GTD_FR_02_mini-300x179.png 300w\" sizes=\"(max-width: 717px) 100vw, 717px\"></p>
<p><span id=\"more-325\"></span></p>
<h2>Quand&nbsp;?</h2>
<p>Le WordPress Global Translation Day aura lieu le dimanche 24 avril 2016. Les sessions en direct commenceront &agrave; 0:00 UTC et les &eacute;v&egrave;nements locaux d&eacute;buteront &agrave; des heures diff&eacute;rentes en fonctions de leur fuseau horaire.</p>
<h2>Quoi&nbsp;?</h2>
<p>Des sessions en direct &agrave; propos de WordPress dans diff&eacute;rentes langues seront sur le site officiel <a href=\"https://wptranslationday.org/\">wptranslationday.org</a>. Durant le WordPress Global Translation Day il y aura plus de 30 &eacute;v&egrave;nements organis&eacute;s dans plus de 20 pays. Rejoignons-nous&nbsp;!</p>
<h2>O&ugrave;&nbsp;?</h2>
<p>Vous pourrez voir toutes les vid&eacute;os des sessions en direct sur le <a href=\"https://wptranslationday.org/#schedule\">site</a>. Pour participer &agrave; la session francophone, nous vous donnons rendez-vous &agrave; 11h. <a href=\"https://profiles.wordpress.org/fxbenard\">FX B&eacute;nard</a>, un membre de l&rsquo;&eacute;quipe de traduction fran&ccedil;aise vous expliquera comment traduire WordPress en Fran&ccedil;ais. Au programme outils, m&eacute;thodes et r&eacute;ponses &agrave; vos questions sur le sujet. Alors <a href=\"https://wptranslationday.org/#attend\">inscrivez-vous</a> !</p>
<p>En plus du site, les communaut&eacute;s bordelaise, du grand sud et toulousaine de WordPress vous donnent rendez-vous au <a href=\"https://aquinum.fr/\">Node de Bordeaux</a> pour une journ&eacute;e de traductions en live d&egrave;s 10h. FX B&eacute;nard y sera pr&eacute;sent, ainsi que de nombreux traducteurs confirm&eacute;s ou d&eacute;butants. C&rsquo;est l&rsquo;occasion de nous rencontrer et de passer une bonne journ&eacute;e tous ensemble autour d&rsquo;un sujet commun. N&rsquo;h&eacute;sitez pas &agrave; passer si vous &ecirc;tes dans le coin, nous nous ferons un plaisir de vous accueillir.</p>
<p>Et si Bordeaux est un peu loin pour vous, n&rsquo;h&eacute;sitez pas &agrave; vous connecter sur le <a href=\"http://boiteaweb.fr/slack-invitation\">Slack de la communaut&eacute; fran&ccedil;aise</a>, channel #gtd, nous y serons pr&eacute;sents toute la journ&eacute;e. Et sinon pourquoi ne pas cr&eacute;er votre propre &eacute;v&egrave;nement pr&egrave;s de chez vous&nbsp;? Il n&rsquo;est pas trop tard, contactez-nous et nous nous ferons un plaisir de vous y aider.</p>
<h2>Pourquoi&nbsp;?</h2>
<p>Parce que nous aimons WordPress et que nous voulons qu&rsquo;il soit accessible pour encore plus de personnes dans encore plus de langues&nbsp;! Et parce que nous voulons vous montrer comment faire pour que cela arrive. Alors, traduisons ensemble&nbsp;!</p>
<p><strong>Le site officiel&nbsp;:</strong> <a href=\"https://wptranslationday.org/\" target=\"_blank\">wptranslationday.org</a></p>
<p style=\"text-align: center\"><strong>La vid&eacute;o de pr&eacute;sentation de l&rsquo;&eacute;v&egrave;nement&nbsp;:</strong></p>
<p><span class=\"embed-youtube\" style=\"text-align:center; display: block;\"><iframe class=\"youtube-player\" type=\"text/html\" width=\"692\" height=\"420\" src=\"https://www.youtube.com/embed/-JjZVPbQl1k?version=3&amp;rel=1&amp;fs=1&amp;autohide=2&amp;showsearch=0&amp;showinfo=1&amp;iv_load_policy=1&amp;wmode=transparent\" frameborder=\"0\" allowfullscreen=\"true\"></iframe></span></p>
<p style=\"text-align: center\"><strong>La banni&egrave;re&nbsp;:</strong></p>
<p style=\"text-align: center\"><a href=\"https://fr.wordpress.org/files/2016/04/GTD_FR_02.png\"><img class=\"aligncenter size-large wp-image-350\" src=\"https://fr.wordpress.org/files/2016/04/GTD_FR_02-1024x278.png\" alt=\"GTD_FR_02\" width=\"692\" height=\"188\" srcset=\"https://fr.wordpress.org/files/2016/04/GTD_FR_02-1024x278.png 1024w, https://fr.wordpress.org/files/2016/04/GTD_FR_02-300x81.png 300w, https://fr.wordpress.org/files/2016/04/GTD_FR_02-768x208.png 768w\" sizes=\"(max-width: 692px) 100vw, 692px\"></a></p>
<p style=\"text-align: center\"><strong>Les badges :&nbsp; </strong>(merci <a href=\"https://twitter.com/crash_47\" target=\"_blank\">@ThomasPiron</a>)</p>
<a href=\"https://fr.wordpress.org/2016/04/08/tout-ce-que-vous-devez-savoir-a-propos-du-wordpress-global-translation-day/#gallery-325-1-slideshow\">Cliquer pour visualiser le diaporama.</a>
<p style=\"text-align: left\"><strong>T&eacute;l&eacute;charger les badges&nbsp;:</strong></p>
<ul>
<li style=\"text-align: left\">
<a href=\"https://fr.wordpress.org/files/2016/04/wpgtd-badge-trad-fr.png\" target=\"_blank\">Badge de traducteur</a> (<a href=\"https://fr.wordpress.org/files/2016/04/wpgtd-badge-trad-trans-fr.png\" target=\"_blank\">transparent</a>)<strong><br></strong>
</li>
<li style=\"text-align: left\">
<a href=\"https://fr.wordpress.org/files/2016/04/wpgtd-badge-speak-fr.png\" target=\"_blank\">Badge d&rsquo;orateur</a> (<a href=\"https://fr.wordpress.org/files/2016/04/wpgtd-badge-speak-trans-fr.png\" target=\"_blank\">transparent)</a>
</li>
</ul>
</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:2:{s:4:\"date\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2016-04-08T10:46:01+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Didier Wolforg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5684:\"<div>
<p>Le WordPress Global Translation Day est une journ&eacute;e consacr&eacute;e &agrave; la traduction de WordPress afin de le proposer &agrave; plus de personnes dans le monde entier.<br>
24 heures de sessions vid&eacute;os de formation en direct sur l&rsquo;internationalisation (i18n) et la localisation (L10n) de WordPress.<br><img class=\"aligncenter size-full wp-image-330\" src=\"https://fr.wordpress.org/files/2016/04/GTD_FR_02_mini.png\" alt=\"GTD_FR_02_mini\" width=\"717\" height=\"427\" srcset=\"https://fr.wordpress.org/files/2016/04/GTD_FR_02_mini.png 717w, https://fr.wordpress.org/files/2016/04/GTD_FR_02_mini-300x179.png 300w\" sizes=\"(max-width: 717px) 100vw, 717px\"></p>
<p><span id=\"more-325\"></span></p>
<h2>Quand&nbsp;?</h2>
<p>Le WordPress Global Translation Day aura lieu le dimanche 24 avril 2016. Les sessions en direct commenceront &agrave; 0:00 UTC et les &eacute;v&egrave;nements locaux d&eacute;buteront &agrave; des heures diff&eacute;rentes en fonctions de leur fuseau horaire.</p>
<h2>Quoi&nbsp;?</h2>
<p>Des sessions en direct &agrave; propos de WordPress dans diff&eacute;rentes langues seront sur le site officiel <a href=\"https://wptranslationday.org/\">wptranslationday.org</a>. Durant le WordPress Global Translation Day il y aura plus de 30 &eacute;v&egrave;nements organis&eacute;s dans plus de 20 pays. Rejoignons-nous&nbsp;!</p>
<h2>O&ugrave;&nbsp;?</h2>
<p>Vous pourrez voir toutes les vid&eacute;os des sessions en direct sur le <a href=\"https://wptranslationday.org/#schedule\">site</a>. Pour participer &agrave; la session francophone, nous vous donnons rendez-vous &agrave; 11h. <a href=\"https://profiles.wordpress.org/fxbenard\">FX B&eacute;nard</a>, un membre de l&rsquo;&eacute;quipe de traduction fran&ccedil;aise vous expliquera comment traduire WordPress en Fran&ccedil;ais. Au programme outils, m&eacute;thodes et r&eacute;ponses &agrave; vos questions sur le sujet. Alors <a href=\"https://wptranslationday.org/#attend\">inscrivez-vous</a> !</p>
<p>En plus du site, les communaut&eacute;s bordelaise, du grand sud et toulousaine de WordPress vous donnent rendez-vous au <a href=\"https://aquinum.fr/\">Node de Bordeaux</a> pour une journ&eacute;e de traductions en live d&egrave;s 10h. FX B&eacute;nard y sera pr&eacute;sent, ainsi que de nombreux traducteurs confirm&eacute;s ou d&eacute;butants. C&rsquo;est l&rsquo;occasion de nous rencontrer et de passer une bonne journ&eacute;e tous ensemble autour d&rsquo;un sujet commun. N&rsquo;h&eacute;sitez pas &agrave; passer si vous &ecirc;tes dans le coin, nous nous ferons un plaisir de vous accueillir.</p>
<p>Et si Bordeaux est un peu loin pour vous, n&rsquo;h&eacute;sitez pas &agrave; vous connecter sur le <a href=\"http://boiteaweb.fr/slack-invitation\">Slack de la communaut&eacute; fran&ccedil;aise</a>, channel #gtd, nous y serons pr&eacute;sents toute la journ&eacute;e. Et sinon pourquoi ne pas cr&eacute;er votre propre &eacute;v&egrave;nement pr&egrave;s de chez vous&nbsp;? Il n&rsquo;est pas trop tard, contactez-nous et nous nous ferons un plaisir de vous y aider.</p>
<h2>Pourquoi&nbsp;?</h2>
<p>Parce que nous aimons WordPress et que nous voulons qu&rsquo;il soit accessible pour encore plus de personnes dans encore plus de langues&nbsp;! Et parce que nous voulons vous montrer comment faire pour que cela arrive. Alors, traduisons ensemble&nbsp;!</p>
<p><strong>Le site officiel&nbsp;:</strong> <a href=\"https://wptranslationday.org/\" target=\"_blank\">wptranslationday.org</a></p>
<p style=\"text-align: center\"><strong>La vid&eacute;o de pr&eacute;sentation de l&rsquo;&eacute;v&egrave;nement&nbsp;:</strong></p>
<p><span class=\"embed-youtube\" style=\"text-align:center; display: block;\"><iframe class=\"youtube-player\" type=\"text/html\" width=\"692\" height=\"420\" src=\"https://www.youtube.com/embed/-JjZVPbQl1k?version=3&amp;rel=1&amp;fs=1&amp;autohide=2&amp;showsearch=0&amp;showinfo=1&amp;iv_load_policy=1&amp;wmode=transparent\" frameborder=\"0\" allowfullscreen=\"true\"></iframe></span></p>
<p style=\"text-align: center\"><strong>La banni&egrave;re&nbsp;:</strong></p>
<p style=\"text-align: center\"><a href=\"https://fr.wordpress.org/files/2016/04/GTD_FR_02.png\"><img class=\"aligncenter size-large wp-image-350\" src=\"https://fr.wordpress.org/files/2016/04/GTD_FR_02-1024x278.png\" alt=\"GTD_FR_02\" width=\"692\" height=\"188\" srcset=\"https://fr.wordpress.org/files/2016/04/GTD_FR_02-1024x278.png 1024w, https://fr.wordpress.org/files/2016/04/GTD_FR_02-300x81.png 300w, https://fr.wordpress.org/files/2016/04/GTD_FR_02-768x208.png 768w\" sizes=\"(max-width: 692px) 100vw, 692px\"></a></p>
<p style=\"text-align: center\"><strong>Les badges :&nbsp; </strong>(merci <a href=\"https://twitter.com/crash_47\" target=\"_blank\">@ThomasPiron</a>)</p>
<a href=\"https://fr.wordpress.org/2016/04/08/tout-ce-que-vous-devez-savoir-a-propos-du-wordpress-global-translation-day/#gallery-325-1-slideshow\">Cliquer pour visualiser le diaporama.</a>
<p style=\"text-align: left\"><strong>T&eacute;l&eacute;charger les badges&nbsp;:</strong></p>
<ul>
<li style=\"text-align: left\">
<a href=\"https://fr.wordpress.org/files/2016/04/wpgtd-badge-trad-fr.png\" target=\"_blank\">Badge de traducteur</a> (<a href=\"https://fr.wordpress.org/files/2016/04/wpgtd-badge-trad-trans-fr.png\" target=\"_blank\">transparent</a>)<strong><br></strong>
</li>
<li style=\"text-align: left\">
<a href=\"https://fr.wordpress.org/files/2016/04/wpgtd-badge-speak-fr.png\" target=\"_blank\">Badge d&rsquo;orateur</a> (<a href=\"https://fr.wordpress.org/files/2016/04/wpgtd-badge-speak-trans-fr.png\" target=\"_blank\">transparent)</a>
</li>
</ul>
</div><img src=\"http://feeds.feedburner.com/~r/wordpress-fr/RaoY/~4/EC4MwOxgjrw\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"https://fr.wordpress.org/2016/04/08/tout-ce-que-vous-devez-savoir-a-propos-du-wordpress-global-translation-day/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:59:\"
    \";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:5:\"about\";s:56:\"http://www.echodesplugins.li-an.fr/plugins/file-manager/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:24:\"http://purl.org/rss/1.0/\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"L&#039;cho des plugins WordPress : File Manager\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"http://feedproxy.google.com/~r/wordpress-fr/RaoY/~3/6qnVSENnHEc/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"<div>Une gestion FTP dans votre administration</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:2:{s:4:\"date\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2016-04-07T17:33:49+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"Li-An\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:156:\"<div>Une gestion FTP dans votre administration</div><img src=\"http://feeds.feedburner.com/~r/wordpress-fr/RaoY/~4/6qnVSENnHEc\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"http://www.echodesplugins.li-an.fr/plugins/file-manager/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:59:\"
    \";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:5:\"about\";s:55:\"http://www.seomix.fr/apprehender-wordpress-developpeur/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:24:\"http://purl.org/rss/1.0/\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"SEOMix : Apprhender WordPress pour un dveloppeur\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"http://feedproxy.google.com/~r/wordpress-fr/RaoY/~3/ILaOPMQdq2U/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2244:\"<div>
<div><img width=\"250\" height=\"250\" src=\"http://www.seomix.fr/wp-content/uploads/2016/04/apprehender_wordpress-250x250.jpg\" class=\"attachment-thumb-250-250-true size-thumb-250-250-true wp-post-image\" alt=\"Appr&eacute;hender WordPress pour un d&eacute;veloppeur\" srcset=\"http://www.seomix.fr/wp-content/uploads/2016/04/apprehender_wordpress-130x130.jpg 130w, http://www.seomix.fr/wp-content/uploads/2016/04/apprehender_wordpress-150x150.jpg 150w, http://www.seomix.fr/wp-content/uploads/2016/04/apprehender_wordpress-200x200.jpg 200w, http://www.seomix.fr/wp-content/uploads/2016/04/apprehender_wordpress-250x250.jpg 250w, http://www.seomix.fr/wp-content/uploads/2016/04/apprehender_wordpress-100x100.jpg 100w\" sizes=\"(max-width: 250px) 100vw, 250px\"></div>Trop souvent, les d&eacute;veloppeurs ne prennent pas le temps de comprendre WordPress. Il est pourtant indispensable de se former &agrave; ce CMS. Voici par o&ugrave; commencer !<p><strong>Acc&eacute;dez &agrave; l\'article original :</strong> <a href=\"http://www.seomix.fr/apprehender-wordpress-developpeur/\">Appr&eacute;hender WordPress pour un d&eacute;veloppeur</a>.</p>
    <p><strong>Voici le d&eacute;but du contenu :</strong> </p>
<p></p> <p>Appr&eacute;hender WordPress, c&rsquo;est comprendre ce que ce CMS propose. Beaucoup de d&eacute;veloppeurs &laquo; qui d&eacute;butent sur WordPress&nbsp;&raquo; auront tendance &ndash; au d&eacute;part &ndash; &agrave; se pr&eacute;cipiter sur le fonctionnel et &agrave; utiliser ce qu&rsquo;ils savent d&eacute;j&agrave;. C&rsquo;est sans aucun doute la premi&egrave;re erreur qu&rsquo;ils commettront alors qu&rsquo;ils connaissent tr&egrave;s bien l&rsquo;adage du d&eacute;veloppeur &laquo;&nbsp;ne pas r&eacute;inventer la roue&nbsp;&raquo;.</p> <p>Pour tout framework (Symfony, zend PHP, AngularJs&hellip;), le d&eacute;veloppeur se documentera pr&eacute;alablement et gardera pour r&eacute;f&eacute;rence la documentation officielle. Pour tout ce qui n&rsquo;existe pas encore, il s&rsquo;inspirera de codes &laquo;&nbsp;snippets&nbsp;&raquo; ou d&eacute;veloppera de toute pi&egrave;ce la classe ou [...]</p>
<hr>
<img src=\"http://feeds.feedburner.com/~r/seomix-wordpress/~4/ILaOPMQdq2U\" height=\"1\" width=\"1\" alt=\"\">
</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:2:{s:4:\"date\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2016-04-07T07:00:16+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Vincent Ble\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2348:\"<div>
<div><img width=\"250\" height=\"250\" src=\"http://www.seomix.fr/wp-content/uploads/2016/04/apprehender_wordpress-250x250.jpg\" class=\"attachment-thumb-250-250-true size-thumb-250-250-true wp-post-image\" alt=\"Appr&eacute;hender WordPress pour un d&eacute;veloppeur\" srcset=\"http://www.seomix.fr/wp-content/uploads/2016/04/apprehender_wordpress-130x130.jpg 130w, http://www.seomix.fr/wp-content/uploads/2016/04/apprehender_wordpress-150x150.jpg 150w, http://www.seomix.fr/wp-content/uploads/2016/04/apprehender_wordpress-200x200.jpg 200w, http://www.seomix.fr/wp-content/uploads/2016/04/apprehender_wordpress-250x250.jpg 250w, http://www.seomix.fr/wp-content/uploads/2016/04/apprehender_wordpress-100x100.jpg 100w\" sizes=\"(max-width: 250px) 100vw, 250px\"></div>Trop souvent, les d&eacute;veloppeurs ne prennent pas le temps de comprendre WordPress. Il est pourtant indispensable de se former &agrave; ce CMS. Voici par o&ugrave; commencer !<p><strong>Acc&eacute;dez &agrave; l\'article original :</strong> <a href=\"http://www.seomix.fr/apprehender-wordpress-developpeur/\">Appr&eacute;hender WordPress pour un d&eacute;veloppeur</a>.</p>
    <p><strong>Voici le d&eacute;but du contenu :</strong> </p>
<p></p> <p>Appr&eacute;hender WordPress, c&rsquo;est comprendre ce que ce CMS propose. Beaucoup de d&eacute;veloppeurs &laquo; qui d&eacute;butent sur WordPress&nbsp;&raquo; auront tendance &ndash; au d&eacute;part &ndash; &agrave; se pr&eacute;cipiter sur le fonctionnel et &agrave; utiliser ce qu&rsquo;ils savent d&eacute;j&agrave;. C&rsquo;est sans aucun doute la premi&egrave;re erreur qu&rsquo;ils commettront alors qu&rsquo;ils connaissent tr&egrave;s bien l&rsquo;adage du d&eacute;veloppeur &laquo;&nbsp;ne pas r&eacute;inventer la roue&nbsp;&raquo;.</p> <p>Pour tout framework (Symfony, zend PHP, AngularJs&hellip;), le d&eacute;veloppeur se documentera pr&eacute;alablement et gardera pour r&eacute;f&eacute;rence la documentation officielle. Pour tout ce qui n&rsquo;existe pas encore, il s&rsquo;inspirera de codes &laquo;&nbsp;snippets&nbsp;&raquo; ou d&eacute;veloppera de toute pi&egrave;ce la classe ou [...]</p>
<hr>
<img src=\"http://feeds.feedburner.com/~r/seomix-wordpress/~4/ILaOPMQdq2U\" height=\"1\" width=\"1\" alt=\"\">
</div><img src=\"http://feeds.feedburner.com/~r/wordpress-fr/RaoY/~4/ILaOPMQdq2U\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"http://www.seomix.fr/apprehender-wordpress-developpeur/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:59:\"
    \";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:5:\"about\";s:60:\"https://wpchannel.com/supprimer-balises-opengraph-yoast-seo/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:24:\"http://purl.org/rss/1.0/\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"WordPress Channel : Supprimer les balises OpenGraph de Yoast SEO\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"http://feedproxy.google.com/~r/wordpress-fr/RaoY/~3/Cx0XtLFpYJc/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:816:\"<div>
<p>Pour am&eacute;liorer votre r&eacute;f&eacute;rencement, des extensions comme Yoast SEO rajoutent des balises Open Graph afin d&rsquo;optimiser le partage de vos contenus sur les r&eacute;seaux sociaux. N&eacute;anmoins, il n&rsquo;existe aucune option vous permettant de choisir pr&eacute;cis&eacute;ment la liste des balises que vous souhaitez activer. Une nouvelle fois, le recours aux fameux hooks est la cl&eacute; de [&hellip;]</p>
<p><a rel=\"nofollow\" href=\"https://wpchannel.com/author/aurelien-denis/\">Aur&eacute;lien Denis</a> - <a rel=\"nofollow\" href=\"https://wpchannel.com/\">WordPress Channel - Tutoriels, th&egrave;mes &amp; plugins WordPress</a> - <a rel=\"nofollow\" href=\"https://wpchannel.com/supprimer-balises-opengraph-yoast-seo/\">Supprimer les balises OpenGraph de Yoast SEO</a></p>
</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:2:{s:4:\"date\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2016-04-05T08:00:35+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Aurlien Denis\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:920:\"<div>
<p>Pour am&eacute;liorer votre r&eacute;f&eacute;rencement, des extensions comme Yoast SEO rajoutent des balises Open Graph afin d&rsquo;optimiser le partage de vos contenus sur les r&eacute;seaux sociaux. N&eacute;anmoins, il n&rsquo;existe aucune option vous permettant de choisir pr&eacute;cis&eacute;ment la liste des balises que vous souhaitez activer. Une nouvelle fois, le recours aux fameux hooks est la cl&eacute; de [&hellip;]</p>
<p><a rel=\"nofollow\" href=\"https://wpchannel.com/author/aurelien-denis/\">Aur&eacute;lien Denis</a> - <a rel=\"nofollow\" href=\"https://wpchannel.com/\">WordPress Channel - Tutoriels, th&egrave;mes &amp; plugins WordPress</a> - <a rel=\"nofollow\" href=\"https://wpchannel.com/supprimer-balises-opengraph-yoast-seo/\">Supprimer les balises OpenGraph de Yoast SEO</a></p>
</div><img src=\"http://feeds.feedburner.com/~r/wordpress-fr/RaoY/~4/Cx0XtLFpYJc\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wpchannel.com/supprimer-balises-opengraph-yoast-seo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:59:\"
    \";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:5:\"about\";s:50:\"http://www.echodesplugins.li-an.fr/plugins/flatty/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:24:\"http://purl.org/rss/1.0/\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"L&#039;cho des plugins WordPress : Flatty\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"http://feedproxy.google.com/~r/wordpress-fr/RaoY/~3/TNaC6d4ln-8/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"<div>Relookez votre administration et effacez toute trace visible de Wordpress</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:2:{s:4:\"date\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2016-04-02T18:28:42+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"Li-An\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:188:\"<div>Relookez votre administration et effacez toute trace visible de Wordpress</div><img src=\"http://feeds.feedburner.com/~r/wordpress-fr/RaoY/~4/TNaC6d4ln-8\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"http://www.echodesplugins.li-an.fr/plugins/flatty/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:59:\"
    \";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:5:\"about\";s:80:\"https://www.gregoirenoyelle.com/wordpress-gestion-optimisee-organisation-medias/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:24:\"http://purl.org/rss/1.0/\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"Grgoire Noyelle : WordPress :: Gestion optimise de lorganisation des mdias\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"http://feedproxy.google.com/~r/wordpress-fr/RaoY/~3/UpMmEOmtz9E/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:817:\"<div>Dans ce tutoriel nous verrons comment dans WordPress optimiser la gestion de tous vos m&eacute;dias gr&acirc;ce &agrave; la tr&egrave;s bonne extension&nbsp;Enhanced Media Library. Organisation des m&eacute;dias dans WordPress Options WordPress par d&eacute;faut Par d&eacute;faut, deux options sont disponibles dans WordPress. La premi&egrave;re, celle par d&eacute;faut, organise les m&eacute;dias par date en cr&eacute;ant des dossiers par ...<p>Cet article a &eacute;t&eacute; publi&eacute; le 31 mars 2016 par <a href=\"https://www.gregoirenoyelle.com/\">Gr&eacute;goire Noyelle</a>. Pour le lire en ligne, suivre le lien: <a href=\"https://www.gregoirenoyelle.com/wordpress-gestion-optimisee-organisation-medias/\">WordPress :: Gestion optimis&eacute;e de l&rsquo;organisation des m&eacute;dias</a>.</p>
</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:2:{s:4:\"date\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2016-03-31T06:59:08+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Grgoire Noyelle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:921:\"<div>Dans ce tutoriel nous verrons comment dans WordPress optimiser la gestion de tous vos m&eacute;dias gr&acirc;ce &agrave; la tr&egrave;s bonne extension&nbsp;Enhanced Media Library. Organisation des m&eacute;dias dans WordPress Options WordPress par d&eacute;faut Par d&eacute;faut, deux options sont disponibles dans WordPress. La premi&egrave;re, celle par d&eacute;faut, organise les m&eacute;dias par date en cr&eacute;ant des dossiers par ...<p>Cet article a &eacute;t&eacute; publi&eacute; le 31 mars 2016 par <a href=\"https://www.gregoirenoyelle.com/\">Gr&eacute;goire Noyelle</a>. Pour le lire en ligne, suivre le lien: <a href=\"https://www.gregoirenoyelle.com/wordpress-gestion-optimisee-organisation-medias/\">WordPress :: Gestion optimis&eacute;e de l&rsquo;organisation des m&eacute;dias</a>.</p>
</div><img src=\"http://feeds.feedburner.com/~r/wordpress-fr/RaoY/~4/UpMmEOmtz9E\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://www.gregoirenoyelle.com/wordpress-gestion-optimisee-organisation-medias/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:59:\"
    \";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:5:\"about\";s:88:\"https://wpchannel.com/wp-admin-ui-personnaliser-optimiser-back-office-wordpress-clients/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:24:\"http://purl.org/rss/1.0/\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"WordPress Channel : WP Admin UI, personnaliser et optimiser le back-office WordPress pour vos clients\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"http://feedproxy.google.com/~r/wordpress-fr/RaoY/~3/bvLfTb79em0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:889:\"<div>
<p>WP Admin UI est un plugin freemium pour personnaliser, optimiser et g&eacute;rer l&rsquo;administration WordPress de&nbsp;vos clients. Aucune connaissance technique n&eacute;cessaire. Petit tour du propri&eacute;taire. Pourquoi ce plugin ? En 2014, j&rsquo;ai eu l&rsquo;occasion de donner une conf&eacute;rence au WP Tech &agrave; Nantes sur la personnalisation du back-office&nbsp;WordPress pour vos clients. Les nombreux retours positifs sur [&hellip;]</p>
<p><a rel=\"nofollow\" href=\"https://wpchannel.com/author/rainbow/\">Benjamin Denis</a> - <a rel=\"nofollow\" href=\"https://wpchannel.com/\">WordPress Channel - Tutoriels, th&egrave;mes &amp; plugins WordPress</a> - <a rel=\"nofollow\" href=\"https://wpchannel.com/wp-admin-ui-personnaliser-optimiser-back-office-wordpress-clients/\">WP Admin UI, personnaliser et optimiser le back-office WordPress pour vos clients</a></p>
</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:2:{s:4:\"date\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2016-03-30T08:00:34+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Benjamin Denis\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:993:\"<div>
<p>WP Admin UI est un plugin freemium pour personnaliser, optimiser et g&eacute;rer l&rsquo;administration WordPress de&nbsp;vos clients. Aucune connaissance technique n&eacute;cessaire. Petit tour du propri&eacute;taire. Pourquoi ce plugin ? En 2014, j&rsquo;ai eu l&rsquo;occasion de donner une conf&eacute;rence au WP Tech &agrave; Nantes sur la personnalisation du back-office&nbsp;WordPress pour vos clients. Les nombreux retours positifs sur [&hellip;]</p>
<p><a rel=\"nofollow\" href=\"https://wpchannel.com/author/rainbow/\">Benjamin Denis</a> - <a rel=\"nofollow\" href=\"https://wpchannel.com/\">WordPress Channel - Tutoriels, th&egrave;mes &amp; plugins WordPress</a> - <a rel=\"nofollow\" href=\"https://wpchannel.com/wp-admin-ui-personnaliser-optimiser-back-office-wordpress-clients/\">WP Admin UI, personnaliser et optimiser le back-office WordPress pour vos clients</a></p>
</div><img src=\"http://feeds.feedburner.com/~r/wordpress-fr/RaoY/~4/bvLfTb79em0\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://wpchannel.com/wp-admin-ui-personnaliser-optimiser-back-office-wordpress-clients/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:59:\"
    \";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:5:\"about\";s:56:\"http://www.echodesplugins.li-an.fr/plugins/front-end-pm/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:24:\"http://purl.org/rss/1.0/\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"L&#039;cho des plugins WordPress : Front End PM\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"http://feedproxy.google.com/~r/wordpress-fr/RaoY/~3/V2FXf1M_t2Y/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"<div>Un syst&egrave;me complet de messages priv&eacute;s</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:2:{s:4:\"date\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2016-03-26T14:18:55+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"Li-An\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:166:\"<div>Un syst&egrave;me complet de messages priv&eacute;s</div><img src=\"http://feeds.feedburner.com/~r/wordpress-fr/RaoY/~4/V2FXf1M_t2Y\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"http://www.echodesplugins.li-an.fr/plugins/front-end-pm/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:59:\"
    \";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:5:\"about\";s:37:\"http://wpmarmite.com/pat-episode-022/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:24:\"http://purl.org/rss/1.0/\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"WP Marmite : PAT022  Emilie Lebrun et la professionnalisation de WordPress en France\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"http://feedproxy.google.com/~r/wordpress-fr/RaoY/~3/GmEJAuhzt34/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1016:\"<div>
<p><img width=\"640\" height=\"220\" src=\"http://wpmarmite.com/wp-content/uploads/2016/03/emilie-lebrun.jpg\" class=\"attachment-full size-full wp-post-image\" alt=\"emilie-lebrun\" srcset=\"http://wpmarmite.com/wp-content/uploads/2016/03/emilie-lebrun-300x103.jpg 300w, http://wpmarmite.com/wp-content/uploads/2016/03/emilie-lebrun.jpg 640w\" sizes=\"(max-width: 640px) 100vw, 640px\"></p>
<p>Je ne vous apprends rien en vous disant que beaucoup de personnes pensent encore que &laquo;&nbsp;WordPress, ce n&rsquo;est que pour&nbsp;faire des blogs&nbsp;&raquo;. Bien s&ucirc;r, je ne parle pas de la...</p>
<p><a rel=\"nofollow\" href=\"http://wpmarmite.com/pat-episode-022/\">PAT022 &ndash; Emilie Lebrun et la professionnalisation de WordPress en France</a> est un article de <a rel=\"nofollow\" href=\"http://wpmarmite.com/\">WP Marmite</a>, le blog qui vous aide &agrave; tirer le meilleur de WordPress.<br><a href=\"http://wpmarmite.com/newsletter\">Abonnez-vous &agrave; la newsletter</a> pour recevoir les suivants.</p>
</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:2:{s:4:\"date\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2016-03-24T07:18:44+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Alex\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1120:\"<div>
<p><img width=\"640\" height=\"220\" src=\"http://wpmarmite.com/wp-content/uploads/2016/03/emilie-lebrun.jpg\" class=\"attachment-full size-full wp-post-image\" alt=\"emilie-lebrun\" srcset=\"http://wpmarmite.com/wp-content/uploads/2016/03/emilie-lebrun-300x103.jpg 300w, http://wpmarmite.com/wp-content/uploads/2016/03/emilie-lebrun.jpg 640w\" sizes=\"(max-width: 640px) 100vw, 640px\"></p>
<p>Je ne vous apprends rien en vous disant que beaucoup de personnes pensent encore que &laquo;&nbsp;WordPress, ce n&rsquo;est que pour&nbsp;faire des blogs&nbsp;&raquo;. Bien s&ucirc;r, je ne parle pas de la...</p>
<p><a rel=\"nofollow\" href=\"http://wpmarmite.com/pat-episode-022/\">PAT022 &ndash; Emilie Lebrun et la professionnalisation de WordPress en France</a> est un article de <a rel=\"nofollow\" href=\"http://wpmarmite.com/\">WP Marmite</a>, le blog qui vous aide &agrave; tirer le meilleur de WordPress.<br><a href=\"http://wpmarmite.com/newsletter\">Abonnez-vous &agrave; la newsletter</a> pour recevoir les suivants.</p>
</div><img src=\"http://feeds.feedburner.com/~r/wordpress-fr/RaoY/~4/GmEJAuhzt34\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://wpmarmite.com/pat-episode-022/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:59:\"
    \";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:5:\"about\";s:57:\"https://wpchannel.com/obtenir-role-utilisateur-wordpress/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:24:\"http://purl.org/rss/1.0/\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"WordPress Channel : Obtenir le rle dun utilisateur WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"http://feedproxy.google.com/~r/wordpress-fr/RaoY/~3/2Tq_lLTnuf4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:910:\"<div>
<p>Un utilisateur WordPress est toujours associ&eacute; &agrave; un r&ocirc;le (abonn&eacute;, contributeur, auteur, &eacute;diteur et administrateur) auquel sont associ&eacute;es des capacit&eacute;s (publier un contenu, modifier les r&eacute;glages, etc.). &nbsp;Si vous souhaitez afficher sur votre site le r&ocirc;le d&rsquo;un utilisateur, quelques lignes de code seront n&eacute;cessaires. Pour obtenir&nbsp;le r&ocirc;le de l&rsquo;utilisateur connect&eacute;, ins&eacute;rez ces quelques lignes l&agrave; [&hellip;]</p>
<p><a rel=\"nofollow\" href=\"https://wpchannel.com/author/aurelien-denis/\">Aur&eacute;lien Denis</a> - <a rel=\"nofollow\" href=\"https://wpchannel.com/\">WordPress Channel - Tutoriels, th&egrave;mes &amp; plugins WordPress</a> - <a rel=\"nofollow\" href=\"https://wpchannel.com/obtenir-role-utilisateur-wordpress/\">Obtenir le r&ocirc;le d&rsquo;un utilisateur WordPress</a></p>
</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:2:{s:4:\"date\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2016-03-22T08:00:38+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Aurlien Denis\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1014:\"<div>
<p>Un utilisateur WordPress est toujours associ&eacute; &agrave; un r&ocirc;le (abonn&eacute;, contributeur, auteur, &eacute;diteur et administrateur) auquel sont associ&eacute;es des capacit&eacute;s (publier un contenu, modifier les r&eacute;glages, etc.). &nbsp;Si vous souhaitez afficher sur votre site le r&ocirc;le d&rsquo;un utilisateur, quelques lignes de code seront n&eacute;cessaires. Pour obtenir&nbsp;le r&ocirc;le de l&rsquo;utilisateur connect&eacute;, ins&eacute;rez ces quelques lignes l&agrave; [&hellip;]</p>
<p><a rel=\"nofollow\" href=\"https://wpchannel.com/author/aurelien-denis/\">Aur&eacute;lien Denis</a> - <a rel=\"nofollow\" href=\"https://wpchannel.com/\">WordPress Channel - Tutoriels, th&egrave;mes &amp; plugins WordPress</a> - <a rel=\"nofollow\" href=\"https://wpchannel.com/obtenir-role-utilisateur-wordpress/\">Obtenir le r&ocirc;le d&rsquo;un utilisateur WordPress</a></p>
</div><img src=\"http://feeds.feedburner.com/~r/wordpress-fr/RaoY/~4/2Tq_lLTnuf4\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://wpchannel.com/obtenir-role-utilisateur-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:59:\"
    \";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:5:\"about\";s:47:\"http://www.echodesplugins.li-an.fr/plugins/amp/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:24:\"http://purl.org/rss/1.0/\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"L&#039;cho des plugins WordPress : AMP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"http://feedproxy.google.com/~r/wordpress-fr/RaoY/~3/-Sqy1seHDc8/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"<div>L\'AMP pour les nuls</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:2:{s:4:\"date\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2016-03-20T15:21:46+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"Li-An\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:134:\"<div>L\'AMP pour les nuls</div><img src=\"http://feeds.feedburner.com/~r/wordpress-fr/RaoY/~4/-Sqy1seHDc8\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://www.echodesplugins.li-an.fr/plugins/amp/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:59:\"
    \";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:5:\"about\";s:49:\"http://wpformation.com/seo-multilingue-wordpress/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:24:\"http://purl.org/rss/1.0/\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WP Formation : SEO et Multilingue sur WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"http://feedproxy.google.com/~r/wordpress-fr/RaoY/~3/4hVRU8LWuM8/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1704:\"<div>
<p><img width=\"900\" height=\"529\" src=\"http://wpformation.com/wp-content/uploads/2016/03/multilingue-seo-wordpress.jpg\" class=\"attachment-Large size-Large wp-post-image\" alt=\"multilingue-seo-wordpress\" style=\"display: block; margin-left: 0px; margin-right: auto; margin-top:10px; margin-bottom:10px; max-width: 640px; max-height: 400px; \" srcset=\"http://wpformation.com/wp-content/uploads/2016/03/multilingue-seo-wordpress-300x176.jpg 300w, http://wpformation.com/wp-content/uploads/2016/03/multilingue-seo-wordpress-768x451.jpg 768w, http://wpformation.com/wp-content/uploads/2016/03/multilingue-seo-wordpress-600x353.jpg 600w, http://wpformation.com/wp-content/uploads/2016/03/multilingue-seo-wordpress-610x359.jpg 610w, http://wpformation.com/wp-content/uploads/2016/03/multilingue-seo-wordpress-810x476.jpg 810w, http://wpformation.com/wp-content/uploads/2016/03/multilingue-seo-wordpress.jpg 900w\" sizes=\"(max-width: 900px) 100vw, 900px\">Le but de cet article est de comprendre comment fonctionne le SEO multilingue et d&rsquo;&ecirc;tre capable de choisir une solution multilingue WordPress compatible avec les  bonnes pratiques de Google.</p>
<p>
</p>
<hr>
<a rel=\"nofollow\" href=\"http://wpformation.com/seo-multilingue-wordpress/\">SEO et Multilingue sur WordPress</a> est un article de <a title=\"Formation WordPress Ecommerce\" href=\"http://wpformation.com/\">WP Formation</a>
<p><a href=\"http://wpformation.com/formation-wordpress/\">Formation WordPress</a> &amp; <a href=\"http://wpformation.com/formation-woocommerce-e-commerce/\">WooCommerce</a> - Pour ne rien manquer : <a href=\"http://wpformation.com/abonnement-newsletter-wpf/\">Abonnez-vous &agrave; la newsletter</a> !<br></p>
<hr>
</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:2:{s:4:\"date\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2016-03-18T09:30:16+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"Rmy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1808:\"<div>
<p><img width=\"900\" height=\"529\" src=\"http://wpformation.com/wp-content/uploads/2016/03/multilingue-seo-wordpress.jpg\" class=\"attachment-Large size-Large wp-post-image\" alt=\"multilingue-seo-wordpress\" style=\"display: block; margin-left: 0px; margin-right: auto; margin-top:10px; margin-bottom:10px; max-width: 640px; max-height: 400px; \" srcset=\"http://wpformation.com/wp-content/uploads/2016/03/multilingue-seo-wordpress-300x176.jpg 300w, http://wpformation.com/wp-content/uploads/2016/03/multilingue-seo-wordpress-768x451.jpg 768w, http://wpformation.com/wp-content/uploads/2016/03/multilingue-seo-wordpress-600x353.jpg 600w, http://wpformation.com/wp-content/uploads/2016/03/multilingue-seo-wordpress-610x359.jpg 610w, http://wpformation.com/wp-content/uploads/2016/03/multilingue-seo-wordpress-810x476.jpg 810w, http://wpformation.com/wp-content/uploads/2016/03/multilingue-seo-wordpress.jpg 900w\" sizes=\"(max-width: 900px) 100vw, 900px\">Le but de cet article est de comprendre comment fonctionne le SEO multilingue et d&rsquo;&ecirc;tre capable de choisir une solution multilingue WordPress compatible avec les  bonnes pratiques de Google.</p>
<p>
</p>
<hr>
<a rel=\"nofollow\" href=\"http://wpformation.com/seo-multilingue-wordpress/\">SEO et Multilingue sur WordPress</a> est un article de <a title=\"Formation WordPress Ecommerce\" href=\"http://wpformation.com/\">WP Formation</a>
<p><a href=\"http://wpformation.com/formation-wordpress/\">Formation WordPress</a> &amp; <a href=\"http://wpformation.com/formation-woocommerce-e-commerce/\">WooCommerce</a> - Pour ne rien manquer : <a href=\"http://wpformation.com/abonnement-newsletter-wpf/\">Abonnez-vous &agrave; la newsletter</a> !<br></p>
<hr>
</div><img src=\"http://feeds.feedburner.com/~r/wordpress-fr/RaoY/~4/4hVRU8LWuM8\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"http://wpformation.com/seo-multilingue-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:59:\"
    \";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:5:\"about\";s:52:\"http://wpmarmite.com/gestion-utilisateurs-wordpress/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:24:\"http://purl.org/rss/1.0/\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WP Marmite : Comment grer les utilisateurs et les rles dans WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"http://feedproxy.google.com/~r/wordpress-fr/RaoY/~3/fSdyA05XYIs/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1113:\"<div>
<p><img width=\"640\" height=\"220\" src=\"http://wpmarmite.com/wp-content/uploads/2016/03/utilisateurs-wordpress.jpg\" class=\"attachment-full size-full wp-post-image\" alt=\"utilisateurs-wordpress\" srcset=\"http://wpmarmite.com/wp-content/uploads/2016/03/utilisateurs-wordpress-300x103.jpg 300w, http://wpmarmite.com/wp-content/uploads/2016/03/utilisateurs-wordpress.jpg 640w\" sizes=\"(max-width: 640px) 100vw, 640px\"></p>
<p>Vous souvenez-vous du jour o&ugrave; vous avez install&eacute;&nbsp;WordPress ? Si oui, vous devez vous rappeler&nbsp;que votre compte a &eacute;t&eacute; cr&eacute;&eacute; automatiquement &agrave; ce moment l&agrave;. Pour &ecirc;tre plus pr&eacute;cis, il...</p>
<p><a rel=\"nofollow\" href=\"http://wpmarmite.com/gestion-utilisateurs-wordpress/\">Comment g&eacute;rer les utilisateurs et les r&ocirc;les dans WordPress</a> est un article de <a rel=\"nofollow\" href=\"http://wpmarmite.com/\">WP Marmite</a>, le blog qui vous aide &agrave; tirer le meilleur de WordPress.<br><a href=\"http://wpmarmite.com/newsletter\">Abonnez-vous &agrave; la newsletter</a> pour recevoir les suivants.</p>
</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:2:{s:4:\"date\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2016-03-18T07:53:23+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Alex\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1217:\"<div>
<p><img width=\"640\" height=\"220\" src=\"http://wpmarmite.com/wp-content/uploads/2016/03/utilisateurs-wordpress.jpg\" class=\"attachment-full size-full wp-post-image\" alt=\"utilisateurs-wordpress\" srcset=\"http://wpmarmite.com/wp-content/uploads/2016/03/utilisateurs-wordpress-300x103.jpg 300w, http://wpmarmite.com/wp-content/uploads/2016/03/utilisateurs-wordpress.jpg 640w\" sizes=\"(max-width: 640px) 100vw, 640px\"></p>
<p>Vous souvenez-vous du jour o&ugrave; vous avez install&eacute;&nbsp;WordPress ? Si oui, vous devez vous rappeler&nbsp;que votre compte a &eacute;t&eacute; cr&eacute;&eacute; automatiquement &agrave; ce moment l&agrave;. Pour &ecirc;tre plus pr&eacute;cis, il...</p>
<p><a rel=\"nofollow\" href=\"http://wpmarmite.com/gestion-utilisateurs-wordpress/\">Comment g&eacute;rer les utilisateurs et les r&ocirc;les dans WordPress</a> est un article de <a rel=\"nofollow\" href=\"http://wpmarmite.com/\">WP Marmite</a>, le blog qui vous aide &agrave; tirer le meilleur de WordPress.<br><a href=\"http://wpmarmite.com/newsletter\">Abonnez-vous &agrave; la newsletter</a> pour recevoir les suivants.</p>
</div><img src=\"http://feeds.feedburner.com/~r/wordpress-fr/RaoY/~4/fSdyA05XYIs\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"http://wpmarmite.com/gestion-utilisateurs-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:59:\"
    \";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:5:\"about\";s:69:\"http://www.seomix.fr/creer-un-site-wordpress-les-cles-de-la-reussite/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:24:\"http://purl.org/rss/1.0/\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"SEOMix : Crer un site WordPress : les cls de la russite !\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"http://feedproxy.google.com/~r/wordpress-fr/RaoY/~3/4CLd-q5rivA/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2191:\"<div>
<div><img width=\"250\" height=\"250\" src=\"http://www.seomix.fr/wp-content/uploads/2016/03/Image2-250x250.png\" class=\"attachment-thumb-250-250-true size-thumb-250-250-true wp-post-image\" alt=\"Se former pour le web\" srcset=\"http://www.seomix.fr/wp-content/uploads/2016/03/Image2-130x130.png 130w, http://www.seomix.fr/wp-content/uploads/2016/03/Image2-150x150.png 150w, http://www.seomix.fr/wp-content/uploads/2016/03/Image2-200x200.png 200w, http://www.seomix.fr/wp-content/uploads/2016/03/Image2-250x250.png 250w, http://www.seomix.fr/wp-content/uploads/2016/03/Image2-100x100.png 100w\" sizes=\"(max-width: 250px) 100vw, 250px\"></div>Apprenez &agrave; cr&eacute;er un site WordPress et &agrave; le transformer en v&eacute;ritable succ&egrave;s pour votre entreprise ! Pour cela, Daniel Roch donne son retour d\'exp&eacute;rience lors du WordCamp Paris 2016<p><strong>Acc&eacute;dez &agrave; l\'article original :</strong> <a href=\"http://www.seomix.fr/creer-un-site-wordpress-les-cles-de-la-reussite/\">Cr&eacute;er un site WordPress : les cl&eacute;s de la r&eacute;ussite !</a>.</p>
    <p><strong>Voici le d&eacute;but du contenu :</strong> </p>
<p>Chez SeoMix, nous sommes des sp&eacute;cialistes du CMS WordPress. On a tendance &agrave; conseiller son utilisation dans un grand nombre de projets de nos clients. Et pourtant, ce n&rsquo;est pas la simple utilisation de cet outil open source qui va vous permettre de r&eacute;ussir notre site Internet.</p> <p>Lors du dernier WordCamp Paris, nous avons justement fait une conf&eacute;rence sur ce sujet (vous retrouvez les slides &agrave; la fin de l&rsquo;article, et la vid&eacute;o d&egrave;s qu&rsquo;elle sera publi&eacute;e).</p> <h2>Strat&eacute;gie, objectifs et moyens d&eacute;di&eacute;s &agrave; WordPress</h2> <p>C&rsquo;est la base : si vous ne d&eacute;finissez pas une strat&eacute;gie coh&eacute;rente, impossible d&rsquo;avoir un projet web qui r&eacute;ussit. Il faut donc d&rsquo;abord poser les bases n&eacute;cessaires au succ&egrave;s : d&eacute;finir correctement son projet WordPress (ou [...]</p>
<hr>
<img src=\"http://feeds.feedburner.com/~r/seomix-wordpress/~4/4CLd-q5rivA\" height=\"1\" width=\"1\" alt=\"\">
</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:2:{s:4:\"date\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2016-03-17T07:00:04+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Daniel Roch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2295:\"<div>
<div><img width=\"250\" height=\"250\" src=\"http://www.seomix.fr/wp-content/uploads/2016/03/Image2-250x250.png\" class=\"attachment-thumb-250-250-true size-thumb-250-250-true wp-post-image\" alt=\"Se former pour le web\" srcset=\"http://www.seomix.fr/wp-content/uploads/2016/03/Image2-130x130.png 130w, http://www.seomix.fr/wp-content/uploads/2016/03/Image2-150x150.png 150w, http://www.seomix.fr/wp-content/uploads/2016/03/Image2-200x200.png 200w, http://www.seomix.fr/wp-content/uploads/2016/03/Image2-250x250.png 250w, http://www.seomix.fr/wp-content/uploads/2016/03/Image2-100x100.png 100w\" sizes=\"(max-width: 250px) 100vw, 250px\"></div>Apprenez &agrave; cr&eacute;er un site WordPress et &agrave; le transformer en v&eacute;ritable succ&egrave;s pour votre entreprise ! Pour cela, Daniel Roch donne son retour d\'exp&eacute;rience lors du WordCamp Paris 2016<p><strong>Acc&eacute;dez &agrave; l\'article original :</strong> <a href=\"http://www.seomix.fr/creer-un-site-wordpress-les-cles-de-la-reussite/\">Cr&eacute;er un site WordPress : les cl&eacute;s de la r&eacute;ussite !</a>.</p>
    <p><strong>Voici le d&eacute;but du contenu :</strong> </p>
<p>Chez SeoMix, nous sommes des sp&eacute;cialistes du CMS WordPress. On a tendance &agrave; conseiller son utilisation dans un grand nombre de projets de nos clients. Et pourtant, ce n&rsquo;est pas la simple utilisation de cet outil open source qui va vous permettre de r&eacute;ussir notre site Internet.</p> <p>Lors du dernier WordCamp Paris, nous avons justement fait une conf&eacute;rence sur ce sujet (vous retrouvez les slides &agrave; la fin de l&rsquo;article, et la vid&eacute;o d&egrave;s qu&rsquo;elle sera publi&eacute;e).</p> <h2>Strat&eacute;gie, objectifs et moyens d&eacute;di&eacute;s &agrave; WordPress</h2> <p>C&rsquo;est la base : si vous ne d&eacute;finissez pas une strat&eacute;gie coh&eacute;rente, impossible d&rsquo;avoir un projet web qui r&eacute;ussit. Il faut donc d&rsquo;abord poser les bases n&eacute;cessaires au succ&egrave;s : d&eacute;finir correctement son projet WordPress (ou [...]</p>
<hr>
<img src=\"http://feeds.feedburner.com/~r/seomix-wordpress/~4/4CLd-q5rivA\" height=\"1\" width=\"1\" alt=\"\">
</div><img src=\"http://feeds.feedburner.com/~r/wordpress-fr/RaoY/~4/4CLd-q5rivA\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"http://www.seomix.fr/creer-un-site-wordpress-les-cles-de-la-reussite/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:59:\"
    \";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:5:\"about\";s:37:\"http://wpmarmite.com/boutons-partage/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:24:\"http://purl.org/rss/1.0/\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"WP Marmite : La vrit sur les boutons de partage (et la meilleure extension)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"http://feedproxy.google.com/~r/wordpress-fr/RaoY/~3/ljvDRKEUGnM/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1117:\"<div>
<p><img width=\"640\" height=\"220\" src=\"http://wpmarmite.com/wp-content/uploads/2016/03/partage-social-wordpress.jpg\" class=\"attachment-full size-full wp-post-image\" alt=\"partage-social-wordpress\" srcset=\"http://wpmarmite.com/wp-content/uploads/2016/03/partage-social-wordpress-300x103.jpg 300w, http://wpmarmite.com/wp-content/uploads/2016/03/partage-social-wordpress.jpg 640w\" sizes=\"(max-width: 640px) 100vw, 640px\"></p>
<p>Il existe des dizaines d&rsquo;extensions de partage social&nbsp;pour WordPress. Devant un tel choix, il est difficile d&rsquo;en choisir une plut&ocirc;t qu&rsquo;une autre&hellip; Jusqu&rsquo;&agrave; aujourd&rsquo;hui. Apr&egrave;s des heures de recherches et...</p>
<p><a rel=\"nofollow\" href=\"http://wpmarmite.com/boutons-partage/\">La v&eacute;rit&eacute; sur les boutons de partage (et la meilleure extension)</a> est un article de <a rel=\"nofollow\" href=\"http://wpmarmite.com/\">WP Marmite</a>, le blog qui vous aide &agrave; tirer le meilleur de WordPress.<br><a href=\"http://wpmarmite.com/newsletter\">Abonnez-vous &agrave; la newsletter</a> pour recevoir les suivants.</p>
</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:2:{s:4:\"date\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2016-03-15T07:24:57+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nicolas Richer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1221:\"<div>
<p><img width=\"640\" height=\"220\" src=\"http://wpmarmite.com/wp-content/uploads/2016/03/partage-social-wordpress.jpg\" class=\"attachment-full size-full wp-post-image\" alt=\"partage-social-wordpress\" srcset=\"http://wpmarmite.com/wp-content/uploads/2016/03/partage-social-wordpress-300x103.jpg 300w, http://wpmarmite.com/wp-content/uploads/2016/03/partage-social-wordpress.jpg 640w\" sizes=\"(max-width: 640px) 100vw, 640px\"></p>
<p>Il existe des dizaines d&rsquo;extensions de partage social&nbsp;pour WordPress. Devant un tel choix, il est difficile d&rsquo;en choisir une plut&ocirc;t qu&rsquo;une autre&hellip; Jusqu&rsquo;&agrave; aujourd&rsquo;hui. Apr&egrave;s des heures de recherches et...</p>
<p><a rel=\"nofollow\" href=\"http://wpmarmite.com/boutons-partage/\">La v&eacute;rit&eacute; sur les boutons de partage (et la meilleure extension)</a> est un article de <a rel=\"nofollow\" href=\"http://wpmarmite.com/\">WP Marmite</a>, le blog qui vous aide &agrave; tirer le meilleur de WordPress.<br><a href=\"http://wpmarmite.com/newsletter\">Abonnez-vous &agrave; la newsletter</a> pour recevoir les suivants.</p>
</div><img src=\"http://feeds.feedburner.com/~r/wordpress-fr/RaoY/~4/ljvDRKEUGnM\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://wpmarmite.com/boutons-partage/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:59:\"
    \";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:5:\"about\";s:65:\"http://www.echodesplugins.li-an.fr/plugins/feature-a-page-widget/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:24:\"http://purl.org/rss/1.0/\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"L&#039;cho des plugins WordPress : Feature A Page Widget\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"http://feedproxy.google.com/~r/wordpress-fr/RaoY/~3/tF34sl64lUM/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"<div>Un widget pour mettre en avant des pages</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:2:{s:4:\"date\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2016-03-14T17:10:51+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"Li-An\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:155:\"<div>Un widget pour mettre en avant des pages</div><img src=\"http://feeds.feedburner.com/~r/wordpress-fr/RaoY/~4/tF34sl64lUM\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"http://www.echodesplugins.li-an.fr/plugins/feature-a-page-widget/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:59:\"
    \";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:5:\"about\";s:37:\"http://wpformation.com/amp-wordpress/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:24:\"http://purl.org/rss/1.0/\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"WP Formation : Pourquoi et comment installer AMP pour WordPress ?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"http://feedproxy.google.com/~r/wordpress-fr/RaoY/~3/xfezuviohEg/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1993:\"<div>
<p><img width=\"1270\" height=\"614\" src=\"http://wpformation.com/wp-content/uploads/2016/03/google-amp-project.png\" class=\"attachment-Large size-Large wp-post-image\" alt=\"google-amp-project\" style=\"display: block; margin-left: 0px; margin-right: auto; margin-top:10px; margin-bottom:10px; max-width: 640px; max-height: 400px; \" srcset=\"http://wpformation.com/wp-content/uploads/2016/03/google-amp-project-300x145.png 300w, http://wpformation.com/wp-content/uploads/2016/03/google-amp-project-768x371.png 768w, http://wpformation.com/wp-content/uploads/2016/03/google-amp-project-1024x495.png 1024w, http://wpformation.com/wp-content/uploads/2016/03/google-amp-project-600x290.png 600w, http://wpformation.com/wp-content/uploads/2016/03/google-amp-project-610x295.png 610w, http://wpformation.com/wp-content/uploads/2016/03/google-amp-project-810x392.png 810w, http://wpformation.com/wp-content/uploads/2016/03/google-amp-project-1140x551.png 1140w, http://wpformation.com/wp-content/uploads/2016/03/google-amp-project.png 1270w\" sizes=\"(max-width: 1270px) 100vw, 1270px\">Nous en entendons parler depuis un bon moment ! AMP par ci, AMP par l&agrave;... Il faut l\'installer...ou pas ?&nbsp;Mais de quoi s\'agit-il exactement ? J\'ai donc d&eacute;cid&eacute; de me pencher sur cet acronyme &eacute;trange. Nous allons voir dans cet article ce qu\'est AMP, &agrave; quoi il sert, si il faut absolument l\'installer et comment, [&hellip;]</p>
<p>
</p>
<hr>
<a rel=\"nofollow\" href=\"http://wpformation.com/amp-wordpress/\">Pourquoi et comment installer AMP pour WordPress ?</a> est un article de <a title=\"Formation WordPress Ecommerce\" href=\"http://wpformation.com/\">WP Formation</a>
<p><a href=\"http://wpformation.com/formation-wordpress/\">Formation WordPress</a> &amp; <a href=\"http://wpformation.com/formation-woocommerce-e-commerce/\">WooCommerce</a> - Pour ne rien manquer : <a href=\"http://wpformation.com/abonnement-newsletter-wpf/\">Abonnez-vous &agrave; la newsletter</a> !<br></p>
<hr>
</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:2:{s:4:\"date\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2016-03-14T09:01:27+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"WPFormation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2097:\"<div>
<p><img width=\"1270\" height=\"614\" src=\"http://wpformation.com/wp-content/uploads/2016/03/google-amp-project.png\" class=\"attachment-Large size-Large wp-post-image\" alt=\"google-amp-project\" style=\"display: block; margin-left: 0px; margin-right: auto; margin-top:10px; margin-bottom:10px; max-width: 640px; max-height: 400px; \" srcset=\"http://wpformation.com/wp-content/uploads/2016/03/google-amp-project-300x145.png 300w, http://wpformation.com/wp-content/uploads/2016/03/google-amp-project-768x371.png 768w, http://wpformation.com/wp-content/uploads/2016/03/google-amp-project-1024x495.png 1024w, http://wpformation.com/wp-content/uploads/2016/03/google-amp-project-600x290.png 600w, http://wpformation.com/wp-content/uploads/2016/03/google-amp-project-610x295.png 610w, http://wpformation.com/wp-content/uploads/2016/03/google-amp-project-810x392.png 810w, http://wpformation.com/wp-content/uploads/2016/03/google-amp-project-1140x551.png 1140w, http://wpformation.com/wp-content/uploads/2016/03/google-amp-project.png 1270w\" sizes=\"(max-width: 1270px) 100vw, 1270px\">Nous en entendons parler depuis un bon moment ! AMP par ci, AMP par l&agrave;... Il faut l\'installer...ou pas ?&nbsp;Mais de quoi s\'agit-il exactement ? J\'ai donc d&eacute;cid&eacute; de me pencher sur cet acronyme &eacute;trange. Nous allons voir dans cet article ce qu\'est AMP, &agrave; quoi il sert, si il faut absolument l\'installer et comment, [&hellip;]</p>
<p>
</p>
<hr>
<a rel=\"nofollow\" href=\"http://wpformation.com/amp-wordpress/\">Pourquoi et comment installer AMP pour WordPress ?</a> est un article de <a title=\"Formation WordPress Ecommerce\" href=\"http://wpformation.com/\">WP Formation</a>
<p><a href=\"http://wpformation.com/formation-wordpress/\">Formation WordPress</a> &amp; <a href=\"http://wpformation.com/formation-woocommerce-e-commerce/\">WooCommerce</a> - Pour ne rien manquer : <a href=\"http://wpformation.com/abonnement-newsletter-wpf/\">Abonnez-vous &agrave; la newsletter</a> !<br></p>
<hr>
</div><img src=\"http://feeds.feedburner.com/~r/wordpress-fr/RaoY/~4/xfezuviohEg\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://wpformation.com/amp-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:59:\"
    \";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:5:\"about\";s:67:\"https://wpchannel.com/26-photos-libres-droits-promouvoir-wordpress/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:24:\"http://purl.org/rss/1.0/\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"WordPress Channel : 26 photos libres de droits pour promouvoir WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"http://feedproxy.google.com/~r/wordpress-fr/RaoY/~3/UT7TGIjvWg8/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:813:\"<div>
<p>Gr&acirc;ce aux nombreux goodies remis aux orateurs lors du WordCamp Paris 2016, je vous invite &agrave; t&eacute;l&eacute;charger sans mod&eacute;ration une archive de 26 clich&eacute;s haute d&eacute;finition &agrave; utiliser sur vos articles de blogs, vos profils de r&eacute;seaux sociaux ou autre. L&rsquo;album est &eacute;galement disponible sur Flickr&nbsp;ou &agrave; t&eacute;l&eacute;charger en direct :</p>
<p><a rel=\"nofollow\" href=\"https://wpchannel.com/author/aurelien-denis/\">Aur&eacute;lien Denis</a> - <a rel=\"nofollow\" href=\"https://wpchannel.com/\">WordPress Channel - Tutoriels, th&egrave;mes &amp; plugins WordPress</a> - <a rel=\"nofollow\" href=\"https://wpchannel.com/26-photos-libres-droits-promouvoir-wordpress/\">26 photos libres de droits pour promouvoir WordPress</a></p>
</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:2:{s:4:\"date\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2016-03-14T08:00:11+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Aurlien Denis\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:917:\"<div>
<p>Gr&acirc;ce aux nombreux goodies remis aux orateurs lors du WordCamp Paris 2016, je vous invite &agrave; t&eacute;l&eacute;charger sans mod&eacute;ration une archive de 26 clich&eacute;s haute d&eacute;finition &agrave; utiliser sur vos articles de blogs, vos profils de r&eacute;seaux sociaux ou autre. L&rsquo;album est &eacute;galement disponible sur Flickr&nbsp;ou &agrave; t&eacute;l&eacute;charger en direct :</p>
<p><a rel=\"nofollow\" href=\"https://wpchannel.com/author/aurelien-denis/\">Aur&eacute;lien Denis</a> - <a rel=\"nofollow\" href=\"https://wpchannel.com/\">WordPress Channel - Tutoriels, th&egrave;mes &amp; plugins WordPress</a> - <a rel=\"nofollow\" href=\"https://wpchannel.com/26-photos-libres-droits-promouvoir-wordpress/\">26 photos libres de droits pour promouvoir WordPress</a></p>
</div><img src=\"http://feeds.feedburner.com/~r/wordpress-fr/RaoY/~4/UT7TGIjvWg8\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wpchannel.com/26-photos-libres-droits-promouvoir-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:59:\"
    \";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:5:\"about\";s:59:\"http://www.wp-spread.com/compte-rendu-de-wpia-6-a-grenoble/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:24:\"http://purl.org/rss/1.0/\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"WP Spread  Blog : Compte rendu de WPIA 6  Grenoble\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"http://feedproxy.google.com/~r/wordpress-fr/RaoY/~3/dUxr6QV29bk/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:650:\"<div>
<p>Plus de 70 personnes sont venues au meetup WordPress Grenoblois ce 9 mars pour suivre 2 conf&eacute;rences, une table ronde et un ap&eacute;ro dans la bonne humeur. Je commencerais par remercier tous les participants ! L&rsquo;int&eacute;r&ecirc;t que vous avez montr&eacute; pour WordPress est inspirant ! J&rsquo;esp&egrave;re que les sujets abord&eacute;s vous ont plu et que [&hellip;]</p>
<p>Cet article <a rel=\"nofollow\" href=\"http://www.wp-spread.com/compte-rendu-de-wpia-6-a-grenoble/\">Compte rendu de WPIA 6 &agrave; Grenoble</a> est apparu en premier sur <a rel=\"nofollow\" href=\"http://www.wp-spread.com/\">WP Spread</a>.</p>
</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:2:{s:4:\"date\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2016-03-11T18:59:37+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"maximebj\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:754:\"<div>
<p>Plus de 70 personnes sont venues au meetup WordPress Grenoblois ce 9 mars pour suivre 2 conf&eacute;rences, une table ronde et un ap&eacute;ro dans la bonne humeur. Je commencerais par remercier tous les participants ! L&rsquo;int&eacute;r&ecirc;t que vous avez montr&eacute; pour WordPress est inspirant ! J&rsquo;esp&egrave;re que les sujets abord&eacute;s vous ont plu et que [&hellip;]</p>
<p>Cet article <a rel=\"nofollow\" href=\"http://www.wp-spread.com/compte-rendu-de-wpia-6-a-grenoble/\">Compte rendu de WPIA 6 &agrave; Grenoble</a> est apparu en premier sur <a rel=\"nofollow\" href=\"http://www.wp-spread.com/\">WP Spread</a>.</p>
</div><img src=\"http://feeds.feedburner.com/~r/wordpress-fr/RaoY/~4/dUxr6QV29bk\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"http://www.wp-spread.com/compte-rendu-de-wpia-6-a-grenoble/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:59:\"
    \";s:7:\"attribs\";a:1:{s:43:\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\";a:1:{s:5:\"about\";s:57:\"http://www.echodesplugins.li-an.fr/plugins/asgaros-forum/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:24:\"http://purl.org/rss/1.0/\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"L&#039;cho des plugins WordPress : Asgaros Forum\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"http://feedproxy.google.com/~r/wordpress-fr/RaoY/~3/6KredOpPePE/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"<div>Un forum tout simple pour Wordpress</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:2:{s:4:\"date\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2016-03-08T09:49:30+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"Li-An\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"<div>Un forum tout simple pour Wordpress</div><img src=\"http://feeds.feedburner.com/~r/wordpress-fr/RaoY/~4/6KredOpPePE\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"http://www.echodesplugins.li-an.fr/plugins/asgaros-forum/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:64;s:7:\"headers\";a:10:{s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:4:\"etag\";s:27:\"dD1o7OAk1aeJL1FnDysTiYXTZ1c\";s:13:\"last-modified\";s:29:\"Fri, 08 Apr 2016 13:51:01 GMT\";s:16:\"content-encoding\";s:4:\"gzip\";s:4:\"date\";s:29:\"Fri, 08 Apr 2016 13:58:26 GMT\";s:7:\"expires\";s:29:\"Fri, 08 Apr 2016 13:58:26 GMT\";s:13:\"cache-control\";s:18:\"private, max-age=0\";s:22:\"x-content-type-options\";s:7:\"nosniff\";s:16:\"x-xss-protection\";s:13:\"1; mode=block\";s:6:\"server\";s:3:\"GSE\";}s:5:\"build\";s:14:\"20160408133650\";}","no");
INSERT INTO ayv_options VALUES("3075","_site_transient_update_core","O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-4.4.2.zip\";s:6:\"locale\";s:5:\"fr_FR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-4.4.2.zip\";s:10:\"no_content\";b:0;s:11:\"new_bundled\";b:0;s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.4.2\";s:7:\"version\";s:5:\"4.4.2\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.4\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1460364390;s:15:\"version_checked\";s:5:\"4.4.2\";s:12:\"translations\";a:0:{}}","yes");
INSERT INTO ayv_options VALUES("3101","WPS_KEEP_NUM_ENTRIES_LT","500","yes");
INSERT INTO ayv_options VALUES("3102","WPS_REFRESH_RATE_AJAX_LT","10","yes");
INSERT INTO ayv_options VALUES("3103","wps_plugin_enable_live_traffic","1","yes");
INSERT INTO ayv_options VALUES("3042","_site_transient_timeout_browser_4f0993a6950c3817a9929207c89f556c","1460728705","yes");
INSERT INTO ayv_options VALUES("3043","_site_transient_browser_4f0993a6950c3817a9929207c89f556c","a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"45.0\";s:10:\"update_url\";s:23:\"http://www.firefox.com/\";s:7:\"img_src\";s:50:\"http://s.wordpress.org/images/browsers/firefox.png\";s:11:\"img_src_ssl\";s:49:\"https://wordpress.org/images/browsers/firefox.png\";s:15:\"current_version\";s:2:\"16\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO ayv_options VALUES("2927","_transient_timeout_wpseo_sitemap_cache_portfolio_1","1457043312","no");
INSERT INTO ayv_options VALUES("2928","_transient_wpseo_sitemap_cache_portfolio_1","<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:image=\"http://www.google.com/schemas/sitemap-image/1.1\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">
	<url>
		<loc>http://www.atelier-yvanvedel.com/portfolio/cuisine-design-plein-cintre-medium-laque-brillante/</loc>
		<lastmod>2015-12-16T13:48:26+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.6</priority>
		<image:image>
			<image:loc>http://www.atelier-yvanvedel.com/wp-content/uploads/2015/11/Cuisine-contemporaine-medium-laque-1.jpg</image:loc>
			<image:caption><![CDATA[Cuisine design plein cintre mdium laque Brillante]]></image:caption>
		</image:image>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/portfolio/cuisine-contemporaine-sur-cadre/</loc>
		<lastmod>2015-12-16T13:46:39+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.6</priority>
		<image:image>
			<image:loc>http://www.atelier-yvanvedel.com/wp-content/uploads/2015/11/Cuisine_contemporaine_sur_cadre-1.jpg</image:loc>
		</image:image>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/portfolio/cuisine-contemporaine-placage-bois-veritable-sycomore-stratifie/</loc>
		<lastmod>2015-12-31T16:22:15+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.6</priority>
		<image:image>
			<image:loc>http://www.atelier-yvanvedel.com/wp-content/uploads/2015/11/Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-1.jpg</image:loc>
			<image:caption><![CDATA[Cuisine contemporaine placage bois vritable sycomore stratifi]]></image:caption>
		</image:image>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/portfolio/cuisine-contemporaine-placage-bois-veritable/</loc>
		<lastmod>2015-12-31T16:19:53+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.6</priority>
		<image:image>
			<image:loc>http://www.atelier-yvanvedel.com/wp-content/uploads/2015/11/Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-1.jpg</image:loc>
			<image:caption><![CDATA[Cuisine contemporaine placage bois vritable]]></image:caption>
		</image:image>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/portfolio/cuisine-contemporaine-avec-bati/</loc>
		<lastmod>2016-01-05T19:24:18+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.6</priority>
		<image:image>
			<image:loc>http://www.atelier-yvanvedel.com/wp-content/uploads/2015/11/Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-1.jpg</image:loc>
			<image:caption><![CDATA[Cuisine contemporaine avec Bti]]></image:caption>
		</image:image>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/portfolio/blanche-en-setapan/</loc>
		<lastmod>2015-12-31T16:14:27+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.6</priority>
		<image:image>
			<image:loc>http://www.atelier-yvanvedel.com/wp-content/uploads/2015/11/Cuisine_contemporaine_blanche_en_setapan-1.jpg</image:loc>
			<image:caption><![CDATA[Cuisine contemporaine blanche en setapan]]></image:caption>
		</image:image>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/portfolio/cuisine-provencale-louis-xv-pastel/</loc>
		<lastmod>2015-12-23T10:59:13+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.6</priority>
		<image:image>
			<image:loc>http://www.atelier-yvanvedel.com/wp-content/uploads/2015/11/Cuisine_provencale_Louis_XV_Pastel-1.jpg</image:loc>
			<image:caption><![CDATA[Cuisine provenale Louis XV Pastel]]></image:caption>
		</image:image>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/portfolio/cuisine-provencale-louis-xv-pourpre/</loc>
		<lastmod>2015-12-31T17:09:30+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.6</priority>
		<image:image>
			<image:loc>http://www.atelier-yvanvedel.com/wp-content/uploads/2015/11/Cuisine_Provencale_Louis_XV_pourpre-1.jpg</image:loc>
			<image:caption><![CDATA[Cuisine Provenale Louis XV Pourpre]]></image:caption>
		</image:image>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/portfolio/cuisine-sous-voutes-tuiles/</loc>
		<lastmod>2015-12-23T11:01:42+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.6</priority>
		<image:image>
			<image:loc>http://www.atelier-yvanvedel.com/wp-content/uploads/2015/11/Cuisine_sous_voutes_tuiles-1.jpg</image:loc>
			<image:caption><![CDATA[Cuisine sous voutes tuils]]></image:caption>
		</image:image>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/portfolio/cuisine-provencale-louis-xv-bati/</loc>
		<lastmod>2015-12-23T10:57:37+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.6</priority>
		<image:image>
			<image:loc>http://www.atelier-yvanvedel.com/wp-content/uploads/2015/11/Cuisine_provencale_Louis_XV_bati-1.jpg</image:loc>
			<image:caption><![CDATA[Cuisine Provenale Louis XV Bati]]></image:caption>
		</image:image>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/portfolio/cuisine-contemporaine-blanc-brillant/</loc>
		<lastmod>2015-12-31T16:24:19+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.6</priority>
		<image:image>
			<image:loc>http://www.atelier-yvanvedel.com/wp-content/uploads/2015/12/Cui-laque-brillante-blanche-1.jpg</image:loc>
			<image:caption><![CDATA[Cuisine contemporaine blanc brillant]]></image:caption>
		</image:image>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/portfolio/cuisine-cevenole-modele-rustique/</loc>
		<lastmod>2015-12-31T16:09:38+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.6</priority>
		<image:image>
			<image:loc>http://www.atelier-yvanvedel.com/wp-content/uploads/2015/12/Cui-cevenole-Modale-rustique-St-Victor-1.jpg</image:loc>
			<image:caption><![CDATA[Cuisine cvenole modle rustique]]></image:caption>
		</image:image>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/portfolio/cuisine-cevenole-couleur-beige-laetitia/</loc>
		<lastmod>2015-12-16T14:35:21+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.6</priority>
		<image:image>
			<image:loc>http://www.atelier-yvanvedel.com/wp-content/uploads/2015/12/Cui-cevenole-Salindres-01.jpg</image:loc>
			<image:caption><![CDATA[Cuisine cvenole Beige Laetitia]]></image:caption>
		</image:image>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/portfolio/cuisine-cevenole-beige-laetitia/</loc>
		<lastmod>2015-12-16T14:39:36+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.6</priority>
		<image:image>
			<image:loc>http://www.atelier-yvanvedel.com/wp-content/uploads/2015/12/Cui-cevenole-St-Privat-des-Vieux-1.jpg</image:loc>
			<image:caption><![CDATA[Cuisine cvenole beige Laetitia]]></image:caption>
		</image:image>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/portfolio/cuisine-cevenole/</loc>
		<lastmod>2015-12-16T14:53:21+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.6</priority>
		<image:image>
			<image:loc>http://www.atelier-yvanvedel.com/wp-content/uploads/2015/12/Cui-cevenole-Barjac-1.jpg</image:loc>
			<image:caption><![CDATA[Cuisine cvenole]]></image:caption>
		</image:image>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/portfolio/cuisine-cevenole-rouge-bigarot/</loc>
		<lastmod>2015-12-16T15:00:05+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.6</priority>
		<image:image>
			<image:loc>http://www.atelier-yvanvedel.com/wp-content/uploads/2015/12/Cui-cevenole-Ales-1.jpg</image:loc>
			<image:caption><![CDATA[Cuisine cvenole Rouge Bigarot]]></image:caption>
		</image:image>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/portfolio/cuisine-cevenole-grise-sous-plafond-voute/</loc>
		<lastmod>2015-12-31T16:43:25+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.6</priority>
		<image:image>
			<image:loc>http://www.atelier-yvanvedel.com/wp-content/uploads/2015/12/Cui-cevenole-grise-1.jpg</image:loc>
			<image:caption><![CDATA[Cuisine cvenole Grise sous plafond vout]]></image:caption>
		</image:image>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/portfolio/salle-de-bains-complete/</loc>
		<lastmod>2016-01-03T17:16:25+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.6</priority>
		<image:image>
			<image:loc>http://www.atelier-yvanvedel.com/wp-content/uploads/2015/12/SB-cadre-alu-verre-laque-1.jpg</image:loc>
			<image:caption><![CDATA[Salle de bains complte]]></image:caption>
		</image:image>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/portfolio/meuble-tele/</loc>
		<lastmod>2016-02-26T17:53:52+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.6</priority>
		<image:image>
			<image:loc>http://www.atelier-yvanvedel.com/wp-content/uploads/2015/12/Meuble-tele-1.jpg</image:loc>
			<image:caption><![CDATA[Meuble tl]]></image:caption>
		</image:image>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/portfolio/cuisine-provencale-louis-xv-noyer-2/</loc>
		<lastmod>2016-01-04T12:15:23+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.6</priority>
		<image:image>
			<image:loc>http://www.atelier-yvanvedel.com/wp-content/uploads/2015/11/Cuisine_provencale_Louis_XV_Noyer-4.jpg</image:loc>
			<image:caption><![CDATA[Cuisine provenale Louis XV Noyer]]></image:caption>
		</image:image>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/portfolio/cuisine-contemporaine-rouge-brillant/</loc>
		<lastmod>2016-01-03T18:54:21+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.6</priority>
		<image:image>
			<image:loc>http://www.atelier-yvanvedel.com/wp-content/uploads/2016/01/Cuisine-laque-brillante-1.jpg</image:loc>
			<image:caption><![CDATA[Cuisine contemporaine Rouge brillant]]></image:caption>
		</image:image>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/portfolio/cuisine-contemporaine-en-setapan/</loc>
		<lastmod>2016-01-13T17:19:52+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.6</priority>
		<image:image>
			<image:loc>http://www.atelier-yvanvedel.com/wp-content/uploads/2016/01/Cuisine-contemporaine-setapan-1.jpg</image:loc>
			<image:caption><![CDATA[Cuisine contemporaine en setapan]]></image:caption>
		</image:image>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/portfolio/cuisine-contemporaine-avec-bati-porte-plane-placage-chene-epais/</loc>
		<lastmod>2016-02-13T08:58:32+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.6</priority>
		<image:image>
			<image:loc>http://www.atelier-yvanvedel.com/wp-content/uploads/2016/01/Cuisine-moderne-1.jpg</image:loc>
			<image:caption><![CDATA[Cuisine contemporaine avec Bti portes placage chne]]></image:caption>
		</image:image>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/portfolio/cuisine-cevennes-portes-placage-chene/</loc>
		<lastmod>2016-02-26T18:49:25+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.6</priority>
		<image:image>
			<image:loc>http://www.atelier-yvanvedel.com/wp-content/uploads/2016/02/Cuisine-cvennes-1.jpg</image:loc>
			<image:caption><![CDATA[Cuisine Cvennes portes placage chne]]></image:caption>
		</image:image>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/portfolio/cuisine-contemporaine-sans-poignee-en-setapan/</loc>
		<lastmod>2016-02-26T18:50:14+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.6</priority>
		<image:image>
			<image:loc>http://www.atelier-yvanvedel.com/wp-content/uploads/2016/02/Cuisine-setapan-1.jpg</image:loc>
			<image:caption><![CDATA[Cuisine contemporaine sans poigne en setapan]]></image:caption>
		</image:image>
	</url>
	<url>
		<loc>http://www.atelier-yvanvedel.com/portfolio/cuisine-contemporaine-en-laque-satinee/</loc>
		<lastmod>2016-02-26T18:49:50+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.6</priority>
		<image:image>
			<image:loc>http://www.atelier-yvanvedel.com/wp-content/uploads/2016/02/Cuisine-Laque-satin-1.jpg</image:loc>
			<image:caption><![CDATA[Cuisine contemporaine en laque satine]]></image:caption>
		</image:image>
	</url>
</urlset>","no");
INSERT INTO ayv_options VALUES("3050","_transient_timeout_feed_mod_925a96b1918580ab3893979ca7a4a994","1460167106","no");
INSERT INTO ayv_options VALUES("3051","_transient_feed_mod_925a96b1918580ab3893979ca7a4a994","1460123906","no");
INSERT INTO ayv_options VALUES("3002","_transient_timeout_wpseo_sitemap_cache_category_1","1457399864","no");
INSERT INTO ayv_options VALUES("3003","_transient_wpseo_sitemap_cache_category_1","<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">
	<url>
		<loc>http://www.atelier-yvanvedel.com/categories/salons/</loc>
		<lastmod>2015-12-29T19:33:15+00:00</lastmod>
		<changefreq>weekly</changefreq>
		<priority>0.2</priority>
	</url>
</urlset>","no");
INSERT INTO ayv_options VALUES("3104","wps_can_run_tasks","1","yes");
DROP TABLE IF EXISTS ayv_postmeta;CREATE TABLE `ayv_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3290 DEFAULT CHARSET=utf8;
INSERT INTO ayv_postmeta VALUES("1","2","_wp_page_template","default");
INSERT INTO ayv_postmeta VALUES("2799","390","_yoast_wpseo_linkdex","31");
INSERT INTO ayv_postmeta VALUES("2798","390","_yoast_wpseo_focuskw","Foire Alespo");
INSERT INTO ayv_postmeta VALUES("2787","347","_yoast_wpseo_focuskw_text_input","Cuisines cvenole");
INSERT INTO ayv_postmeta VALUES("2788","347","_yoast_wpseo_focuskw","Cuisines cvenole");
INSERT INTO ayv_postmeta VALUES("2789","347","_yoast_wpseo_linkdex","28");
INSERT INTO ayv_postmeta VALUES("2832","15","sbg_selected_sidebar","0");
INSERT INTO ayv_postmeta VALUES("2795","390","sbg_selected_sidebar","0");
INSERT INTO ayv_postmeta VALUES("2796","390","sbg_selected_sidebar_replacement","Sidebar");
INSERT INTO ayv_postmeta VALUES("2797","390","_yoast_wpseo_focuskw_text_input","Foire Alespo");
INSERT INTO ayv_postmeta VALUES("2711","426","_mail","a:8:{s:7:\"subject\";s:14:\"[your-subject]\";s:6:\"sender\";s:45:\"[your-name] <wordpress@atelier-yvanvedel.com>\";s:4:\"body\";s:205:\"De : [your-name] <[your-email]>
Sujet : [your-subject]
Corps du message :
[your-message]
--
Cet email a t envoy via le formulaire de contact de Atelier Yvan Vedel (http://www.atelier-yvanvedel.com)\";s:9:\"recipient\";s:28:\"atelier-yvan.vedel@orange.fr\";s:18:\"additional_headers\";s:22:\"Reply-To: [your-email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO ayv_postmeta VALUES("3053","470","_wp_attached_file","2016/01/Cuisine-moderne-1.jpg");
INSERT INTO ayv_postmeta VALUES("2939","117","sbg_selected_sidebar","Secondary Sidebar");
INSERT INTO ayv_postmeta VALUES("2736","430","heading_bg","");
INSERT INTO ayv_postmeta VALUES("2710","426","_form","<div class=\"col-sm-5 noleftpadding\">
<p>[text* your-name placeholder \"Votre nom *\"] </p>
<p>[email* your-email placeholder \"Votre email *\"] </p>
<p>[text your-subject placeholder \"Sujet\"] </p>
</div>
<div class=\"col-sm-7 norightpadding\">
<p>[textarea your-message placeholder \"Votre message\"] </p>
<p>[submit \"Envoyer\"]</p>
</div>");
INSERT INTO ayv_postmeta VALUES("2737","430","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("2738","430","gallery_images","");
INSERT INTO ayv_postmeta VALUES("2739","430","_menu_item_type","post_type");
INSERT INTO ayv_postmeta VALUES("2740","430","_menu_item_menu_item_parent","0");
INSERT INTO ayv_postmeta VALUES("2741","430","_menu_item_object_id","2");
INSERT INTO ayv_postmeta VALUES("2742","430","_menu_item_object","page");
INSERT INTO ayv_postmeta VALUES("2743","430","_menu_item_target","");
INSERT INTO ayv_postmeta VALUES("2744","430","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO ayv_postmeta VALUES("2745","430","_menu_item_xfn","");
INSERT INTO ayv_postmeta VALUES("2746","430","_menu_item_url","");
INSERT INTO ayv_postmeta VALUES("2747","430","_menu_item_orphaned","1451379531");
INSERT INTO ayv_postmeta VALUES("2748","431","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("2749","431","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("2750","431","heading_bg","");
INSERT INTO ayv_postmeta VALUES("2751","431","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("2752","431","gallery_images","");
INSERT INTO ayv_postmeta VALUES("2753","431","_menu_item_type","post_type");
INSERT INTO ayv_postmeta VALUES("2754","431","_menu_item_menu_item_parent","0");
INSERT INTO ayv_postmeta VALUES("2755","431","_menu_item_object_id","114");
INSERT INTO ayv_postmeta VALUES("2756","431","_menu_item_object","page");
INSERT INTO ayv_postmeta VALUES("2757","431","_menu_item_target","");
INSERT INTO ayv_postmeta VALUES("2758","431","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO ayv_postmeta VALUES("2759","431","_menu_item_xfn","");
INSERT INTO ayv_postmeta VALUES("2760","431","_menu_item_url","");
INSERT INTO ayv_postmeta VALUES("2761","431","_menu_item_orphaned","1451379591");
INSERT INTO ayv_postmeta VALUES("2968","456","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1277;s:6:\"height\";i:958;s:4:\"file\";s:37:\"2016/01/Cuisine-laque-brillante-1.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:37:\"Cuisine-laque-brillante-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"Cuisine-laque-brillante-1-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:37:\"Cuisine-laque-brillante-1-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:38:\"Cuisine-laque-brillante-1-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:37:\"Cuisine-laque-brillante-1-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:37:\"Cuisine-laque-brillante-1-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:38:\"Cuisine-laque-brillante-1-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:37:\"Cuisine-laque-brillante-1-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:37:\"Cuisine-laque-brillante-1-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:37:\"Cuisine-laque-brillante-1-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:37:\"Cuisine-laque-brillante-1-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:37:\"Cuisine-laque-brillante-1-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:36:\"Cuisine-laque-brillante-1-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";d:2.7999999999999998;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:19:\"Canon PowerShot G11\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1321289379;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"6.1\";s:3:\"iso\";s:3:\"500\";s:13:\"shutter_speed\";s:17:\"0.066666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:1;s:8:\"keywords\";a:0:{}}}");
INSERT INTO ayv_postmeta VALUES("2967","456","_wp_attached_file","2016/01/Cuisine-laque-brillante-1.jpg");
INSERT INTO ayv_postmeta VALUES("2735","430","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("15","6","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("16","6","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("17","6","heading_bg","");
INSERT INTO ayv_postmeta VALUES("18","6","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("19","6","gallery_images","");
INSERT INTO ayv_postmeta VALUES("20","6","_menu_item_type","custom");
INSERT INTO ayv_postmeta VALUES("21","6","_menu_item_menu_item_parent","0");
INSERT INTO ayv_postmeta VALUES("22","6","_menu_item_object_id","6");
INSERT INTO ayv_postmeta VALUES("23","6","_menu_item_object","custom");
INSERT INTO ayv_postmeta VALUES("24","6","_menu_item_target","");
INSERT INTO ayv_postmeta VALUES("25","6","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO ayv_postmeta VALUES("26","6","_menu_item_xfn","");
INSERT INTO ayv_postmeta VALUES("27","6","_menu_item_url","http://atelier-yvanvedel.com/");
INSERT INTO ayv_postmeta VALUES("2456","378","_wp_attachment_metadata","a:5:{s:5:\"width\";i:253;s:6:\"height\";i:55;s:4:\"file\";s:37:\"2015/12/logo-atelier-yvan-vedel-1.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"logo-atelier-yvan-vedel-1-150x55.png\";s:5:\"width\";i:150;s:6:\"height\";i:55;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:36:\"logo-atelier-yvan-vedel-1-190x54.png\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("723","109","anps_portfolio_shorttext","");
INSERT INTO ayv_postmeta VALUES("722","109","anps_subtitle","");
INSERT INTO ayv_postmeta VALUES("721","109","anps_team_subtitle","");
INSERT INTO ayv_postmeta VALUES("718","109","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("717","109","_wpb_vc_js_status","false");
INSERT INTO ayv_postmeta VALUES("2838","109","sbg_selected_sidebar_replacement","0");
INSERT INTO ayv_postmeta VALUES("714","109","_edit_lock","1451418994:2");
INSERT INTO ayv_postmeta VALUES("81","11","_wp_attachment_metadata","a:5:{s:5:\"width\";i:253;s:6:\"height\";i:39;s:4:\"file\";s:35:\"2015/10/logo-atelier-yvan-vedel.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"logo-atelier-yvan-vedel-150x39.png\";s:5:\"width\";i:150;s:6:\"height\";i:39;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:34:\"logo-atelier-yvan-vedel-190x39.png\";s:5:\"width\";i:190;s:6:\"height\";i:39;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("143","20","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1400;s:6:\"height\";i:542;s:4:\"file\";s:21:\"2015/10/SlideTest.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"SlideTest-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"SlideTest-300x116.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:116;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:22:\"SlideTest-1024x396.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:396;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:21:\"SlideTest-370x143.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:143;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:21:\"SlideTest-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:22:\"SlideTest-1200x465.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:465;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:21:\"SlideTest-360x139.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:139;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:21:\"SlideTest-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:21:\"SlideTest-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:21:\"SlideTest-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:21:\"SlideTest-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:20:\"SlideTest-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("142","20","_wp_attached_file","2015/10/SlideTest.jpg");
INSERT INTO ayv_postmeta VALUES("80","11","_wp_attached_file","2015/10/logo-atelier-yvan-vedel.png");
INSERT INTO ayv_postmeta VALUES("82","12","_wp_attached_file","2015/10/logo-atelier-yvan-vedel-blanc.png");
INSERT INTO ayv_postmeta VALUES("83","12","_wp_attachment_metadata","a:5:{s:5:\"width\";i:253;s:6:\"height\";i:39;s:4:\"file\";s:41:\"2015/10/logo-atelier-yvan-vedel-blanc.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:40:\"logo-atelier-yvan-vedel-blanc-150x39.png\";s:5:\"width\";i:150;s:6:\"height\";i:39;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:40:\"logo-atelier-yvan-vedel-blanc-190x39.png\";s:5:\"width\";i:190;s:6:\"height\";i:39;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2099","2","_edit_lock","1451579238:2");
INSERT INTO ayv_postmeta VALUES("85","15","_edit_last","2");
INSERT INTO ayv_postmeta VALUES("88","15","_wpb_vc_js_status","true");
INSERT INTO ayv_postmeta VALUES("89","15","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("92","15","anps_team_subtitle","");
INSERT INTO ayv_postmeta VALUES("93","15","anps_subtitle","");
INSERT INTO ayv_postmeta VALUES("94","15","anps_portfolio_shorttext","");
INSERT INTO ayv_postmeta VALUES("95","15","custom_breadcrumbs","");
INSERT INTO ayv_postmeta VALUES("96","15","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("97","15","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("98","15","heading_bg","");
INSERT INTO ayv_postmeta VALUES("99","15","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("100","15","gallery_images","");
INSERT INTO ayv_postmeta VALUES("198","32","_wp_attached_file","2015/10/HP-cuisines-contemporaines.jpg");
INSERT INTO ayv_postmeta VALUES("103","15","_edit_lock","1451579541:2");
INSERT INTO ayv_postmeta VALUES("104","17","_edit_last","1");
INSERT INTO ayv_postmeta VALUES("639","17","sbg_selected_sidebar_replacement","Sidebar");
INSERT INTO ayv_postmeta VALUES("107","17","_wpb_vc_js_status","false");
INSERT INTO ayv_postmeta VALUES("108","17","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("111","17","anps_team_subtitle","");
INSERT INTO ayv_postmeta VALUES("112","17","anps_subtitle","");
INSERT INTO ayv_postmeta VALUES("113","17","anps_portfolio_shorttext","");
INSERT INTO ayv_postmeta VALUES("114","17","custom_breadcrumbs","");
INSERT INTO ayv_postmeta VALUES("115","17","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("116","17","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("117","17","heading_bg","");
INSERT INTO ayv_postmeta VALUES("118","17","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("119","17","gallery_images","");
INSERT INTO ayv_postmeta VALUES("640","98","_edit_last","1");
INSERT INTO ayv_postmeta VALUES("122","17","_edit_lock","1447143857:1");
INSERT INTO ayv_postmeta VALUES("123","19","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("124","19","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("125","19","heading_bg","");
INSERT INTO ayv_postmeta VALUES("126","19","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("127","19","gallery_images","");
INSERT INTO ayv_postmeta VALUES("128","19","_menu_item_type","post_type");
INSERT INTO ayv_postmeta VALUES("129","19","_menu_item_menu_item_parent","0");
INSERT INTO ayv_postmeta VALUES("130","19","_menu_item_object_id","17");
INSERT INTO ayv_postmeta VALUES("131","19","_menu_item_object","page");
INSERT INTO ayv_postmeta VALUES("132","19","_menu_item_target","");
INSERT INTO ayv_postmeta VALUES("133","19","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO ayv_postmeta VALUES("134","19","_menu_item_xfn","");
INSERT INTO ayv_postmeta VALUES("135","19","_menu_item_url","");
INSERT INTO ayv_postmeta VALUES("140","19","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("137","6","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("2455","378","_wp_attached_file","2015/12/logo-atelier-yvan-vedel-1.png");
INSERT INTO ayv_postmeta VALUES("2386","104","sbg_selected_sidebar","Secondary Sidebar");
INSERT INTO ayv_postmeta VALUES("2734","430","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("2100","257","_wp_old_slug","porte-placage-bois-stratifiee-croco-oberflex");
INSERT INTO ayv_postmeta VALUES("2833","15","sbg_selected_sidebar_replacement","0");
INSERT INTO ayv_postmeta VALUES("199","32","_wp_attachment_metadata","a:5:{s:5:\"width\";i:700;s:6:\"height\";i:284;s:4:\"file\";s:38:\"2015/10/HP-cuisines-contemporaines.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:38:\"HP-cuisines-contemporaines-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:38:\"HP-cuisines-contemporaines-300x122.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:122;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:38:\"HP-cuisines-contemporaines-370x150.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:38:\"HP-cuisines-contemporaines-360x146.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:38:\"HP-cuisines-contemporaines-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:38:\"HP-cuisines-contemporaines-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:38:\"HP-cuisines-contemporaines-262x284.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:38:\"HP-cuisines-contemporaines-554x284.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:37:\"HP-cuisines-contemporaines-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("200","33","_wp_attached_file","2015/10/HP-cuisines-rustiques-provencales.jpg");
INSERT INTO ayv_postmeta VALUES("201","33","_wp_attachment_metadata","a:5:{s:5:\"width\";i:700;s:6:\"height\";i:284;s:4:\"file\";s:45:\"2015/10/HP-cuisines-rustiques-provencales.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:45:\"HP-cuisines-rustiques-provencales-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:45:\"HP-cuisines-rustiques-provencales-300x122.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:122;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:45:\"HP-cuisines-rustiques-provencales-370x150.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:45:\"HP-cuisines-rustiques-provencales-360x146.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:45:\"HP-cuisines-rustiques-provencales-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:45:\"HP-cuisines-rustiques-provencales-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:45:\"HP-cuisines-rustiques-provencales-262x284.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:45:\"HP-cuisines-rustiques-provencales-554x284.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:44:\"HP-cuisines-rustiques-provencales-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("202","34","_wp_attached_file","2015/10/HP-diverse.jpg");
INSERT INTO ayv_postmeta VALUES("203","34","_wp_attachment_metadata","a:5:{s:5:\"width\";i:700;s:6:\"height\";i:284;s:4:\"file\";s:22:\"2015/10/HP-diverse.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"HP-diverse-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"HP-diverse-300x122.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:122;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:22:\"HP-diverse-370x150.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:22:\"HP-diverse-360x146.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:22:\"HP-diverse-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:22:\"HP-diverse-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:22:\"HP-diverse-262x284.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:22:\"HP-diverse-554x284.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:21:\"HP-diverse-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("228","39","_wp_attached_file","2015/10/HP-discutons.jpg");
INSERT INTO ayv_postmeta VALUES("229","39","_wp_attachment_metadata","a:5:{s:5:\"width\";i:700;s:6:\"height\";i:520;s:4:\"file\";s:24:\"2015/10/HP-discutons.jpg\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"HP-discutons-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"HP-discutons-300x223.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:223;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:24:\"HP-discutons-370x275.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:275;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:24:\"HP-discutons-700x412.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:24:\"HP-discutons-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:24:\"HP-discutons-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:24:\"HP-discutons-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:24:\"HP-discutons-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:24:\"HP-discutons-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:23:\"HP-discutons-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("344","59","_edit_last","1");
INSERT INTO ayv_postmeta VALUES("345","59","_edit_lock","1446544951:1");
INSERT INTO ayv_postmeta VALUES("400","59","sbg_selected_sidebar_replacement","0");
INSERT INTO ayv_postmeta VALUES("348","59","_wpb_vc_js_status","true");
INSERT INTO ayv_postmeta VALUES("349","59","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("399","59","sbg_selected_sidebar","0");
INSERT INTO ayv_postmeta VALUES("352","59","anps_team_subtitle","");
INSERT INTO ayv_postmeta VALUES("353","59","anps_subtitle","");
INSERT INTO ayv_postmeta VALUES("354","59","anps_portfolio_shorttext","");
INSERT INTO ayv_postmeta VALUES("355","59","custom_breadcrumbs","");
INSERT INTO ayv_postmeta VALUES("356","59","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("357","59","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("358","59","heading_bg","");
INSERT INTO ayv_postmeta VALUES("359","59","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("360","59","gallery_images","");
INSERT INTO ayv_postmeta VALUES("363","61","_wp_attached_file","2015/11/SlideRealFooter1.jpg");
INSERT INTO ayv_postmeta VALUES("364","61","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1400;s:6:\"height\";i:212;s:4:\"file\";s:28:\"2015/11/SlideRealFooter1.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"SlideRealFooter1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"SlideRealFooter1-300x45.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:45;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:29:\"SlideRealFooter1-1024x155.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:155;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:27:\"SlideRealFooter1-370x56.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:56;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:28:\"SlideRealFooter1-720x212.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:212;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:29:\"SlideRealFooter1-1200x182.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:27:\"SlideRealFooter1-360x55.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:55;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:28:\"SlideRealFooter1-360x212.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:212;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:28:\"SlideRealFooter1-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:28:\"SlideRealFooter1-262x212.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:212;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:28:\"SlideRealFooter1-554x212.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:212;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:27:\"SlideRealFooter1-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("438","73","_wp_attached_file","2015/10/Actu1.jpg");
INSERT INTO ayv_postmeta VALUES("439","73","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:485;s:4:\"file\";s:17:\"2015/10/Actu1.jpg\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"Actu1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"Actu1-300x146.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:17:\"Actu1-370x179.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:179;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:17:\"Actu1-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:17:\"Actu1-360x175.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:17:\"Actu1-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:17:\"Actu1-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:17:\"Actu1-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:17:\"Actu1-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:16:\"Actu1-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("3117","482","gallery_images","");
INSERT INTO ayv_postmeta VALUES("3116","482","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("3114","482","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("3115","482","heading_bg","");
INSERT INTO ayv_postmeta VALUES("3113","482","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("3112","482","custom_breadcrumbs","0");
INSERT INTO ayv_postmeta VALUES("3111","482","anps_portfolio_shorttext","");
INSERT INTO ayv_postmeta VALUES("3110","482","anps_subtitle","");
INSERT INTO ayv_postmeta VALUES("3109","482","anps_team_subtitle","");
INSERT INTO ayv_postmeta VALUES("3102","482","_edit_lock","1455118046:1");
INSERT INTO ayv_postmeta VALUES("3103","482","_edit_last","2");
INSERT INTO ayv_postmeta VALUES("3165","482","sbg_selected_sidebar","0");
INSERT INTO ayv_postmeta VALUES("3166","482","sbg_selected_sidebar_replacement","0");
INSERT INTO ayv_postmeta VALUES("3106","482","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("3167","491","_wp_attached_file","2016/02/Cuisine-cvennes-1.jpg");
INSERT INTO ayv_postmeta VALUES("3168","491","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1277;s:6:\"height\";i:958;s:4:\"file\";s:31:\"2016/02/Cuisine-cvennes-1.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"Cuisine-cvennes-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"Cuisine-cvennes-1-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:31:\"Cuisine-cvennes-1-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:32:\"Cuisine-cvennes-1-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:31:\"Cuisine-cvennes-1-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:31:\"Cuisine-cvennes-1-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:32:\"Cuisine-cvennes-1-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:31:\"Cuisine-cvennes-1-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:31:\"Cuisine-cvennes-1-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:31:\"Cuisine-cvennes-1-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:31:\"Cuisine-cvennes-1-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:31:\"Cuisine-cvennes-1-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:30:\"Cuisine-cvennes-1-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"4\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:19:\"Canon PowerShot G11\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1453631961\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"6.1\";s:3:\"iso\";s:3:\"125\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO ayv_postmeta VALUES("523","81","_edit_last","2");
INSERT INTO ayv_postmeta VALUES("2880","81","sbg_selected_sidebar_replacement","0");
INSERT INTO ayv_postmeta VALUES("526","81","_wpb_vc_js_status","true");
INSERT INTO ayv_postmeta VALUES("527","81","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("530","81","anps_team_subtitle","");
INSERT INTO ayv_postmeta VALUES("531","81","anps_subtitle","");
INSERT INTO ayv_postmeta VALUES("532","81","anps_portfolio_shorttext","");
INSERT INTO ayv_postmeta VALUES("533","81","custom_breadcrumbs","");
INSERT INTO ayv_postmeta VALUES("534","81","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("535","81","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("536","81","heading_bg","");
INSERT INTO ayv_postmeta VALUES("537","81","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("538","81","gallery_images","");
INSERT INTO ayv_postmeta VALUES("541","81","_edit_lock","1451748974:2");
INSERT INTO ayv_postmeta VALUES("548","84","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("549","84","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("550","84","heading_bg","");
INSERT INTO ayv_postmeta VALUES("551","84","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("552","84","gallery_images","");
INSERT INTO ayv_postmeta VALUES("553","84","_menu_item_type","post_type");
INSERT INTO ayv_postmeta VALUES("554","84","_menu_item_menu_item_parent","0");
INSERT INTO ayv_postmeta VALUES("555","84","_menu_item_object_id","81");
INSERT INTO ayv_postmeta VALUES("556","84","_menu_item_object","page");
INSERT INTO ayv_postmeta VALUES("557","84","_menu_item_target","");
INSERT INTO ayv_postmeta VALUES("558","84","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO ayv_postmeta VALUES("559","84","_menu_item_xfn","");
INSERT INTO ayv_postmeta VALUES("560","84","_menu_item_url","");
INSERT INTO ayv_postmeta VALUES("562","84","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("638","17","sbg_selected_sidebar","0");
INSERT INTO ayv_postmeta VALUES("641","98","_edit_lock","1451846703:2");
INSERT INTO ayv_postmeta VALUES("1698","222","_wp_attached_file","2015/11/Cuisine_contemporaine_blanche_en_setapan-1.jpg");
INSERT INTO ayv_postmeta VALUES("1699","222","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:54:\"2015/11/Cuisine_contemporaine_blanche_en_setapan-1.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-1-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:55:\"Cuisine_contemporaine_blanche_en_setapan-1-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-1-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-1-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:55:\"Cuisine_contemporaine_blanche_en_setapan-1-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-1-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-1-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-1-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-1-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-1-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:53:\"Cuisine_contemporaine_blanche_en_setapan-1-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("1700","223","_wp_attached_file","2015/11/Cuisine_contemporaine_blanche_en_setapan-2.jpg");
INSERT INTO ayv_postmeta VALUES("1701","223","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:54:\"2015/11/Cuisine_contemporaine_blanche_en_setapan-2.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-2-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:55:\"Cuisine_contemporaine_blanche_en_setapan-2-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-2-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-2-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:55:\"Cuisine_contemporaine_blanche_en_setapan-2-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-2-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-2-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-2-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-2-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-2-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:53:\"Cuisine_contemporaine_blanche_en_setapan-2-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("1702","224","_wp_attached_file","2015/11/Cuisine_contemporaine_blanche_en_setapan-3.jpg");
INSERT INTO ayv_postmeta VALUES("1703","224","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:54:\"2015/11/Cuisine_contemporaine_blanche_en_setapan-3.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-3-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:55:\"Cuisine_contemporaine_blanche_en_setapan-3-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-3-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-3-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:55:\"Cuisine_contemporaine_blanche_en_setapan-3-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-3-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-3-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-3-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-3-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-3-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:53:\"Cuisine_contemporaine_blanche_en_setapan-3-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("1704","225","_wp_attached_file","2015/11/Cuisine_contemporaine_blanche_en_setapan-4.jpg");
INSERT INTO ayv_postmeta VALUES("1705","225","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:54:\"2015/11/Cuisine_contemporaine_blanche_en_setapan-4.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-4-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:55:\"Cuisine_contemporaine_blanche_en_setapan-4-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-4-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-4-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:55:\"Cuisine_contemporaine_blanche_en_setapan-4-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-4-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-4-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-4-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-4-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-4-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:53:\"Cuisine_contemporaine_blanche_en_setapan-4-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("1706","226","_wp_attached_file","2015/11/Cuisine_contemporaine_blanche_en_setapan-5.jpg");
INSERT INTO ayv_postmeta VALUES("1707","226","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:54:\"2015/11/Cuisine_contemporaine_blanche_en_setapan-5.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-5-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:55:\"Cuisine_contemporaine_blanche_en_setapan-5-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-5-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-5-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:55:\"Cuisine_contemporaine_blanche_en_setapan-5-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-5-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-5-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-5-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-5-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-5-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:53:\"Cuisine_contemporaine_blanche_en_setapan-5-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("653","98","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("654","98","anps_team_subtitle","");
INSERT INTO ayv_postmeta VALUES("655","98","anps_subtitle","");
INSERT INTO ayv_postmeta VALUES("656","98","anps_portfolio_shorttext","");
INSERT INTO ayv_postmeta VALUES("657","98","custom_breadcrumbs","109");
INSERT INTO ayv_postmeta VALUES("658","98","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("659","98","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("660","98","heading_bg","");
INSERT INTO ayv_postmeta VALUES("661","98","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("662","98","gallery_images","249,250,251,252,253,");
INSERT INTO ayv_postmeta VALUES("663","104","_edit_last","1");
INSERT INTO ayv_postmeta VALUES("821","122","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("713","109","_edit_last","2");
INSERT INTO ayv_postmeta VALUES("666","104","_wpb_vc_js_status","false");
INSERT INTO ayv_postmeta VALUES("667","104","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("670","104","anps_team_subtitle","");
INSERT INTO ayv_postmeta VALUES("671","104","anps_subtitle","");
INSERT INTO ayv_postmeta VALUES("672","104","anps_portfolio_shorttext","");
INSERT INTO ayv_postmeta VALUES("673","104","custom_breadcrumbs","");
INSERT INTO ayv_postmeta VALUES("674","104","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("675","104","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("676","104","heading_bg","");
INSERT INTO ayv_postmeta VALUES("677","104","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("678","104","gallery_images","");
INSERT INTO ayv_postmeta VALUES("681","104","_edit_lock","1451418789:2");
INSERT INTO ayv_postmeta VALUES("2387","104","sbg_selected_sidebar_replacement","0");
INSERT INTO ayv_postmeta VALUES("686","106","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("687","106","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("688","106","heading_bg","");
INSERT INTO ayv_postmeta VALUES("689","106","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("690","106","gallery_images","");
INSERT INTO ayv_postmeta VALUES("691","106","_menu_item_type","post_type");
INSERT INTO ayv_postmeta VALUES("692","106","_menu_item_menu_item_parent","0");
INSERT INTO ayv_postmeta VALUES("693","106","_menu_item_object_id","104");
INSERT INTO ayv_postmeta VALUES("694","106","_menu_item_object","page");
INSERT INTO ayv_postmeta VALUES("695","106","_menu_item_target","");
INSERT INTO ayv_postmeta VALUES("696","106","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO ayv_postmeta VALUES("697","106","_menu_item_xfn","");
INSERT INTO ayv_postmeta VALUES("698","106","_menu_item_url","");
INSERT INTO ayv_postmeta VALUES("700","106","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("724","109","custom_breadcrumbs","");
INSERT INTO ayv_postmeta VALUES("725","109","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("726","109","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("727","109","heading_bg","");
INSERT INTO ayv_postmeta VALUES("728","109","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("729","109","gallery_images","");
INSERT INTO ayv_postmeta VALUES("732","111","_edit_last","2");
INSERT INTO ayv_postmeta VALUES("733","111","_edit_lock","1451839066:2");
INSERT INTO ayv_postmeta VALUES("2851","111","sbg_selected_sidebar_replacement","0");
INSERT INTO ayv_postmeta VALUES("736","111","_wpb_vc_js_status","false");
INSERT INTO ayv_postmeta VALUES("737","111","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("740","111","anps_team_subtitle","");
INSERT INTO ayv_postmeta VALUES("741","111","anps_subtitle","");
INSERT INTO ayv_postmeta VALUES("742","111","anps_portfolio_shorttext","");
INSERT INTO ayv_postmeta VALUES("743","111","custom_breadcrumbs","");
INSERT INTO ayv_postmeta VALUES("744","111","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("745","111","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("746","111","heading_bg","");
INSERT INTO ayv_postmeta VALUES("747","111","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("748","111","gallery_images","");
INSERT INTO ayv_postmeta VALUES("751","114","_edit_last","1");
INSERT INTO ayv_postmeta VALUES("752","114","_edit_lock","1451846400:2");
INSERT INTO ayv_postmeta VALUES("2684","114","sbg_selected_sidebar_replacement","0");
INSERT INTO ayv_postmeta VALUES("755","114","_wpb_vc_js_status","false");
INSERT INTO ayv_postmeta VALUES("756","114","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("2872","2","sbg_selected_sidebar","0");
INSERT INTO ayv_postmeta VALUES("759","114","anps_team_subtitle","");
INSERT INTO ayv_postmeta VALUES("760","114","anps_subtitle","");
INSERT INTO ayv_postmeta VALUES("761","114","anps_portfolio_shorttext","");
INSERT INTO ayv_postmeta VALUES("762","114","custom_breadcrumbs","");
INSERT INTO ayv_postmeta VALUES("763","114","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("764","114","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("765","114","heading_bg","");
INSERT INTO ayv_postmeta VALUES("766","114","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("767","114","gallery_images","");
INSERT INTO ayv_postmeta VALUES("770","117","_edit_last","2");
INSERT INTO ayv_postmeta VALUES("771","117","_edit_lock","1451839204:2");
INSERT INTO ayv_postmeta VALUES("2418","2","_edit_last","2");
INSERT INTO ayv_postmeta VALUES("774","117","_wpb_vc_js_status","false");
INSERT INTO ayv_postmeta VALUES("775","117","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("778","117","anps_team_subtitle","");
INSERT INTO ayv_postmeta VALUES("779","117","anps_subtitle","");
INSERT INTO ayv_postmeta VALUES("780","117","anps_portfolio_shorttext","");
INSERT INTO ayv_postmeta VALUES("781","117","custom_breadcrumbs","");
INSERT INTO ayv_postmeta VALUES("782","117","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("783","117","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("784","117","heading_bg","");
INSERT INTO ayv_postmeta VALUES("785","117","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("786","117","gallery_images","");
INSERT INTO ayv_postmeta VALUES("2940","117","sbg_selected_sidebar_replacement","0");
INSERT INTO ayv_postmeta VALUES("822","122","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("823","122","heading_bg","");
INSERT INTO ayv_postmeta VALUES("824","122","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("825","122","gallery_images","");
INSERT INTO ayv_postmeta VALUES("826","122","_menu_item_type","post_type");
INSERT INTO ayv_postmeta VALUES("827","122","_menu_item_menu_item_parent","0");
INSERT INTO ayv_postmeta VALUES("828","122","_menu_item_object_id","104");
INSERT INTO ayv_postmeta VALUES("829","122","_menu_item_object","page");
INSERT INTO ayv_postmeta VALUES("830","122","_menu_item_target","");
INSERT INTO ayv_postmeta VALUES("831","122","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO ayv_postmeta VALUES("832","122","_menu_item_xfn","");
INSERT INTO ayv_postmeta VALUES("833","122","_menu_item_url","");
INSERT INTO ayv_postmeta VALUES("835","122","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("836","123","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("837","123","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("838","123","heading_bg","");
INSERT INTO ayv_postmeta VALUES("839","123","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("840","123","gallery_images","");
INSERT INTO ayv_postmeta VALUES("841","123","_menu_item_type","post_type");
INSERT INTO ayv_postmeta VALUES("842","123","_menu_item_menu_item_parent","0");
INSERT INTO ayv_postmeta VALUES("843","123","_menu_item_object_id","117");
INSERT INTO ayv_postmeta VALUES("844","123","_menu_item_object","page");
INSERT INTO ayv_postmeta VALUES("845","123","_menu_item_target","");
INSERT INTO ayv_postmeta VALUES("846","123","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO ayv_postmeta VALUES("847","123","_menu_item_xfn","");
INSERT INTO ayv_postmeta VALUES("848","123","_menu_item_url","");
INSERT INTO ayv_postmeta VALUES("880","123","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("859","125","_menu_item_type","post_type");
INSERT INTO ayv_postmeta VALUES("860","125","_menu_item_menu_item_parent","0");
INSERT INTO ayv_postmeta VALUES("861","125","_menu_item_object_id","111");
INSERT INTO ayv_postmeta VALUES("862","125","_menu_item_object","page");
INSERT INTO ayv_postmeta VALUES("863","125","_menu_item_target","");
INSERT INTO ayv_postmeta VALUES("864","125","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO ayv_postmeta VALUES("865","125","_menu_item_xfn","");
INSERT INTO ayv_postmeta VALUES("866","125","_menu_item_url","");
INSERT INTO ayv_postmeta VALUES("878","125","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("868","126","_menu_item_type","post_type");
INSERT INTO ayv_postmeta VALUES("869","126","_menu_item_menu_item_parent","0");
INSERT INTO ayv_postmeta VALUES("870","126","_menu_item_object_id","109");
INSERT INTO ayv_postmeta VALUES("871","126","_menu_item_object","page");
INSERT INTO ayv_postmeta VALUES("872","126","_menu_item_target","");
INSERT INTO ayv_postmeta VALUES("873","126","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO ayv_postmeta VALUES("874","126","_menu_item_xfn","");
INSERT INTO ayv_postmeta VALUES("875","126","_menu_item_url","");
INSERT INTO ayv_postmeta VALUES("877","126","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("885","98","gss_98","ids=\"103,102,101,100,99\"");
INSERT INTO ayv_postmeta VALUES("2190","328","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:1536;s:4:\"file\";s:37:\"2015/12/Cui-cevenole-Salindres-06.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-06-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-06-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:38:\"Cui-cevenole-Salindres-06-683x1024.jpg\";s:5:\"width\";i:683;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-06-240x360.jpg\";s:5:\"width\";i:240;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-06-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-06-360x540.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:540;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-06-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-06-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-06-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-06-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:36:\"Cui-cevenole-Salindres-06-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2189","328","_wp_attached_file","2015/12/Cui-cevenole-Salindres-06.jpg");
INSERT INTO ayv_postmeta VALUES("1716","231","_wp_attached_file","2015/11/Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-1.jpg");
INSERT INTO ayv_postmeta VALUES("1717","231","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1493;s:6:\"height\";i:994;s:4:\"file\";s:70:\"2015/11/Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-1.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:71:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-1-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-1-370x246.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:246;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-1-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:71:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-1-1200x799.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:799;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-1-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-1-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-1-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-1-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-1-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:69:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-1-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("1714","230","_wp_attached_file","2015/11/Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-3.jpg");
INSERT INTO ayv_postmeta VALUES("1715","230","_wp_attachment_metadata","a:5:{s:5:\"width\";i:904;s:6:\"height\";i:678;s:4:\"file\";s:80:\"2015/11/Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-3.jpg\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:80:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:80:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-3-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:80:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-3-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:80:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-3-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:80:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-3-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:80:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-3-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:80:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-3-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:80:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-3-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:80:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-3-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:79:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-3-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("1712","229","_wp_attached_file","2015/11/Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-2.jpg");
INSERT INTO ayv_postmeta VALUES("1713","229","_wp_attachment_metadata","a:5:{s:5:\"width\";i:904;s:6:\"height\";i:678;s:4:\"file\";s:80:\"2015/11/Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-2.jpg\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:80:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:80:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-2-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:80:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-2-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:80:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-2-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:80:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-2-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:80:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-2-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:80:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-2-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:80:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-2-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:80:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-2-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:79:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-2-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("1710","228","_wp_attached_file","2015/11/Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-1.jpg");
INSERT INTO ayv_postmeta VALUES("1711","228","_wp_attachment_metadata","a:5:{s:5:\"width\";i:904;s:6:\"height\";i:678;s:4:\"file\";s:80:\"2015/11/Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-1.jpg\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:80:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:80:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-1-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:80:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-1-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:80:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-1-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:80:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-1-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:80:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-1-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:80:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-1-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:80:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-1-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:80:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-1-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:79:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_croco_Oberflex-1-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("1708","227","_wp_attached_file","2015/11/Cuisine_contemporaine_blanche_en_setapan-6.jpg");
INSERT INTO ayv_postmeta VALUES("1709","227","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:54:\"2015/11/Cuisine_contemporaine_blanche_en_setapan-6.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-6-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:55:\"Cuisine_contemporaine_blanche_en_setapan-6-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-6-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-6-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:55:\"Cuisine_contemporaine_blanche_en_setapan-6-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-6-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-6-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-6-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-6-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:54:\"Cuisine_contemporaine_blanche_en_setapan-6-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:53:\"Cuisine_contemporaine_blanche_en_setapan-6-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2211","332","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:46:\"2015/12/Cui-cevenole-St-Privat-des-Vieux-3.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-3-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:47:\"Cui-cevenole-St-Privat-des-Vieux-3-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-3-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-3-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:47:\"Cui-cevenole-St-Privat-des-Vieux-3-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-3-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-3-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-3-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-3-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-3-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:45:\"Cui-cevenole-St-Privat-des-Vieux-3-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2210","332","_wp_attached_file","2015/12/Cui-cevenole-St-Privat-des-Vieux-3.jpg");
INSERT INTO ayv_postmeta VALUES("1718","232","_wp_attached_file","2015/11/Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-2.jpg");
INSERT INTO ayv_postmeta VALUES("1719","232","_wp_attachment_metadata","a:5:{s:5:\"width\";i:994;s:6:\"height\";i:1493;s:4:\"file\";s:70:\"2015/11/Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-2.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-2-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:71:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-2-682x1024.jpg\";s:5:\"width\";i:682;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-2-240x360.jpg\";s:5:\"width\";i:240;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-2-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-2-360x541.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:541;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-2-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-2-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-2-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-2-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:69:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-2-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("1720","233","_wp_attached_file","2015/11/Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-3.jpg");
INSERT INTO ayv_postmeta VALUES("1721","233","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1493;s:6:\"height\";i:994;s:4:\"file\";s:70:\"2015/11/Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-3.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:71:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-3-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-3-370x246.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:246;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-3-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:71:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-3-1200x799.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:799;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-3-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-3-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-3-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-3-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-3-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:69:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-3-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("1722","234","_wp_attached_file","2015/11/Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-4.jpg");
INSERT INTO ayv_postmeta VALUES("1723","234","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1493;s:6:\"height\";i:994;s:4:\"file\";s:70:\"2015/11/Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-4.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:71:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-4-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-4-370x246.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:246;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-4-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:71:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-4-1200x799.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:799;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-4-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-4-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-4-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-4-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-4-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:69:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-4-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("1724","235","_wp_attached_file","2015/11/Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-5.jpg");
INSERT INTO ayv_postmeta VALUES("1725","235","_wp_attachment_metadata","a:5:{s:5:\"width\";i:994;s:6:\"height\";i:1493;s:4:\"file\";s:70:\"2015/11/Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-5.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-5-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:71:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-5-682x1024.jpg\";s:5:\"width\";i:682;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-5-240x360.jpg\";s:5:\"width\";i:240;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-5-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-5-360x541.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:541;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-5-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-5-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-5-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-5-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:69:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-5-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("1726","236","_wp_attached_file","2015/11/Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-6.jpg");
INSERT INTO ayv_postmeta VALUES("1727","236","_wp_attachment_metadata","a:5:{s:5:\"width\";i:994;s:6:\"height\";i:1493;s:4:\"file\";s:70:\"2015/11/Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-6.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-6-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:71:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-6-682x1024.jpg\";s:5:\"width\";i:682;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-6-240x360.jpg\";s:5:\"width\";i:240;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-6-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-6-360x541.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:541;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-6-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-6-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-6-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-6-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:69:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-6-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("1728","237","_wp_attached_file","2015/11/Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-7.jpg");
INSERT INTO ayv_postmeta VALUES("1729","237","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1493;s:6:\"height\";i:994;s:4:\"file\";s:70:\"2015/11/Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-7.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-7-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:71:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-7-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-7-370x246.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:246;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-7-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:71:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-7-1200x799.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:799;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-7-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-7-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-7-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-7-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-7-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:69:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-7-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("1730","238","_wp_attached_file","2015/11/Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-8.jpg");
INSERT INTO ayv_postmeta VALUES("1731","238","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1493;s:6:\"height\";i:994;s:4:\"file\";s:70:\"2015/11/Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-8.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-8-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:71:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-8-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-8-370x246.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:246;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-8-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:71:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-8-1200x799.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:799;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-8-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-8-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-8-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-8-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:70:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-8-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:69:\"Cuisine_contemporaine_porte_placage_bois_stratifiee_Ober-8-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("1732","239","_wp_attached_file","2015/11/Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-1.jpg");
INSERT INTO ayv_postmeta VALUES("1733","239","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1229;s:6:\"height\";i:820;s:4:\"file\";s:64:\"2015/11/Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-1.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:65:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-1-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-1-370x247.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:247;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-1-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:65:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-1-1200x801.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:801;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-1-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-1-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-1-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-1-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-1-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:63:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-1-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("1734","240","_wp_attached_file","2015/11/Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-2.jpg");
INSERT INTO ayv_postmeta VALUES("1735","240","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1229;s:6:\"height\";i:820;s:4:\"file\";s:64:\"2015/11/Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-2.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:65:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-2-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-2-370x247.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:247;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-2-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:65:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-2-1200x801.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:801;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-2-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-2-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-2-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-2-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-2-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:63:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-2-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2209","331","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:46:\"2015/12/Cui-cevenole-St-Privat-des-Vieux-2.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-2-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:47:\"Cui-cevenole-St-Privat-des-Vieux-2-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-2-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-2-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:47:\"Cui-cevenole-St-Privat-des-Vieux-2-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-2-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-2-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-2-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-2-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-2-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:45:\"Cui-cevenole-St-Privat-des-Vieux-2-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2208","331","_wp_attached_file","2015/12/Cui-cevenole-St-Privat-des-Vieux-2.jpg");
INSERT INTO ayv_postmeta VALUES("1747","246","_wp_attachment_metadata","a:5:{s:5:\"width\";i:904;s:6:\"height\";i:678;s:4:\"file\";s:45:\"2015/11/Cuisine_contemporaine_sur_cadre-3.jpg\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-3-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-3-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-3-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-3-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-3-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-3-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-3-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-3-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:44:\"Cuisine_contemporaine_sur_cadre-3-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("1744","245","_wp_attached_file","2015/11/Cuisine_contemporaine_sur_cadre-2.jpg");
INSERT INTO ayv_postmeta VALUES("1745","245","_wp_attachment_metadata","a:5:{s:5:\"width\";i:904;s:6:\"height\";i:678;s:4:\"file\";s:45:\"2015/11/Cuisine_contemporaine_sur_cadre-2.jpg\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-2-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-2-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-2-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-2-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-2-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-2-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-2-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-2-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:44:\"Cuisine_contemporaine_sur_cadre-2-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("1746","246","_wp_attached_file","2015/11/Cuisine_contemporaine_sur_cadre-3.jpg");
INSERT INTO ayv_postmeta VALUES("1740","243","_wp_attached_file","2015/11/Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-5.jpg");
INSERT INTO ayv_postmeta VALUES("1741","243","_wp_attachment_metadata","a:5:{s:5:\"width\";i:539;s:6:\"height\";i:359;s:4:\"file\";s:64:\"2015/11/Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-5.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-5-370x246.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:246;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-5-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-5-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-5-539x202.jpg\";s:5:\"width\";i:539;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-5-262x359.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:359;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:63:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-5-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("1738","242","_wp_attached_file","2015/11/Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-4.jpg");
INSERT INTO ayv_postmeta VALUES("1739","242","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1359;s:6:\"height\";i:909;s:4:\"file\";s:64:\"2015/11/Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-4.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-4-300x201.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:201;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:65:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-4-1024x685.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:685;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-4-370x247.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:247;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-4-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:65:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-4-1200x803.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:803;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-4-360x241.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:241;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-4-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-4-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-4-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-4-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:63:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-4-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("1736","241","_wp_attached_file","2015/11/Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-3.jpg");
INSERT INTO ayv_postmeta VALUES("1737","241","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1359;s:6:\"height\";i:909;s:4:\"file\";s:64:\"2015/11/Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-3.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-3-300x201.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:201;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:65:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-3-1024x685.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:685;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-3-370x247.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:247;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-3-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:65:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-3-1200x803.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:803;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-3-360x241.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:241;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-3-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-3-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-3-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:64:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-3-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:63:\"Cuisine_Contemporaine_stratifiee_sycomore_Oberflex-3-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("1742","244","_wp_attached_file","2015/11/Cuisine_contemporaine_sur_cadre-1.jpg");
INSERT INTO ayv_postmeta VALUES("1743","244","_wp_attachment_metadata","a:5:{s:5:\"width\";i:904;s:6:\"height\";i:678;s:4:\"file\";s:45:\"2015/11/Cuisine_contemporaine_sur_cadre-1.jpg\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-1-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-1-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-1-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-1-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-1-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-1-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-1-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-1-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:44:\"Cuisine_contemporaine_sur_cadre-1-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("1756","251","_wp_attached_file","2015/11/Cuisine-contemporaine-medium-laque-3.jpg");
INSERT INTO ayv_postmeta VALUES("1757","251","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:48:\"2015/11/Cuisine-contemporaine-medium-laque-3.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-3-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:49:\"Cuisine-contemporaine-medium-laque-3-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-3-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-3-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:49:\"Cuisine-contemporaine-medium-laque-3-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-3-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-3-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-3-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-3-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-3-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:47:\"Cuisine-contemporaine-medium-laque-3-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("1754","250","_wp_attached_file","2015/11/Cuisine-contemporaine-medium-laque-2.jpg");
INSERT INTO ayv_postmeta VALUES("1755","250","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:48:\"2015/11/Cuisine-contemporaine-medium-laque-2.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-2-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:49:\"Cuisine-contemporaine-medium-laque-2-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-2-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-2-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:49:\"Cuisine-contemporaine-medium-laque-2-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-2-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-2-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-2-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-2-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-2-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:47:\"Cuisine-contemporaine-medium-laque-2-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("1752","249","_wp_attached_file","2015/11/Cuisine-contemporaine-medium-laque-1.jpg");
INSERT INTO ayv_postmeta VALUES("1753","249","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:48:\"2015/11/Cuisine-contemporaine-medium-laque-1.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-1-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:49:\"Cuisine-contemporaine-medium-laque-1-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-1-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-1-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:49:\"Cuisine-contemporaine-medium-laque-1-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-1-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-1-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-1-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-1-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-1-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:47:\"Cuisine-contemporaine-medium-laque-1-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("1748","247","_wp_attached_file","2015/11/Cuisine_contemporaine_sur_cadre-4.jpg");
INSERT INTO ayv_postmeta VALUES("1749","247","_wp_attachment_metadata","a:5:{s:5:\"width\";i:904;s:6:\"height\";i:678;s:4:\"file\";s:45:\"2015/11/Cuisine_contemporaine_sur_cadre-4.jpg\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-4-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-4-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-4-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-4-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-4-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-4-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-4-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-4-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:44:\"Cuisine_contemporaine_sur_cadre-4-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("1750","248","_wp_attached_file","2015/11/Cuisine_contemporaine_sur_cadre-5.jpg");
INSERT INTO ayv_postmeta VALUES("1751","248","_wp_attachment_metadata","a:5:{s:5:\"width\";i:904;s:6:\"height\";i:678;s:4:\"file\";s:45:\"2015/11/Cuisine_contemporaine_sur_cadre-5.jpg\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-5-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-5-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-5-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-5-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-5-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-5-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-5-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:45:\"Cuisine_contemporaine_sur_cadre-5-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:44:\"Cuisine_contemporaine_sur_cadre-5-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2207","330","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:46:\"2015/12/Cui-cevenole-St-Privat-des-Vieux-1.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-1-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:47:\"Cui-cevenole-St-Privat-des-Vieux-1-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-1-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-1-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:47:\"Cui-cevenole-St-Privat-des-Vieux-1-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-1-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-1-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-1-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-1-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-1-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:45:\"Cui-cevenole-St-Privat-des-Vieux-1-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2206","330","_wp_attached_file","2015/12/Cui-cevenole-St-Privat-des-Vieux-1.jpg");
INSERT INTO ayv_postmeta VALUES("2205","329","gallery_images","330,331,332,333");
INSERT INTO ayv_postmeta VALUES("2204","329","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("2203","329","heading_bg","");
INSERT INTO ayv_postmeta VALUES("2202","329","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("2201","329","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("2200","329","custom_breadcrumbs","111");
INSERT INTO ayv_postmeta VALUES("2199","329","anps_portfolio_shorttext","");
INSERT INTO ayv_postmeta VALUES("2198","329","anps_subtitle","");
INSERT INTO ayv_postmeta VALUES("2197","329","anps_team_subtitle","");
INSERT INTO ayv_postmeta VALUES("2196","329","_ville","field_56446f186d761");
INSERT INTO ayv_postmeta VALUES("1758","252","_wp_attached_file","2015/11/Cuisine-contemporaine-medium-laque-4.jpg");
INSERT INTO ayv_postmeta VALUES("1759","252","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:48:\"2015/11/Cuisine-contemporaine-medium-laque-4.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-4-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:49:\"Cuisine-contemporaine-medium-laque-4-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-4-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-4-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:49:\"Cuisine-contemporaine-medium-laque-4-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-4-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-4-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-4-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-4-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-4-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:47:\"Cuisine-contemporaine-medium-laque-4-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("1760","253","_wp_attached_file","2015/11/Cuisine-contemporaine-medium-laque-5.jpg");
INSERT INTO ayv_postmeta VALUES("1761","253","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:48:\"2015/11/Cuisine-contemporaine-medium-laque-5.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-5-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:49:\"Cuisine-contemporaine-medium-laque-5-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-5-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-5-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:49:\"Cuisine-contemporaine-medium-laque-5-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-5-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-5-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-5-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-5-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:48:\"Cuisine-contemporaine-medium-laque-5-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:47:\"Cuisine-contemporaine-medium-laque-5-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("1762","98","_thumbnail_id","249");
INSERT INTO ayv_postmeta VALUES("1764","254","_wp_old_slug","medium-laqueelorem-ipsum");
INSERT INTO ayv_postmeta VALUES("1765","254","_edit_last","1");
INSERT INTO ayv_postmeta VALUES("1766","254","_edit_lock","1451578693:2");
INSERT INTO ayv_postmeta VALUES("1767","254","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("1768","254","anps_team_subtitle","");
INSERT INTO ayv_postmeta VALUES("1769","254","anps_subtitle","");
INSERT INTO ayv_postmeta VALUES("1770","254","anps_portfolio_shorttext","");
INSERT INTO ayv_postmeta VALUES("1771","254","custom_breadcrumbs","109");
INSERT INTO ayv_postmeta VALUES("1772","254","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("1773","254","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("1774","254","heading_bg","");
INSERT INTO ayv_postmeta VALUES("1775","254","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("1776","254","gallery_images","244,245,246,247,248");
INSERT INTO ayv_postmeta VALUES("1777","254","gss_98","ids=\"103,102,101,100,99\"");
INSERT INTO ayv_postmeta VALUES("1778","254","ville","Domessargues");
INSERT INTO ayv_postmeta VALUES("1779","254","_ville","field_56446f186d761");
INSERT INTO ayv_postmeta VALUES("1780","254","_thumbnail_id","244");
INSERT INTO ayv_postmeta VALUES("1781","254","_dp_original","98");
INSERT INTO ayv_postmeta VALUES("1782","255","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("1783","255","_wp_old_slug","cuisine-contemporainesur-cadre");
INSERT INTO ayv_postmeta VALUES("1784","255","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("1785","255","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("1786","255","_wp_old_slug","medium-laqueelorem-ipsum");
INSERT INTO ayv_postmeta VALUES("1787","255","_edit_last","2");
INSERT INTO ayv_postmeta VALUES("1788","255","_edit_lock","1451579021:2");
INSERT INTO ayv_postmeta VALUES("1789","255","anps_team_subtitle","");
INSERT INTO ayv_postmeta VALUES("1790","255","anps_subtitle","");
INSERT INTO ayv_postmeta VALUES("1791","255","anps_portfolio_shorttext","");
INSERT INTO ayv_postmeta VALUES("1792","255","custom_breadcrumbs","109");
INSERT INTO ayv_postmeta VALUES("1793","255","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("1794","255","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("1795","255","heading_bg","");
INSERT INTO ayv_postmeta VALUES("1796","255","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("1797","255","gallery_images","239,240,241,242,243");
INSERT INTO ayv_postmeta VALUES("1798","255","gss_98","ids=\"103,102,101,100,99\"");
INSERT INTO ayv_postmeta VALUES("1799","255","ville","Als");
INSERT INTO ayv_postmeta VALUES("1800","255","_ville","field_56446f186d761");
INSERT INTO ayv_postmeta VALUES("1804","255","_thumbnail_id","239");
INSERT INTO ayv_postmeta VALUES("1803","255","_dp_original","254");
INSERT INTO ayv_postmeta VALUES("1805","256","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("1806","256","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("1807","256","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("1808","256","_wp_old_slug","cuisine-contemporainesur-cadre");
INSERT INTO ayv_postmeta VALUES("1809","256","_wp_old_slug","medium-laqueelorem-ipsum");
INSERT INTO ayv_postmeta VALUES("1810","256","_edit_last","2");
INSERT INTO ayv_postmeta VALUES("1811","256","_edit_lock","1451578902:2");
INSERT INTO ayv_postmeta VALUES("1812","256","anps_team_subtitle","");
INSERT INTO ayv_postmeta VALUES("1813","256","anps_subtitle","");
INSERT INTO ayv_postmeta VALUES("1814","256","anps_portfolio_shorttext","");
INSERT INTO ayv_postmeta VALUES("1815","256","custom_breadcrumbs","109");
INSERT INTO ayv_postmeta VALUES("1816","256","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("1817","256","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("1818","256","heading_bg","");
INSERT INTO ayv_postmeta VALUES("1819","256","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("1820","256","gallery_images","231,232,233,234,235,236,237,238,");
INSERT INTO ayv_postmeta VALUES("1821","256","gss_98","ids=\"103,102,101,100,99\"");
INSERT INTO ayv_postmeta VALUES("1822","256","ville","Marguerittes");
INSERT INTO ayv_postmeta VALUES("1823","256","_ville","field_56446f186d761");
INSERT INTO ayv_postmeta VALUES("1826","256","_dp_original","255");
INSERT INTO ayv_postmeta VALUES("1827","256","_thumbnail_id","231");
INSERT INTO ayv_postmeta VALUES("1828","257","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("1829","257","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("1830","257","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("1831","257","_wp_old_slug","cuisine-contemporainesur-cadre");
INSERT INTO ayv_postmeta VALUES("1832","257","_wp_old_slug","medium-laqueelorem-ipsum");
INSERT INTO ayv_postmeta VALUES("1833","257","_edit_last","2");
INSERT INTO ayv_postmeta VALUES("1834","257","_edit_lock","1452021895:2");
INSERT INTO ayv_postmeta VALUES("1835","257","anps_team_subtitle","");
INSERT INTO ayv_postmeta VALUES("1836","257","anps_subtitle","");
INSERT INTO ayv_postmeta VALUES("1837","257","anps_portfolio_shorttext","");
INSERT INTO ayv_postmeta VALUES("1838","257","custom_breadcrumbs","109");
INSERT INTO ayv_postmeta VALUES("1839","257","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("1840","257","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("1841","257","heading_bg","");
INSERT INTO ayv_postmeta VALUES("1842","257","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("1843","257","gallery_images","228,230,229,");
INSERT INTO ayv_postmeta VALUES("1851","258","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("1844","257","gss_98","ids=\"103,102,101,100,99\"");
INSERT INTO ayv_postmeta VALUES("1845","257","ville","Ales");
INSERT INTO ayv_postmeta VALUES("1846","257","_ville","field_56446f186d761");
INSERT INTO ayv_postmeta VALUES("1849","257","_dp_original","256");
INSERT INTO ayv_postmeta VALUES("1850","257","_thumbnail_id","228");
INSERT INTO ayv_postmeta VALUES("1852","258","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("1853","258","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("1854","258","_wp_old_slug","cuisine-contemporainesur-cadre");
INSERT INTO ayv_postmeta VALUES("1855","258","_wp_old_slug","medium-laqueelorem-ipsum");
INSERT INTO ayv_postmeta VALUES("1856","258","_edit_last","2");
INSERT INTO ayv_postmeta VALUES("1857","258","_edit_lock","1452022895:2");
INSERT INTO ayv_postmeta VALUES("1858","258","anps_team_subtitle","");
INSERT INTO ayv_postmeta VALUES("1859","258","anps_subtitle","");
INSERT INTO ayv_postmeta VALUES("1860","258","anps_portfolio_shorttext","");
INSERT INTO ayv_postmeta VALUES("1861","258","custom_breadcrumbs","109");
INSERT INTO ayv_postmeta VALUES("1862","258","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("1863","258","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("1864","258","heading_bg","");
INSERT INTO ayv_postmeta VALUES("1865","258","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("1866","258","gallery_images","222,223,224,225,226,227,");
INSERT INTO ayv_postmeta VALUES("1867","258","gss_98","ids=\"103,102,101,100,99\"");
INSERT INTO ayv_postmeta VALUES("1868","258","ville","Als");
INSERT INTO ayv_postmeta VALUES("1869","258","_ville","field_56446f186d761");
INSERT INTO ayv_postmeta VALUES("1872","258","_dp_original","257");
INSERT INTO ayv_postmeta VALUES("1873","258","_thumbnail_id","222");
INSERT INTO ayv_postmeta VALUES("1874","259","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("1875","259","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("1876","259","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("1877","259","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("1878","259","_wp_old_slug","cuisine-contemporainesur-cadre");
INSERT INTO ayv_postmeta VALUES("1879","259","_wp_old_slug","medium-laqueelorem-ipsum");
INSERT INTO ayv_postmeta VALUES("1880","259","_edit_last","1");
INSERT INTO ayv_postmeta VALUES("1881","259","_edit_lock","1451843163:2");
INSERT INTO ayv_postmeta VALUES("1882","259","anps_team_subtitle","");
INSERT INTO ayv_postmeta VALUES("1883","259","anps_subtitle","");
INSERT INTO ayv_postmeta VALUES("1884","259","anps_portfolio_shorttext","");
INSERT INTO ayv_postmeta VALUES("1885","259","custom_breadcrumbs","111");
INSERT INTO ayv_postmeta VALUES("1886","259","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("1887","259","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("1888","259","heading_bg","");
INSERT INTO ayv_postmeta VALUES("1889","259","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("1890","259","gallery_images","295,296,297,298");
INSERT INTO ayv_postmeta VALUES("1891","259","gss_98","ids=\"103,102,101,100,99\"");
INSERT INTO ayv_postmeta VALUES("1892","259","ville","Meyrannes");
INSERT INTO ayv_postmeta VALUES("1893","259","_ville","field_56446f186d761");
INSERT INTO ayv_postmeta VALUES("1896","259","_dp_original","258");
INSERT INTO ayv_postmeta VALUES("2080","294","_wp_attached_file","2015/11/Cuisine_provencale_Louis_XV_bati-5.jpg");
INSERT INTO ayv_postmeta VALUES("2081","294","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:848;s:4:\"file\";s:46:\"2015/11/Cuisine_provencale_Louis_XV_bati-5.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-5-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_bati-5-1024x678.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:678;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-5-370x245.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:245;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-5-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_bati-5-1200x795.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:795;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-5-360x239.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:239;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-5-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-5-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-5-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-5-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:45:\"Cuisine_provencale_Louis_XV_bati-5-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2078","293","_wp_attached_file","2015/11/Cuisine_provencale_Louis_XV_bati-4.jpg");
INSERT INTO ayv_postmeta VALUES("2079","293","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:848;s:4:\"file\";s:46:\"2015/11/Cuisine_provencale_Louis_XV_bati-4.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-4-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_bati-4-1024x678.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:678;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-4-370x245.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:245;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-4-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_bati-4-1200x795.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:795;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-4-360x239.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:239;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-4-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-4-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-4-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-4-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:45:\"Cuisine_provencale_Louis_XV_bati-4-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2076","292","_wp_attached_file","2015/11/Cuisine_provencale_Louis_XV_bati-3.jpg");
INSERT INTO ayv_postmeta VALUES("2077","292","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:848;s:4:\"file\";s:46:\"2015/11/Cuisine_provencale_Louis_XV_bati-3.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-3-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_bati-3-1024x678.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:678;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-3-370x245.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:245;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-3-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_bati-3-1200x795.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:795;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-3-360x239.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:239;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-3-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-3-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-3-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-3-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:45:\"Cuisine_provencale_Louis_XV_bati-3-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2074","291","_wp_attached_file","2015/11/Cuisine_provencale_Louis_XV_bati-2.jpg");
INSERT INTO ayv_postmeta VALUES("2075","291","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:848;s:4:\"file\";s:46:\"2015/11/Cuisine_provencale_Louis_XV_bati-2.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-2-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_bati-2-1024x678.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:678;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-2-370x245.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:245;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-2-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_bati-2-1200x795.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:795;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-2-360x239.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:239;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-2-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-2-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-2-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-2-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:45:\"Cuisine_provencale_Louis_XV_bati-2-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2072","290","_wp_attached_file","2015/11/Cuisine_provencale_Louis_XV_bati-1.jpg");
INSERT INTO ayv_postmeta VALUES("2073","290","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:848;s:4:\"file\";s:46:\"2015/11/Cuisine_provencale_Louis_XV_bati-1.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-1-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_bati-1-1024x678.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:678;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-1-370x245.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:245;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-1-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_bati-1-1200x795.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:795;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-1-360x239.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:239;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-1-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-1-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-1-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_bati-1-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:45:\"Cuisine_provencale_Louis_XV_bati-1-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2062","286","_wp_attached_file","2015/11/Cuisine_provencale_Louis_XV_Noyer-1.jpg");
INSERT INTO ayv_postmeta VALUES("2063","286","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:853;s:4:\"file\";s:47:\"2015/11/Cuisine_provencale_Louis_XV_Noyer-1.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Noyer-1-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-1-370x247.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:247;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-1-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Noyer-1-1200x800.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-1-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-1-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-1-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-1-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-1-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_Noyer-1-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2064","287","_wp_attached_file","2015/11/Cuisine_provencale_Louis_XV_Noyer-2.jpg");
INSERT INTO ayv_postmeta VALUES("2065","287","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:853;s:4:\"file\";s:47:\"2015/11/Cuisine_provencale_Louis_XV_Noyer-2.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Noyer-2-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-2-370x247.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:247;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-2-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Noyer-2-1200x800.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-2-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-2-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-2-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-2-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-2-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_Noyer-2-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2066","288","_wp_attached_file","2015/11/Cuisine_provencale_Louis_XV_Noyer-3.jpg");
INSERT INTO ayv_postmeta VALUES("2067","288","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:853;s:4:\"file\";s:47:\"2015/11/Cuisine_provencale_Louis_XV_Noyer-3.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Noyer-3-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-3-370x247.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:247;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-3-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Noyer-3-1200x800.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-3-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-3-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-3-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-3-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-3-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_Noyer-3-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2083","295","_wp_attached_file","2015/11/Cuisine_provencale_Louis_XV_Pastel-1.jpg");
INSERT INTO ayv_postmeta VALUES("2084","295","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:848;s:4:\"file\";s:48:\"2015/11/Cuisine_provencale_Louis_XV_Pastel-1.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-1-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:49:\"Cuisine_provencale_Louis_XV_Pastel-1-1024x678.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:678;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-1-370x245.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:245;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-1-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:49:\"Cuisine_provencale_Louis_XV_Pastel-1-1200x795.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:795;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-1-360x239.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:239;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-1-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-1-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-1-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-1-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Pastel-1-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2085","296","_wp_attached_file","2015/11/Cuisine_provencale_Louis_XV_Pastel-2.jpg");
INSERT INTO ayv_postmeta VALUES("2086","296","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:848;s:4:\"file\";s:48:\"2015/11/Cuisine_provencale_Louis_XV_Pastel-2.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-2-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:49:\"Cuisine_provencale_Louis_XV_Pastel-2-1024x678.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:678;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-2-370x245.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:245;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-2-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:49:\"Cuisine_provencale_Louis_XV_Pastel-2-1200x795.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:795;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-2-360x239.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:239;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-2-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-2-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-2-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-2-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Pastel-2-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2087","297","_wp_attached_file","2015/11/Cuisine_provencale_Louis_XV_Pastel-3.jpg");
INSERT INTO ayv_postmeta VALUES("2088","297","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:848;s:4:\"file\";s:48:\"2015/11/Cuisine_provencale_Louis_XV_Pastel-3.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-3-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:49:\"Cuisine_provencale_Louis_XV_Pastel-3-1024x678.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:678;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-3-370x245.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:245;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-3-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:49:\"Cuisine_provencale_Louis_XV_Pastel-3-1200x795.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:795;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-3-360x239.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:239;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-3-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-3-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-3-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-3-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Pastel-3-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2089","298","_wp_attached_file","2015/11/Cuisine_provencale_Louis_XV_Pastel-4.jpg");
INSERT INTO ayv_postmeta VALUES("2090","298","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:848;s:4:\"file\";s:48:\"2015/11/Cuisine_provencale_Louis_XV_Pastel-4.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-4-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:49:\"Cuisine_provencale_Louis_XV_Pastel-4-1024x678.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:678;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-4-370x245.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:245;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-4-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:49:\"Cuisine_provencale_Louis_XV_Pastel-4-1200x795.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:795;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-4-360x239.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:239;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-4-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-4-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-4-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Pastel-4-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Pastel-4-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2092","299","_wp_attached_file","2015/11/Cuisine_Provencale_Louis_XV_pourpre-1.jpg");
INSERT INTO ayv_postmeta VALUES("2093","299","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:853;s:4:\"file\";s:49:\"2015/11/Cuisine_Provencale_Louis_XV_pourpre-1.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:49:\"Cuisine_Provencale_Louis_XV_pourpre-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:49:\"Cuisine_Provencale_Louis_XV_pourpre-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:50:\"Cuisine_Provencale_Louis_XV_pourpre-1-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:49:\"Cuisine_Provencale_Louis_XV_pourpre-1-370x247.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:247;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:49:\"Cuisine_Provencale_Louis_XV_pourpre-1-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:50:\"Cuisine_Provencale_Louis_XV_pourpre-1-1200x800.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:49:\"Cuisine_Provencale_Louis_XV_pourpre-1-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:49:\"Cuisine_Provencale_Louis_XV_pourpre-1-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:49:\"Cuisine_Provencale_Louis_XV_pourpre-1-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:49:\"Cuisine_Provencale_Louis_XV_pourpre-1-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:49:\"Cuisine_Provencale_Louis_XV_pourpre-1-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:48:\"Cuisine_Provencale_Louis_XV_pourpre-1-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2094","300","_wp_attached_file","2015/11/Cuisine_Provencale_Louis_XV_pourpre-2.jpg");
INSERT INTO ayv_postmeta VALUES("2095","300","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:853;s:4:\"file\";s:49:\"2015/11/Cuisine_Provencale_Louis_XV_pourpre-2.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:49:\"Cuisine_Provencale_Louis_XV_pourpre-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:49:\"Cuisine_Provencale_Louis_XV_pourpre-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:50:\"Cuisine_Provencale_Louis_XV_pourpre-2-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:49:\"Cuisine_Provencale_Louis_XV_pourpre-2-370x247.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:247;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:49:\"Cuisine_Provencale_Louis_XV_pourpre-2-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:50:\"Cuisine_Provencale_Louis_XV_pourpre-2-1200x800.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:49:\"Cuisine_Provencale_Louis_XV_pourpre-2-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:49:\"Cuisine_Provencale_Louis_XV_pourpre-2-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:49:\"Cuisine_Provencale_Louis_XV_pourpre-2-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:49:\"Cuisine_Provencale_Louis_XV_pourpre-2-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:49:\"Cuisine_Provencale_Louis_XV_pourpre-2-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:48:\"Cuisine_Provencale_Louis_XV_pourpre-2-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("1925","274","_wp_attached_file","2015/11/Cuisine_sous_voutes_tuiles-1.jpg");
INSERT INTO ayv_postmeta VALUES("1926","274","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:857;s:4:\"file\";s:40:\"2015/11/Cuisine_sous_voutes_tuiles-1.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-1-300x201.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:201;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:41:\"Cuisine_sous_voutes_tuiles-1-1024x686.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:686;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-1-370x248.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:248;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-1-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:41:\"Cuisine_sous_voutes_tuiles-1-1200x803.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:803;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-1-360x241.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:241;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-1-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-1-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-1-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-1-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:39:\"Cuisine_sous_voutes_tuiles-1-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("1927","275","_wp_attached_file","2015/11/Cuisine_sous_voutes_tuiles-2.jpg");
INSERT INTO ayv_postmeta VALUES("1928","275","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:857;s:4:\"file\";s:40:\"2015/11/Cuisine_sous_voutes_tuiles-2.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-2-300x201.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:201;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:41:\"Cuisine_sous_voutes_tuiles-2-1024x686.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:686;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-2-370x248.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:248;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-2-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:41:\"Cuisine_sous_voutes_tuiles-2-1200x803.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:803;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-2-360x241.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:241;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-2-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-2-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-2-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-2-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:39:\"Cuisine_sous_voutes_tuiles-2-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("1929","276","_wp_attached_file","2015/11/Cuisine_sous_voutes_tuiles-3.jpg");
INSERT INTO ayv_postmeta VALUES("1930","276","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:857;s:4:\"file\";s:40:\"2015/11/Cuisine_sous_voutes_tuiles-3.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-3-300x201.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:201;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:41:\"Cuisine_sous_voutes_tuiles-3-1024x686.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:686;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-3-370x248.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:248;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-3-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:41:\"Cuisine_sous_voutes_tuiles-3-1200x803.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:803;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-3-360x241.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:241;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-3-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-3-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-3-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-3-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:39:\"Cuisine_sous_voutes_tuiles-3-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("1931","277","_wp_attached_file","2015/11/Cuisine_sous_voutes_tuiles-4.jpg");
INSERT INTO ayv_postmeta VALUES("1932","277","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:857;s:4:\"file\";s:40:\"2015/11/Cuisine_sous_voutes_tuiles-4.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-4-300x201.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:201;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:41:\"Cuisine_sous_voutes_tuiles-4-1024x686.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:686;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-4-370x248.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:248;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-4-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:41:\"Cuisine_sous_voutes_tuiles-4-1200x803.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:803;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-4-360x241.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:241;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-4-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-4-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-4-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-4-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:39:\"Cuisine_sous_voutes_tuiles-4-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("1933","278","_wp_attached_file","2015/11/Cuisine_sous_voutes_tuiles-5.jpg");
INSERT INTO ayv_postmeta VALUES("1934","278","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:857;s:4:\"file\";s:40:\"2015/11/Cuisine_sous_voutes_tuiles-5.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-5-300x201.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:201;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:41:\"Cuisine_sous_voutes_tuiles-5-1024x686.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:686;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-5-370x248.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:248;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-5-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:41:\"Cuisine_sous_voutes_tuiles-5-1200x803.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:803;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-5-360x241.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:241;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-5-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-5-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-5-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:40:\"Cuisine_sous_voutes_tuiles-5-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:39:\"Cuisine_sous_voutes_tuiles-5-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("1365","189","_edit_last","1");
INSERT INTO ayv_postmeta VALUES("1400","189","sbg_selected_sidebar_replacement","0");
INSERT INTO ayv_postmeta VALUES("1368","189","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("1369","189","field_56446f186d761","a:14:{s:3:\"key\";s:19:\"field_56446f186d761\";s:5:\"label\";s:5:\"Ville\";s:4:\"name\";s:5:\"ville\";s:4:\"type\";s:4:\"text\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";s:1:\"0\";s:13:\"default_value\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"prepend\";s:0:\"\";s:6:\"append\";s:0:\"\";s:10:\"formatting\";s:4:\"none\";s:9:\"maxlength\";s:0:\"\";s:17:\"conditional_logic\";a:3:{s:6:\"status\";s:1:\"0\";s:5:\"rules\";a:1:{i:0;a:2:{s:5:\"field\";s:4:\"null\";s:8:\"operator\";s:2:\"==\";}}s:8:\"allorany\";s:3:\"all\";}s:8:\"order_no\";i:0;}");
INSERT INTO ayv_postmeta VALUES("1398","189","rule","a:5:{s:5:\"param\";s:9:\"post_type\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:9:\"portfolio\";s:8:\"order_no\";i:0;s:8:\"group_no\";i:0;}");
INSERT INTO ayv_postmeta VALUES("1394","98","ville","Als");
INSERT INTO ayv_postmeta VALUES("1395","98","_ville","field_56446f186d761");
INSERT INTO ayv_postmeta VALUES("1999","283","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("2000","283","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("1372","189","position","normal");
INSERT INTO ayv_postmeta VALUES("1373","189","layout","no_box");
INSERT INTO ayv_postmeta VALUES("1374","189","hide_on_screen","");
INSERT INTO ayv_postmeta VALUES("1377","189","anps_team_subtitle","");
INSERT INTO ayv_postmeta VALUES("1378","189","anps_subtitle","");
INSERT INTO ayv_postmeta VALUES("1379","189","anps_portfolio_shorttext","");
INSERT INTO ayv_postmeta VALUES("1380","189","custom_breadcrumbs","");
INSERT INTO ayv_postmeta VALUES("1381","189","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("1382","189","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("1383","189","heading_bg","");
INSERT INTO ayv_postmeta VALUES("1384","189","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("1385","189","gallery_images","");
INSERT INTO ayv_postmeta VALUES("1386","189","_edit_lock","1447686644:1");
INSERT INTO ayv_postmeta VALUES("1399","189","sbg_selected_sidebar","0");
INSERT INTO ayv_postmeta VALUES("1763","254","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("2191","322","_thumbnail_id","323");
INSERT INTO ayv_postmeta VALUES("2192","329","_edit_last","1");
INSERT INTO ayv_postmeta VALUES("2193","329","_edit_lock","1455084485:2");
INSERT INTO ayv_postmeta VALUES("2194","329","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("2195","329","ville","St Privat des Vieux");
INSERT INTO ayv_postmeta VALUES("2108","305","ville","Nmes");
INSERT INTO ayv_postmeta VALUES("2109","305","_ville","field_56446f186d761");
INSERT INTO ayv_postmeta VALUES("2110","305","anps_team_subtitle","");
INSERT INTO ayv_postmeta VALUES("2111","305","anps_subtitle","");
INSERT INTO ayv_postmeta VALUES("2112","305","anps_portfolio_shorttext","");
INSERT INTO ayv_postmeta VALUES("2113","305","custom_breadcrumbs","109");
INSERT INTO ayv_postmeta VALUES("2114","305","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("2115","305","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("2116","305","heading_bg","");
INSERT INTO ayv_postmeta VALUES("2117","305","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("2118","305","gallery_images","306,307,308,309,310,311,312,313,314");
INSERT INTO ayv_postmeta VALUES("2119","306","_wp_attached_file","2015/12/Cui-laque-brillante-blanche-1.jpg");
INSERT INTO ayv_postmeta VALUES("2120","306","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:852;s:4:\"file\";s:41:\"2015/12/Cui-laque-brillante-blanche-1.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:42:\"Cui-laque-brillante-blanche-1-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-1-370x246.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:246;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-1-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:42:\"Cui-laque-brillante-blanche-1-1200x799.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:799;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-1-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-1-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-1-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-1-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-1-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:40:\"Cui-laque-brillante-blanche-1-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2096","301","_wp_attached_file","2015/11/Cuisine_Provencale_Louis_XV_pourpre-3.jpg");
INSERT INTO ayv_postmeta VALUES("2097","301","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:853;s:4:\"file\";s:49:\"2015/11/Cuisine_Provencale_Louis_XV_pourpre-3.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:49:\"Cuisine_Provencale_Louis_XV_pourpre-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:49:\"Cuisine_Provencale_Louis_XV_pourpre-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:50:\"Cuisine_Provencale_Louis_XV_pourpre-3-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:49:\"Cuisine_Provencale_Louis_XV_pourpre-3-370x247.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:247;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:49:\"Cuisine_Provencale_Louis_XV_pourpre-3-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:50:\"Cuisine_Provencale_Louis_XV_pourpre-3-1200x800.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:49:\"Cuisine_Provencale_Louis_XV_pourpre-3-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:49:\"Cuisine_Provencale_Louis_XV_pourpre-3-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:49:\"Cuisine_Provencale_Louis_XV_pourpre-3-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:49:\"Cuisine_Provencale_Louis_XV_pourpre-3-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:49:\"Cuisine_Provencale_Louis_XV_pourpre-3-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:48:\"Cuisine_Provencale_Louis_XV_pourpre-3-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2098","282","_thumbnail_id","299");
INSERT INTO ayv_postmeta VALUES("2101","98","_wp_old_slug","medium-laquee");
INSERT INTO ayv_postmeta VALUES("2102","256","_wp_old_slug","porte-placage-bois-stratifiee-ober");
INSERT INTO ayv_postmeta VALUES("2103","255","_wp_old_slug","stratifiee-sycomore-oberflex");
INSERT INTO ayv_postmeta VALUES("2104","256","_wp_old_slug","cuisine-contemporaine-en-placage-bois-veritable");
INSERT INTO ayv_postmeta VALUES("2105","305","_edit_last","2");
INSERT INTO ayv_postmeta VALUES("2106","305","_edit_lock","1451579060:2");
INSERT INTO ayv_postmeta VALUES("2107","305","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("1966","282","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("1967","282","_wp_old_slug","cuisine-provencale-louis-xv-noyer");
INSERT INTO ayv_postmeta VALUES("1968","282","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("1969","282","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("1970","282","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("1971","282","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("1972","282","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("1973","282","_wp_old_slug","blanche-en-setapan-3");
INSERT INTO ayv_postmeta VALUES("1974","282","_wp_old_slug","cuisine-contemporainesur-cadre");
INSERT INTO ayv_postmeta VALUES("1975","282","_wp_old_slug","medium-laqueelorem-ipsum");
INSERT INTO ayv_postmeta VALUES("1976","282","_edit_last","2");
INSERT INTO ayv_postmeta VALUES("1977","282","_edit_lock","1451843146:2");
INSERT INTO ayv_postmeta VALUES("1978","282","anps_team_subtitle","");
INSERT INTO ayv_postmeta VALUES("1979","282","anps_subtitle","");
INSERT INTO ayv_postmeta VALUES("1980","282","anps_portfolio_shorttext","");
INSERT INTO ayv_postmeta VALUES("1981","282","custom_breadcrumbs","111");
INSERT INTO ayv_postmeta VALUES("1982","282","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("1983","282","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("1984","282","heading_bg","");
INSERT INTO ayv_postmeta VALUES("1985","282","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("1986","282","gallery_images","299,300,301,");
INSERT INTO ayv_postmeta VALUES("1987","282","gss_98","ids=\"103,102,101,100,99\"");
INSERT INTO ayv_postmeta VALUES("1988","282","ville","Cassagnoles");
INSERT INTO ayv_postmeta VALUES("1989","282","_ville","field_56446f186d761");
INSERT INTO ayv_postmeta VALUES("1992","282","_dp_original","281");
INSERT INTO ayv_postmeta VALUES("1994","282","_wp_old_slug","blanche-en-setapan-2-2-2");
INSERT INTO ayv_postmeta VALUES("1996","259","_wp_old_slug","blanche-en-setapan-2");
INSERT INTO ayv_postmeta VALUES("1997","255","_wp_old_slug","medium-laquee-2-2");
INSERT INTO ayv_postmeta VALUES("1998","254","_wp_old_slug","medium-laquee-2");
INSERT INTO ayv_postmeta VALUES("2001","283","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("2002","283","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("2003","283","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("2004","283","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("2005","283","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("2006","283","_wp_old_slug","cuisine-provencale-louis-xv-noyer");
INSERT INTO ayv_postmeta VALUES("2007","283","_wp_old_slug","blanche-en-setapan-3");
INSERT INTO ayv_postmeta VALUES("2008","283","_wp_old_slug","cuisine-contemporainesur-cadre");
INSERT INTO ayv_postmeta VALUES("2009","283","_wp_old_slug","medium-laqueelorem-ipsum");
INSERT INTO ayv_postmeta VALUES("2010","283","_wp_old_slug","blanche-en-setapan-2-2-2");
INSERT INTO ayv_postmeta VALUES("2011","283","_edit_last","1");
INSERT INTO ayv_postmeta VALUES("2012","283","_edit_lock","1450877875:1");
INSERT INTO ayv_postmeta VALUES("2013","283","anps_team_subtitle","");
INSERT INTO ayv_postmeta VALUES("2014","283","anps_subtitle","");
INSERT INTO ayv_postmeta VALUES("2015","283","anps_portfolio_shorttext","");
INSERT INTO ayv_postmeta VALUES("2016","283","custom_breadcrumbs","111");
INSERT INTO ayv_postmeta VALUES("2017","283","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("2018","283","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("2019","283","heading_bg","");
INSERT INTO ayv_postmeta VALUES("2020","283","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("2021","283","gallery_images","274,275,276,277,278,");
INSERT INTO ayv_postmeta VALUES("2022","283","gss_98","ids=\"103,102,101,100,99\"");
INSERT INTO ayv_postmeta VALUES("2023","283","ville","Als");
INSERT INTO ayv_postmeta VALUES("2024","283","_ville","field_56446f186d761");
INSERT INTO ayv_postmeta VALUES("2027","283","_dp_original","282");
INSERT INTO ayv_postmeta VALUES("2028","283","_thumbnail_id","274");
INSERT INTO ayv_postmeta VALUES("2030","285","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("2029","283","_wp_old_slug","cuisine-provencale-louis-xv-pourpre-2");
INSERT INTO ayv_postmeta VALUES("2031","285","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("2032","285","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("2033","285","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("2034","285","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("2035","285","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("2036","285","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("2037","285","_wp_old_slug","cuisine-provencale-louis-xv-noyer");
INSERT INTO ayv_postmeta VALUES("2038","285","_wp_old_slug","blanche-en-setapan-3");
INSERT INTO ayv_postmeta VALUES("2039","285","_wp_old_slug","cuisine-contemporainesur-cadre");
INSERT INTO ayv_postmeta VALUES("2040","285","_wp_old_slug","medium-laqueelorem-ipsum");
INSERT INTO ayv_postmeta VALUES("2041","285","_wp_old_slug","blanche-en-setapan-2-2-2");
INSERT INTO ayv_postmeta VALUES("2042","285","_edit_last","1");
INSERT INTO ayv_postmeta VALUES("2043","285","_edit_lock","1451843128:2");
INSERT INTO ayv_postmeta VALUES("2044","285","anps_team_subtitle","");
INSERT INTO ayv_postmeta VALUES("2045","285","anps_subtitle","");
INSERT INTO ayv_postmeta VALUES("2046","285","anps_portfolio_shorttext","");
INSERT INTO ayv_postmeta VALUES("2047","285","custom_breadcrumbs","111");
INSERT INTO ayv_postmeta VALUES("2048","285","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("2049","285","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("2050","285","heading_bg","");
INSERT INTO ayv_postmeta VALUES("2051","285","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("2052","285","gallery_images","290,291,292,293,294");
INSERT INTO ayv_postmeta VALUES("2053","285","gss_98","ids=\"103,102,101,100,99\"");
INSERT INTO ayv_postmeta VALUES("2054","285","ville","St Hilaire de Brethmas");
INSERT INTO ayv_postmeta VALUES("2055","285","_ville","field_56446f186d761");
INSERT INTO ayv_postmeta VALUES("2058","285","_dp_original","282");
INSERT INTO ayv_postmeta VALUES("2060","285","_wp_old_slug","cuisine-provencale-louis-xv-pourpre-2");
INSERT INTO ayv_postmeta VALUES("2068","289","_wp_attached_file","2015/11/Cuisine_provencale_Louis_XV_Noyer-4.jpg");
INSERT INTO ayv_postmeta VALUES("2069","289","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:853;s:4:\"file\";s:47:\"2015/11/Cuisine_provencale_Louis_XV_Noyer-4.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Noyer-4-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-4-370x247.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:247;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-4-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:48:\"Cuisine_provencale_Louis_XV_Noyer-4-1200x800.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-4-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-4-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-4-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-4-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:47:\"Cuisine_provencale_Louis_XV_Noyer-4-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:46:\"Cuisine_provencale_Louis_XV_Noyer-4-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2082","285","_thumbnail_id","290");
INSERT INTO ayv_postmeta VALUES("2091","259","_thumbnail_id","295");
INSERT INTO ayv_postmeta VALUES("2121","307","_wp_attached_file","2015/12/Cui-laque-brillante-blanche-2.jpg");
INSERT INTO ayv_postmeta VALUES("2122","307","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:852;s:4:\"file\";s:41:\"2015/12/Cui-laque-brillante-blanche-2.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:42:\"Cui-laque-brillante-blanche-2-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-2-370x246.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:246;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-2-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:42:\"Cui-laque-brillante-blanche-2-1200x799.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:799;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-2-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-2-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-2-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-2-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-2-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:40:\"Cui-laque-brillante-blanche-2-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2123","308","_wp_attached_file","2015/12/Cui-laque-brillante-blanche-3.jpg");
INSERT INTO ayv_postmeta VALUES("2124","308","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:852;s:4:\"file\";s:41:\"2015/12/Cui-laque-brillante-blanche-3.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:42:\"Cui-laque-brillante-blanche-3-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-3-370x246.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:246;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-3-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:42:\"Cui-laque-brillante-blanche-3-1200x799.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:799;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-3-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-3-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-3-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-3-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-3-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:40:\"Cui-laque-brillante-blanche-3-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2125","309","_wp_attached_file","2015/12/Cui-laque-brillante-blanche-4.jpg");
INSERT INTO ayv_postmeta VALUES("2126","309","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:852;s:4:\"file\";s:41:\"2015/12/Cui-laque-brillante-blanche-4.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:42:\"Cui-laque-brillante-blanche-4-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-4-370x246.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:246;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-4-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:42:\"Cui-laque-brillante-blanche-4-1200x799.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:799;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-4-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-4-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-4-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-4-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-4-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:40:\"Cui-laque-brillante-blanche-4-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2127","310","_wp_attached_file","2015/12/Cui-laque-brillante-blanche-5.jpg");
INSERT INTO ayv_postmeta VALUES("2128","310","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:852;s:4:\"file\";s:41:\"2015/12/Cui-laque-brillante-blanche-5.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:42:\"Cui-laque-brillante-blanche-5-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-5-370x246.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:246;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-5-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:42:\"Cui-laque-brillante-blanche-5-1200x799.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:799;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-5-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-5-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-5-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-5-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-5-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:40:\"Cui-laque-brillante-blanche-5-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2129","311","_wp_attached_file","2015/12/Cui-laque-brillante-blanche-6.jpg");
INSERT INTO ayv_postmeta VALUES("2130","311","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:852;s:4:\"file\";s:41:\"2015/12/Cui-laque-brillante-blanche-6.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-6-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:42:\"Cui-laque-brillante-blanche-6-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-6-370x246.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:246;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-6-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:42:\"Cui-laque-brillante-blanche-6-1200x799.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:799;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-6-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-6-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-6-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-6-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-6-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:40:\"Cui-laque-brillante-blanche-6-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2131","312","_wp_attached_file","2015/12/Cui-laque-brillante-blanche-7.jpg");
INSERT INTO ayv_postmeta VALUES("2132","312","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:852;s:4:\"file\";s:41:\"2015/12/Cui-laque-brillante-blanche-7.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-7-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:42:\"Cui-laque-brillante-blanche-7-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-7-370x246.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:246;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-7-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:42:\"Cui-laque-brillante-blanche-7-1200x799.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:799;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-7-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-7-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-7-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-7-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-7-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:40:\"Cui-laque-brillante-blanche-7-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2133","313","_wp_attached_file","2015/12/Cui-laque-brillante-blanche-8.jpg");
INSERT INTO ayv_postmeta VALUES("2134","313","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:852;s:4:\"file\";s:41:\"2015/12/Cui-laque-brillante-blanche-8.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-8-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:42:\"Cui-laque-brillante-blanche-8-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-8-370x246.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:246;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-8-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:42:\"Cui-laque-brillante-blanche-8-1200x799.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:799;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-8-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-8-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-8-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-8-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-8-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:40:\"Cui-laque-brillante-blanche-8-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2135","314","_wp_attached_file","2015/12/Cui-laque-brillante-blanche-9.jpg");
INSERT INTO ayv_postmeta VALUES("2136","314","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:852;s:4:\"file\";s:41:\"2015/12/Cui-laque-brillante-blanche-9.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-9-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:42:\"Cui-laque-brillante-blanche-9-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-9-370x246.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:246;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-9-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:42:\"Cui-laque-brillante-blanche-9-1200x799.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:799;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-9-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-9-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-9-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-9-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:41:\"Cui-laque-brillante-blanche-9-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:40:\"Cui-laque-brillante-blanche-9-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2137","305","_thumbnail_id","306");
INSERT INTO ayv_postmeta VALUES("2138","315","_edit_last","2");
INSERT INTO ayv_postmeta VALUES("2139","315","_edit_lock","1451578225:2");
INSERT INTO ayv_postmeta VALUES("2140","315","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("2141","315","ville","St Victor");
INSERT INTO ayv_postmeta VALUES("2142","315","_ville","field_56446f186d761");
INSERT INTO ayv_postmeta VALUES("2143","315","anps_team_subtitle","");
INSERT INTO ayv_postmeta VALUES("2144","315","anps_subtitle","");
INSERT INTO ayv_postmeta VALUES("2145","315","anps_portfolio_shorttext","");
INSERT INTO ayv_postmeta VALUES("2146","315","custom_breadcrumbs","111");
INSERT INTO ayv_postmeta VALUES("2147","315","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("2148","315","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("2149","315","heading_bg","");
INSERT INTO ayv_postmeta VALUES("2150","315","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("2151","315","gallery_images","316,317,318,319,321,320,");
INSERT INTO ayv_postmeta VALUES("2152","316","_wp_attached_file","2015/12/Cui-cevenole-Modale-rustique-St-Victor-1.jpg");
INSERT INTO ayv_postmeta VALUES("2153","316","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:853;s:4:\"file\";s:52:\"2015/12/Cui-cevenole-Modale-rustique-St-Victor-1.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:53:\"Cui-cevenole-Modale-rustique-St-Victor-1-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-1-370x247.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:247;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-1-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:53:\"Cui-cevenole-Modale-rustique-St-Victor-1-1200x800.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-1-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-1-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-1-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-1-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-1-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:51:\"Cui-cevenole-Modale-rustique-St-Victor-1-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2154","317","_wp_attached_file","2015/12/Cui-cevenole-Modale-rustique-St-Victor-2.jpg");
INSERT INTO ayv_postmeta VALUES("2155","317","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:853;s:4:\"file\";s:52:\"2015/12/Cui-cevenole-Modale-rustique-St-Victor-2.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:53:\"Cui-cevenole-Modale-rustique-St-Victor-2-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-2-370x247.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:247;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-2-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:53:\"Cui-cevenole-Modale-rustique-St-Victor-2-1200x800.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-2-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-2-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-2-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-2-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-2-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:51:\"Cui-cevenole-Modale-rustique-St-Victor-2-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2156","318","_wp_attached_file","2015/12/Cui-cevenole-Modale-rustique-St-Victor-3.jpg");
INSERT INTO ayv_postmeta VALUES("2157","318","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:853;s:4:\"file\";s:52:\"2015/12/Cui-cevenole-Modale-rustique-St-Victor-3.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:53:\"Cui-cevenole-Modale-rustique-St-Victor-3-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-3-370x247.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:247;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-3-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:53:\"Cui-cevenole-Modale-rustique-St-Victor-3-1200x800.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-3-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-3-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-3-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-3-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-3-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:51:\"Cui-cevenole-Modale-rustique-St-Victor-3-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2158","319","_wp_attached_file","2015/12/Cui-cevenole-Modale-rustique-St-Victor-4.jpg");
INSERT INTO ayv_postmeta VALUES("2159","319","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:853;s:4:\"file\";s:52:\"2015/12/Cui-cevenole-Modale-rustique-St-Victor-4.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:53:\"Cui-cevenole-Modale-rustique-St-Victor-4-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-4-370x247.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:247;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-4-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:53:\"Cui-cevenole-Modale-rustique-St-Victor-4-1200x800.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-4-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-4-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-4-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-4-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-4-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:51:\"Cui-cevenole-Modale-rustique-St-Victor-4-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2160","320","_wp_attached_file","2015/12/Cui-cevenole-Modale-rustique-St-Victor-5.jpg");
INSERT INTO ayv_postmeta VALUES("2161","320","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:1536;s:4:\"file\";s:52:\"2015/12/Cui-cevenole-Modale-rustique-St-Victor-5.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-5-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:53:\"Cui-cevenole-Modale-rustique-St-Victor-5-683x1024.jpg\";s:5:\"width\";i:683;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-5-240x360.jpg\";s:5:\"width\";i:240;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-5-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-5-360x540.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:540;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-5-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-5-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-5-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-5-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:51:\"Cui-cevenole-Modale-rustique-St-Victor-5-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2162","321","_wp_attached_file","2015/12/Cui-cevenole-Modale-rustique-St-Victor-6.jpg");
INSERT INTO ayv_postmeta VALUES("2163","321","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:853;s:4:\"file\";s:52:\"2015/12/Cui-cevenole-Modale-rustique-St-Victor-6.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-6-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:53:\"Cui-cevenole-Modale-rustique-St-Victor-6-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-6-370x247.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:247;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-6-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:53:\"Cui-cevenole-Modale-rustique-St-Victor-6-1200x800.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-6-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-6-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-6-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-6-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:52:\"Cui-cevenole-Modale-rustique-St-Victor-6-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:51:\"Cui-cevenole-Modale-rustique-St-Victor-6-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2181","324","_wp_attached_file","2015/12/Cui-cevenole-Salindres-02.jpg");
INSERT INTO ayv_postmeta VALUES("2182","324","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:853;s:4:\"file\";s:37:\"2015/12/Cui-cevenole-Salindres-02.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-02-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-02-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:38:\"Cui-cevenole-Salindres-02-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-02-370x247.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:247;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-02-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:38:\"Cui-cevenole-Salindres-02-1200x800.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-02-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-02-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-02-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-02-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-02-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:36:\"Cui-cevenole-Salindres-02-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2183","325","_wp_attached_file","2015/12/Cui-cevenole-Salindres-03.jpg");
INSERT INTO ayv_postmeta VALUES("2184","325","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:853;s:4:\"file\";s:37:\"2015/12/Cui-cevenole-Salindres-03.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-03-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-03-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:38:\"Cui-cevenole-Salindres-03-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-03-370x247.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:247;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-03-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:38:\"Cui-cevenole-Salindres-03-1200x800.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-03-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-03-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-03-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-03-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-03-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:36:\"Cui-cevenole-Salindres-03-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2185","326","_wp_attached_file","2015/12/Cui-cevenole-Salindres-04.jpg");
INSERT INTO ayv_postmeta VALUES("2186","326","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:853;s:4:\"file\";s:37:\"2015/12/Cui-cevenole-Salindres-04.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-04-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-04-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:38:\"Cui-cevenole-Salindres-04-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-04-370x247.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:247;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-04-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:38:\"Cui-cevenole-Salindres-04-1200x800.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-04-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-04-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-04-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-04-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-04-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:36:\"Cui-cevenole-Salindres-04-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2187","327","_wp_attached_file","2015/12/Cui-cevenole-Salindres-05.jpg");
INSERT INTO ayv_postmeta VALUES("2188","327","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:1536;s:4:\"file\";s:37:\"2015/12/Cui-cevenole-Salindres-05.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-05-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-05-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:38:\"Cui-cevenole-Salindres-05-683x1024.jpg\";s:5:\"width\";i:683;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-05-240x360.jpg\";s:5:\"width\";i:240;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-05-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-05-360x540.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:540;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-05-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-05-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-05-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-05-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:36:\"Cui-cevenole-Salindres-05-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2164","315","_thumbnail_id","316");
INSERT INTO ayv_postmeta VALUES("2165","322","_edit_last","1");
INSERT INTO ayv_postmeta VALUES("2166","322","_edit_lock","1450276382:1");
INSERT INTO ayv_postmeta VALUES("2167","322","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("2168","322","ville","Salindres");
INSERT INTO ayv_postmeta VALUES("2169","322","_ville","field_56446f186d761");
INSERT INTO ayv_postmeta VALUES("2170","322","anps_team_subtitle","");
INSERT INTO ayv_postmeta VALUES("2171","322","anps_subtitle","");
INSERT INTO ayv_postmeta VALUES("2172","322","anps_portfolio_shorttext","");
INSERT INTO ayv_postmeta VALUES("2173","322","custom_breadcrumbs","111");
INSERT INTO ayv_postmeta VALUES("2174","322","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("2175","322","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("2176","322","heading_bg","");
INSERT INTO ayv_postmeta VALUES("2177","322","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("2178","322","gallery_images","323,324,325,326,327,328");
INSERT INTO ayv_postmeta VALUES("2179","323","_wp_attached_file","2015/12/Cui-cevenole-Salindres-01.jpg");
INSERT INTO ayv_postmeta VALUES("2180","323","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:853;s:4:\"file\";s:37:\"2015/12/Cui-cevenole-Salindres-01.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-01-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-01-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:38:\"Cui-cevenole-Salindres-01-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-01-370x247.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:247;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-01-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:38:\"Cui-cevenole-Salindres-01-1200x800.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-01-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-01-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-01-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-01-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:37:\"Cui-cevenole-Salindres-01-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:36:\"Cui-cevenole-Salindres-01-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2212","333","_wp_attached_file","2015/12/Cui-cevenole-St-Privat-des-Vieux-4.jpg");
INSERT INTO ayv_postmeta VALUES("2213","333","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:46:\"2015/12/Cui-cevenole-St-Privat-des-Vieux-4.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-4-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:47:\"Cui-cevenole-St-Privat-des-Vieux-4-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-4-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-4-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:47:\"Cui-cevenole-St-Privat-des-Vieux-4-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-4-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-4-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-4-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-4-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:46:\"Cui-cevenole-St-Privat-des-Vieux-4-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:45:\"Cui-cevenole-St-Privat-des-Vieux-4-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2214","329","_thumbnail_id","330");
INSERT INTO ayv_postmeta VALUES("2215","334","_edit_last","1");
INSERT INTO ayv_postmeta VALUES("2216","334","_edit_lock","1455084472:2");
INSERT INTO ayv_postmeta VALUES("2217","335","_wp_attached_file","2015/12/Cui-cevenole-Barjac-1.jpg");
INSERT INTO ayv_postmeta VALUES("2218","335","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:33:\"2015/12/Cui-cevenole-Barjac-1.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-1-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:34:\"Cui-cevenole-Barjac-1-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-1-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-1-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:34:\"Cui-cevenole-Barjac-1-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-1-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-1-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-1-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-1-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-1-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-Barjac-1-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2219","336","_wp_attached_file","2015/12/Cui-cevenole-Barjac-2.jpg");
INSERT INTO ayv_postmeta VALUES("2220","336","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:33:\"2015/12/Cui-cevenole-Barjac-2.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-2-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:34:\"Cui-cevenole-Barjac-2-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-2-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-2-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:34:\"Cui-cevenole-Barjac-2-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-2-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-2-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-2-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-2-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-2-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-Barjac-2-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2221","337","_wp_attached_file","2015/12/Cui-cevenole-Barjac-3.jpg");
INSERT INTO ayv_postmeta VALUES("2222","337","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:33:\"2015/12/Cui-cevenole-Barjac-3.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-3-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:34:\"Cui-cevenole-Barjac-3-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-3-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-3-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:34:\"Cui-cevenole-Barjac-3-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-3-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-3-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-3-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-3-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-3-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-Barjac-3-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2223","338","_wp_attached_file","2015/12/Cui-cevenole-Barjac-4.jpg");
INSERT INTO ayv_postmeta VALUES("2224","338","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:33:\"2015/12/Cui-cevenole-Barjac-4.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-4-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:34:\"Cui-cevenole-Barjac-4-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-4-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-4-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:34:\"Cui-cevenole-Barjac-4-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-4-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-4-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-4-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-4-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-4-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-Barjac-4-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2225","339","_wp_attached_file","2015/12/Cui-cevenole-Barjac-5.jpg");
INSERT INTO ayv_postmeta VALUES("2226","339","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:33:\"2015/12/Cui-cevenole-Barjac-5.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-5-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:34:\"Cui-cevenole-Barjac-5-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-5-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-5-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:34:\"Cui-cevenole-Barjac-5-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-5-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-5-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-5-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-5-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-Barjac-5-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-Barjac-5-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2227","334","_thumbnail_id","335");
INSERT INTO ayv_postmeta VALUES("2228","334","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("2229","334","ville","Barjac");
INSERT INTO ayv_postmeta VALUES("2230","334","_ville","field_56446f186d761");
INSERT INTO ayv_postmeta VALUES("2231","334","anps_team_subtitle","");
INSERT INTO ayv_postmeta VALUES("2232","334","anps_subtitle","");
INSERT INTO ayv_postmeta VALUES("2233","334","anps_portfolio_shorttext","");
INSERT INTO ayv_postmeta VALUES("2234","334","custom_breadcrumbs","111");
INSERT INTO ayv_postmeta VALUES("2235","334","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("2236","334","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("2237","334","heading_bg","");
INSERT INTO ayv_postmeta VALUES("2238","334","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("2239","334","gallery_images","335,339,338,337,336");
INSERT INTO ayv_postmeta VALUES("2240","340","_edit_last","1");
INSERT INTO ayv_postmeta VALUES("2241","340","_edit_lock","1450277887:1");
INSERT INTO ayv_postmeta VALUES("2242","340","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("2243","340","ville","Als");
INSERT INTO ayv_postmeta VALUES("2244","340","_ville","field_56446f186d761");
INSERT INTO ayv_postmeta VALUES("2245","340","anps_team_subtitle","");
INSERT INTO ayv_postmeta VALUES("2246","340","anps_subtitle","");
INSERT INTO ayv_postmeta VALUES("2247","340","anps_portfolio_shorttext","");
INSERT INTO ayv_postmeta VALUES("2248","340","custom_breadcrumbs","111");
INSERT INTO ayv_postmeta VALUES("2249","340","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("2250","340","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("2251","340","heading_bg","");
INSERT INTO ayv_postmeta VALUES("2252","340","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("2253","340","gallery_images","341,345,342,343,344,");
INSERT INTO ayv_postmeta VALUES("2254","341","_wp_attached_file","2015/12/Cui-cevenole-Ales-1.jpg");
INSERT INTO ayv_postmeta VALUES("2255","341","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:853;s:4:\"file\";s:31:\"2015/12/Cui-cevenole-Ales-1.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-Ales-1-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-1-370x247.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:247;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-1-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-Ales-1-1200x800.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-1-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-1-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-1-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-1-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-1-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:30:\"Cui-cevenole-Ales-1-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2256","342","_wp_attached_file","2015/12/Cui-cevenole-Ales-2.jpg");
INSERT INTO ayv_postmeta VALUES("2257","342","_wp_attachment_metadata","a:5:{s:5:\"width\";i:900;s:6:\"height\";i:1350;s:4:\"file\";s:31:\"2015/12/Cui-cevenole-Ales-2.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-2-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-Ales-2-683x1024.jpg\";s:5:\"width\";i:683;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-2-240x360.jpg\";s:5:\"width\";i:240;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-2-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-2-360x540.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:540;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-2-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-2-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-2-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-2-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:30:\"Cui-cevenole-Ales-2-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2258","343","_wp_attached_file","2015/12/Cui-cevenole-Ales-3.jpg");
INSERT INTO ayv_postmeta VALUES("2259","343","_wp_attachment_metadata","a:5:{s:5:\"width\";i:900;s:6:\"height\";i:1350;s:4:\"file\";s:31:\"2015/12/Cui-cevenole-Ales-3.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-3-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-Ales-3-683x1024.jpg\";s:5:\"width\";i:683;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-3-240x360.jpg\";s:5:\"width\";i:240;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-3-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-3-360x540.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:540;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-3-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-3-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-3-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-3-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:30:\"Cui-cevenole-Ales-3-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2260","344","_wp_attached_file","2015/12/Cui-cevenole-Ales-4.jpg");
INSERT INTO ayv_postmeta VALUES("2261","344","_wp_attachment_metadata","a:5:{s:5:\"width\";i:900;s:6:\"height\";i:1350;s:4:\"file\";s:31:\"2015/12/Cui-cevenole-Ales-4.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-4-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-Ales-4-683x1024.jpg\";s:5:\"width\";i:683;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-4-240x360.jpg\";s:5:\"width\";i:240;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-4-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-4-360x540.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:540;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-4-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-4-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-4-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-4-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:30:\"Cui-cevenole-Ales-4-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2262","345","_wp_attached_file","2015/12/Cui-cevenole-Ales-5.jpg");
INSERT INTO ayv_postmeta VALUES("2263","345","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:853;s:4:\"file\";s:31:\"2015/12/Cui-cevenole-Ales-5.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-Ales-5-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-5-370x247.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:247;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-5-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-Ales-5-1200x800.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-5-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-5-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-5-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-5-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-Ales-5-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:30:\"Cui-cevenole-Ales-5-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2264","340","_thumbnail_id","341");
INSERT INTO ayv_postmeta VALUES("2271","347","_edit_last","2");
INSERT INTO ayv_postmeta VALUES("2272","347","_edit_lock","1451749394:2");
INSERT INTO ayv_postmeta VALUES("2273","347","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("2274","347","ville","Stainville");
INSERT INTO ayv_postmeta VALUES("2275","347","_ville","field_56446f186d761");
INSERT INTO ayv_postmeta VALUES("2276","347","anps_team_subtitle","");
INSERT INTO ayv_postmeta VALUES("2277","347","anps_subtitle","");
INSERT INTO ayv_postmeta VALUES("2278","347","anps_portfolio_shorttext","");
INSERT INTO ayv_postmeta VALUES("2279","347","custom_breadcrumbs","111");
INSERT INTO ayv_postmeta VALUES("2280","347","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("2281","347","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("2282","347","heading_bg","");
INSERT INTO ayv_postmeta VALUES("2283","347","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("2284","347","gallery_images","354,348,349,350,351,352,353,");
INSERT INTO ayv_postmeta VALUES("2285","348","_wp_attached_file","2015/12/Cui-cevenole-grise-2.jpg");
INSERT INTO ayv_postmeta VALUES("2286","348","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:32:\"2015/12/Cui-cevenole-grise-2.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-2-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-grise-2-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-2-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-2-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-grise-2-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-2-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-2-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-2-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-2-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-2-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-grise-2-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2287","349","_wp_attached_file","2015/12/Cui-cevenole-grise-3.jpg");
INSERT INTO ayv_postmeta VALUES("2288","349","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:32:\"2015/12/Cui-cevenole-grise-3.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-3-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-grise-3-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-3-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-3-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-grise-3-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-3-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-3-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-3-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-3-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-3-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-grise-3-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2289","350","_wp_attached_file","2015/12/Cui-cevenole-grise-4.jpg");
INSERT INTO ayv_postmeta VALUES("2290","350","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:32:\"2015/12/Cui-cevenole-grise-4.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-4-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-grise-4-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-4-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-4-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-grise-4-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-4-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-4-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-4-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-4-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-4-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-grise-4-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2291","351","_wp_attached_file","2015/12/Cui-cevenole-grise-5.jpg");
INSERT INTO ayv_postmeta VALUES("2292","351","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:32:\"2015/12/Cui-cevenole-grise-5.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-5-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-grise-5-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-5-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-5-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-grise-5-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-5-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-5-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-5-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-5-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-5-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-grise-5-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2293","352","_wp_attached_file","2015/12/Cui-cevenole-grise-6.jpg");
INSERT INTO ayv_postmeta VALUES("2294","352","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:32:\"2015/12/Cui-cevenole-grise-6.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-6-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-grise-6-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-6-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-6-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-grise-6-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-6-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-6-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-6-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-6-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-6-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-grise-6-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2295","353","_wp_attached_file","2015/12/Cui-cevenole-grise-7.jpg");
INSERT INTO ayv_postmeta VALUES("2296","353","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:32:\"2015/12/Cui-cevenole-grise-7.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-7-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-grise-7-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-7-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-7-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-grise-7-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-7-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-7-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-7-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-7-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-7-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-grise-7-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2297","354","_wp_attached_file","2015/12/Cui-cevenole-grise-1.jpg");
INSERT INTO ayv_postmeta VALUES("2298","354","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:32:\"2015/12/Cui-cevenole-grise-1.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-1-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-grise-1-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-1-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-1-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:33:\"Cui-cevenole-grise-1-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-1-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-1-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-1-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-1-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:32:\"Cui-cevenole-grise-1-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:31:\"Cui-cevenole-grise-1-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2299","347","_thumbnail_id","354");
INSERT INTO ayv_postmeta VALUES("2683","114","sbg_selected_sidebar","Secondary Sidebar");
INSERT INTO ayv_postmeta VALUES("2873","2","sbg_selected_sidebar_replacement","0");
INSERT INTO ayv_postmeta VALUES("2421","2","_wpb_vc_js_status","false");
INSERT INTO ayv_postmeta VALUES("2422","2","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("2425","2","anps_team_subtitle","");
INSERT INTO ayv_postmeta VALUES("2426","2","anps_subtitle","");
INSERT INTO ayv_postmeta VALUES("2427","2","anps_portfolio_shorttext","");
INSERT INTO ayv_postmeta VALUES("2428","2","custom_breadcrumbs","");
INSERT INTO ayv_postmeta VALUES("2429","2","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("2430","2","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("2431","2","heading_bg","");
INSERT INTO ayv_postmeta VALUES("2432","2","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("2433","2","gallery_images","");
INSERT INTO ayv_postmeta VALUES("2440","377","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("2441","377","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("2442","377","heading_bg","");
INSERT INTO ayv_postmeta VALUES("2443","377","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("2444","377","gallery_images","");
INSERT INTO ayv_postmeta VALUES("2445","377","_menu_item_type","post_type");
INSERT INTO ayv_postmeta VALUES("2446","377","_menu_item_menu_item_parent","0");
INSERT INTO ayv_postmeta VALUES("2447","377","_menu_item_object_id","2");
INSERT INTO ayv_postmeta VALUES("2448","377","_menu_item_object","page");
INSERT INTO ayv_postmeta VALUES("2449","377","_menu_item_target","");
INSERT INTO ayv_postmeta VALUES("2450","377","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO ayv_postmeta VALUES("2451","377","_menu_item_xfn","");
INSERT INTO ayv_postmeta VALUES("2452","377","_menu_item_url","");
INSERT INTO ayv_postmeta VALUES("2454","377","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("2457","379","_wp_attached_file","2015/12/logo-atelier-yvan-vedel-blanc-1.png");
INSERT INTO ayv_postmeta VALUES("2458","379","_wp_attachment_metadata","a:5:{s:5:\"width\";i:253;s:6:\"height\";i:55;s:4:\"file\";s:43:\"2015/12/logo-atelier-yvan-vedel-blanc-1.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:42:\"logo-atelier-yvan-vedel-blanc-1-150x55.png\";s:5:\"width\";i:150;s:6:\"height\";i:55;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:42:\"logo-atelier-yvan-vedel-blanc-1-190x54.png\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2459","379","_edit_lock","1450800920:1");
INSERT INTO ayv_postmeta VALUES("2496","385","_edit_last","2");
INSERT INTO ayv_postmeta VALUES("2497","385","_edit_lock","1451417596:2");
INSERT INTO ayv_postmeta VALUES("2535","390","_oembed_a18ccc67b27332d622ddd9a4e73522ea","{{unknown}}");
INSERT INTO ayv_postmeta VALUES("2805","385","sbg_selected_sidebar","0");
INSERT INTO ayv_postmeta VALUES("2503","385","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("2506","385","anps_team_subtitle","");
INSERT INTO ayv_postmeta VALUES("2507","385","anps_subtitle","");
INSERT INTO ayv_postmeta VALUES("2508","385","anps_portfolio_shorttext","");
INSERT INTO ayv_postmeta VALUES("2509","385","custom_breadcrumbs","17");
INSERT INTO ayv_postmeta VALUES("2510","385","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("2511","385","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("2512","385","heading_bg","");
INSERT INTO ayv_postmeta VALUES("2513","385","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("2514","385","gallery_images","");
INSERT INTO ayv_postmeta VALUES("2806","385","sbg_selected_sidebar_replacement","0");
INSERT INTO ayv_postmeta VALUES("2536","390","_edit_last","2");
INSERT INTO ayv_postmeta VALUES("2537","390","_edit_lock","1453534803:2");
INSERT INTO ayv_postmeta VALUES("2557","392","_wp_attached_file","2015/12/Alespo.png");
INSERT INTO ayv_postmeta VALUES("2543","390","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("2568","393","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1020;s:6:\"height\";i:154;s:4:\"file\";s:19:\"2015/12/Alespo1.png\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"Alespo1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"Alespo1-300x45.png\";s:5:\"width\";i:300;s:6:\"height\";i:45;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:18:\"Alespo1-370x56.png\";s:5:\"width\";i:370;s:6:\"height\";i:56;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:19:\"Alespo1-720x154.png\";s:5:\"width\";i:720;s:6:\"height\";i:154;s:9:\"mime-type\";s:9:\"image/png\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:18:\"Alespo1-360x54.png\";s:5:\"width\";i:360;s:6:\"height\";i:54;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:19:\"Alespo1-360x154.png\";s:5:\"width\";i:360;s:6:\"height\";i:154;s:9:\"mime-type\";s:9:\"image/png\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:19:\"Alespo1-554x154.png\";s:5:\"width\";i:554;s:6:\"height\";i:154;s:9:\"mime-type\";s:9:\"image/png\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:19:\"Alespo1-262x154.png\";s:5:\"width\";i:262;s:6:\"height\";i:154;s:9:\"mime-type\";s:9:\"image/png\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:19:\"Alespo1-554x154.png\";s:5:\"width\";i:554;s:6:\"height\";i:154;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:18:\"Alespo1-190x54.png\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2546","390","anps_team_subtitle","");
INSERT INTO ayv_postmeta VALUES("2547","390","anps_subtitle","");
INSERT INTO ayv_postmeta VALUES("2548","390","anps_portfolio_shorttext","");
INSERT INTO ayv_postmeta VALUES("2549","390","custom_breadcrumbs","17");
INSERT INTO ayv_postmeta VALUES("2550","390","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("2551","390","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("2552","390","heading_bg","");
INSERT INTO ayv_postmeta VALUES("2553","390","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("2554","390","gallery_images","");
INSERT INTO ayv_postmeta VALUES("2558","392","_wp_attachment_metadata","a:5:{s:5:\"width\";i:400;s:6:\"height\";i:136;s:4:\"file\";s:18:\"2015/12/Alespo.png\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"Alespo-150x136.png\";s:5:\"width\";i:150;s:6:\"height\";i:136;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"Alespo-300x102.png\";s:5:\"width\";i:300;s:6:\"height\";i:102;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:18:\"Alespo-370x126.png\";s:5:\"width\";i:370;s:6:\"height\";i:126;s:9:\"mime-type\";s:9:\"image/png\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:18:\"Alespo-360x122.png\";s:5:\"width\";i:360;s:6:\"height\";i:122;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:18:\"Alespo-360x136.png\";s:5:\"width\";i:360;s:6:\"height\";i:136;s:9:\"mime-type\";s:9:\"image/png\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:18:\"Alespo-262x136.png\";s:5:\"width\";i:262;s:6:\"height\";i:136;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:17:\"Alespo-190x54.png\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2567","393","_wp_attached_file","2015/12/Alespo1.png");
INSERT INTO ayv_postmeta VALUES("2569","390","_thumbnail_id","393");
INSERT INTO ayv_postmeta VALUES("2577","394","_wp_attached_file","2015/12/11eme-salon-habitat.jpg");
INSERT INTO ayv_postmeta VALUES("2578","394","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1020;s:6:\"height\";i:154;s:4:\"file\";s:31:\"2015/12/11eme-salon-habitat.jpg\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"11eme-salon-habitat-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"11eme-salon-habitat-300x45.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:45;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:30:\"11eme-salon-habitat-370x56.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:56;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:31:\"11eme-salon-habitat-720x154.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:154;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:30:\"11eme-salon-habitat-360x54.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:31:\"11eme-salon-habitat-360x154.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:154;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:31:\"11eme-salon-habitat-554x154.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:154;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:31:\"11eme-salon-habitat-262x154.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:154;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:31:\"11eme-salon-habitat-554x154.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:154;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:30:\"11eme-salon-habitat-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2579","385","_thumbnail_id","394");
INSERT INTO ayv_postmeta VALUES("2587","395","_wp_attached_file","2015/10/Esquisse-cuisine-web.jpg");
INSERT INTO ayv_postmeta VALUES("2588","395","_wp_attachment_metadata","a:5:{s:5:\"width\";i:700;s:6:\"height\";i:520;s:4:\"file\";s:32:\"2015/10/Esquisse-cuisine-web.jpg\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"Esquisse-cuisine-web-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"Esquisse-cuisine-web-300x223.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:223;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:32:\"Esquisse-cuisine-web-370x275.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:275;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:32:\"Esquisse-cuisine-web-700x412.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:32:\"Esquisse-cuisine-web-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:32:\"Esquisse-cuisine-web-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:32:\"Esquisse-cuisine-web-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:32:\"Esquisse-cuisine-web-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:32:\"Esquisse-cuisine-web-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:31:\"Esquisse-cuisine-web-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2595","397","_edit_last","2");
INSERT INTO ayv_postmeta VALUES("2596","397","_edit_lock","1451841407:2");
INSERT INTO ayv_postmeta VALUES("2597","397","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("2598","397","ville","Ales");
INSERT INTO ayv_postmeta VALUES("2599","397","_ville","field_56446f186d761");
INSERT INTO ayv_postmeta VALUES("2600","397","anps_team_subtitle","");
INSERT INTO ayv_postmeta VALUES("2601","397","anps_subtitle","");
INSERT INTO ayv_postmeta VALUES("2602","397","anps_portfolio_shorttext","");
INSERT INTO ayv_postmeta VALUES("2603","397","custom_breadcrumbs","117");
INSERT INTO ayv_postmeta VALUES("2604","397","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("2605","397","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("2606","397","heading_bg","");
INSERT INTO ayv_postmeta VALUES("2607","397","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("2608","397","gallery_images","398,399,400,401,403,");
INSERT INTO ayv_postmeta VALUES("2609","398","_wp_attached_file","2015/12/SB-cadre-alu-verre-laque-1.jpg");
INSERT INTO ayv_postmeta VALUES("2610","398","_wp_attachment_metadata","a:5:{s:5:\"width\";i:900;s:6:\"height\";i:1353;s:4:\"file\";s:38:\"2015/12/SB-cadre-alu-verre-laque-1.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-1-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:39:\"SB-cadre-alu-verre-laque-1-681x1024.jpg\";s:5:\"width\";i:681;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-1-239x360.jpg\";s:5:\"width\";i:239;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-1-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-1-360x541.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:541;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-1-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-1-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-1-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-1-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:37:\"SB-cadre-alu-verre-laque-1-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2611","399","_wp_attached_file","2015/12/SB-cadre-alu-verre-laque-2.jpg");
INSERT INTO ayv_postmeta VALUES("2612","399","_wp_attachment_metadata","a:5:{s:5:\"width\";i:900;s:6:\"height\";i:1353;s:4:\"file\";s:38:\"2015/12/SB-cadre-alu-verre-laque-2.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-2-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:39:\"SB-cadre-alu-verre-laque-2-681x1024.jpg\";s:5:\"width\";i:681;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-2-239x360.jpg\";s:5:\"width\";i:239;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-2-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-2-360x541.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:541;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-2-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-2-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-2-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-2-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:37:\"SB-cadre-alu-verre-laque-2-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2613","400","_wp_attached_file","2015/12/SB-cadre-alu-verre-laque-3.jpg");
INSERT INTO ayv_postmeta VALUES("2614","400","_wp_attachment_metadata","a:5:{s:5:\"width\";i:900;s:6:\"height\";i:1353;s:4:\"file\";s:38:\"2015/12/SB-cadre-alu-verre-laque-3.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-3-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:39:\"SB-cadre-alu-verre-laque-3-681x1024.jpg\";s:5:\"width\";i:681;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-3-239x360.jpg\";s:5:\"width\";i:239;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-3-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-3-360x541.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:541;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-3-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-3-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-3-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-3-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:37:\"SB-cadre-alu-verre-laque-3-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2615","401","_wp_attached_file","2015/12/SB-cadre-alu-verre-laque-4.jpg");
INSERT INTO ayv_postmeta VALUES("2616","401","_wp_attachment_metadata","a:5:{s:5:\"width\";i:900;s:6:\"height\";i:1353;s:4:\"file\";s:38:\"2015/12/SB-cadre-alu-verre-laque-4.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-4-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:39:\"SB-cadre-alu-verre-laque-4-681x1024.jpg\";s:5:\"width\";i:681;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-4-239x360.jpg\";s:5:\"width\";i:239;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-4-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-4-360x541.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:541;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-4-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-4-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-4-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-4-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:37:\"SB-cadre-alu-verre-laque-4-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2617","402","_wp_attached_file","2015/12/SB-cadre-alu-verre-laque-5.jpg");
INSERT INTO ayv_postmeta VALUES("2618","402","_wp_attachment_metadata","a:5:{s:5:\"width\";i:900;s:6:\"height\";i:1353;s:4:\"file\";s:38:\"2015/12/SB-cadre-alu-verre-laque-5.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-5-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:39:\"SB-cadre-alu-verre-laque-5-681x1024.jpg\";s:5:\"width\";i:681;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-5-239x360.jpg\";s:5:\"width\";i:239;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-5-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-5-360x541.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:541;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-5-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-5-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-5-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-5-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:37:\"SB-cadre-alu-verre-laque-5-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2619","403","_wp_attached_file","2015/12/SB-cadre-alu-verre-laque-6.jpg");
INSERT INTO ayv_postmeta VALUES("2620","403","_wp_attachment_metadata","a:5:{s:5:\"width\";i:900;s:6:\"height\";i:1353;s:4:\"file\";s:38:\"2015/12/SB-cadre-alu-verre-laque-6.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-6-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:39:\"SB-cadre-alu-verre-laque-6-681x1024.jpg\";s:5:\"width\";i:681;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-6-239x360.jpg\";s:5:\"width\";i:239;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-6-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-6-360x541.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:541;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-6-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-6-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-6-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:38:\"SB-cadre-alu-verre-laque-6-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:37:\"SB-cadre-alu-verre-laque-6-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2621","397","_thumbnail_id","398");
INSERT INTO ayv_postmeta VALUES("2622","404","_edit_last","2");
INSERT INTO ayv_postmeta VALUES("2623","404","_edit_lock","1456509249:2");
INSERT INTO ayv_postmeta VALUES("2624","404","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO ayv_postmeta VALUES("2625","404","ville","Nmes");
INSERT INTO ayv_postmeta VALUES("2626","404","_ville","field_56446f186d761");
INSERT INTO ayv_postmeta VALUES("2627","404","anps_team_subtitle","");
INSERT INTO ayv_postmeta VALUES("2628","404","anps_subtitle","");
INSERT INTO ayv_postmeta VALUES("2629","404","anps_portfolio_shorttext","");
INSERT INTO ayv_postmeta VALUES("2630","404","custom_breadcrumbs","117");
INSERT INTO ayv_postmeta VALUES("2631","404","anps_menu_separate","0");
INSERT INTO ayv_postmeta VALUES("2632","404","anps_disable_heading","0");
INSERT INTO ayv_postmeta VALUES("2633","404","heading_bg","");
INSERT INTO ayv_postmeta VALUES("2634","404","anps_featured_video","");
INSERT INTO ayv_postmeta VALUES("2635","404","gallery_images","405,406,407,408,409,410,411,412,");
INSERT INTO ayv_postmeta VALUES("2636","405","_wp_attached_file","2015/12/Meuble-tele-1.jpg");
INSERT INTO ayv_postmeta VALUES("2637","405","_wp_attachment_metadata","a:5:{s:5:\"width\";i:898;s:6:\"height\";i:674;s:4:\"file\";s:25:\"2015/12/Meuble-tele-1.jpg\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-1-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-1-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-1-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-1-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-1-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-1-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-1-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-1-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:24:\"Meuble-tele-1-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2638","406","_wp_attached_file","2015/12/Meuble-tele-2.jpg");
INSERT INTO ayv_postmeta VALUES("2639","406","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:25:\"2015/12/Meuble-tele-2.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-2-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:26:\"Meuble-tele-2-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-2-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-2-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:26:\"Meuble-tele-2-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-2-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-2-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-2-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-2-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-2-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:24:\"Meuble-tele-2-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2640","407","_wp_attached_file","2015/12/Meuble-tele-3.jpg");
INSERT INTO ayv_postmeta VALUES("2641","407","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:25:\"2015/12/Meuble-tele-3.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-3-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:26:\"Meuble-tele-3-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-3-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-3-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:26:\"Meuble-tele-3-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-3-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-3-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-3-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-3-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-3-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:24:\"Meuble-tele-3-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2642","408","_wp_attached_file","2015/12/Meuble-tele-4.jpg");
INSERT INTO ayv_postmeta VALUES("2643","408","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:25:\"2015/12/Meuble-tele-4.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-4-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:26:\"Meuble-tele-4-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-4-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-4-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:26:\"Meuble-tele-4-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-4-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-4-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-4-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-4-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-4-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:24:\"Meuble-tele-4-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2644","409","_wp_attached_file","2015/12/Meuble-tele-5.jpg");
INSERT INTO ayv_postmeta VALUES("2645","409","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:25:\"2015/12/Meuble-tele-5.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-5-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:26:\"Meuble-tele-5-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-5-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-5-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:26:\"Meuble-tele-5-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-5-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-5-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-5-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-5-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-5-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:24:\"Meuble-tele-5-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2646","410","_wp_attached_file","2015/12/Meuble-tele-6.jpg");
INSERT INTO ayv_postmeta VALUES("2647","410","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:25:\"2015/12/Meuble-tele-6.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-6-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:26:\"Meuble-tele-6-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-6-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-6-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:26:\"Meuble-tele-6-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-6-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-6-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-6-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-6-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-6-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:24:\"Meuble-tele-6-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2648","411","_wp_attached_file","2015/12/Meuble-tele-7.jpg");
INSERT INTO ayv_postmeta VALUES("2649","411","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:25:\"2015/12/Meuble-tele-7.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-7-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:26:\"Meuble-tele-7-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-7-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-7-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:26:\"Meuble-tele-7-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-7-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-7-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-7-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-7-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-7-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:24:\"Meuble-tele-7-190x54.jpg\";s:5:\"width\";i:190;s:6:\"height\";i:54;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO ayv_postmeta VALUES("2650","412","_wp_attached_file","2015/12/Meuble-tele-8.jpg");
INSERT INTO ayv_postmeta VALUES("2651","412","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:25:\"2015/12/Meuble-tele-8.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-8-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:26:\"Meuble-tele-8-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"team-3\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-8-370x278.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-grid\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-8-720x412.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:412;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-full\";a:4:{s:4:\"file\";s:26:\"Meuble-tele-8-1200x900.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"blog-masonry-3-columns\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-8-360x270.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"post-thumb\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-8-360x267.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:24:\"portfolio-random-width-2\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-8-554x202.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"portfolio-random-height-2\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-8-262x433.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"portfolio-random-width-2-height-2\";a:4:{s:4:\"file\";s:25:\"Meuble-tele-8-554x433.jpg\";s:5:\"width\";i:554;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:24:\"